/*---------------------------------------------------------------------------

               Copyright (c) 1994 SandStone Software Inc.
                          All rights reserved

----------------------------------------------------------------------------*/
#if !defined( SSLEX)
#  define SSLEX
#  include<stdio.h>
#  include<malloc.h>
#  include<sssto.hpp>
#  include<ssref.hpp>
#  include<ssglobal.h>
#  include<ssdbcs.hpp>
#  include<ssexcept.hpp>

#  define SSLexConsumerDefaultInc   0
#  define SSLexConsumerAll          0xffffffff
#  define SSLexConsumerDefaultSize  SSLexConsumerAll

#  define SSLexFileModeCharacter    "r"
#  define SSLexFileModeBinary       "rb"
#  define SSLexFileModeUnicode      "rb"

#  define SSLexMinimumCharacterSize 2
#  define SSLexTokenBof             0xffffffff
#  define SSLexStateInvalid         0xffffffff
#  define SSLexTokenNotFound        "SSLexTokenNotFound"

#  define SSLexMsgFileOpen          "SSLex0101e: Error opening file, %s, %ld"
#  define SSLexMsgFileLength        "SSLex0102e: Invalid file length or read error, %s"
#  define SSLexMsgLexemeLength      "SSLex0103e: Lexeme too long, %ld"
#  define SSLexMsgTable             "SSLex0104e: Invalid table, %s"
#  define SSLexMsgError             "SSLex0105e: Invalid token, Line %ld, Offset %ld, %s"
#  define SSLexMsgIterator          "SSLex0106e: Invalid expression list index, %ld"
#  define SSLexMsgMissingParm       "SSLex0107e: Table or consumer missing, required"

   class SSLex;
   class SSLexMark;
   class SSLexTable;
   class SSLexLexeme;
   class SSLexConsumer;
   class SSLexIterator;
   class SSLexFileConsumer;
   class SSLexStringConsumer;
   class SSLexExpressionList;

   typedef SSRef< SSLexLexeme>  SSLexLexemeRef;
   typedef SSLexExpressionList* SSLexExpressionListPtr;

   class SSLexMark
      {
      friend class SSLexConsumer;

      public:
         SSConstr          SSLexMark( void);
 
      private:
         SSUnsigned32      oulMark;
         SSUnsigned32      oulLine;
         SSUnsigned32      oulOffset;
      };
 
   class SSLexExpressionList : public SSExceptionPresent
      {
      public:
         SSConstr         SSLexExpressionList( void*);
         SSDestr          SSLexExpressionList( void);

      protected:
         void*            opTable;
      };

   class SSLexTable : public SSExceptionPresent
      {
      public:
         SSConstr               SSLexTable( const char*);

         void*                  table( void);
         SSLexExpressionList*   expressionList( SSUnsigned32 = 0);

         SSDestr                SSLexTable( void);

      private:
         void*                  opTable;
         SSLexExpressionList**  oapExpressionList;
         SSUnsigned32           oulExpressionList;
      };

   class SSLexLexeme : public SSRefCount, public SSExceptionPresent
      {
      public:

         enum SSLexLexemeType
            {
            unicode,
            character
            };

         SSConstr            SSLexLexeme( void);
         SSConstr            SSLexLexeme( SSUnsigned32);
         SSConstr            SSLexLexeme( SSUnsigned32, SSUnsigned32);
         SSConstr            SSLexLexeme( SSLexConsumer&, SSUnsigned32,
                                SSLexMark&, SSBooleanValue = SSFalse);
         SSConstr            SSLexLexeme( SSUnsigned32, SSUnsigned32,
                                SSUnsigned32, SSUnsigned32, 
                                SSBooleanValue = SSFalse);
         SSConstr            SSLexLexeme( SSUnsigned32, SSUnsigned32,
                                const char*, SSUnsigned32, SSUnsigned32,
                                SSBooleanValue = SSFalse);
         SSConstr            SSLexLexeme( SSUnsigned32, SSUnsigned32,
                                const SSUnicode*, SSUnsigned32, SSUnsigned32,
                                SSBooleanValue = SSFalse);

         void*               operator new( size_t);
         void                operator delete( void*);
         void*               operator new( size_t, SSUnsigned32);
 
         SSLexLexemeType     type( void) const;
         SSUnsigned32        line( void) const;
         SSUnsigned32        token( void) const;
         SSUnsigned32        offset( void) const;
         SSUnsigned32        length( void) const;

         void                setBuffer( char*);
         void                setLine( SSUnsigned32);
         void                setToken( SSUnsigned32);
         void                setOffset( SSUnsigned32);
         void                setLength( SSUnsigned32);
         void                setType( SSLexLexemeType);

         char*               asChar( void) const;
         const char*         asConstChar( void) const;
         const SSUnicode*    asConstUnicode( void) const;
                             operator const char*( void);
                             operator const SSUnicode*( void);
         SSBooleanValue      isEqualLexeme( SSLexLexeme&) const;
         SSUnsigned32        asUnsigned32( SSBooleanValue&) const;

         void                refFree( void);
         virtual SSDestr     SSLexLexeme( void);

      protected:
         SSBooleanValue      oOwn;
         SSLexLexemeType     oType;
         SSUnsigned32        oulLine;
         SSUnsigned32        oulToken;
         char*               opchBuff;
         SSUnsigned32        oulLength;
         SSUnsigned32        oulOffset;
      };

   class SSLexConsumer : public SSExceptionPresent
      {
      public:

         enum SSLexConsumerType
            {
            binary,
            unicode,
            character
            };

         SSConstr               SSLexConsumer( SSLexConsumerType = character);

         SSLexMark              mark( void);
         SSBooleanValue         operator++( int);
         SSLexConsumerType      type( void) const;
         SSDbcsInfo&            dbcs( void) const;
         void                   singleByte( void);
         void                   doubleByte( void);
         void                   flushLexeme( void);
         void                   unicodeByte( void);
         SSUnsigned32           current( void) const;
         SSUnsigned32           consumed( void) const;
         virtual SSUnsigned32   nextBuffer( void) = 0;
         SSLexLexeme*           lexemeToCurrent( void);
         SSBooleanValue         endOfData( void) const;
         void                   flushLexeme( SSLexMark&);
         void                   flushStartOfLine( SSLexMark&);
         void                   addBuffer( char*, SSUnsigned32);
         SSLexLexeme*           lexemeToMark( SSLexMark&, SSUnsigned32);
         SSBooleanValue         shiftBuffer( SSUnsigned32&, SSUnsigned32&);
         SSBooleanValue         expandBuffer( SSUnsigned32&, SSUnsigned32&);
         void                   adjustMark( SSLexMark&, SSBooleanValue = SSFalse);

         char*                  buffer( void);
         SSUnsigned32           bufferInc( void);
         SSUnsigned32           line( void) const;
         void                   setBuffer( char*);
         SSUnsigned32           offset( void) const;
         SSUnsigned32           bufferLength( void);
         void                   setEndOfData( void);
         SSUnsigned32           lexemeLength( void) const;
         char*                  lexemeBuffer( void) const;
         void                   setBufferInc( SSUnsigned32);
         void                   setDataLength( SSUnsigned32);
         SSUnsigned32           lexemeLength( SSLexMark&) const;
         void                   setBufferLength( SSUnsigned32);

         virtual SSDestr        SSLexConsumer( void);

      protected:
         SSDbcsInfo&            oDbcs;
         SSLexConsumerType      oType;
         SSUnsigned32           oulBof;
         SSUnsigned32           oulInc;
         SSUnsigned32           oulLine;
         SSUnsigned32           oulBuff;
         SSUnsigned32           oulMark;
         char*                  opchBuff;
         SSUnsigned32           oulStart;
         SSUnsigned32           oulIndex;
         SSUnsigned32           oulLength;
         SSUnsigned32           oulOffset;
         SSUnsigned32           oulCurrent;
         SSBooleanValue         oEndOfData;
         SSUnsigned32           oulConsumed;
         SSUnsigned32           oulScanLine;
         SSUnsigned32           oulMarkLine;
         SSUnsigned32           oulScanOffset;
         SSUnsigned32           oulMarkOffset;
      };

   class SSLexFileConsumer : public SSLexConsumer
      {
      public:
         SSConstr               SSLexFileConsumer( const char*,
                                   SSLexConsumerType = character,
                                   SSUnsigned32 = SSLexConsumerDefaultSize,
                                   SSUnsigned32 = SSLexConsumerDefaultInc);

         void                   close( void);
         FILE*                  file( void) const;
         SSUnsigned32           nextBuffer( void);
 
         virtual SSDestr        SSLexFileConsumer( void);

      protected:
         FILE*                  opFile;
      };

   class SSLexStringConsumer : public SSLexConsumer
      {
      public:
         SSConstr              SSLexStringConsumer( const char*,
                                  SSLexConsumerType = character);

         SSUnsigned32          nextBuffer( void);
      };

   class SSLex : public SSExceptionPresent
      {
      public:
         SSConstr               SSLex( const char* = 0);
         SSConstr               SSLex( const char*, const char*);
         SSConstr               SSLex( SSLexConsumer&, SSLexTable&);

         void                   setTable( SSLexTable&);
         void                   setTable( const char*);
         void                   setConsumer( const char*);
         void                   setConsumer( SSLexConsumer&);

         void                   reset( void);
         SSLexLexeme*           operator++( int);
         SSLexTable*            table( void) const;
         SSUnsigned32           lexemesValid( void);
         SSLexConsumer*         consumer( void) const;
         virtual SSLexLexeme*   error( SSLexConsumer&);
         SSBooleanValue         popExpressionList( void);
         virtual const char*    tokenToConstChar( SSUnsigned32);
         SSBooleanValue         isCurrentExpressionList( SSUnsigned32);
         SSBooleanValue         pushExpressionList( SSLexExpressionList&);
         SSBooleanValue         gotoExpressionList( SSLexExpressionList&);
         virtual SSLexLexeme*   complete( SSLexConsumer&, SSUnsigned32,
                                   SSLexMark&);

         SSDestr                SSLex( void);

      protected:
         SSLexTable*            opTable;
         SSUnsigned32           oulState;
         SSBooleanValue         oOwnTable;
         SSLexConsumer*         opConsumer;
         SSBooleanValue         oOwnConsumer;
         SSUnsigned32           oulLexemesValid;

      protected:
         void                   open( void);
         SSLexIterator&         iterator( void) const;

         SSLexIterator*         opIterator;
         void*                  opExpressionListStack;
      };

#  include<sslex.inl>

#endif
