/* setnewha.c
   Extracted from libgcc2.c and modified by Eberhard Mattes, Aug 1995 */

/* Copyright (C) 1989, 1992, 1993, 1994, 1995 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/* As a special exception, if you link this library with other files,
   some of which are compiled with GCC, to produce an executable,
   this library does not by itself cause the resulting executable
   to be covered by the GNU General Public License.
   This exception does not however invalidate any other reasons why
   the executable file might be covered by the GNU General Public License.  */


#include <unistd.h>

/* set_new_handler (fvoid_t *) and the default new handler, described in
   17.3.3.2 and 17.3.3.5.  These functions define the result of a failure
   to allocate the amount of memory requested from operator new or new []. */

#ifndef inhibit_libc
/* This gets us __GNU_LIBRARY__.  */
#undef NULL /* Avoid errors if stdio.h and our stddef.h mismatch.  */
#include <stdio.h>

#ifdef __GNU_LIBRARY__
  /* Avoid forcing the library's meaning of `write' on the user program
     by using the "internal" name (for use within the library)  */
#define write(fd, buf, n)	__write((fd), (buf), (n))
#endif
#ifdef EMX
#include <io.h>
#define write(fd, buf, n)	_write((fd), (buf), (n))
#define set_new_handler		_set_new_handler
#endif /* EMX */
#endif /* inhibit_libc */

typedef void (*vfp)(void);
void __default_new_handler (void);

vfp __new_handler = (vfp)0;

vfp
set_new_handler (vfp handler)
{
  vfp prev_handler;

  prev_handler = __new_handler;
  if (handler == 0) handler = __default_new_handler;
  __new_handler = handler;
  return prev_handler;
}

#define MESSAGE "Virtual memory exceeded in `new'\n"

void
__default_new_handler ()
{
#ifndef inhibit_libc
  /* don't use fprintf (stderr, ...) because it may need to call malloc.  */
  /* This should really print the name of the program, but that is hard to
     do.  We need a standard, clean way to get at the name.  */
  write (2, MESSAGE, sizeof (MESSAGE));
#endif
  /* don't call exit () because that may call global destructors which
     may cause a loop.  */
  _exit (-1);
}
