/* vftest.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/winmgr.h>

void slow (FILE *f, const char *s)
{
  while (*s != 0)
    {
      fputc (*s, f);
      _sleep2 (200);
      ++s;
    }
}


void buffer (wm_handle wh, const char *s, int mode)
{
  FILE *f;

  f = wm_fopen (wh);
  if (f == NULL)
    {
      perror ("wm_fopen");
      exit (1);
    }
  setvbuf (f, NULL, mode, 64);
  slow (f, s);
  wm_fclose (f);
}


int main (int argc, char *argv[])
{
  FILE *f;
  wm_handle wh;
  const char *s;

  if (!wm_init (1))
    {
      fprintf (stderr, "wm_init() failed.\n");
      return 1;
    }
  wh = wm_create (8, 4, 63, 20,
                  1, BW_NORMAL|INTENSITY, BW_NORMAL);
  if (wh == NULL)
    {
      fprintf (stderr, "wm_create() failed.\n");
      return 1;
    }
  wm_open (wh);
  f = wm_fopen (wh);
  if (f == NULL)
    {
      perror ("wm_fopen");
      return 1;
    }
  fprintf (f, "This is printed by fprintf\n");
  fputs ("This is printed by fputs\n", f);
  for (s = "This is printed with fputc\n"; *s != 0; ++s)
    fputc (*s, f);
  s = "This is printed with fwrite\n";
  fwrite (s, strlen (s), 1, f);
  slow (f, "Unbuffered\n  output\n");
  wm_fclose (f);
  buffer (wh, "Buffered\n  output\n", _IOFBF);
  buffer (wh, "Line-buffered\n  output\n", _IOLBF);
  wm_exit ();
  return 0;
}
