diff -urP ../mh-6.8.4/conf/config/config.c ./conf/config/config.c
--- ../mh-6.8.4/conf/config/config.c	Wed Dec  1 13:00:14 1993
+++ ./conf/config/config.c	Sat Mar  2 14:23:28 1996
@@ -14,6 +14,12 @@
 #include <stdio.h>
 
 
+#ifdef __EMX__
+#define binpath(file)  #file".exe"
+#define binpath2(file) #file
+#define etcpath(file)  #file".exe"
+#define etcpath2(file) #file
+#else
 #if	defined(__STDC__)
 #define	binpath(file) "@(MHBINPATH)/"#file
 #define	etcpath(file) "@(MHETCPATH)/"#file
@@ -21,6 +27,7 @@
 #define binpath(file) "@(MHBINPATH)/file"
 #define etcpath(file) "@(MHETCPATH)/file"
 #endif
+#endif
 
 static char Config[] = "@(#)Config: @(MHCONFIGFILE)";
 
@@ -51,6 +58,10 @@
 #ifdef	MHRC
     m_getdefs ();
 #endif /* MHRC */
+#ifdef __EMX__
+    if (_fnisabs (file))
+        return file;
+#endif
 
     switch (*file) {
 	case '/': 
@@ -85,10 +96,43 @@
 		return cp;
     }
 
+#ifdef __EMX__
+    cp = getenv ("MHETCPATH");
+    if (cp && *cp) {
+        strcpy (lpath, cp);
+        strcat (lpath, "/");
+        strcat (lpath, file);
+        _abspath (lpath, lpath, BUFSIZ);
+    }
+    else
+        (void) sprintf (lpath, "@(MHETCPATH)/%s", file);
+#else
     (void) sprintf (lpath, etcpath (%s), file);
+#endif
     return (access (lpath, 04) != NOTOK ? lpath : file);
 }
 
+#ifdef __EMX__
+static    char epath[BUFSIZ];
+
+char   *exepath (file)
+char   *file;
+{
+    char   *cp;
+
+    cp = getenv ("MHBINPATH");
+    if (cp && *cp) {
+        strcpy (epath, cp);
+        strcat (epath, "/");
+        strcat (epath, file);
+        _abspath (epath, epath, BUFSIZ);
+    }
+    else
+        (void) sprintf (epath, "@(MHBINPATH)/%s", file);
+    return (access (epath, 04) != NOTOK ? epath : file);
+}
+
+#endif
 /*  */
 
 /* 
@@ -115,7 +159,11 @@
 char   *draft = "draft";
 char   *forwcomps = "forwcomps";
 char   *inbox = "inbox";
+#ifdef __EMX__
+char   *mh_defaults = etcpath2 (mh.profile);
+#else
 char   *mh_defaults = etcpath (mh.profile);
+#endif
 char   *mh_profile = ".mh_profile";
 char   *mhlformat = "mhl.format";
 char   *mhlforward = "mhl.forward";
@@ -196,7 +244,11 @@
  */
 
 #ifndef	MORE
+#ifdef __EMX__
+char   *lproc = "mhl.exe";
+#else
 char   *lproc = "/usr/ucb/more";
+#endif
 #else /* MORE */
 char   *lproc = MORE;
 #endif /* MORE */
@@ -214,7 +266,11 @@
  */
 
 #ifndef	MORE
+#ifdef __EMX__
+char   *moreproc = NULL;
+#else
 char   *moreproc = "/usr/ucb/more";
+#endif
 #else /* MORE */
 char   *moreproc = MORE;
 #endif /* MORE */
@@ -284,7 +340,11 @@
  */
 
 #ifndef	MORE
+#ifdef __EMX__
+char   *showproc = "mhl.exe";
+#else
 char   *showproc = "/usr/ucb/more";
+#endif
 #else /* MORE */
 char   *showproc = MORE;
 #endif /* MORE */
@@ -336,7 +396,11 @@
  * This is the MH alias file.
  */
 
+#ifdef __EMX__
+char   *AliasFile = etcpath2 (MailAliases);
+#else
 char   *AliasFile = etcpath (MailAliases);
+#endif
 
 /*  */
 
diff -urP ../mh-6.8.4/conf/config/mts.c ./conf/config/mts.c
--- ../mh-6.8.4/conf/config/mts.c	Sat Mar  2 01:48:50 1996
+++ ./conf/config/mts.c	Sat Jul  6 15:35:16 1996
@@ -10,6 +10,9 @@
 #define	NETWORK
 #endif
 
+#ifdef  __EMX__
+#include <sys/types.h>
+#endif /* __EMX__ */
 #include "../h/strings.h"
 #include <ctype.h>
 #include <stdio.h>
@@ -19,7 +22,7 @@
 #include <netdb.h>
 #endif
 #else	/* NETWORK */
-#ifndef SYS5
+#if !defined(SYS5) && !defined(__EMX__)
 #include <whoami.h>
 #else
 #include <sys/utsname.h>
@@ -84,7 +87,11 @@
 
 
 #ifdef	MF
+#ifdef  __EMX__
+char   *umincproc = "uminc.exe";
+#else
 char   *umincproc = "@(MHETCPATH)/uminc";
+#endif
 #else /* MF */
 char   *umincproc = NULL;
 #endif /* MF */
@@ -119,7 +126,11 @@
 
 #ifdef	SENDMTS
 char   *hostable = "@(MHETCPATH)/hosts";
+#ifdef  __EMX__
+char   *sendmail = "sendmail";
+#else
 char   *sendmail = "/usr/lib/sendmail";
+#endif
 #endif /* SENDMTS */
 
 
@@ -242,8 +253,33 @@
     register    FILE *fp;
     static int  inited = 0;
 
+#ifdef __EMX__
+    if (inited++)
+	return;
+#ifdef MF
+    uupc_init ();
+#endif    
+#if defined(SENDMTS) && !defined(SMTP) && !defined(SOUPER)
+    tcpip_init ();
+    localname = SendmailReplyDomain;
+    servers = SendmailMailServer;
+#endif
+    cp = getenv ("MHETCPATH");
+    if (cp && *cp) {
+        strcpy (buffer, cp);
+        strcat (buffer, "/");
+        strcat (buffer, "mtstailor");
+        _abspath (buffer, buffer, BUFSIZ);
+    }
+    else
+        strcpy (buffer, mtstailor);
+
+    if ((fp = fopen (buffer, "r")) == NULL)
+	return;
+#else
     if (inited++ || (fp = fopen (mtstailor, "r")) == NULL)
 	return;
+#endif
 
     while (fgets (buffer, sizeof buffer, fp)) {
 	if ((cp = index (buffer, '\n')) == NULL)
@@ -389,7 +425,7 @@
 /*  */
 
 char *SystemName () {
-#if	defined(SYS5) && !defined(NETWORK)
+#if	(defined(SYS5) || defined(__EMX__)) && !defined(NETWORK)
     struct utsname name;
 #endif /* SYS5 and not NETWORK */
     static char buffer[BUFSIZ] = "";
@@ -400,14 +436,18 @@
     mts_init ("mts");
     if (*systemname)
 	return strcpy (buffer, systemname);
+#if	defined(__EMX__) && defined(MF)
+    if (*UupcFromDomain)
+	return strcpy (buffer, UupcFromDomain);
+#endif
 
 #ifdef	sysname
     (void) strcpy (buffer, sysname);
 #else /* sysname */
-#if	!defined(SYS5) || defined(NETWORK)
+#if	(!defined(SYS5) && !defined(__EMX__)) || defined(NETWORK)
     (void) gethostname (buffer, sizeof buffer);
 #else /* SYS5 and not NETWORK */
-#ifdef	SYS5
+#if	defined(SYS5) || defined(__EMX__)
     (void) uname (&name);
     (void) strcpy (buffer, name.nodename);
 #endif /* SYS5 */
@@ -485,6 +525,7 @@
     if (username[0])
 	return username;
 
+#ifndef __EMX__
 #ifndef KPOP
     if ((pw = getpwuid (getuid ())) == NULL
 	    || pw -> pw_name == NULL
@@ -498,11 +539,17 @@
 	     || pw -> pw_name == NULL
 	     || *pw -> pw_name == '\0') {
 #endif /* KPOP */
+#else  /* __EMX__ */
+    if ((cp = getenv ("USER")) != NULL)
+      strcpy (username, cp);
+    else {
+#endif /* __EMX__ */
 	(void) strcpy (username, "unknown");
 	(void) sprintf (fullname, "The Unknown User-ID (%d)", getuid ());
 	return username;
     }
 
+#ifndef __EMX__
     np = pw -> pw_gecos;
 #ifndef	GCOS_HACK
     for (cp = fullname; *np && *np != (MMailids ? '<' : ','); *cp++ = *np++)
@@ -529,7 +576,13 @@
     }
     if (MMailids == 0 || *np == '\0')
 	(void) strcpy (username, pw -> pw_name);
+#endif /* not __EMX__ */
 
+#if	defined(__EMX__) && defined(MF)
+    mts_init ("mts");
+    if (*UupcName)
+	(void) strcpy (fullname, UupcName);
+#endif
     if ((cp = getenv ("SIGNATURE")) && *cp)
 	(void) strcpy (fullname, cp);
     if (index(fullname, '.')) {		/*  quote any .'s */
diff -urP ../mh-6.8.4/conf/mhconfig.c ./conf/mhconfig.c
--- ../mh-6.8.4/conf/mhconfig.c	Sat Mar  2 01:49:16 1996
+++ ./conf/mhconfig.c	Sat Jul  6 17:22:56 1996
@@ -6,6 +6,9 @@
 
 #include <ctype.h>
 #include <stdio.h>
+#ifdef __EMX__
+#include <stdlib.h>
+#endif
 #ifdef	hpux
 #define	SYS5
 #endif
@@ -21,12 +24,21 @@
 extern	char *sprintf();	/* rely on stdio.h to declare this */
 #endif
 
+#ifdef __EMX__
+#define	BANNER	"This is %s, for OS/2 (MH.6 configuration program)\n\n"
+#else
 #define	BANNER	"This is %s, for generic UNIX (MH.6 configuration program)\n\n"
+#endif
 
 
 #define	SED		"config.sed"
+#ifdef __EMX__
+#define	SEDOC		"doc\\config.sed"
+#define	MAKE		"..\\%s\\Makefile"
+#else
 #define	SEDOC		"doc/config.sed"
 #define	MAKE		"../%s/Makefile"
+#endif
 
 #define	WARNING	"This file is automatically generated.  Do not edit!"
 #define	MHRELEASE	"6.8.4"		/* for version: "Maj.min.pat" */
@@ -119,6 +131,9 @@
     "mh", "MHMTS", mh, NOFLAGS,
     "sendmail", "SENDMTS", sendmail, NOMF,
     "sendmail/smtp", "SENDMTS SMTP", sendmail, NOMF,
+#ifdef __EMX__
+    "souper", "SENDMTS SOUPER", sendmail, NOMF,
+#endif
     "zmailer", "ZMAILER SENDMTS", sendmail, NOMF,
     "zmailer/smtp", "ZMAILER SENDMTS SMTP", sendmail, NOMF,
     NULL, NULL, unknown, NOFLAGS
@@ -198,6 +213,19 @@
 /*  */
 
 char   *files[] = {
+#ifdef __EMX__
+    "..\\support\\bboards\\bboards.daily",
+    "..\\support\\bboards\\bboards.weekly",
+    "..\\support\\bboards\\crontab",
+    "..\\support\\bboards\\MakeBBoards",
+    "..\\config\\config.c",
+    "..\\zotnet\\mts\\mts.c",
+    "..\\zotnet\\mts\\mtstailor",
+    "..\\support\\general\\MailAliases",
+    "..\\mts\\sendmail\\bboardsMH.m4",
+    "..\\mts\\sendmail\\popMH.m4",
+    NULL
+#else
     "../support/bboards/bboards.daily",
     "../support/bboards/bboards.weekly",
     "../support/bboards/crontab",
@@ -209,12 +237,30 @@
     "../mts/sendmail/bboardsMH.m4",
     "../mts/sendmail/popMH.m4",
     NULL
+#endif
 };
 
 static struct pair {
     char   *infile;
     char   *outfile;
 }                  makefiles[] = {
+#ifdef __EMX__
+			"os2\\MH-Makefile", ".",
+			"os2\\config","config",
+			"os2\\doc","doc",
+			"os2\\mtsM","mts",
+			    "os2\\mts\\mh","mts\\mh",
+			    "os2\\mts\\sendmail","mts\\sendmail",
+			"os2\\sbr","sbr",
+			"os2\\supportM","support",
+			    "os2\\support\\general","support\\general",
+			"os2\\uip","uip",
+			"os2\\zotnetM","zotnet",
+			    "os2\\zotnet\\bboards","zotnet\\bboards",
+			    "os2\\zotnet\\mf","zotnet\\mf",
+			    "os2\\zotnet\\mts","zotnet\\mts",
+			    "os2\\zotnet\\tws","zotnet\\tws",
+#else
 			"makefiles/MH-Makefile", ".",
 			"makefiles/config","config",
 			"makefiles/dist","dist",
@@ -235,6 +281,7 @@
 			    "makefiles/zotnet/mf","zotnet/mf",
 			    "makefiles/zotnet/mts","zotnet/mts",
 			    "makefiles/zotnet/tws","zotnet/tws",
+#endif
 			NULL
 };
 
@@ -547,13 +594,21 @@
     char  **pp;
 
     for (pp = files; *pp; pp++)
+#ifdef __EMX__
+	shell ("rm -f %s & sed -f %s < config\\%s > %s",
+#else
 	shell ("rm -f %s; sed -f %s < config/%s > %s",
+#endif
 		*pp, SED, tail (*pp), *pp);
 }
 
 
 static  do_doc () {
+#ifdef __EMX__
+    shell (".\\mhdoc");
+#else
     shell ("./mhdoc");
+#endif
 }
 
 
@@ -563,7 +618,11 @@
 
     for (pp = makefiles; pp -> infile; pp++) {
 	(void) sprintf (buffer, MAKE, pp -> outfile);
+#ifdef __EMX__
+	shell ("rm -f %s & sed -f %s < %s > %s",
+#else
 	shell ("rm -f %s; sed -f %s < %s > %s",
+#endif
 		buffer, SED, pp -> infile, buffer);
     }
 }
@@ -598,11 +657,21 @@
     char   *ap,
            *cp,
            *dp,
+#ifdef __EMX__
+           *tp,
+           *tp2,
+            buffer2[BUFSIZ],
+#endif
             buffer[BUFSIZ];
     struct bind *bp;
     FILE * fp;
 
+#ifdef __EMX__
+    myname = _getname (*vec);
+    _remext (myname);
+#else
     myname = tail (*vec);
+#endif
     printf (BANNER, myname);
     (void) fflush (stdout);
     
@@ -710,7 +779,11 @@
     if (mailpath == NULL)
 	adios (NULLCP, "mail must be specified in %s", config);
     trim (mailpath);
+#ifdef __EMX__
+    if (_fnisabs(mailpath))
+#else
     if (*mailpath == '/')
+#endif
 	maildir = mailpath;
     else
 	mailfile = mailpath;
@@ -794,7 +867,23 @@
 	for (ap = cp; dp = index (ap, ' '); ap = dp) {
 	    *dp++ = '\0';
 	    add_myopt (ap);
+#ifdef __EMX__
+	    /* This is a quick hack for OS/2 GNU make. OS/2 GNU make does NOT  */
+	    /* allow -DPOPSERVICE='"pop3"'.  Instead, it should be             */
+	    /* -DPOPSERVICE=\"pop3\".  Also, -DSBACKUP=\"#\" is invalid        */
+	    /* because # alone is handles as a start of comment.  It should be */
+	    /* -DSBACKUP=\"\#\".  Interesting though....                       */
+	    for (tp = ap, tp2 = buffer2; *tp; tp++) {
+		if (*tp == '\"' || *tp == '#'){
+		    *tp2++ = '\\'; *tp2++ = '\\';
+		}
+		*tp2++ = *tp;
+	    }
+	    *tp2 = '\0';
+	    (void) sprintf (buffer, "%s-D%s", options ? " " : "", buffer2);
+#else
 	    (void) sprintf (buffer, "%s-D%s", options ? " " : "", ap);
+#endif
 	    ap = buffer;
 	    options = stradd (ap, options);
 	    while (isspace (*dp))
@@ -802,7 +891,18 @@
 	}
 	if (*ap) {
 	    add_myopt (ap);
+#ifdef __EMX__
+	    for (tp = ap, tp2 = buffer2; *tp; tp++) {
+		if (*tp == '\"' || *tp == '#'){
+		    *tp2++ = '\\'; *tp2++ = '\\';
+		}
+		*tp2++ = *tp;
+	    }
+	    *tp2 = '\0';
+	    (void) sprintf (buffer, "%s-D%s", options ? " " : "", buffer2);
+#else
 	    (void) sprintf (buffer, "%s-D%s", options ? " " : "", ap);
+#endif
 	    ap = buffer;
 	    options = stradd (ap, options);
 	}
@@ -903,7 +1003,11 @@
 {
     char   *p;
 
+#ifdef __EMX__
+    if (p = rindex (s, '\\'))
+#else
     if (p = rindex (s, '/'))
+#endif
 	p++;
     return ((p == NULL || *p == '\0') ? s : p);
 }
diff -urP ../mh-6.8.4/config/version.cmd ./config/version.cmd
--- ../mh-6.8.4/config/version.cmd	Thu Jan  1 00:00:00 1970
+++ ./config/version.cmd	Sat Mar  2 14:23:52 1996
@@ -0,0 +1,24 @@
+/* */
+
+Patch="..\Patchlevel"
+
+if LINES(Patch) then do
+  ln = LINEIN(Patch, 1, 1)
+  parse var ln mh '.' major '.' minor ' ' pat '.' plevel
+end
+else do
+  parse arg ln
+  parse var ln major '.' minor '.' plevel
+end
+
+if plevel ='' then
+  ver =  major'.'minor
+else
+  ver =  major'.'minor'.'plevel
+
+'@rm -f version.c'
+
+'@echo char *version = "@(#)MH' ver '[OS/2] of' TIME('N') DATE('N')'"; >> version.c'
+'@echo .ds MH' ver '[OS/2] > ..\doc\version.rf'
+call LINEOUT '..\doc\version.rf' ''
+'@echo' ver '> version'
diff -urP ../mh-6.8.4/h/local.h ./h/local.h
--- ../mh-6.8.4/h/local.h	Wed Dec  1 13:00:26 1993
+++ ./h/local.h	Sat Mar  2 14:23:54 1996
@@ -7,6 +7,7 @@
 #include <sys/param.h>
 #endif
 
+#ifndef	__EMX__
 #ifndef	BSD42
 #ifndef NDIR
 #ifndef	SYS5DIR
@@ -18,6 +19,9 @@
 #include <ndir.h>
 #endif
 #else	/* BSD42 */
+#include <sys/dir.h>
+#endif
+#else   /* __EMX__ */
 #include <sys/dir.h>
 #endif
 
diff -urP ../mh-6.8.4/h/mh.h ./h/mh.h
--- ../mh-6.8.4/h/mh.h	Wed Dec  1 13:00:26 1993
+++ ./h/mh.h	Sat Mar  2 14:24:04 1996
@@ -265,6 +265,9 @@
 char   *getcpy ();
 void	help ();
 char   *libpath ();
+#ifdef __EMX__
+char   *exepath ();
+#endif /* __EMX__ */
 int     m_atoi ();
 char   *m_backup ();
 int     m_convert ();
@@ -322,6 +325,10 @@
 char   *trimcpy ();
 int     type ();
 int     uleq ();
+#ifdef __EMX__
+int     _unlink2 ();
+char   *_getenv2 ();
+#endif /* __EMX__ */
 int	unputenv ();
 int     uprf ();
 int	vfgets ();
@@ -332,7 +339,7 @@
 
 /* should be in <stdio.h> */
 
-#if	!defined(SYS5) && !defined(ncr) && !defined(_AIX) && !defined(OSF1) && !defined(__convex__) && !defined(__386BSD__) && !defined(BSD44)
+#if	!defined(SYS5) && !defined(ncr) && !defined(_AIX) && !defined(OSF1) && !defined(__convex__) && !defined(__386BSD__) && !defined(BSD44) && !defined(__EMX__)
 typedef struct _iobuf  *FP;
 FP   popen ();
 #else /* SYS5 */
@@ -342,7 +349,7 @@
 
 /* miscellaneous */
 
-#if !defined(BSD42) && !defined(hpux) && !defined(ncr) && !defined(_AIX) && !defined(RENAME)
+#if !defined(BSD42) && !defined(hpux) && !defined(ncr) && !defined(_AIX) && !defined(RENAME) && !defined(__EMX__)
 #define	rename(f1,f2)	(link (f1, f2) != NOTOK ? unlink (f1) : NOTOK)
 #endif	/* not BSD42 */
 
@@ -362,4 +369,10 @@
 #if (defined(BSD44) || defined(SUN40) || defined(hpux) \
 	|| defined(_AIX) || defined (sgi)) && !defined(UNISTD)
 #define       UNISTD
+#endif
+
+#if defined(__EMX__)
+#define chdir _chdir2
+#define unlink	_unlink2
+#define getenv	_getenv2
 #endif
diff -urP ../mh-6.8.4/h/strings.h ./h/strings.h
--- ../mh-6.8.4/h/strings.h	Sat Mar  2 01:49:24 1996
+++ ./h/strings.h	Sat Mar  2 14:24:06 1996
@@ -8,6 +8,20 @@
 #include <stdlib.h>
 #endif
 
+#ifdef __EMX__
+#include <string.h>
+#include <stdlib.h>
+#include <memory.h>
+
+#define     index                    strchr
+#define     rindex                   strrchr
+#define     strcasecmp               stricmp
+#define     bcmp(b1,b2,length)       memcmp(b1, b2, length)
+#define     bcopy(b1,b2,length)      (void) memcpy (b2, b1, length)
+#define     bcpy(b1,b2,length)       memcmp (b1, b2, length)
+#define     bzero(b,length)          (void) memset (b, 0, length)
+#else /* __EMX__ */
+
 #ifdef _AIX
 #include <string.h>
 #include <stdlib.h>
@@ -64,6 +78,7 @@
 #define	bzero(b,length)		(void) memset (b, 0, length)
 #endif /* SYS5 */
 #endif	/* _AIX */
+#endif	/* __EMX__ */
 #endif /* not _STRINGS */
 
 #if !defined(bcopy) && (defined(__HIGHC__) || __GNUC__ == 2)
diff -urP ../mh-6.8.4/mts/mh/hosts.c ./mts/mh/hosts.c
--- ../mh-6.8.4/mts/mh/hosts.c	Wed Dec  1 13:00:52 1993
+++ ./mts/mh/hosts.c	Sat Apr  6 13:44:00 1996
@@ -15,6 +15,9 @@
 #include "../zotnet/mts.h"
 #include <ctype.h>
 #if	defined(BSD42) || defined(SOCKETS)
+#ifdef  __EMX__
+#include <sys/types.h>
+#endif
 #include <netdb.h>
 #endif	/* BSD42 or SOCKETS */
 
diff -urP ../mh-6.8.4/mts/mh/netmail.c ./mts/mh/netmail.c
--- ../mh-6.8.4/mts/mh/netmail.c	Wed Dec  1 13:00:52 1993
+++ ./mts/mh/netmail.c	Sat Apr  6 13:55:46 1996
@@ -33,7 +33,9 @@
 
 
 long    time ();
-char   *cdate (), *ctime ();
+char   *ctime ();
+static  char *cdate ();
+static  quefile ();
 
 /*  */
 
@@ -113,7 +115,7 @@
 	*p++ = hex[(*q >> 4) & 0xf];
 	*p++ = hex[(*q) & 0xf];
     }
-    *p = NULL;
+    *p = '\0';
 
     (void) sprintf (que, "%s/%s", Mailqdir, buffer);
     (void) sprintf (lnk, "%s/%s", TMailqdir, buffer);
@@ -134,7 +136,7 @@
     cp[8] = cp[22];
     cp[9] = cp[23];
     cp[10] = '@';
-    cp[19] = NULL;
+    cp[19] = '\0';
 
     return cp + 1;
 }
diff -urP ../mh-6.8.4/mts/mh/uucp.c ./mts/mh/uucp.c
--- ../mh-6.8.4/mts/mh/uucp.c	Wed Dec  1 13:00:54 1993
+++ ./mts/mh/uucp.c	Mon Apr 29 14:47:04 1996
@@ -16,6 +16,9 @@
 int    uucpsite (system)
 register char  *system;
 {
+#ifdef  __EMX__
+    return OK;
+#else
     register char  *bp;
     char    buffer[BUFSIZ];
     register FILE  *fp;
@@ -27,7 +30,7 @@
 	if (strncmp (buffer, "xxx", 3) == 0
 		|| (bp = index (buffer, ' ')) == NULL)
 	    continue;
-	*bp = NULL;
+	*bp = '\0';
 	if (strcmp (buffer, system) == 0) {
 	    (void) fclose (fp);
 	    return OK;
@@ -36,4 +39,5 @@
 
     (void) fclose (fp);
     return NOTOK;
+#endif
 }
diff -urP ../mh-6.8.4/mts/sendmail/hosts.c ./mts/sendmail/hosts.c
--- ../mh-6.8.4/mts/sendmail/hosts.c	Wed Dec  1 13:00:54 1993
+++ ./mts/sendmail/hosts.c	Sat Mar  2 14:24:10 1996
@@ -11,6 +11,9 @@
    let SendMail worry about it. */
 
 
+#ifdef __EMX__
+#include <sys/types.h>
+#endif /* __EMX__ */
 #include "../h/strings.h"
 #include <stdio.h>
 #include "../zotnet/mts.h"
diff -urP ../mh-6.8.4/mts/sendmail/smail.c ./mts/sendmail/smail.c
--- ../mh-6.8.4/mts/sendmail/smail.c	Sat Mar  2 01:49:36 1996
+++ ./mts/sendmail/smail.c	Sun Jun 30 21:58:48 1996
@@ -168,6 +168,9 @@
     if (client == NULL || *client == '\0')
 	client = "localhost";
 #endif
+#ifdef __EMX__
+    return RP_OK;
+#endif
 
     if (pipe (pdi) == NOTOK)
 	return sm_ierror ("no pipes");
@@ -342,8 +345,13 @@
     (void) signal (SIGALRM, alrmser);
     (void) signal (SIGPIPE, SIG_IGN);
 
+#ifdef  __EMX__
+    if ((sm_rfp = fdopen (sd1, "rb")) == NULL
+	    || (sm_wfp = fdopen (sd2, "wb")) == NULL) {
+#else  /* __EMX__ */
     if ((sm_rfp = fdopen (sd1, "r")) == NULL
 	    || (sm_wfp = fdopen (sd2, "w")) == NULL) {
+#endif  /* __EMX__ */
 	(void) close (sd1);
 	(void) close (sd2);
 	sm_rfp = sm_wfp = NULL;
@@ -450,6 +458,9 @@
 register int	mode;
 register char   *from;
 {
+#if defined(__EMX__) && !defined(SMTP)
+    return RP_OK;
+#endif
 #ifdef	MPOP
     if (sm_ispool && !sm_wfp) {
 	(void) strlen (strcpy (sm_reply.text,
@@ -490,6 +501,9 @@
 	 char   *host,
 		*path;
 {
+#if defined(__EMX__) && !defined(SMTP)
+    return RP_OK;
+#endif
 #ifndef	BERK
     switch (smtalk (SM_RCPT, host && *host ? "RCPT TO:<%s%s@%s>"
 					   : "RCPT TO:<%s%s>",
@@ -530,6 +544,9 @@
 /*  */
 
 int     sm_waend () {
+#if defined(__EMX__) && !defined(SMTP)
+    return RP_OK;
+#endif
     switch (smtalk (SM_DATA, "DATA")) {
 	case 354: 
 	    sm_nl = TRUE;
@@ -604,6 +621,9 @@
     struct smtp sm_note;
 
 #ifndef	SMTP
+#ifdef __EMX__
+    return RP_OK;
+#endif
     switch (sm_child) {
 	case NOTOK: 
 	case OK: 
diff -urP ../mh-6.8.4/sbr/addrsbr.c ./sbr/addrsbr.c
--- ../mh-6.8.4/sbr/addrsbr.c	Wed Dec  1 13:01:20 1993
+++ ./sbr/addrsbr.c	Sat Sep 21 21:20:42 1996
@@ -187,12 +187,15 @@
 
 	case NORMAL+'\n':	/* discard newlines */
 	case QS+'\n':
-	case COM+'\n':
 	case ERR+'\n':
 	    --nxtout;
 	    --adrcopy;
 	    break;
 
+	case COM+'\n':
+	    --adrcopy;
+	    break;
+
 	case NORMAL+' ':	/* skip unquoted whitespace */
 	case NORMAL+'\t':
 	    --nxtout;
@@ -417,7 +420,7 @@
 #else /* not MMDFMTS */
 	if (up && (pp = index (host, '.')) 
 		&& uleq (up, pp + 1)) {/* uucpaddr@host.<uucp> */
-	    *pp = NULL;
+	    *pp = '\0';
 	    mp -> m_host = getcpy (host);
 	    mp -> m_mbox = getcpy (mbox);
 	    mp -> m_type = UUCPHOST;
@@ -427,7 +430,7 @@
 	if (up && uleq (dfhost, LocalName ())
 		&& uleq (up, host)) {/* uucpaddr@<uucp> [local] */
 	    if (pp = index (mbox, '!')) {
-		*pp++ = NULL;
+		*pp++ = '\0';
 		mp -> m_host = getcpy (mbox);
 		mp -> m_mbox = getcpy (pp);
 	    }
@@ -472,7 +475,7 @@
     if (wanthost == AD_NHST)
 	mp -> m_type = uleq (LocalName (), mp -> m_host)
 	    ? LOCALHOST : NETHOST;
-#ifdef	DUMB
+#if	defined(DUMB) || defined(__EMX__)
     else
 	mp -> m_type = uleq (LocalName (), mp -> m_host) ? LOCALHOST
 		: NETHOST;
@@ -487,7 +490,7 @@
 	}
 	else {
 	    if (dp = index (mp -> m_host, '.')) {
-		*dp = NULL;
+		*dp = '\0';
 		if (pp = OfficialName (mp -> m_host))
 		    goto got_real_host;
 		*dp = '.';
@@ -567,7 +570,11 @@
 	(void) sprintf (addr, "%s!%s%%%s@%s", mp -> m_host, mp -> m_mbox,
 		up, LocalName ());
 #else /* not MMDFMTS */
+#ifdef  __EMX__
+	(void) sprintf (addr, "%s@%s", mp -> m_mbox, mp -> m_host);
+#else /* not __EMX__ */
 	(void) sprintf (addr, "%s@%s.%s", mp -> m_mbox, mp -> m_host, up);
+#endif /* __EMX__ */
 #endif /* not MMDFMTS */
     else 
 #endif /* MF */
diff -urP ../mh-6.8.4/sbr/advertise.c ./sbr/advertise.c
--- ../mh-6.8.4/sbr/advertise.c	Wed Dec  1 13:01:20 1993
+++ ./sbr/advertise.c	Sat Mar  2 14:24:16 1996
@@ -15,10 +15,12 @@
    output...  More importantly though, it's a sexy syscall()...
  */
 
+#ifndef __EMX__
 extern int  errno;
 #ifndef	BSD44	/* in <stdio.h> */
 extern int  sys_nerr;
 extern char *sys_errlist[];
+#endif
 #endif
 
 /*  */
diff -urP ../mh-6.8.4/sbr/closefds.c ./sbr/closefds.c
--- ../mh-6.8.4/sbr/closefds.c	Wed Dec  1 13:01:20 1993
+++ ./sbr/closefds.c	Mon Sep 16 21:52:24 1996
@@ -8,15 +8,22 @@
 #include <stdio.h>
 #endif	/* not BSD42 */
 
+#ifdef		__EMX__
+extern __const__ int _nfiles;
+#endif	/*      __EMX__ */
 
 void	closefds (i)
 register int	i;
 {
+#ifndef	__EMX__
 #ifndef	BSD42
     int     nbits = _NFILE;
 #else	/* BSD42 */
     int     nbits = getdtablesize ();
 #endif	/* BSD42 */
+#else	/* __EMX__  */
+    int     nbits = _nfiles;
+#endif	/* __EMX__ */
 
     for (; i < nbits; i++)
 #ifdef	OVERHEAD
diff -urP ../mh-6.8.4/sbr/discard.c ./sbr/discard.c
--- ../mh-6.8.4/sbr/discard.c	Wed Dec  1 13:01:22 1993
+++ ./sbr/discard.c	Sat Mar  2 14:24:22 1996
@@ -8,7 +8,7 @@
 #ifdef POSIX
 #include <termios.h>
 #else
-#ifndef	SYS5
+#if !defined(SYS5) && !defined(__EMX__)
 #include <sgtty.h>
 #else	/* SYS5 */
 #include <sys/types.h>
@@ -16,7 +16,7 @@
 #ifndef	NOIOCTLH
 #include <sys/ioctl.h>
 #endif	/* NOIOCTLH */
-#endif	/* SYS5 */
+#endif	/* SYS5, __EMX__ */
 #endif	/* POSIX */
 
 
@@ -24,9 +24,9 @@
 FILE   *io;
 {
 #ifndef POSIX
-#ifndef	SYS5
+#if !defined(SYS5) && !defined(__EMX__)
     struct sgttyb   sg;
-#else	/* SYS5 */
+#else	/* SYS5, __EMX__ */
     struct termio   sg;
 #endif	/* SYS5 */
 #endif	/* POSIX */
@@ -37,19 +37,29 @@
 #ifdef POSIX
     tcflush (fileno (io), TCOFLUSH);
 #else
-#ifndef	SYS5
+#if !defined(SYS5) && !defined(__EMX__)
     if (ioctl (fileno (io), TIOCGETP, (char *) &sg) != NOTOK)
 	(void) ioctl (fileno (io), TIOCSETP, (char *) &sg);
 #else	/* SYS5 */
     if (ioctl (fileno (io), TCGETA, &sg) != NOTOK)
 	(void) ioctl (fileno (io), TCSETA, &sg);
-#endif	/* SYS5 */
+#endif	/* SYS5, __EMX__ */
 #endif	/* POSIX */
 
+#ifdef __EMX__
+#ifdef _FILE_MEMBERS_HAVE_UNDERSCORE
+    if (io -> _ptr = io -> _buffer)
+	io -> _wcount = io -> _rcount = 0;
+#else
+    if (io -> ptr = io -> buffer)
+	io -> wcount = io -> rcount = 0;
+#endif
+#else
 #ifdef _FSTDIO
     fpurge (io);
 #else
     if (io -> _ptr = io -> _base)
 	io -> _cnt = 0;
 #endif
+#endif  /* __EMX__ */
 }
diff -urP ../mh-6.8.4/sbr/formatsbr.c ./sbr/formatsbr.c
--- ../mh-6.8.4/sbr/formatsbr.c	Sat Mar  2 01:49:36 1996
+++ ./sbr/formatsbr.c	Sat Sep 21 21:19:02 1996
@@ -45,6 +45,9 @@
 {
     struct stat st;
     register    FILE *fp;
+#ifdef __EMX__
+    int         len;
+#endif
 
     if (formats)
 	free (formats);
@@ -59,10 +62,17 @@
 	if ((formats = malloc ((unsigned) st.st_size + 1)) == NULLCP)
 	    adios (form, "unable to allocate space for format");
 
+#ifdef __EMX__
+	if ((len = read (fileno(fp), formats, (int) st.st_size)) == EOF)
+	    adios (form, "error reading format file");
+
+	formats[len] = '\0';
+#else  /* __EMX__ */
 	if (read (fileno(fp), formats, (int) st.st_size) != st.st_size)
 	    adios (form, "error reading format file");
 
 	formats[st.st_size] = '\0';
+#endif /* __EMX__ */
 
 	(void) fclose (fp);
     }
@@ -516,7 +526,8 @@
 	    if (str) {
 		    register char *xp;
 
-		    (void) strcpy(buffer, str);
+		    (void) strncpy(buffer, str, BUFSIZ);
+		    buffer[BUFSIZ-1] = '\0';
 		    str = buffer;
 		    while (isspace(*str))
 			    str++;
diff -urP ../mh-6.8.4/sbr/getanswer.c ./sbr/getanswer.c
--- ../mh-6.8.4/sbr/getanswer.c	Wed Dec  1 13:01:22 1993
+++ ./sbr/getanswer.c	Sat Mar  2 14:24:22 1996
@@ -10,7 +10,11 @@
     static int  interactive = NOTOK;
 
     if (interactive < OK)
+#ifdef __EMX__
+	interactive = isatty (fileno (stdout)) ? DONE : OK;
+#else  /* __EMX__ */
 	interactive = isatty (fileno (stdin)) ? DONE : OK;
+#endif /* __EMX__ */
 
     return (interactive ? gans (prompt, anoyes) : DONE);
 }
diff -urP ../mh-6.8.4/sbr/m_backup.c ./sbr/m_backup.c
--- ../mh-6.8.4/sbr/m_backup.c	Wed Dec  1 13:01:22 1993
+++ ./sbr/m_backup.c	Sat Mar  2 14:24:24 1996
@@ -8,9 +8,19 @@
 register char   *file;
 {
     register char  *cp;
+#ifdef __EMX__
+    register char  *cp1;
+#endif
     static char buffer[BUFSIZ];
 
+#ifdef __EMX__
+    cp = r1bindex (file, '/');
+    if (cp < (cp1 = r1bindex (file, '\\')))
+        cp = cp1;
+    if (cp == file)
+#else
     if ((cp = r1bindex (file, '/')) == file)
+#endif
 	(void) sprintf (buffer, "%s%s", SBACKUP, cp);
     else
 	(void) sprintf (buffer, "%.*s%s%s", cp - file, file, SBACKUP, cp);
diff -urP ../mh-6.8.4/sbr/m_foil.c ./sbr/m_foil.c
--- ../mh-6.8.4/sbr/m_foil.c	Wed Dec  1 13:01:22 1993
+++ ./sbr/m_foil.c	Sat Mar  2 14:24:24 1996
@@ -9,7 +9,11 @@
 {
     register struct node *np;
 
+#ifdef __EMX__
+    defpath = context = "nul";
+#else  /* __EMX__ */
     defpath = context = "/dev/null";
+#endif /* __EMX__ */
 
     if (path) {
 	np = m_defs = (struct node *) malloc (sizeof *np);
diff -urP ../mh-6.8.4/sbr/m_getdefs.c ./sbr/m_getdefs.c
--- ../mh-6.8.4/sbr/m_getdefs.c	Wed Dec  1 13:01:22 1993
+++ ./sbr/m_getdefs.c	Sun Mar  3 20:23:42 1996
@@ -9,6 +9,10 @@
 #include <sys/types.h>
 #include <sys/stat.h>
 #include <pwd.h>
+#ifdef __EMX__
+#include <stdlib.h>
+#include <process.h>
+#endif
 
 
 extern int errno;
@@ -42,6 +46,9 @@
     struct stat st;
     register struct passwd *pw;
     register    FILE *ib;
+#ifdef __EMX__
+    char    tmpbuf[_MAX_PATH];
+#endif
 
     if (defpath)
 	return;
@@ -49,12 +56,20 @@
 	if (mypath = getenv ("HOME"))
 	    mypath = getcpy (mypath);
 	else
+#ifndef __EMX__
 	    if ((pw = getpwuid (getuid ())) == NULL
 		    || pw -> pw_dir == NULL
 		    || *pw -> pw_dir == 0)
 		adios (NULLCP, "no HOME envariable");
 	    else
 		mypath = getcpy (pw -> pw_dir);
+#else
+            adios (NULLCP, "no HOME envariable");
+
+        _abspath (tmpbuf, mypath, _MAX_PATH);
+        free (mypath);
+        mypath = getcpy(tmpbuf);
+#endif
 	if ((cp = mypath + strlen (mypath) - 1) > mypath && *cp == '/')
 	    *cp = 0;
     }
@@ -63,13 +78,27 @@
 	defpath = path (cp, TFILE);
 	if ((ib = FOpen (defpath, "r", "MHFD", 0)) == NULL)
 	    adios (defpath, "unable to read");
+#ifdef __EMX__
+        if (_fnisabs (cp) == OK)
+#else
 	if (*cp != '/')
+#endif
 	    (void) m_putenv ("MH", defpath);
     }
     else {
 	defpath = concat (mypath, "/", mh_profile, NULLCP);
 
 	if ((ib = FOpen (defpath, "r", "MHFD", 0)) == NULL)
+#ifdef __EMX__
+            if (-1 == spawnlp (P_WAIT, libpath (installproc), "install-mh", "-auto", NULLCP)) {
+	        fprintf (stderr, "unable to exec ");
+		perror (installproc);
+		_exit (-1);
+            }
+	    else
+	        if ((ib = fopen (defpath, "r")) == NULL)
+		    adios (NULLCP, "[install-mh aborted]");
+#else
 	    switch (pid = vfork ()) {
 		case NOTOK:
 		    adios ("fork", "unable to");
@@ -88,6 +117,7 @@
 			    || (ib = fopen (defpath, "r")) == NULL)
 			adios (NULLCP, "[install-mh aborted]");
 	    }
+#endif
     }
 
 #if	defined (notdef) || defined (COMPAT)
@@ -97,7 +127,11 @@
     (void) FClose (ib);
 
     if ((pp = m_find ("path")) != NULL && *pp) {
+#ifdef __EMX__
+        if (_fnisabs (pp) == OK)
+#else
 	if (*pp != '/')
+#endif
 	    (void) sprintf (buf, "%s/%s", mypath, pp);
 	else
 	    (void) strcpy (buf, pp);
@@ -115,7 +149,11 @@
     }
 
 #ifdef	COMPAT
+#ifdef  __EMX__
+    if (strcmp (ctx, "nul") == 0)
+#else
     if (strcmp (ctx, "/dev/null") == 0)
+#endif
 	return;			/* called by install-mh */
 
     if (access (ctxpath = getcpy (m_maildir (ctx)), 0) == NOTOK)
@@ -128,7 +166,11 @@
 		(void) setuid (getuid ());
 		fprintf (stderr, "install-mh -compat\n");
 
+#ifdef  __EMX__
+		execlp (libpath (installproc), "install-mh", "-compat", NULLCP);
+#else
 		execlp (installproc, "install-mh", "-compat", NULLCP);
+#endif
 		fprintf (stderr, "unable to exec ");
 		perror (installproc);
 		_exit (-1);
diff -urP ../mh-6.8.4/sbr/m_getfld.c ./sbr/m_getfld.c
--- ../mh-6.8.4/sbr/m_getfld.c	Wed Dec  1 13:01:24 1993
+++ ./sbr/m_getfld.c	Sun Sep 22 00:06:06 1996
@@ -169,8 +169,23 @@
 static unsigned char *edelim;
 static int  edelimlen;
 
+#ifdef CONTENT_LENGTH
+static int content_length = -1;
+static long end_of_contents = -1;
+#endif
+
 static int  (*eom_action) () = NULL;
 
+#ifdef __EMX__
+#ifdef _FILE_MEMBERS_HAVE_UNDERSCORE
+#define	_cnt	_rcount		/* Retch */
+#else
+#define	_ptr	ptr		/* Gag */
+#define	_cnt	rcount		/* Retch */
+#endif
+#define	_filbuf	_fill 		/* Puke */
+#endif
+
 #ifdef _FSTDIO
 #define	_ptr	_p		/* Gag */
 #define	_cnt	_r		/* Retch */
@@ -195,6 +210,17 @@
     register int    i;
     register int    j;
 
+#ifdef CONTENT_LENGTH
+    /*
+     * When starting to read from a new file, we have to reset the state,
+     * but only if the state wasn't reset.  That may save us a number of
+     * lseeks.
+     */
+    if (state == FLD &&
+	(content_length != -1 || end_of_contents != -1) &&
+	ftell(iob) == 0)
+	    end_of_contents = content_length = -1;
+#endif
     if ((c = Getc(iob)) < 0) {
 	msg_count = 0;
 	*buf = 0;
@@ -222,6 +248,39 @@
 		while (c != '\n' && (c = Getc(iob)) >= 0)
 		    ;
 
+#ifdef CONTENT_LENGTH
+		/*
+		 * When we've found a content-length header, we're
+		 * going to use it to tell where the message boundary
+		 * is, if it is a valid mesage boundary.
+		 * There can be a number of cases:
+		 * - no bytes after <content-length> bytes: the usual format
+		 *   of a message in an MH folder.
+		 * - only a newline - last message in mail drop.
+		 * - "\nFrom "	- beginning of next message
+		 * - other - ignore Content-Length header, but issue warning
+		 */
+		if (msg_style != MS_DEFAULT && content_length != -1) {
+		    long here = ftell(iob);
+		    static char delim[] = "\nFrom ";
+		    char buf[sizeof(delim)-1];
+		    int cnt;
+
+		    /* compute position of character after file */
+		    end_of_contents = here + content_length + 1;
+		    content_length = -1;
+		    /* And see whether this is a From header or eof. */
+		    fseek(iob, end_of_contents - 1, 0);
+		    cnt = fread(buf, sizeof(char), sizeof(buf), iob);
+		    if (cnt != 0 && (cnt != 1 || buf[0] != '\n') &&
+			(cnt != sizeof(buf) ||
+			  strncmp(buf,delim, sizeof(buf)) != 0)) {
+			    advise (NULLCP, "invalid Content-Length: header\n");
+			    end_of_contents = -1;
+		    }
+		    fseek(iob, here, 0);
+		}
+#endif
 		if (c < 0 || (c = Getc(iob)) < 0 || eom (c, iob)) {
 		    if (! eom_action) {
 			/* flush null messages */
@@ -425,6 +484,16 @@
 finish:;
     *cp = 0;
     msg_count = cp - buf;
+
+#ifdef CONTENT_LENGTH
+    /* Check whether this was a Content-Length header */
+    if (msg_style != MS_DEFAULT && state == FLD &&
+	    uleq((char*)"content-length", (char*) name)) {
+	content_length = atoi(buf);
+	/* This value is computed when end-of-headers is detected */
+	end_of_contents = -1;
+    }
+#endif
     return (state);
 }
 
@@ -544,6 +613,38 @@
 #endif /* RPATHS */
 
     pos = ftell (iob);
+
+#ifdef CONTENT_LENGTH
+    if (msg_style != MS_DEFAULT && end_of_contents != -1) {
+	if (end_of_contents == pos) {
+	    end_of_contents = -1;
+	    if ((fread (text, sizeof *text, edelimlen, iob) == edelimlen)
+		    && (strncmp (text, (char *)edelim, edelimlen) == 0)
+		    && (msg_style == MS_UUCP)) {
+#ifndef	RPATHS
+		while ((c = getc (iob)) != '\n')
+		    if (c < 0)
+			break;
+#else /* RPATHS */
+		cp = unixbuf;
+		while ((c = getc (iob)) != '\n' && c >= 0)
+		    *cp++ = c;
+		*cp = 0;
+#endif /* RPATHS */
+	    }
+	    return 1;
+	}
+	/* we've read past the end of a message, this should never happen
+	 * because of the other checks we do */
+	if (end_of_contents < pos) {
+	    end_of_contents = -1;
+	    adios(NULLCP,
+		    "Content-Length: header broken, can't read mailbox\n");
+	}
+	return 0;
+    }
+#endif
+    
     if ((i = fread (text, sizeof *text, edelimlen, iob)) != edelimlen
 	    || strncmp (text, (char *)edelim, edelimlen)) {
 	if (i == 0 && msg_style == MS_UUCP)
@@ -561,6 +662,18 @@
 	return 0;
     }
 
+#ifdef CONTENT_LENGTH
+    /* There's one extra special case to be considered here:
+     * content_length > 0.  That we got here is because the
+     * message body starts with "From "
+     */
+    if (msg_style != MS_DEFAULT && content_length > 0) {
+	(void) fseek (iob, (long)(pos-1), 0);
+	(void) getc (iob);		/* should be OK */
+	return 0;
+    }
+#endif
+
     if (msg_style == MS_UUCP) {
 #ifndef	RPATHS
 	while ((c = getc (iob)) != '\n')
@@ -708,3 +821,4 @@
 	*b++ = 0;
 }
 #endif /* not BSD42 */
+
diff -urP ../mh-6.8.4/sbr/m_gmsg.c ./sbr/m_gmsg.c
--- ../mh-6.8.4/sbr/m_gmsg.c	Wed Dec  1 13:01:24 1993
+++ ./sbr/m_gmsg.c	Sat Mar  2 14:24:28 1996
@@ -50,7 +50,11 @@
 	free (name);
 	return NULL;
     }
+#ifdef __EMX__
+    (void) fstat (dd -> dd_id, &st);
+#else
     (void) fstat (dd -> dd_fd, &st);
+#endif
 
     mp = (struct msgs  *) malloc (MHSIZE (mp, 0, 0));
     if (mp == NULL)
diff -urP ../mh-6.8.4/sbr/m_maildir.c ./sbr/m_maildir.c
--- ../mh-6.8.4/sbr/m_maildir.c	Wed Dec  1 13:01:24 1993
+++ ./sbr/m_maildir.c	Sat Mar  2 14:24:30 1996
@@ -4,6 +4,9 @@
 #endif	/* lint */
 
 #include "../h/mh.h"
+#ifdef __EMX__
+#include <stdlib.h>
+#endif
 #include <stdio.h>
 
 #define	CWD	"./"
@@ -41,11 +44,15 @@
     register char  *cp;
     char    maildir[BUFSIZ];
 
+#ifdef __EMX__
+    if (_fnisabs (folder))
+#else
     if (*folder == '/'
 	    || strncmp (folder, CWD, NCWD) == 0
 	    || strcmp (folder, DOT) == 0
 	    || strcmp (folder, DOTDOT) == 0
 	    || strncmp (folder, PWD, NPWD) == 0)
+#endif
 	cp = path (folder, TFOLDER);
     else {
 	(void) strcpy (maildir, mailfold);/* preserve... */
@@ -66,18 +73,26 @@
 
     if (folder == NULL)
 	folder = m_getfolder ();
+#ifdef __EMX__
+    if (_fnisabs (folder)) {
+#else
     if (*folder == '/'
 	    || strncmp (folder, CWD, NCWD) == 0
 	    || strcmp (folder, DOT) == 0
 	    || strcmp (folder, DOTDOT) == 0
 	    || strncmp (folder, PWD, NPWD) == 0) {
+#endif
 	(void) strcpy (mailfold, folder);
 	return mailfold;
     }
 
     cp = mailfold;
     if ((pp = m_find ("path")) != NULL && *pp) {
+#ifdef __EMX__
+        if (!_fnisabs (pp)) {
+#else
 	if (*pp != '/') {
+#endif
 	    (void) sprintf (cp, "%s/", mypath);
 	    cp += strlen (cp);
 	}
diff -urP ../mh-6.8.4/sbr/m_sync.c ./sbr/m_sync.c
--- ../mh-6.8.4/sbr/m_sync.c	Wed Dec  1 13:01:24 1993
+++ ./sbr/m_sync.c	Sat Sep 21 19:41:46 1996
@@ -39,7 +39,7 @@
     mp -> msgflags &= ~SEQMOD;
 
     m_getdefs ();
-    (void) sprintf (seq, "%s/%s", mp -> foldpath, mh_seq);
+    (void) sprintf (seq, "%s/%s", mp -> foldpath, mh_seq? mh_seq: "");
     bits = FFATTRSLOT;
     fp = NULL;
 
diff -urP ../mh-6.8.4/sbr/m_tmpfil.c ./sbr/m_tmpfil.c
--- ../mh-6.8.4/sbr/m_tmpfil.c	Wed Dec  1 13:01:24 1993
+++ ./sbr/m_tmpfil.c	Sat Mar  2 14:24:30 1996
@@ -2,14 +2,32 @@
 
 #include "../h/mh.h"
 #include <stdio.h>
+#ifdef __EMX__
+#include <io.h>
+#endif
 
 
 char   *m_tmpfil (template)
 register char  *template;
 {
+#ifdef __EMX__
+    char *cp;
+#endif
     static char tmpfil[BUFSIZ];
 
+#ifdef __EMX__
+    cp = getenv("TMP");
+    if (cp && *cp) {
+	(void) sprintf (tmpfil, "%s/%sXXXXXX", cp, template);
+	if (_fullpath (tmpfil, tmpfil, BUFSIZ))
+	    (void) sprintf (tmpfil, "./%sXXXXXX", template);
+    }
+    else
+	(void) sprintf (tmpfil, "./%sXXXXXX", template);
+    _fullpath (tmpfil, tmpfil, BUFSIZ);
+#else
     (void) sprintf (tmpfil, "/tmp/%sXXXXXX", template);
+#endif
     (void) unlink (mktemp (tmpfil));
 
     return tmpfil;
diff -urP ../mh-6.8.4/sbr/m_update.c ./sbr/m_update.c
--- ../mh-6.8.4/sbr/m_update.c	Wed Dec  1 13:01:24 1993
+++ ./sbr/m_update.c	Sat Mar  2 14:24:30 1996
@@ -72,6 +72,9 @@
     int     i,
             child_id;
 
+#ifdef __EMX__
+    return (NOTOK);
+#else
     if (getuid () == geteuid ())
 	return (NOTOK);
 
@@ -92,4 +95,5 @@
     }
 
     return child_id;
+#endif
 }
diff -urP ../mh-6.8.4/sbr/makedir.c ./sbr/makedir.c
--- ../mh-6.8.4/sbr/makedir.c	Wed Dec  1 13:01:24 1993
+++ ./sbr/makedir.c	Sat Mar  2 14:24:32 1996
@@ -15,7 +15,7 @@
 #include <stdio.h>
 
 #if defined (BSD42) || defined (hpux) || defined(SVR4) || \
-	defined(ncr) || defined (_AIX) || defined(AUX)
+	defined(ncr) || defined (_AIX) || defined(AUX) || defined(__EMX__)
 #include <errno.h>
 #include <sys/param.h>
 #include <sys/file.h>
@@ -35,16 +35,28 @@
 {
     int     pid;
     register char  *cp;
-#if defined (BSD42)  || defined (hpux) || defined (SYS5DIR)
+#if defined (BSD42)  || defined (hpux) || defined (SYS5DIR) || defined(__EMX__)
     register char  *c;
+#ifdef __EMX__
+    char   drivename;
+#endif /* __EMX__ */
     char path[MAXPATHLEN];
 #endif	/* BSD42 */
 
     m_update ();
     (void) fflush (stdout);
 
-#if	defined (BSD42) ||  defined (hpux) || defined (SYS5DIR)
+#if	defined (BSD42) ||  defined (hpux) || defined (SYS5DIR) || defined(__EMX__)
     if (getuid () == geteuid ()) {
+#ifdef __EMX__
+            if (drivename =  _fngetdrive (dir)) {
+                _chdrive (drivename);
+                dir += 2;
+            }
+	    for (c = dir; *c; c++)
+                if (*c == '\\')
+                    *c = '/';
+#endif /* __EMX__ */
 	    c = strcpy(path, dir);     
 
 	    while ((c = index((c + 1), '/')) != NULL) {	
@@ -69,6 +81,7 @@
     }
     else
 #endif	/* BSD42 or hpux or SYS5DIR */
+#ifndef __EMX__
     switch (pid = vfork ()) {
 	case NOTOK: 
 	    advise ("fork", "unable to");
@@ -89,10 +102,19 @@
 		return 0;
 	    break;
     }
+    advise (dir, "unable to create directory");
+    return 0;
 
     if ((cp = m_find ("folder-protect")) == NULL)
 	cp = foldprot;
     (void) chmod (dir, atooi (cp));
     return 1;
+#else  /* __EMX__ */
+    {
+        advise (dir, "unable to create directory");
+        return 0;
+    }
+    return 1;
+#endif /* __EMX__ */
 }
 
diff -urP ../mh-6.8.4/sbr/os2.c ./sbr/os2.c
--- ../mh-6.8.4/sbr/os2.c	Thu Jan  1 00:00:00 1970
+++ ./sbr/os2.c	Mon Sep 16 21:50:54 1996
@@ -0,0 +1,430 @@
+/* os2.c - functions for OS/2 */
+#ifndef	lint
+static char ident[] = "@(#)$Id: os2.c,v 1.4 1996/07/06 16:58:20 H.Ueno $";
+#endif	/* lint */
+
+#if defined(SENDMTS) && !defined(SMTP) && !defined(SOUPER)
+#include <os2.h>
+#endif
+#include "../h/mh.h"
+#include <stdio.h>
+#include <stdlib.h>
+#include <errno.h>
+#include <io.h>
+#include <sys/types.h>
+#include <sys/stat.h>
+#include <sys/utime.h>
+#include <sys/dir.h>
+#ifdef  MF
+#include "../zotnet/mts.h"
+#endif
+
+extern __const__ int _nfiles;
+typedef struct _unlink2_file {
+    char                 * name;
+    struct _unlink2_file * next;
+} UNLINK2FILE;
+
+static UNLINK2FILE * unlinklist = NULL;
+
+#ifdef  MF
+char	*UupcName = "";
+char	*UupcMailbox = "";
+char	*UupcMailDir = "";
+char	*UupcConfDir = "";
+char	*UupcHomeDir = "";
+char	*UupcFileSent = "";
+char	*UupcOrganization = "";
+char	*UupcReplyto = "";
+char	*UupcDomain = "";
+char	*UupcFromDomain = "";
+char	*UupcMailExt = "";
+char	*UupcSignature = "";
+int	 UupcAutoSign;
+
+char	*UupcFileSentName = "";
+char	*UupcSignatureName = "";
+
+struct {
+    char *name ;
+    char **value ;
+} Conf[] = {
+    { "name",		&UupcName		},
+    { "mailbox",	&UupcMailbox		},
+    { "maildir",	&UupcMailDir		},
+    { "confdir",	&UupcConfDir		},
+    { "home",		&UupcHomeDir		},
+    { "filesent",	&UupcFileSent		},
+    { "organization",	&UupcOrganization	},
+    { "replyto",	&UupcReplyto		},
+    { "domain",		&UupcDomain		},
+    { "fromdomain",	&UupcFromDomain		},
+    { "mailext",	&UupcMailExt		},
+    { "signature",	&UupcSignature		},
+    { NULL, NULL }
+};
+
+static GetUupcConfigData ();
+#endif
+#if defined(SENDMTS) && !defined(SMTP) && !defined(SOUPER)
+char	*SendmailReplyDomain = "";
+char	*SendmailMailServer = "";
+
+static char *GetIniData ();
+#endif
+static char *getcpy2 ();
+
+static _os2_exit(msg)
+char *msg;
+{
+    fprintf (stderr, "os2: %s", msg);
+    exit (1);
+}
+
+static void _unlink_cleanup()
+{
+    UNLINK2FILE *up, *up2;
+    register int i;
+
+    fcloseall();
+    for (i = 3; i < _nfiles; i++)
+	(void) close (i);
+    for (up = unlinklist; up; ) {
+        remove (up->name);
+        free (up->name);
+        up2 = up->next;
+        free (up);
+        up = up2;
+    }
+    unlinklist = NULL;
+}
+
+static void _unlink_suspended()
+{
+    UNLINK2FILE *up, *up2;
+
+    for (up = unlinklist, unlinklist = NULL; up; ) {
+        up2 = up->next;
+        if (remove (up->name)) {
+	    up->next = unlinklist;
+	    unlinklist = up;
+	}
+	else {
+	    free (up->name);
+	    free (up);
+	}
+	up = up2;
+    }
+}
+
+int _unlink2 (const char *name)
+{
+    char buffer[MAXPATHLEN+1];
+    UNLINK2FILE *up;
+    int rc;
+    static int reg = 0;
+
+    _unlink_suspended();
+    if (rc = remove (name)) {
+        if (errno == EACCES) {
+            _abspath (buffer, name, MAXPATHLEN);
+    
+            if (reg == 0) {
+              atexit (_unlink_cleanup);
+	      reg++;
+	    }
+
+	    for (up = unlinklist; up; up = up->next) {
+	      if (!stricmp (buffer, up->name))
+	        break;
+	    }
+
+	    if (!up) {
+	      up = (UNLINK2FILE *) malloc (sizeof (UNLINK2FILE));
+	      if (!up)
+		_os2_exit ("couldn't allocate buffer space");
+	      up->next = unlinklist;
+	      if ((up->name = malloc ((unsigned) (strlen (buffer) + 1))) == NULL)
+		_os2_exit ("unable to allocate string storage");
+	      (void) strcpy (up->name, buffer);
+	      unlinklist = up;
+	    }
+    
+            errno = 0;
+            rc = 0;
+        }
+    }
+
+    return rc;
+}
+
+
+int link (oldname, newname)
+char *oldname;
+char *newname;
+{
+    struct stat st, source_st;
+    struct utimbuf tv;
+    FILE *oldfp, *newfp;
+    char buffer[BUFSIZ];
+    size_t rcount;
+    int errsave;
+    int rc = OK;
+
+    errsave = errno;
+    if (stat (newname, &st) == OK) {
+        errno = EEXIST;
+        return (NOTOK);
+    }
+    errno = errsave;
+
+    if (stat (oldname, &source_st) != OK)
+        return (NOTOK);
+
+    if ((oldfp = fopen (oldname, "rb")) == NULL)
+        return (NOTOK);
+
+    if ((newfp = fopen (newname, "wb")) == NULL)
+        return (NOTOK);
+
+    while ((feof (oldfp) == OK) && ((rc = ferror(oldfp)) == OK) &&
+           ((rc = ferror(newfp)) == OK)) {
+        if (rcount = fread (buffer, 1, BUFSIZ, oldfp)) {
+            fwrite (buffer, 1, rcount, newfp);
+        }
+    }
+    fclose (oldfp);
+    fclose (newfp);
+
+    if (rc == OK) {
+        tv.actime = source_st.st_atime;
+        tv.modtime = source_st.st_mtime;
+        utime (newname, &tv);
+    }
+    else {
+        errsave = errno;
+        unlink (newname);
+        errno = errsave;
+    }
+
+    return (rc);
+}
+
+#ifdef MF
+void uupc_init ()
+{
+    char *sysrc, *usrrc;
+    char *cp;
+    char rcfile[BUFSIZ];
+    char tmpbuf[BUFSIZ];
+
+    sysrc = getcpy2 (getenv ("UUPCSYSRC"));
+    GetUupcConfigData (sysrc);
+
+    *(_getname (sysrc)) = '\0';
+    if (_getname (usrrc = getenv ("UUPCUSRRC")) == usrrc)
+	sprintf (rcfile, "%s%s", sysrc, usrrc);
+    else
+	strcpy (rcfile, usrrc);
+    GetUupcConfigData (rcfile);
+
+    if (*UupcFromDomain == '\0')
+	UupcFromDomain = UupcDomain;
+
+    if (*UupcHomeDir == '\0')
+	UupcHomeDir = ".";
+    else {
+	cp = UupcHomeDir + strlen (UupcHomeDir) - 1;
+	if (*cp == '/' || *cp == '\\')
+	    *cp = '\0';
+    }
+
+    if (*UupcMailDir)
+	cp = UupcMailDir;
+    else {
+	cp = tmpbuf;
+	sprintf (tmpbuf, "%s/Mail", *UupcConfDir ? UupcConfDir : sysrc);
+    }
+    uucpldir = getcpy2 (cp);
+
+    if (*UupcMailbox) {
+	if (*UupcMailExt) {
+	    sprintf (tmpbuf, "%s.%s", UupcMailbox, UupcMailExt);
+	    cp = getcpy2 (tmpbuf);
+	}
+	else
+	    cp = getcpy2 (UupcMailbox);
+
+	uucplfil = cp;
+    }
+
+    if (*UupcFileSent) {
+	if (*UupcMailExt)
+	    sprintf (tmpbuf, "%s/%s.%s", UupcHomeDir, UupcFileSent, UupcMailExt);
+	else
+	    sprintf (tmpbuf, "%s/%s", UupcHomeDir, UupcFileSent);
+	UupcFileSentName = getcpy2 (tmpbuf);
+    }
+
+    if (UupcAutoSign && *UupcSignature) {
+	sprintf (tmpbuf, "%s/%s", UupcHomeDir, UupcSignature);
+	UupcSignatureName = getcpy2 (tmpbuf);
+    }
+}
+
+static GetUupcConfigData (char *fname)
+{
+    char	*pos;
+    FILE	*fp;
+    int		lp, find;
+    char	tmp[BUFSIZ];
+    char	wbuf[BUFSIZ];
+
+    if (!fname || !(fp = fopen (fname, "r")))
+	return;
+
+    while (fgets (tmp, BUFSIZ, fp) != NULL) {
+	if (*tmp == '#')
+	    continue;
+
+	pos = tmp ;
+	while (isspace (*pos)) ++pos;
+	if (*pos == '\0')
+	    continue;
+	strcpy (wbuf, pos);
+
+	pos = strstr (wbuf, "\n");
+	while (isspace (*pos)) --pos;
+	*(++pos) = '\0';
+
+	strcpy (tmp, wbuf);
+	if ((pos = strstr (tmp, "=")) == NULL)
+	    continue;
+	*pos = '\0';
+	strcpy (wbuf, wbuf + (pos - tmp) + 1);
+
+	for (pos = tmp ; *pos ; ++pos)
+	    *pos = (char)tolower (*pos);
+
+	if (strstr (tmp, "options") == tmp) {
+	    for (pos = wbuf ; *pos ; ++pos)
+		*pos = (char)tolower (*pos);
+
+	    if (strstr (wbuf, "autosign") != NULL)
+		if (strstr (wbuf, "noautosign") != NULL)
+		    UupcAutoSign = 0;
+		else
+		    UupcAutoSign = 1;
+
+	    continue;
+	}
+	
+	lp = find = 0;
+	while (Conf[lp].name != NULL) {
+	    if (strstr (tmp, Conf[lp].name) == tmp) {
+		find = lp + 1;
+		break;
+	    }
+	    ++lp;
+	}
+	if (!find)
+	    continue;
+	--find;
+
+	*Conf[find].value = getcpy2 (wbuf);
+    }
+    fclose (fp);
+}
+#endif
+
+#if defined(SENDMTS) && !defined(SMTP) && !defined(SOUPER)
+char *GetIniData(hini, app, key )
+HINI hini;
+unsigned char *app;
+unsigned char *key;
+{
+    unsigned long  len = BUFSIZ;
+    char           temp[BUFSIZ];
+
+    if (PrfQueryProfileData (hini, app, key, (void *)temp, &len ) &&
+	                 len && temp[0])
+	return getcpy2 (temp);
+    else
+	return getcpy2 ((char *)NULL);
+}
+
+void tcpip_init ()
+{
+    HAB           hab = 0;
+    HINI          hini;
+    unsigned long len  = BUFSIZ;
+    char          wbuf[BUFSIZ];
+    char          *pp = wbuf;
+
+    sprintf( wbuf, "%s/TCPOS2.INI", getenv ("ETC") ) ;
+    if ( ( hini = PrfOpenProfile( hab, wbuf ) ) == NULLHANDLE )
+	return;
+
+    if (PrfQueryProfileData (hini, "CONNECTION", "CURRENT_CONNECTION",
+			 (void *)wbuf, &len ))
+	if (len && *pp) {
+	    SendmailReplyDomain = GetIniData (hini, pp, "REPLY_DOMAIN");
+	    SendmailMailServer  = GetIniData (hini, pp, "MAIL_GW");
+    }
+
+    PrfCloseProfile( hini ) ;
+}
+#endif
+
+static char *getcpy2 (str)
+register char  *str;
+{
+    register char  *cp;
+
+    if (!str) {
+	if ((cp = malloc ((unsigned) (1))) == NULL)
+	    _os2_exit ("unable to allocate string storage");
+	(void) strcpy (cp, "");
+    } else {
+	if ((cp = malloc ((unsigned) (strlen (str) + 1))) == NULL)
+	    _os2_exit ("unable to allocate string storage");
+
+	(void) strcpy (cp, str);
+    }
+    return cp;
+}
+
+#undef getenv
+
+char * _getenv2 (name)
+const char *name;
+{
+    char *cp;
+    char uprname[BUFSIZ];
+
+    strcpy (uprname, name);
+    strupr (uprname);
+
+    (cp = getenv (name)) || (cp = getenv (uprname));
+    return (cp);
+}
+
+
+int chown (file, uid, gid)
+char   *file;
+int     uid,
+        gid;
+{
+    /* OS/2 is a single user operating system. Therer is no group, no user. */
+    /* Owner change request will be ignored and always return OK            */
+    return (OK);
+}
+
+
+int setuid (uid)
+int     uid;
+{
+    /* OS/2 is a single user operating system. Therer is no user concept.   */
+    /* User id set request will be ignored and always return OK             */
+    return (OK);
+}
diff -urP ../mh-6.8.4/sbr/path.c ./sbr/path.c
--- ../mh-6.8.4/sbr/path.c	Wed Dec  1 13:01:24 1993
+++ ./sbr/path.c	Sat Mar  2 14:24:34 1996
@@ -5,6 +5,9 @@
 
 #include "../h/mh.h"
 #include <stdio.h>
+#ifdef __EMX__
+#include <stdlib.h>
+#endif  /* __EMX__ */
 
 #define	CWD	"./"
 #define	NCWD	(sizeof CWD - 1)
@@ -29,7 +32,11 @@
 
     if ((cp = expath (name, flag))
 	    && (ep = cp + strlen (cp) - 1) > cp
+#ifdef __EMX__
+	    && (*ep == '/' || *ep == '\\'))
+#else  /* __EMX__ */
 	    && *ep == '/')
+#endif /* __EMX__ */
 	*ep = 0;
 
     return cp;
@@ -58,7 +65,11 @@
 	flag = TFOLDER;
     }
 
+#ifdef __EMX__
+    if (_fnisabs (name)
+#else  /* __EMX__ */
     if (*name == '/'
+#endif /* __EMX__ */
 	    || (flag == TFOLDER
 		&& (strncmp (name, CWD, NCWD)
 		    && strcmp (name, DOT)
@@ -90,6 +101,11 @@
     if (strncmp (name, PWD, NPWD) == 0)
 	name += NPWD;
     else
+#ifdef __EMX__
+        if (strcmp (pwds, "/") == 0)
+            cp = pwds;
+        else
+#endif /* __EMX__ */
 	cp = ep;
 
     (void) sprintf (buffer, "%.*s/%s", cp - pwds, pwds, name);
diff -urP ../mh-6.8.4/sbr/push.c ./sbr/push.c
--- ../mh-6.8.4/sbr/push.c	Wed Dec  1 13:01:26 1993
+++ ./sbr/push.c	Sun Mar  3 20:31:18 1996
@@ -27,8 +27,13 @@
 		(void) signal (SIGTTIN, SIG_IGN);
 		(void) signal (SIGTTOU, SIG_IGN);
 #endif	/* SIGTSTP */
+#ifdef  __EMX__
+		(void) freopen ("nul", "r", stdin);
+		(void) freopen ("nul", "w", stdout);
+#else
 		(void) freopen ("/dev/null", "r", stdin);
 		(void) freopen ("/dev/null", "w", stdout);
+#endif
 		break;
 
 	    default: 
diff -urP ../mh-6.8.4/sbr/putenv.c ./sbr/putenv.c
--- ../mh-6.8.4/sbr/putenv.c	Wed Dec  1 13:01:26 1993
+++ ./sbr/putenv.c	Sat Mar  2 14:24:36 1996
@@ -5,6 +5,9 @@
 
 #include "../h/mh.h"
 #include <stdio.h>
+#ifdef __EMX__
+#include <ctype.h>
+#endif
 
 
 extern  char **environ;
@@ -67,7 +70,11 @@
 register char  *s1,
                *s2;
 {
+#ifdef __EMX__
+    while ((*s1 == *s2++) || (tolower (*s1) == tolower (*(s2 - 1))))
+#else
     while (*s1 == *s2++)
+#endif
 	if (*s1++ == '=')
 	    return 1;
 
diff -urP ../mh-6.8.4/sbr/pwd.c ./sbr/pwd.c
--- ../mh-6.8.4/sbr/pwd.c	Wed Dec  1 13:01:26 1993
+++ ./sbr/pwd.c	Sat Apr  6 02:16:30 1996
@@ -4,9 +4,9 @@
 #endif	/* lint */
 
 #include "../h/mh.h"
-#if	!defined (BSD42) && !defined (SYS5DIR)
+#if	!defined (BSD42) && !defined (SYS5DIR) && !defined (__EMX__)
 #include "../h/local.h"
-#endif	/* not BSD42 and not SYS5DIR */
+#endif	/* not BSD42 and not SYS5DIR and not __EMX__ */
 #include <stdio.h>
 
 #define	MAXPATHLEN	1024
@@ -18,6 +18,7 @@
 char   *pwd () {
     register char  *cp;
 
+#ifndef	__EMX__
 #ifndef	BSD42
 #ifndef	SYS5DIR
     if (getwd (curwd) == NOTOK) {
@@ -30,6 +31,10 @@
     if (getwd (curwd) == 0) {
 	admonish (NULLCP, "unable to determine working directory: %s", curwd);
 #endif	/* BSD42 */
+#else	/* __EMX__ */
+    if (_getcwd2 (curwd, MAXPATHLEN) == NULL) {
+	admonish (NULLCP, "unable to determine working directory: %s", curwd);
+#endif	/* __EMX__ */
 	if (mypath == NULL
 		|| *mypath == 0
 		|| ((void) strcpy (curwd, mypath), chdir (curwd)) == NOTOK) {
@@ -47,7 +52,7 @@
 
 /*  */
 
-#if	!defined (BSD42) && !defined (SYS5DIR)
+#if	!defined (BSD42) && !defined (SYS5DIR) && !defined (__EMX__)
 /* getwd() - get the current working directory */
 
 /* Algorithm from several sources, -ljobs, pwd.c, etc., etc. */
@@ -123,4 +128,4 @@
     closedir (dd);
     return NOTOK;
 }
-#endif	/* not BSD42 and not SYS5DIR */
+#endif	/* not BSD42 and not SYS5DIR and not __EMX__ */
diff -urP ../mh-6.8.4/sbr/refile.c ./sbr/refile.c
--- ../mh-6.8.4/sbr/refile.c	Wed Dec  1 13:01:26 1993
+++ ./sbr/refile.c	Sat Mar  2 14:24:38 1996
@@ -5,6 +5,10 @@
 
 #include "../h/mh.h"
 #include <stdio.h>
+#ifdef __EMX__
+#include <process.h>
+#include <stdlib.h>
+#endif /* __EMX__ */
 
 int     refile (arg, file)
 register char **arg,
@@ -15,7 +19,11 @@
     char   *vec[MAXARGS];
 
     vecp = 0;
+#ifdef __EMX__
+    vec[vecp++] = _getname (fileproc);
+#else  /* __EMX__ */
     vec[vecp++] = r1bindex (fileproc, '/');
+#endif /* __EMX__ */
     vec[vecp++] = "-nolink";	/* override bad .mh_profile defaults */
     vec[vecp++] = "-nopreserve";
     vec[vecp++] = "-file";
@@ -29,6 +37,13 @@
     m_update ();
     (void) fflush (stdout);
 
+#ifdef __EMX__
+    if (-1 == spawnvp (P_WAIT, exepath (fileproc), (char * __const__ *)vec)) {
+      fprintf (stderr, "unable to exec ");
+      perror (fileproc);
+      _exit (-1);
+    }
+#else
     switch (pid = vfork ()) {
 	case NOTOK: 
 	    advise ("fork", "unable to");
@@ -43,4 +58,5 @@
 	default: 
 	    return (pidwait (pid, NOTOK));
     }
+#endif
 }
diff -urP ../mh-6.8.4/sbr/remdir.c ./sbr/remdir.c
--- ../mh-6.8.4/sbr/remdir.c	Wed Dec  1 13:01:26 1993
+++ ./sbr/remdir.c	Sat Mar  2 14:24:38 1996
@@ -10,14 +10,14 @@
 remdir (dir)
 char *dir;
 {
-#if	!defined (BSD42) && !defined (SYS5DIR)
+#if	!defined (BSD42) && !defined (SYS5DIR) && !defined (__EMX__)
     int     pid;
-#endif	/* not BSD42 and not SYS5DIR */
+#endif	/* not BSD42 and not SYS5DIR and not __EMX__ */
 
     m_update ();
     (void) fflush (stdout);
 
-#if	!defined (BSD42) && !defined (SYS5DIR)
+#if	!defined (BSD42) && !defined (SYS5DIR) && !defined (__EMX__)
     switch (pid = vfork ()) {
 	case NOTOK: 
 	    advise ("fork", "unable to");
@@ -35,12 +35,12 @@
 		return 0;
 	    break;
     }
-#else	/* BSD42 or SYS5DIR */
+#else	/* BSD42 or SYS5DIR or __EMX__ */
     if (rmdir (dir) == NOTOK) {
 	admonish (dir, "unable to remove directory");
 	return 0;
     }
-#endif	/* BSD42 or SYS5DIR */
+#endif	/* BSD42 or SYS5DIR or __EMX__ */
 
     return 1;
 }
diff -urP ../mh-6.8.4/sbr/ruserpass.c ./sbr/ruserpass.c
--- ../mh-6.8.4/sbr/ruserpass.c	Wed Dec  1 13:01:26 1993
+++ ./sbr/ruserpass.c	Sat Sep 21 21:15:12 1996
@@ -19,6 +19,9 @@
 static char sccsid[] = "@(#)ruserpass.c	5.1 (Berkeley) 3/1/89";
 #endif /* not lint */
 
+#ifdef __EMX__
+#include "../h/strings.h"
+#endif
 #include <sys/types.h>
 #include <sys/stat.h>
 #include <stdio.h>
@@ -91,7 +94,7 @@
 			/*
 			 * Allow match either for user's host name.
 			 */
-			if (strcasecmp(host, tokval) == 0)
+			if (uleq(host, tokval))
 				goto match;
 			continue;
 		}
@@ -105,12 +108,14 @@
 			}
 			break;
 		case PASSWD:
+#ifndef __EMX__
 			if (fstat(fileno(cfile), &stb) >= 0 &&
 			    (stb.st_mode & 077) != 0) {
 	fprintf(stderr, "Error - .netrc file not correct mode.\n");
 	fprintf(stderr, "Remove password or correct mode.\n");
 				goto bad;
 			}
+#endif /* __EMX__ */
 			if (token() && *apass == 0) {
 				*apass = malloc((unsigned) strlen(tokval) + 1);
 				(void) strcpy(*apass, tokval);
diff -urP ../mh-6.8.4/sbr/showfile.c ./sbr/showfile.c
--- ../mh-6.8.4/sbr/showfile.c	Wed Dec  1 13:01:26 1993
+++ ./sbr/showfile.c	Sat Mar  2 14:24:40 1996
@@ -2,6 +2,10 @@
 
 #include "../h/mh.h"
 #include <stdio.h>
+#ifdef __EMX__
+#include <process.h>
+#include <stdlib.h>
+#endif
 
 
 showfile (arg, file)
@@ -12,10 +16,49 @@
             pid;
     register int    vecp;
     char   *vec[MAXARGS];
+#ifdef __EMX__
+    char   *cp;
+#endif  /* __EMX__ */
 
     m_update ();
     (void) fflush (stdout);
 
+#ifdef __EMX__
+    cp = getcpy (_getname (lproc));
+    _remext (cp);
+    if (strcmp (cp, "mhl") == 0)
+	lproc = mhlproc;
+
+    vecp = 0;
+    vec[vecp++] = "cmd.exe";
+    vec[vecp++] = "/c";
+    vec[vecp++] = libpath (_getname (lproc));
+    free (cp);
+    isdraft = 1;
+    if (arg)
+	while (*arg) {
+	    if (**arg != '-')
+		isdraft = 0;
+	    vec[vecp++] = *arg++;
+	}
+    if (isdraft) {
+         cp = getcpy (_getname (lproc));
+         _remext (cp);
+	if (strcmp (cp, "show") == 0)
+	    vec[vecp++] = "-file";
+	vec[vecp++] = file;
+        free (cp);
+    }
+    vec[vecp] = NULL;
+
+    if (-1 == spawnvp (P_WAIT, "cmd.exe", (char * __const__ *)vec)) {
+        fprintf (stderr, "unable to exec ");
+        perror (lproc);
+        _exit (-1);
+    }
+
+    return 0;
+#else
     if (strcmp (r1bindex (lproc, '/'), "mhl") == 0)
 	lproc = mhlproc;
 
@@ -49,4 +92,5 @@
 	default: 
 	    return (pidwait (pid, NOTOK) & 0377 ? 1 : 0);
     }
+#endif
 }
diff -urP ../mh-6.8.4/support/general/bootmhn.cmd ./support/general/bootmhn.cmd
--- ../mh-6.8.4/support/general/bootmhn.cmd	Thu Jan  1 00:00:00 1970
+++ ./support/general/bootmhn.cmd	Sat Apr 20 19:32:42 1996
@@ -0,0 +1,103 @@
+/* */
+address 'cmd'
+call RxFuncAdd 'SysSearchPath', 'RexxUtil', 'SysSearchPath'
+call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
+
+if arg(1)='' then do
+    say 'usage: bootmhn MH-library-area'
+    exit 1
+end
+
+LIB=arg(1)
+MHN=LIB'\mhn_defaults'
+MHN=translate(MHN,'\','/')
+
+if LINES(MHN) then do
+    say MHN': already exists.'
+    exit 1
+end
+
+if findit('jless.exe')<>'' then do
+    '@echo mhn-show-text/plain: %%pjless %%F >>' MHN
+    '@echo mhn-show-message/rfc822: %%pjless %%F >>' MHN
+end
+else do
+    if findit('less.exe')='' & findit('nkf.exe')<>'' then do
+        '@echo mhn-show-text/plain: %%pnkf -s %%f ^| more >>' MHN
+        '@echo mhn-show-message/rfc822: %%pnkf -s %%f ^| more >>' MHN
+    end
+    else do
+        if findit('less.exe')='' then do
+            '@echo mhn-show-text/plain: %%pmore ^< %%F >>' MHN
+            '@echo mhn-show-message/rfc822: %%pmore ^< %%F >>' MHN
+        end
+    end
+end
+
+'@echo mhn-store-text: %%m%%P.txt >>' MHN
+'@echo mhn-store-text/richtext: %%m%%P.rt >>' MHN
+'@echo mhn-store-application/PostScript: %%m%%P.ps >>' MHN
+
+'@echo mhn-show-application/octet-stream: %%l >>' MHN
+
+'@echo mhn-store-image/gif: %%m%%P.gif >>' MHN
+'@echo mhn-store-image/jpeg: %%m%%P.jpg >>' MHN
+
+if findit('ib.exe')<>'' then do
+    '@echo mhn-show-image: %%pib %%F >>' MHN
+    if findit('pmjpeg.exe')<>'' then do
+        '@echo mhn-show-image/jpeg: %%ppmjpeg %%F >>' MHN
+    end
+end
+else do
+    if findit('pmjpeg.exe')<>'' then
+        '@echo mhn-show-image: %%ppmjpeg %%F >>' MHN
+end  /* Do */
+
+'@echo mhn-store-audio/basic: %%m%%P.au >>' MHN
+'@echo mhn-store-audio/x-aiff: %%m%%P.aif >>' MHN
+'@echo mhn-store-audio/x-wav: %%m%%P.wav >>' MHN
+
+if findit('ab.exe')<>'' then do
+    '@echo mhn-show-audio/basic: %%pab %%F >>' MHN
+    '@echo mhn-show-audio/x-aiff: %%pab %%F >>' MHN
+    '@echo mhn-show-audio/x-wav: %%pab %%F >>' MHN
+end
+
+'@echo mhn-store-video/x-msvideo: %%m%%P.avi >>' MHN
+'@echo mhn-store-video/x-avi: %%m%%P.avi >>' MHN
+'@echo mhn-store-video/quicktime: %%m%%P.mov >>' MHN
+'@echo mhn-store-video/mpeg: %%m%%P.mpg >>' MHN
+
+if findit('vb.exe')<>'' then do
+    '@echo mhn-show-video/x-msvideo: %%pvb %%F >>' MHN
+    '@echo mhn-show-video/x-avi: %%pvb %%F >>' MHN
+end
+
+if findit('mainview.exe')<>'' then
+    '@echo mhn-show-video/quicktime: %%pmainview %%F >>' MHN
+
+if findit('mpegplay.exe')<>'' then
+    '@echo mhn-show-video/mpeg: %%pmpegplay %%F >>' MHN
+else do
+    if findit('pmmpeg.exe')<>'' then
+        '@echo mhn-show-video/mpeg: %%ppmmpeg %%F >>' MHN
+end
+
+if findit('gvpm.exe')<>'' then
+    '@echo mhn-show-application/PostScript: %%pgvpm %%F >>' MHN
+
+if findit('richtext.exe')<>'' then
+    '@echo mhn-show-text/richtext: %%prichtext -p %%F >>' MHN
+else do
+    if findit('rt2raw.exe')<>'' then
+        '@echo mhn-show-text/richtext: %%prt2raw < %%f ^| fmt -78 ^| more >>' MHN
+end
+
+if findit('mule2.exe')<>'' then
+    '@echo mhn-charset-iso-8859-1: mule2 -d %%F >>' MHN
+
+exit 0
+
+findit: procedure
+    return SysSearchPath('PATH',arg(1))
diff -urP ../mh-6.8.4/uip/ali.c ./uip/ali.c
--- ../mh-6.8.4/uip/ali.c	Wed Dec  1 13:01:34 1993
+++ ./uip/ali.c	Fri Apr  5 01:38:50 1996
@@ -74,7 +74,13 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+    setvbuf (stdout, NULL, _IOLBF, BUFSIZ);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     mts_init (invo_name);
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
diff -urP ../mh-6.8.4/uip/aliasbr.c ./uip/aliasbr.c
--- ../mh-6.8.4/uip/aliasbr.c	Wed Dec  1 13:01:34 1993
+++ ./uip/aliasbr.c	Sat Mar  2 14:24:42 1996
@@ -9,7 +9,9 @@
 #include <sys/types.h>
 #endif
 #include <ctype.h>
+#ifndef __EMX__
 #include <grp.h>
+#endif
 #include <pwd.h>
 #include <stdio.h>
 
@@ -342,6 +344,7 @@
 register struct aka *ak;
 register char   *grp;
 {
+#ifndef __EMX__
     register char  *gp;
     register struct group  *gr = getgrnam (grp);
     register struct home   *hm = NULL;
@@ -378,6 +381,9 @@
 #endif /* DBMPWD */
 
     return 1;
+#else /* __EMX__ */
+    return 0;
+#endif /* __EMX__ */
 }
 
 /*  */
@@ -386,6 +392,7 @@
 register struct aka *ak;
 register char   *grp;
 {
+#ifndef __EMX__
     int     gid;
     register struct group  *gr = getgrnam (grp);
     register struct home   *hm = NULL;
@@ -411,6 +418,9 @@
 	    add_aka (ak, hm -> h_name);
 
     return 1;
+#else /* __EMX__ */
+    return 0;
+#endif /* __EMX__ */
 }
 
 /*  */
diff -urP ../mh-6.8.4/uip/anno.c ./uip/anno.c
--- ../mh-6.8.4/uip/anno.c	Wed Dec  1 13:01:34 1993
+++ ./uip/anno.c	Sat Mar  2 14:24:42 1996
@@ -63,7 +63,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
diff -urP ../mh-6.8.4/uip/annosbr.c ./uip/annosbr.c
--- ../mh-6.8.4/uip/annosbr.c	Wed Dec  1 13:01:34 1993
+++ ./uip/annosbr.c	Sat Mar  2 14:24:44 1996
@@ -69,7 +69,11 @@
 
     (void) strcpy (tmpfil, m_scratch (file, "annotate"));
 
+#ifdef __EMX__
+    if ((tmp = fopen (tmpfil, "wb")) == NULL) {
+#else
     if ((tmp = fopen (tmpfil, "w")) == NULL) {
+#endif
 	admonish (tmpfil, "unable to create");
 	return 1;
     }
@@ -103,6 +107,9 @@
 	(void) unlink (tmpfil);
     }
     else {
+#ifdef __EMX__
+        (void) lkclose (src, file);
+#endif
 	(void) strcpy (buffer, m_backup (file));
 	if (rename (file, buffer) == NOTOK) {
 	    switch (errno) {
diff -urP ../mh-6.8.4/uip/ap.c ./uip/ap.c
--- ../mh-6.8.4/uip/ap.c	Wed Dec  1 13:01:34 1993
+++ ./uip/ap.c	Sat Mar  2 14:24:44 1996
@@ -73,7 +73,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     mts_init (invo_name);
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
diff -urP ../mh-6.8.4/uip/bbc.c ./uip/bbc.c
--- ../mh-6.8.4/uip/bbc.c	Wed Dec  1 13:01:34 1993
+++ ./uip/bbc.c	Sat Mar  2 14:24:46 1996
@@ -100,7 +100,7 @@
 #define	HELPSW	17
     "help", 4,
 
-    NULL, NULL
+    NULL, 0
 };
 
 struct bbcount {
@@ -191,7 +191,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
 #ifdef	BPOP
     mts_init (invo_name);
     if (popbbhost && *popbbhost)
@@ -615,7 +620,11 @@
 #endif	BPOP
 	    vec[vecp++] = archivesw ? bb -> bb_archive : bb -> bb_file;
 	    vec[vecp] = NULL;
+#ifdef __EMX__
+	    execvp (exepath (mshproc), vec);
+#else
 	    execvp (mshproc, vec);
+#endif
 	    fprintf (stderr, "unable to exec ");
 	    perror (mshproc);
 	    _exit (-1);
@@ -966,6 +975,9 @@
     register struct bboard  *bb;
     static struct bboard   *tail = NULL;
 
+#ifdef __EMX__
+    s = getcpy (s);
+#endif
     make_lower (s, s);
     if ((bb = getbbaux (s)) == NULL)
 	if (hush == OK)
diff -urP ../mh-6.8.4/uip/bbl.c ./uip/bbl.c
--- ../mh-6.8.4/uip/bbl.c	Wed Dec  1 13:01:34 1993
+++ ./uip/bbl.c	Sat Mar  2 14:24:48 1996
@@ -27,7 +27,7 @@
 #define	HELPSW	3
     "help", 4,
 
-    NULL, NULL
+    NULL, 0
 };
 
 /*  */
@@ -77,7 +77,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
@@ -360,8 +365,10 @@
     pack (folder, file);
     if (chmod (file, (int) (stp -> st_mode & 0777)) == NOTOK)
 	admonish (file, "unable to change mode of");
+#ifndef __EMX__
     if (stat (file, &st) != NOTOK && st.st_gid != stp -> st_gid)
 	chgrp (file, stp -> st_gid);
+#endif
 }
 
 /*  */
@@ -461,7 +468,11 @@
 	    if (verbosw)
 		fprintf (stderr, "pack %s -file %s\n", folder, file);
 
+#ifdef __EMX__
+	    execlp (exepath (packproc), r1bindex (packproc, '/'),
+#else
 	    execlp (packproc, r1bindex (packproc, '/'),
+#endif
 		    folder, "-file", file, NULLCP);
 	    fprintf (stderr, "unable to exec ");
 	    perror (packproc);
@@ -522,7 +533,11 @@
 	    if (verbosw)
 		fprintf (stderr, "rmf %s\n", folder);
 
+#ifdef __EMX__
+	    execlp (exepath (rmfproc), r1bindex (rmfproc, '/'), folder, NULLCP);
+#else
 	    execlp (rmfproc, r1bindex (rmfproc, '/'), folder, NULLCP);
+#endif
 	    fprintf (stderr, "unable to exec ");
 	    perror (rmfproc);
 	    _exit (-1);
@@ -578,7 +593,11 @@
 	case OK: 
 	    if (verbosw)
 		fprintf (stderr, "inc %s -file %s -silent\n", folder, file);
+#ifdef __EMX__
+	    execlp (exepath (incproc), r1bindex (incproc, '/'),
+#else
 	    execlp (incproc, r1bindex (incproc, '/'),
+#endif
 		    folder, "-file", file, "-silent", NULLCP);
 	    fprintf (stderr, "unable to exec ");
 	    perror (incproc);
diff -urP ../mh-6.8.4/uip/burst.c ./uip/burst.c
--- ../mh-6.8.4/uip/burst.c	Wed Dec  1 13:01:34 1993
+++ ./uip/burst.c	Sat Mar  2 14:24:50 1996
@@ -75,7 +75,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
@@ -304,7 +309,11 @@
 	    printf ("message %d of digest %d becomes message %d\n",
 		    j, msgnum, i);
 
+#ifdef __EMX__
+	if ((out = fopen (f2, "wb")) == NULL)
+#else
 	if ((out = fopen (f2, "w")) == NULL)
+#endif
 	    adios (f2, "unable to write message");
 	(void) chmod (f2, mode);
 	(void) fseek (in, pos = smsgs[j].s_start, 0);
@@ -392,3 +401,4 @@
     if (ferror (out))
 	adios (ofile, "error writing");
 }
+
diff -urP ../mh-6.8.4/uip/comp.c ./uip/comp.c
--- ../mh-6.8.4/uip/comp.c	Wed Dec  1 13:01:34 1993
+++ ./uip/comp.c	Sat Mar  2 14:24:52 1996
@@ -10,6 +10,9 @@
 #ifdef LOCALE
 #include	<locale.h>
 #endif
+#ifdef __EMX__
+#include <stdlib.h>
+#endif /* __EMX__ */
 
 /*  */
 
@@ -113,7 +116,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
diff -urP ../mh-6.8.4/uip/conflict.c ./uip/conflict.c
--- ../mh-6.8.4/uip/conflict.c	Wed Dec  1 13:01:34 1993
+++ ./uip/conflict.c	Sat Apr 13 16:14:48 1996
@@ -119,6 +119,7 @@
 
     alias_files (akp, akv);
     pwd_names ();
+#ifndef  __EMX__
     grp_names ();
     grp_members ();
     grp_ids ();
@@ -127,6 +128,7 @@
     ldr_ship ();
 #endif	/* UCI */
     maildrops ();
+#endif
 
     done (0);
 }
@@ -170,6 +172,7 @@
 }
 
 
+#ifndef  __EMX__
 grp_names () {
     register int    gp,
                     hit = 0;
@@ -257,6 +260,7 @@
     if (!hit && out && !mail)
 	fprintf (out, "all group members accounted for\n");
 }
+#endif
 
 
 grp_ids () {		/* -DRAND not implemented at most places */
diff -urP ../mh-6.8.4/uip/dist.c ./uip/dist.c
--- ../mh-6.8.4/uip/dist.c	Wed Dec  1 13:01:34 1993
+++ ./uip/dist.c	Sat Mar  2 14:24:54 1996
@@ -118,7 +118,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
diff -urP ../mh-6.8.4/uip/dp.c ./uip/dp.c
--- ../mh-6.8.4/uip/dp.c	Wed Dec  1 13:01:34 1993
+++ ./uip/dp.c	Sat Mar  2 14:24:56 1996
@@ -67,7 +67,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
diff -urP ../mh-6.8.4/uip/dropsbr.c ./uip/dropsbr.c
--- ../mh-6.8.4/uip/dropsbr.c	Sat Mar  2 01:49:56 1996
+++ ./uip/dropsbr.c	Sat Sep 21 22:43:52 1996
@@ -21,6 +21,9 @@
 #else
 #define	ntohl(n) (n)
 #endif
+#ifdef __EMX__
+#include <sys/fcntl.h>
+#endif
 
 
 #define	MMDF	1
@@ -103,7 +106,11 @@
     struct stat st;
 
     for (*clear = 0, count = 4, j = 0; count > 0; count--)
+#ifdef __EMX__
+	if ((fd = lkopen (file, O_RDWR | O_NONBLOCK | O_BINARY)) == NOTOK)
+#else
 	if ((fd = lkopen (file, 6)) == NOTOK)
+#endif
 	    switch (errno) {
 		case ENOENT: 
 		    if (mbx_create (file, uid, gid, mode) == NOTOK)
@@ -111,10 +118,12 @@
 		    (*clear)++;
 		    break;
 
-#ifdef	BSD42
+#if	defined(BSD42) || defined(__EMX__)
 		case EWOULDBLOCK:
 #endif	/* BSD42 */
+#ifndef	__EMX__
 		case ETXTBSY: 
+#endif
 		    j = errno;
 		    sleep (5);
 		    break;
@@ -394,10 +403,12 @@
 	    }
 		    
 	    for (j = 0; fgets (buffer, sizeof buffer, fp) != NULL; j++) {
+#ifndef CONTENT_LENGTH
 		if (j != 0 && strncmp (buffer, "From ", 5) == 0) {
 		    (void) write (md, ">", 1);
 		    size++;
 		}
+#endif
 		i = strlen (buffer);
 		if (write (md, buffer, i) != i) {
 		    (void) fclose (fp);
diff -urP ../mh-6.8.4/uip/fmtdump.c ./uip/fmtdump.c
--- ../mh-6.8.4/uip/fmtdump.c	Wed Dec  1 13:01:34 1993
+++ ./uip/fmtdump.c	Sat Mar  2 14:25:00 1996
@@ -56,7 +56,12 @@
 #ifdef LOCALE
     setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
diff -urP ../mh-6.8.4/uip/folder.c ./uip/folder.c
--- ../mh-6.8.4/uip/folder.c	Wed Dec  1 13:01:36 1993
+++ ./uip/folder.c	Sun Apr 28 13:38:54 1996
@@ -7,12 +7,19 @@
 #include "../h/local.h"
 #include <errno.h>
 #include <stdio.h>
+#include <sys/types.h>
+#include <sys/stat.h>
+#ifdef __EMX__
+#include <stdlib.h>
+#include <ctype.h>
+#endif
 #ifdef LOCALE
 #include	<locale.h>
 #endif
 
 static		dodir(), addir(), addfold(), dother();
 static int	pfold(), sfold(), compare();
+static int	ImustDig();
 /*  */
 
 static struct swit switches[] = {
@@ -69,6 +76,11 @@
 #define	HELPSW	21
     "help", 4,
 
+#define LEAFSW	22
+    "leaf", 0,
+#define NLEAFSW	23
+    "noleaf", 0,
+
     NULL, 0
 };
 
@@ -87,6 +99,7 @@
 static int  foldtot = 0;
 static int  start = 0;
 static int  foldp = 0;
+static int  fleaf = 0;
 
 static char *mhdir;
 static char *stack = "Folder-Stack";
@@ -120,9 +133,16 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+    if (tolower (invo_name[strlen (invo_name) - 1]) == 's')
+	all++;
+#else
     invo_name = r1bindex (argv[0], '/');
     if (argv[0][strlen (argv[0]) - 1] == 's')
 	all++;
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
@@ -228,6 +248,12 @@
 		    listsw++;
 		    pushsw = 0;
 		    continue;
+	        case LEAFSW:
+		    fleaf++;
+		    continue;
+		case NLEAFSW:
+		    fleaf = 0;
+		    continue;
 	    }
 	if (*cp == '+' || *cp == '@')
 	    if (argfolder)
@@ -410,7 +436,7 @@
 	printf ("%s\n", fold);
 
 	if (!msg && !fpack) {
-	    if (frecurse)
+	    if (frecurse && ImustDig(fold))
 		dodir (fold);
 	    return retval;
 	}
@@ -461,7 +487,7 @@
     others = mp -> msgflags & OTHERS;
     m_fmsg (mp);
 
-    if (frecurse && others)
+    if (frecurse && others && ImustDig(fold))
 	dodir (fold);
 
     return retval;
@@ -557,11 +583,11 @@
     }
     while (dp = readdir (dd))
 	if (strcmp (dp -> d_name, ".") && strcmp (dp -> d_name, "..")) {
-#ifdef SYS5DIR
+#if defined(SYS5DIR) || defined(__EMX__)
 	    if (cp + dp -> d_reclen + 2 >= name + BUFSIZ)
-#else /* SYS5DIR */
+#else /* SYS5DIR or __EMX__ */
 	    if (cp + strlen (dp -> d_name) + 2 >= name + BUFSIZ)
-#endif /* SYS5DIR */
+#endif /* SYS5DIR or __EMX__ */
 		continue;
 	    (void) strcpy (cp, dp -> d_name);
 	    if (stat (name, &st) != NOTOK && (st.st_mode & S_IFMT) == S_IFDIR)
@@ -627,4 +653,21 @@
 	if (ssequal (atrcur, np -> n_name)
 		&& !ssequal (mhdir, np -> n_name + atrlen))
 	    (void) pfold (np -> n_name + atrlen, NULLCP);
+}
+
+/*  */
+
+static int ImustDig(path)
+    char *path;
+{
+    struct stat buf;
+
+    if (!fleaf) return 1; /* don't trust link counter */
+
+    if (stat(m_maildir(path), &buf) == NOTOK) {
+	perror("stat:");
+	return 0;
+    }
+
+    return (int)buf.st_nlink > 2 ? 1:0;
 }
diff -urP ../mh-6.8.4/uip/forw.c ./uip/forw.c
--- ../mh-6.8.4/uip/forw.c	Sat Mar  2 01:49:58 1996
+++ ./uip/forw.c	Sat Mar  2 14:25:04 1996
@@ -12,6 +12,9 @@
 #ifdef LOCALE
 #include	<locale.h>
 #endif
+#ifdef __EMX__
+#include <process.h>
+#endif
 
 #ifndef	MIME
 #define	MIMEminc(a)	(a)
@@ -183,7 +186,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
@@ -505,7 +513,11 @@
     if (pipe (pd) == NOTOK)
 	adios ("pipe", "unable to create");
 
+#ifdef __EMX__
+    vec[0] = _getname (mhlproc);
+#else  /* __EMX__ */
     vec[0] = r1bindex (mhlproc, '/');
+#endif /* __EMX__ */
 
     for (i = 0; (child_id = fork ()) == NOTOK && i < 5; i++)
 	sleep (5);
@@ -539,7 +551,11 @@
 		    vec[i++] = getcpy (m_name (msgnum));
 	    vec[i] = NULL;
 
-	    execvp (mhlproc, vec);
+#ifdef __EMX__
+	    execvp (libpath (mhlproc), (char * __const__ *) vec);
+#else  /* __EMX__ */
+	    execvp (mhlproc, (char __const__ * __const__ *) vec);
+#endif /* __EMX__ */
 	    fprintf (stderr, "unable to exec ");
 	    perror (mhlproc);
 	    _exit (-1);
diff -urP ../mh-6.8.4/uip/ftpsbr.c ./uip/ftpsbr.c
--- ../mh-6.8.4/uip/ftpsbr.c	Wed Dec  1 13:01:36 1993
+++ ./uip/ftpsbr.c	Sat Mar  2 14:25:06 1996
@@ -18,6 +18,9 @@
 #else
 #include <varargs.h>
 #endif
+#ifdef __EMX__
+#include <errno.h>
+#endif
 
 #ifdef __STDC__
 static int	command(int arg1, ...);
@@ -66,11 +69,13 @@
 
 /*  */
 
+#ifndef __EMX__
 extern	int	errno;
 #ifndef	BSD44
 extern	int	sys_nerr;
 extern	char   *sys_errlist[];
 #endif
+#endif
 
 
 #define	start_tcp_client(sock,priv) \
@@ -336,13 +341,20 @@
 	    perror (local);
 	    goto bad;
 	}
+#ifdef __EMX__
+    _fsetmode (fp, "b");
+#endif
 
     if (istore) {
 	if (ascii) {
 	    int	    c;
 	    FILE   *out;
 
+#ifdef __EMX__
+	    if (!(out = fdopen (data_fd, "wb"))) {
+#else
 	    if (!(out = fdopen (data_fd, "w"))) {
+#endif
 		perror ("fdopen");
 		goto bad;
 	    }
@@ -376,7 +388,11 @@
 	    int	    c;
 	    FILE   *in;
 
+#ifdef __EMX__
+	    if (!(in = fdopen (data_fd, "rb"))) {
+#else
 	    if (!(in = fdopen (data_fd, "r"))) {
+#endif
 		perror ("fdopen");
 		goto bad;
 	    }
diff -urP ../mh-6.8.4/uip/inc.c ./uip/inc.c
--- ../mh-6.8.4/uip/inc.c	Sat Mar  2 01:49:58 1996
+++ ./uip/inc.c	Tue Sep 17 00:51:08 1996
@@ -184,7 +184,11 @@
 	    nbytes,
 	    p = 0,
 #endif	/* POP */
+#ifdef  RPOP
 	    rpop = 1,
+#else
+	    rpop = 0,
+#endif
             i,
 	    hghnum,
             msgnum;
@@ -221,7 +225,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     mts_init (invo_name);
 
 #ifdef	POP
@@ -557,7 +566,11 @@
 	    if ((pd = mbx_open (file, getuid (), getgid (), m_gmprot ()))
 		    == NOTOK)
 		adios (file, "unable to open");
+#ifdef __EMX__
+	    if ((pf = fdopen (pd, "wb+")) == NULL)
+#else
 	    if ((pf = fdopen (pd, "w+")) == NULL)
+#endif
 		adios (NULLCP, "unable to fdopen %s", file);
 	}
 	else {
@@ -586,7 +599,11 @@
 	    }
 	    else {
 		cp = getcpy (m_name (msgnum));
+#ifdef __EMX__
+		if ((pf = fopen (cp, "wb+")) == NULL)
+#else
 		if ((pf = fopen (cp, "w+")) == NULL)
+#endif
 		    adios (cp, "unable to write");
 		(void) chmod (cp, m_gmprot ());
 		start = stop = 0L;
@@ -596,6 +613,9 @@
 
 		if (fflush (pf))
 		    adios (cp, "write error on");
+#ifdef __EMX__
+		utime(".", NULL);
+#endif
 		(void) fseek (pf, 0L, 0);
 	    }
 	    switch (p = scan (pf, msgnum, 0, nfs, width,
@@ -908,7 +928,11 @@
 	    break;
 
 	case OK: 
+#ifdef  __EMX__
+	    execlp (libpath (umincproc), umincproc, NULLCP);
+#else
 	    execlp (umincproc, r1bindex (umincproc, '/'), NULLCP);
+#endif
 	    fprintf (stderr, "unable to exec ");
 	    perror (umincproc);
 	    _exit (-1);
diff -urP ../mh-6.8.4/uip/install-mh.c ./uip/install-mh.c
--- ../mh-6.8.4/uip/install-mh.c	Wed Dec  1 13:01:36 1993
+++ ./uip/install-mh.c	Sat Mar  2 14:25:08 1996
@@ -15,7 +15,11 @@
 /*  */
 
 static char *message[] = {
+#ifdef __EMX__
+    "Prior to using MH, it is necessary to have a file in your HOME",
+#else
     "Prior to using MH, it is necessary to have a file in your login",
+#endif
     "directory (%s) named %s which contains information",
     "to direct certain MH operations.  The only item which is required",
     "is the path to use for all MH folder operations.  The suggested MH",
@@ -23,6 +27,9 @@
     NULL
 };
 
+#ifdef __EMX__
+static char tmpbuf[_MAX_PATH];
+#endif
 
 static char   *geta ();
 
@@ -53,11 +60,20 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
 
 #ifdef	COMPAT
     if (argc == 2 && strcmp (argv[1], "-compat") == 0) {
+#ifdef __EMX__
+        context = "nul";
+#else
 	context = "/dev/null";	/* hack past m_getdefs() */
+#endif
 	
 	m_getdefs ();
 	for (np = m_defs; np; np = np -> n_next)
@@ -86,12 +102,20 @@
 	if (mypath = getenv ("HOME"))
 	    mypath = getcpy (mypath);
 	else
+#ifndef __EMX__
 	    if ((pw = getpwuid (getuid ())) == NULL
 		    || pw -> pw_dir == NULL
 		    || *pw -> pw_dir == 0)
 		adios (NULLCP, "no HOME envariable");
 	    else
 		mypath = getcpy (pw -> pw_dir);
+#else
+            adios (NULLCP, "no HOME envariable");
+
+	_abspath (tmpbuf, mypath, _MAX_PATH);
+	free (mypath);
+	mypath = getcpy(tmpbuf);
+#endif
 	if ((cp = mypath + strlen (mypath) - 1) > mypath && *cp == '/')
 	    *cp = 0;
     }
@@ -138,14 +162,24 @@
 	    path = "Mail";
 	else {
     query:  ;
+#ifdef __EMX__
+	    if (gans ("Do you want a path below your HOME directory? ",
+#else
 	    if (gans ("Do you want a path below your login directory? ",
+#endif
 			anoyes)) {
 		printf ("What is the path?  %s/", mypath);
 		path = geta ();
 	    }
 	    else {
+#ifdef __EMX__
+		printf ("What is the whole path?  ");
+		_abspath (tmpbuf, geta (), _MAX_PATH);
+		path = tmpbuf;
+#else
 		printf ("What is the whole path?  /");
 		path = concat ("/", geta (), NULLCP);
+#endif
 	    }
 	}
     }
diff -urP ../mh-6.8.4/uip/mark.c ./uip/mark.c
--- ../mh-6.8.4/uip/mark.c	Sat Mar  2 01:50:00 1996
+++ ./uip/mark.c	Sat Mar  2 14:25:10 1996
@@ -73,7 +73,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
diff -urP ../mh-6.8.4/uip/mhlsbr.c ./uip/mhlsbr.c
--- ../mh-6.8.4/uip/mhlsbr.c	Sat Mar  2 01:50:00 1996
+++ ./uip/mhlsbr.c	Thu Sep 26 03:32:24 1996
@@ -20,6 +20,9 @@
 #include <stdio.h>
 #include <sys/types.h>
 #include <sys/stat.h>
+#ifdef __EMX__
+#include <stdlib.h>
+#endif /* __EMX__ */
 
 
 /* MAJOR BUG:
@@ -41,9 +44,9 @@
  */
 
 
-#ifdef	SYS5
+#if   	defined(SYS5) | defined(__EMX__)
 #define	u_short	ushort
-#endif	/* SYS5 */
+#endif	/* SYS5 or __EMX__ */
 
 #define ONECOMP		0
 #define TWOCOMP		1
@@ -309,7 +312,13 @@
            *arguments[MAXARGS],
            *files[MAXARGS];
 
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+    setvbuf (stdout, NULL, _IOLBF, BUFSIZ);
+#else  /* __EMX__ */
     invo_name = r1bindex (argv[0], '/');
+#endif /* __EMX__ */
     if ((cp = getenv ("MHLDEBUG")) && *cp)
 	mhldebug++;
     if ((cp = m_find (invo_name)) != NULL) {
@@ -1463,6 +1472,9 @@
     discard (stdout);
     (void) putchar ('\n');
 
+#ifdef  __EMX__
+    (void) signal (SIGINT, SIG_ACK);
+#endif
     longjmp (env, DONE);
 }
 
@@ -1523,7 +1535,7 @@
 
 /*  */
 
-#if	defined(BSD42) || defined(SOCKETS)
+#if	(defined(BSD42) || defined(SOCKETS)) && !defined(__EMX__)
 
 /* faceproc is two elements defining the image agent's location:
 	Internet host
@@ -1790,6 +1802,10 @@
 char *name;
 {
     int     pd[2];
+#ifdef __EMX__
+    int     vecp;
+    char    *vec[10];
+#endif /* __EMX__ */
 
     if (mhl_action && (sd = dup (fileno (stdout))) == NOTOK)
 	adios ("standard output", "unable to dup()");
@@ -1810,7 +1826,16 @@
 		(void) dup2 (pd[0], fileno (stdin));
 		(void) close (pd[0]);
 	    }
+#ifdef __EMX__
+            vecp = 0;
+            vec[vecp++] = "cmd.exe";
+            vec[vecp++] = "/c";
+            vec[vecp++] = name;
+            vec[vecp] = NULL;
+	    execvp ("cmd.exe", (char __const__ * __const__ *) vec);
+#else  /* __EMX__ */
 	    execlp (name, r1bindex (name, '/'), NULLCP);
+#endif /* __EMX__ */
 	    fprintf (stderr, "unable to exec ");
 	    perror (name);
 	    _exit (-1);
diff -urP ../mh-6.8.4/uip/mhmail.c ./uip/mhmail.c
--- ../mh-6.8.4/uip/mhmail.c	Wed Dec  1 13:01:36 1993
+++ ./uip/mhmail.c	Sat Mar  2 14:25:18 1996
@@ -9,6 +9,9 @@
 #ifdef LOCALE
 #include	<locale.h>
 #endif
+#ifdef __EMX__
+#include <process.h>
+#endif /* __EMX__ */
 
 /*  */
 
@@ -73,11 +76,20 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     m_foil (NULLCP);
 
     if (argc == 1) {
+#ifdef __EMX__
+	execlp (exepath (incproc), _getname (incproc), NULLCP);
+#else
 	execlp (incproc, r1bindex (incproc, '/'), NULLCP);
+#endif
 	adios (incproc, "unable to exec");
     }
 
@@ -137,7 +149,11 @@
     if (tolist == NULL)
 	adios (NULLCP, "usage: %s addrs ... [switches]", invo_name);
     (void) strcpy (tmpfil, m_tmpfil (invo_name));
+#ifdef __EMX__
+    if ((out = fopen (tmpfil, "wb")) == NULL)
+#else
     if ((out = fopen (tmpfil, "w")) == NULL)
+#endif
 	adios (tmpfil, "unable to write");
     (void) chmod (tmpfil, 0600);
 
@@ -174,7 +190,11 @@
 /*  */
 
     nvec = 0;
+#ifdef __EMX__
+    vec[nvec++] = _getname (postproc);
+#else
     vec[nvec++] = r1bindex (postproc, '/');
+#endif
     vec[nvec++] = tmpfil;
     if (resent)
 	vec[nvec++] = "-dist";
@@ -182,6 +202,24 @@
 	vec[nvec++] = "-queued";
     vec[nvec] = 0;
 
+#ifdef __EMX__
+    if (-1 == (status = spawnvp (P_WAIT, libpath (postproc),
+				 (char * __const__ *)vec))) {
+        fprintf (stderr, "unable to exec ");
+        perror (fileproc);
+        _exit (-1);
+    }
+
+    if (status) {
+	fprintf (stderr, "Letter saved in dead.letter\n");
+	execl ("mv.exe", "mv", tmpfil, "dead.letter", NULLCP);
+	perror ("mv");
+	_exit (-1);
+    }
+
+    (void) unlink (tmpfil);
+    done (0);
+#else
     for (i = 0; (child_id = fork ()) == NOTOK && i < 5; i++)
 	sleep (5);
     switch (child_id) {
@@ -206,6 +244,7 @@
 	    (void) unlink (tmpfil);
 	    done (status ? 1 : 0);
     }
+#endif
 }
 
 /*  */
diff -urP ../mh-6.8.4/uip/mhn.c ./uip/mhn.c
--- ../mh-6.8.4/uip/mhn.c	Sat Mar  2 01:50:02 1996
+++ ./uip/mhn.c	Sun Apr 14 23:57:00 1996
@@ -15,6 +15,10 @@
 #ifdef	BSD42
 #include <sys/wait.h>
 #endif
+#ifdef  __EMX__
+#include <io.h>
+#include <errno.h>
+#endif
 #ifdef LOCALE
 #include	<locale.h>
 #endif
@@ -195,13 +199,20 @@
 static	char   *dir;
 static	char   *errs = NULL;
 static	char   *tmp;
+#ifdef __EMX__
+static  char   *shell;
+static  char   *shelloption;
+static  int     unixshell = 0;
+#endif
 
 
+#ifndef __EMX__
 extern	int	errno;
 #ifndef	BSD44
 extern	int	sys_nerr;
 extern	char   *sys_errlist[];
 #endif
+#endif
 
 off_t	lseek ();
 time_t	time ();
@@ -375,7 +386,23 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+
+    shell = getenv ("COMSPEC");
+    if (!stricmp (_getname (shell), "CMD.EXE") ||
+	!stricmp (_getname (shell), "4OS2.EXE")) {
+      unixshell = 0;
+      shelloption = "/c";
+    }
+    else {
+      unixshell = 1;
+      shelloption = "-c";
+    }
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if (argv[1] && uprf (argv[1], "-via"))
 	m_foil (NULLCP);
     if ((cp = m_find (invo_name)) != NULL) {
@@ -637,7 +664,11 @@
     }
 
     (void) sprintf (buf, "%s-cache", invo_name);
+#ifdef __EMX__
+    if ((cache_public = m_find (buf)) && !_fnisabs (cache_public))
+#else
     if ((cache_public = m_find (buf)) && *cache_public != '/')
+#endif
 	cache_public = NULL;
     (void) sprintf (buf, "%s-private-cache", invo_name);
     if (!(cache_private = m_find (buf)))
@@ -684,6 +715,10 @@
 
 	    if ((fp = fopen (file, "w+")) == NULL)
 		adios (file, "unable to fopen for writing and reading");
+#ifdef __EMX__
+	    _fsetmode (fp, "b");
+	    _fsetmode (stdin, "b");
+#endif
 	    (void) chmod (file, 0600);
 	    while (fgets (buffer, sizeof buffer, stdin))
 		(void) fputs (buffer, fp);
@@ -702,7 +737,11 @@
 	    (void) fseek (fp, 0L, 0);
 	}
 	else
+#ifdef __EMX__
+	    if ((fp = fopen (file, "rb")) == NULL)
+#else
 	    if ((fp = fopen (file, "r")) == NULL)
+#endif
 		adios (file, "unable to read");
 
 	if (ct = get_content (fp, file, 1)) {
@@ -930,7 +969,11 @@
 			/* NOTREACHED */
 
 		    case OK:
+#ifdef __EMX__
+			(void) execvp (libpath (mhlproc), vec);
+#else
 			(void) execvp (mhlproc, vec);
+#endif
 			fprintf (stderr, "unable to exec ");
 			perror (mhlproc);
 			_exit (-1);
@@ -1293,7 +1336,9 @@
 
 	    case BODY:
 	    case BODYEOF:
+#ifndef __EMX__
 		ct -> c_begin = ftell (in) - strlen (buf);
+#endif
 		break;
 
 	    case FILEEOF:
@@ -1887,6 +1932,9 @@
 
     (void) putchar ('\n');
 
+#ifdef  __EMX__
+    (void) signal (SIGINT, SIG_ACK);
+#endif
     longjmp (intrenv, DONE);
 }
 
@@ -2139,10 +2187,20 @@
 	}
     }
 
+#ifdef __EMX__
+    if (!unixshell)
+      (void) sprintf (exec, "%s", buffer);
+    else
+#endif
     (void) sprintf (exec, "exec %s", buffer);
 
+#ifdef __EMX__
+    vec[0] = shell;
+    vec[1] = shelloption;
+#else
     vec[0] = "/bin/sh";
     vec[1] = "-c";
+#endif
     vec[2] = exec;
     vec[3] = NULL;
 
@@ -2162,9 +2220,15 @@
 	    if (!xstdin)
 		(void) dup2 (fd, 0);
 	    (void) close (fd);
+#ifdef __EMX__
+	    (void) execvp (shell, vec);
+	    fprintf (stderr, "unable to exec ");
+	    perror (shell);
+#else
 	    (void) execvp ("/bin/sh", vec);
 	    fprintf (stderr, "unable to exec ");
 	    perror ("/bin/sh");
+#endif
 	    _exit (-1);
 	    /* NOTREACHED */
 
@@ -2268,6 +2332,14 @@
 	    break;
 
 	default:
+#ifdef __EMX__
+	    if (*(cp + 1) == ':' &&
+		(*(cp + 2) == '/' || *(cp + 2) == '\\')) {
+		bp = buffer;
+		buffer[0] = '\0';
+		break;
+	    }
+#endif
 	    bp = autosw ? cwd : dir;
 	    (void) sprintf (buffer, "%s/", bp[1] ? bp : "");
 	    bp = buffer + strlen (buffer);
@@ -2338,6 +2410,9 @@
 	return show_content_aux (ct, 1, 0, buffer + 1, autosw ? cwd : dir);
 got_filename: ;
 
+#ifdef __EMX__
+    _abspath (buffer, buffer, BUFSIZ);
+#endif
     ct -> c_storage = add (buffer, NULLCP);
     (void) fflush (stdout);
     fprintf (stderr, "storing message %s", ct -> c_file);
@@ -2393,6 +2468,9 @@
 			appending ? "appending" : "writing");
 		goto losing;
 	    }
+#ifdef __EMX__
+	_fsetmode (fp, "b");
+#endif
 
 	if (append && !*append)
 	    (void) copy_some_headers (fp, ct);
@@ -2451,6 +2529,9 @@
 		    appending ? "appending" : "writing");
 	    return NOTOK;
 	}
+#ifdef __EMX__
+    _fsetmode (fp, "b");
+#endif
 
     if (append && !*append) {
 	(void) copy_some_headers (fp, ct);
@@ -2570,7 +2651,11 @@
     for (cp = file + 1; cp = index (cp, '/'); cp++) {
 	struct stat st;
 
-	*cp = NULL;
+#ifdef __EMX__
+	if (*(cp - 1) == ':')
+	    continue;
+#endif
+	*cp = '\0';
 
 	if (stat (file, &st) == NOTOK) {
 	    int	    answer;
@@ -2817,10 +2902,22 @@
 	if (uleq (ci -> ci_subtype, kv -> kv_key))
 	    break;
     if ((ct -> c_subtype = kv -> kv_value) == TEXT_PLAIN) {
+#ifdef __EMX__
+      if (!unixshell)
+	(void) sprintf (buffer, "%%p%s %%F",
+			progsw ? progsw
+			       : moreproc && *moreproc ? moreproc : "less");
+      else
+	(void) sprintf (buffer, "%%p%s '%%F'",
+			progsw ? progsw
+			       : moreproc && *moreproc ? moreproc : "less");
+	ct -> c_showproc = add (buffer, NULLCP);
+#else
 	(void) sprintf (buffer, "%%p%s '%%F'",
 			progsw ? progsw
 			       : moreproc && *moreproc ? moreproc : "more");
 	ct -> c_showproc = add (buffer, NULLCP);
+#endif
     }
 
     for (ap = ci -> ci_attrs, ep = ci -> ci_values; *ap; ap++, ep++)
@@ -3132,6 +3229,11 @@
 			         part = part -> mp_next) {
 			    p = part -> mp_part;
 
+#ifdef __EMX__
+			    if (!unixshell)
+			      (void) sprintf (bp, "%s%s", s, p -> c_storage);
+			    else
+#endif
 			    (void) sprintf (bp, "%s'%s'", s, p -> c_storage);
 			    bp += strlen (bp);
 			    s = " ";
@@ -3827,6 +3929,9 @@
 {
     register struct k2v *kv;
     register CI	    ci = &ct -> c_ctinfo;
+#ifdef __EMX__
+    char   buffer[BUFSIZ];
+#endif
 
     if (ct -> c_encoding != CE_7BIT) {
 	admonish (NULLCP,
@@ -3843,7 +3948,13 @@
 
     switch (ct -> c_subtype = kv -> kv_value) {
 	case MESSAGE_RFC822:
+#ifdef __EMX__
+	    (void) sprintf (buffer, "%%pless %s",
+			    unixshell ? "'%F'" : "%F");
+	    ct -> c_showproc = add (buffer, NULLCP);
+#else
 	    ct -> c_showproc = add ("%pshow -file '%F'", NULLCP);
+#endif
 	    break;
 
 	case MESSAGE_PARTIAL:
@@ -4294,6 +4405,9 @@
 	    content_error (ce -> ce_file, ct, "unable to fopen for reading");
 	    return NOTOK;
 	}
+#ifdef __EMX__
+	_fsetmode (ce -> ce_fp, "b");
+#endif
 
 	*file = ce -> ce_file;
 	return fileno (ce -> ce_fp);
@@ -4308,6 +4422,9 @@
 		       "unable to fopen for writing and reading");
 	return NOTOK;
     }
+#ifdef __EMX__
+    _fsetmode (ce -> ce_fp, "b");
+#endif
 
     if ((len = ct -> c_end - ct -> c_begin) < 0)
 	adios (NULLCP, "internal error(1)");
@@ -4316,6 +4433,9 @@
 	content_error (ct -> c_file, ct, "unable to open for reading");
 	return NOTOK;
     }
+#ifdef __EMX__
+    _fsetmode (ct -> c_fp, "b");
+#endif
     
     if (digested = ct -> c_digested)
 	MD5Init (&mdContext);
@@ -4501,6 +4621,9 @@
 	    content_error (ce -> ce_file, ct, "unable to fopen for reading");
 	    return NOTOK;
 	}
+#ifdef __EMX__
+	_fsetmode (ce -> ce_fp, "b");
+#endif
 
 	*file = ce -> ce_file;
 	return fileno (ce -> ce_fp);
@@ -4515,6 +4638,9 @@
 		       "unable to fopen for writing and reading");
 	return NOTOK;
     }
+#ifdef __EMX__
+    _fsetmode (ce -> ce_fp, "b");
+#endif
 
     if ((len = ct -> c_end - ct -> c_begin) < 0)
 	adios (NULLCP, "internal error(2)");
@@ -4523,6 +4649,9 @@
 	content_error (ct -> c_file, ct, "unable to open for reading");
 	return NOTOK;
     }
+#ifdef __EMX__
+    _fsetmode (ct -> c_fp, "b");
+#endif
 
     if (digested = ct -> c_digested)
 	MD5Init (&mdContext);
@@ -4543,6 +4672,10 @@
 	if ((cc = strlen (buffer)) > len)
 	    cc = len;
 	len -= cc;
+#ifdef __EMX__
+	_crlf (buffer, cc, (size_t *)&cc);
+	buffer[cc] = '\0';
+#endif
 
 	for (ep = (cp = buffer) + cc - 1; cp <= ep; ep--)
 	    if (!isspace (*ep))
@@ -4703,6 +4836,9 @@
 		       "unable to fopen for writing and reading");
 	return NOTOK;
     }
+#ifdef __EMX__
+    _fsetmode (ce -> ce_fp, "b");
+#endif
 
     if (ct -> c_type == CT_MULTIPART) {
 	register char **ap,
@@ -4759,6 +4895,9 @@
 	content_error (ct -> c_file, ct, "unable to open for reading");
 	return NOTOK;
     }
+#ifdef __EMX__
+    _fsetmode (ct -> c_fp, "b");
+#endif
 
     (void) lseek (fd = fileno (ct -> c_fp), (off_t) ct -> c_begin, 0);
     while (len > 0)
@@ -5190,7 +5329,11 @@
 	    return NOTOK;
 
 	case OK:
+#ifdef __EMX__
+	    (void) execvp (exepath (mailproc), vec);
+#else
 	    (void) execvp (mailproc, vec);
+#endif
 	    fprintf (stderr, "unable to exec ");
 	    perror (mailproc);
 	    _exit (-1);
@@ -5594,6 +5737,10 @@
     if ((out = fopen (tmpfil, "w")) == NULL)
 	adios (tmpfil, "unable to open for writing");
     free_file = tmpfil;
+#ifdef __EMX__
+    _fsetmode (in, "b");
+    _fsetmode (out, "b");
+#endif
 
     for (compnum = 1, state = FLD;;) {
 	switch (state = m_getfld (state, name, buf, sizeof buf, in)) {
@@ -5730,6 +5877,9 @@
     free_ct = NULL;
 
     (void) sprintf (buf, "%s.orig", m_backup (file));
+#ifdef __EMX__
+    unlink (buf);
+#endif
     if (rename (file, buf) == NOTOK)
 	adios (buf, "unable to rename %s to", file);
     if (rename (tmpfil, file) == NOTOK) {
@@ -5751,12 +5901,19 @@
 {
     register char *cp,
 		  *ep;
+#ifdef __EMX__
+    size_t         len;
+#endif
 
     for (ep = (cp = s) + n; cp < ep; ) {
 	register int	i;
 
 	if (!fgets (cp, n, stream))
 	    return (cp != s ? s : NULL);
+#ifdef __EMX__
+	_crlf (cp, strlen (cp), &len);
+	*(cp + len) = '\0';
+#endif
 	if (cp == s && *cp != '#')
 	    return s;
 
@@ -5813,6 +5970,9 @@
 
 	if ((out = fopen (ct -> c_file, "w")) == NULL)
 	    adios (ct -> c_file, "unable to open for writing");
+#ifdef __EMX__
+	_fsetmode (out, "b");
+#endif
 
 	if (buf[0] == '#' && buf[1] == '<') {
 	    (void) strcpy (content, buf + 2);
@@ -6364,8 +6524,13 @@
 			ci -> ci_type, ci -> ci_subtype, buffer);
 		(void) fflush (stdout);
 
+#ifdef __EMX__
+		vec[0] = shell;
+		vec[1] = shelloption;
+#else
 		vec[0] = "/bin/sh";
 		vec[1] = "-c";
+#endif
 		vec[2] = buffer;
 		vec[3] = NULL;
 
@@ -6383,9 +6548,15 @@
 			if (!xstdout)
 			    (void) dup2 (fileno (out), 1);
 			(void) close (fileno (out));
+#ifdef __EMX__
+			(void) execvp (shell, vec);
+			fprintf (stderr, "unable to exec ");
+			perror (shell);
+#else
 			(void) execvp ("/bin/sh", vec);
 			fprintf (stderr, "unable to exec ");
 			perror ("/bin/sh");
+#endif
 			_exit (-1);
 			/* NOTREACHED */
 
@@ -6869,6 +7040,9 @@
 
     if ((in = fopen (ct -> c_file, "r")) == NULL)
 	adios (ct -> c_file, "unable to open for reading");
+#ifdef __EMX__
+    _fsetmode (in, "b");
+#endif
 
     result = writeBase64aux (in, out);
 
@@ -7113,7 +7287,11 @@
     (void) umask (~m_gmprot ());
 
     (void) strcpy (tmpfil, m_tmpfil (invo_name));
+#ifdef __EMX__
+    if ((fp = fopen (tmpfil, "wb+")) == NULL)
+#else
     if ((fp = fopen (tmpfil, "w+")) == NULL)
+#endif
 	adios (tmpfil, "unable to open for writing");
     (void) chmod (tmpfil, 0600);
 
@@ -7247,7 +7425,11 @@
 	    /* NOTREACHED */
 
 	case OK:
+#ifdef __EMX__
+	    (void) execlp (libpath (postproc), postproc, file,
+#else
 	    (void) execlp (postproc, r1bindex (postproc, '/'), file,
+#endif
 			   queued ? "-queued" : NULLCP, NULLCP);
 	    fprintf (stderr, "unable to exec ");
 	    perror (postproc);
diff -urP ../mh-6.8.4/uip/mhparam.c ./uip/mhparam.c
--- ../mh-6.8.4/uip/mhparam.c	Wed Dec  1 13:01:36 1993
+++ ./uip/mhparam.c	Sat Mar  2 14:26:08 1996
@@ -48,7 +48,12 @@
            *arguments[MAXARGS],
            *comps[MAXARGS];
 
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
diff -urP ../mh-6.8.4/uip/mhpath.c ./uip/mhpath.c
--- ../mh-6.8.4/uip/mhpath.c	Wed Dec  1 13:01:36 1993
+++ ./uip/mhpath.c	Sat Mar  2 14:26:08 1996
@@ -41,7 +41,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
diff -urP ../mh-6.8.4/uip/msgchk.c ./uip/msgchk.c
--- ../mh-6.8.4/uip/msgchk.c	Sat Mar  2 01:50:02 1996
+++ ./uip/msgchk.c	Sat Apr  6 14:55:56 1996
@@ -103,7 +103,11 @@
 {
     int     datesw = 1,
 	    notifysw = NT_ALL,
+#ifdef  RPOP
 	    rpop = 1,
+#else
+	    rpop = 0,
+#endif
 	    status = 0,
 	    snoop = 0,
 	    vecp = 0;
@@ -125,7 +129,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     mts_init (invo_name);
 #ifdef	POP
     if ((cp = getenv ("MHPOPDEBUG")) && *cp)
@@ -324,7 +333,7 @@
 	: st.st_atime <= st.st_mtime ? MMDFNEW : MMDFOLD;
 
 #ifdef	MF
-    if (umincproc != NULL && *umincproc != NULL) {
+    if (umincproc != NULL && *umincproc != '\0') {
 	(void) sprintf (buffer, "%s/%s",
 		uucpldir[0] ? uucpldir : home,
 		uucplfil[0] ? uucplfil : user);
diff -urP ../mh-6.8.4/uip/msh.c ./uip/msh.c
--- ../mh-6.8.4/uip/msh.c	Sat Mar  2 01:50:02 1996
+++ ./uip/msh.c	Mon Sep 16 22:06:48 1996
@@ -177,6 +177,10 @@
 jmp_buf sigenv;			/* the environment pointer */
 #endif	/* BSD42 */
 
+#ifdef	__EMX__
+extern __const__ int _nfiles;
+#endif	/* __EMX__ */
+
 static TYPESIG	intrser (), pipeser (), quitser ();
 
 
@@ -222,7 +226,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     mts_init (invo_name);
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
@@ -365,6 +374,20 @@
 
 #ifdef	BPOP
     if (pmsh = pmsh1 && pmsh2) {
+#ifdef __EMX__
+	char	bufr[BUFSIZ],
+		bufw[BUFSIZ];
+	int	snoop = getenv ("MHPOPDEBUG") ? 1 : 0;
+
+	/* emx/gcc does not allow to inherit the socket handles */
+	/* from the parent process.  So we need pop_init()      */
+	/* here again.                                          */
+	if (pop_init (popbbhost, NULL, NULL, snoop, 0) == NOTOK)
+	    adios (NULLCP, "%s", response);
+	pop_fd (bufr, bufw);
+	pmsh1 = atoi (bufr);
+	pmsh2 = atoi (bufw);
+#endif
 	cp = getenv ("MHPOPDEBUG");
 #ifdef	NNTP
 	if (pop_set (pmsh1, pmsh2, cp && *cp, myname) == NOTOK)
@@ -693,11 +716,15 @@
 
     fmsh = getcpy (folder);
 
+#ifdef  __EMX__
+    maxfds = _nfiles / 2;
+#else
 #ifndef	BSD42
     maxfds = _NFILE / 2;
 #else	/* BSD42 */
     maxfds = getdtablesize () / 2;
 #endif	/* BSD42 */
+#endif
     if ((maxfds -= 2) < 1)
 	maxfds = 1;
 }
@@ -1340,6 +1367,9 @@
             map2[BUFSIZ];
     struct stat st;
     FILE   *dp;
+#ifdef __EMX__
+    int     upd = 0;
+#endif
 
     if (!(mp -> msgflags & MODIFIED) || mp -> msgflags & READONLY || fmsh) {
 	    if (vmh)
@@ -1399,6 +1429,9 @@
 	}
     (void) mbx_close (tmpfil, md);
 
+#ifdef __EMX__
+    upd++;
+#else
     if (rename (tmpfil, mp -> foldpath) == NOTOK)
 	admonish (mp -> foldpath, "unable to rename %s to", tmpfil);
     else {
@@ -1411,6 +1444,7 @@
 	    (void) unlink (map2);
 	}
     }
+#endif
 
 release: ;
     if (cp)
@@ -1420,6 +1454,27 @@
 	(void) ttyR (NULLCMD);
 	(void) pFIN ();
     }
+#ifdef __EMX__
+    if (!upd)
+	return;
+
+    fcloseall ();
+    unlink (mp -> foldpath);
+    unlink (map_name (mp -> foldpath));
+
+    if (rename (tmpfil, mp -> foldpath) == NOTOK)
+	admonish (mp -> foldpath, "unable to rename %s to", tmpfil);
+    else {
+	(void) strcpy (map1, map_name (tmpfil));
+	(void) strcpy (map2, map_name (mp -> foldpath));
+
+	if (rename (map1, map2) == NOTOK) {
+	    admonish (map2, "unable to rename %s to", map1);
+	    (void) unlink (map1);
+	    (void) unlink (map2);
+	}
+    }
+#endif
 }
 
 /*  */
@@ -1460,7 +1515,7 @@
 	for (cp = buffer; (i = getchar ()) != '\n';) {
 #ifndef	BSD42
 	    if (interrupted && !told_to_quit) {
-		buffer[0] = NULL;
+		buffer[0] = '\0';
 		(void) putchar ('\n');
 		break;
 	    }
@@ -2431,7 +2486,11 @@
 		padios ("diagnostic output", "unable to dup");
 
 	    (void) close (0);
+#ifdef __EMX__
+	    if ((i = open ("nul", 0)) != NOTOK && i != fileno (stdin)) {
+#else
 	    if ((i = open ("/dev/null", 0)) != NOTOK && i != fileno (stdin)) {
+#endif
 		(void) dup2 (i, fileno (stdin));
 		(void) close (i);
 	    }
@@ -2544,7 +2603,11 @@
 
 	case OK: 
 	    (void) close (fileno (stdin));
+#ifdef __EMX__
+	    if ((i = open ("nul", 0)) != NOTOK && i != fileno (stdin)) {
+#else
 	    if ((i = open ("/dev/null", 0)) != NOTOK && i != fileno (stdin)) {
+#endif
 		(void) dup2 (i, fileno (stdin));
 		(void) close (i);
 	    }
diff -urP ../mh-6.8.4/uip/mshcmds.c ./uip/mshcmds.c
--- ../mh-6.8.4/uip/mshcmds.c	Sat Mar  2 01:50:04 1996
+++ ./uip/mshcmds.c	Sun Apr  7 00:54:46 1996
@@ -73,6 +73,12 @@
     int     child_id;
     char   *vec[MAXARGS];
 
+#ifdef __EMX__
+    static char tmp[260];
+
+    sprintf (tmp, "%s.exe", pgm);
+    pgm = exepath (tmp);
+#endif
     vec[0] = r1bindex (pgm, '/');
     (void) copyip (args, vec + 1);
 
@@ -2546,7 +2552,11 @@
 	    msgnum++)
 	if (mp -> msgstats[msgnum] & SELECTED) {
 	    if (optim && Msgs[msgnum].m_scanl)
+#ifdef JAPAN
+		ml_fputs (Msgs[msgnum].m_scanl, stdout);
+#else
 		printf ("%s", Msgs[msgnum].m_scanl);
+#endif
 	    else {
 #ifdef	MPOP
 #ifdef	BPOP
@@ -2723,7 +2733,11 @@
     if (!nshow && !getenv ("NOMHNPROC"))
 	for (msgnum = mp -> lowsel; msgnum <= mp -> hghsel; msgnum++)
 	    if ((mp -> msgstats[msgnum] & SELECTED) && nontext (msgnum)) {
+#ifndef __EMX__
+		proc = (cp = m_find ("mhnproc")) ? cp : exepath ("mhn.exe");
+#else
 		proc = (cp = m_find ("mhnproc")) ? cp : "mhn";
+#endif
 		vec[vecp++] = "-show";
 		vec[vecp++] = "-file";
 		vec[vecp] = NULL;
@@ -2734,8 +2748,13 @@
     if (nshow)
 	proc = "cat";
     else
+#ifdef __EMX__
+	if (!strcmp (showproc, "mhl") || !strcmp (showproc, "mhl.exe")) {
+	    proc = libpath (mhlproc);
+#else
 	if (strcmp (showproc, "mhl") == 0) {
 	    proc = mhlproc;
+#endif
 	    mhl++;
 	}
 
@@ -2961,8 +2980,8 @@
 		    }
 		    for (dp = bp; istoken (*dp); dp++)
 			continue;
-		    c = *dp, *dp = NULL;
-		    if (*bp == NULL)
+		    c = *dp, *dp = '\0';
+		    if (*bp == '\0')
 			goto invalid;
 		    if (passno > 1) {
 			if (result = !uleq (bp, "plain"))
@@ -2981,12 +3000,12 @@
 			    dp++;
 			if (*dp == '"') {
 			    if (bp = index (++dp, '"'))
-				*bp = NULL;
+				*bp = '\0';
 			}
 			else
 			    for (bp = dp; *bp; bp++)
 				if (isspace (*bp)) {
-				    *bp = NULL;
+				    *bp = '\0';
 				    break;
 				}
 			if ((result = !uleq (dp, chset))
@@ -3021,7 +3040,7 @@
 			continue;
 		    for (dp = bp; istoken (*dp); dp++)
 			continue;
-		    *dp = NULL;
+		    *dp = '\0';
 		    result = !uleq (bp, "7bit")
 				&& !uleq (bp, "8bit")
 				&& !uleq (bp, "binary");
@@ -3348,6 +3367,14 @@
 	    status;
     char    tmpfil[80];
     FILE   *out;
+#ifdef __EMX__
+    static char tmp[260];
+
+    strcpy (tmp, proc);
+    _remext (tmp);
+    strcat (tmp, ".exe");
+    proc = exepath (tmp);
+#endif
 
     if (fmsh) {
 	(void) strcpy (tmpfil, m_name (msgnum));
@@ -3374,6 +3401,9 @@
 	else
 	    (void) strcpy (tmpfil, newfil);
     }
+#ifdef __EMX__
+    _fsetmode (out, "b");
+#endif
     copy_message (msgnum, out);
     (void) fclose (out);
 
diff -urP ../mh-6.8.4/uip/packf.c ./uip/packf.c
--- ../mh-6.8.4/uip/packf.c	Wed Dec  1 13:01:36 1993
+++ ./uip/packf.c	Sat Mar  2 14:26:58 1996
@@ -60,7 +60,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
diff -urP ../mh-6.8.4/uip/pick.c ./uip/pick.c
--- ../mh-6.8.4/uip/pick.c	Wed Dec  1 13:01:36 1993
+++ ./uip/pick.c	Sat Mar  2 14:27:00 1996
@@ -102,7 +102,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
diff -urP ../mh-6.8.4/uip/picksbr.c ./uip/picksbr.c
--- ../mh-6.8.4/uip/picksbr.c	Wed Dec  1 13:01:36 1993
+++ ./uip/picksbr.c	Sat Sep 21 22:13:06 1996
@@ -544,6 +544,7 @@
 
     dp = (ep = n -> n_expbuf) + sizeof n -> n_expbuf;
     sp = astr;
+    lastep = NULL;
     if (*sp == '^') {
 	n -> n_circf = 1;
 	sp++;
@@ -624,6 +625,13 @@
                    *cbp;
     char    ibuf[BUFSIZ];
 
+    static char *linebuf = NULL;
+    static int len = 0;
+
+    if (linebuf == NULL)
+	if ((linebuf = malloc((unsigned) (len = LBSIZE + 1))) == NULL)
+		adios (NULLCP, "unable to allocate string storage");
+
     (void) fseek (fp, start, 0);
     body = 0;
     ebp = cbp = ibuf;
@@ -664,8 +672,15 @@
 		    lf++;
 		    c = ' ';
 		}
-	    if (c && p1 < &linebuf[LBSIZE - 1])
+	    if (c && p1 < &linebuf[len - 2])
 		*p1++ = c;
+	    else if (c) { /* buffer overflow */
+		if ((linebuf = realloc(linebuf, len + LBSIZE)) == NULL)
+		    adios (NULLCP, "unable to allocate string storage");
+		p1 = linebuf + len - 2;
+		len += LBSIZE;
+		*p1++ = c;
+	    }
 	}
 
 	*p1++ = 0;
diff -urP ../mh-6.8.4/uip/popsbr.c ./uip/popsbr.c
--- ../mh-6.8.4/uip/popsbr.c	Sat Mar  2 01:50:06 1996
+++ ./uip/popsbr.c	Sat Mar  2 14:27:02 1996
@@ -27,11 +27,13 @@
 #define	TRM	"."
 #define	TRMLEN	(sizeof TRM - 1)
 
+#ifndef __EMX__
 extern int  errno;
 #ifndef	BSD44
 extern int  sys_nerr;
 extern char *sys_errlist[];
 #endif
+#endif  /* __EMX__ */
 
 static int  poprint = 0;
 static int  pophack = 0;
@@ -93,7 +95,7 @@
 	return NULL;
     }
 
-    *++lp = NULL;
+    *++lp = '\0';
     (void) sprintf (buffer, "%s%s", cp, pass);
 
     MD5Init (&mdContext);
@@ -107,7 +109,7 @@
 	     dp < ep;
 	     cp += 2)
 	(void) sprintf (cp, "%02x", *dp++ & 0xff);
-    *cp = NULL;
+    *cp = '\0';
 
     return buffer;
 }
@@ -239,8 +241,13 @@
 	strcpy (xtnd_name, myname);	/* interface from bbc to msh */
 
 #endif	/* NNTP */
+#ifdef __EMX__
+    if ((input = fdopen (in, "rb")) == NULL
+	    || (output = fdopen (out, "wb")) == NULL) {
+#else /* __EMX__ */
     if ((input = fdopen (in, "r")) == NULL
 	    || (output = fdopen (out, "w")) == NULL) {
+#endif /* __EMX__ */
 	(void) strcpy (response, "fdopen failed on connection descriptor");
 	if (input)
 	    (void) fclose (input);
diff -urP ../mh-6.8.4/uip/post.c ./uip/post.c
--- ../mh-6.8.4/uip/post.c	Sat Mar  2 01:50:06 1996
+++ ./uip/post.c	Sat Jul  6 16:58:44 1996
@@ -36,6 +36,11 @@
 #ifdef LOCALE
 #include <locale.h>
 #endif
+#ifdef __EMX__
+#include <process.h>
+#include <unistd.h>
+#include <fcntl.h>
+#endif /* __EMX__ */
 
 
 #ifndef	MMDFMTS
@@ -354,6 +359,13 @@
 #else
 static	post();
 #endif	/* !TMA */
+#ifdef MHMTS
+static  localmail(), uucpmail (), netmail ();
+static  int  usr_hook (), copyfile (), make_uucp_file ();
+#endif
+#if defined(__EMX__) && defined(SENDMTS) && !defined(SMTP)
+static  do_sendmail ();
+#endif
 /*    MAIN */
 
 /* ARGSUSED */
@@ -375,7 +387,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else /* __EMX__ */
     invo_name = r1bindex (argv[0], '/');
+#endif /* __EMX__ */
     m_foil (NULLCP);
     mts_init (invo_name);
 #ifdef	MMDFMTS
@@ -631,7 +648,11 @@
     else
 #ifdef	MHMTS
     if (deliver) {
+#ifdef  __EMX__
+	if ((out = fopen ("nul", "r")) == NULL)
+#else
 	if ((out = fopen ("/dev/null", "r")) == NULL)
+#endif
 	    adios ("/dev/null", "unable to write");
 	(void) strcpy (tmpfil, msg);
 	putfmt ("To", deliver, out);
@@ -640,14 +661,24 @@
     else
 #endif	/* MHMTS */
 	if (whomsw) {
+#ifdef __EMX__
+	    if ((out = fopen (fill_in ? fill_in : "nul", "w")) == NULL)
+#else /* __EMX__ */
 	    if ((out = fopen (fill_in ? fill_in : "/dev/null", "w")) == NULL)
+#endif /* __EMX__ */
 		adios ("/dev/null", "unable to open");
 	}
 	else {
 	    (void) strcpy (tmpfil, m_scratch ("", m_maildir (invo_name)));
+#ifdef __EMX__
+	    if ((out = fopen (tmpfil, "wb")) == NULL) {
+		(void) strcpy (tmpfil, m_tmpfil (invo_name));
+		if ((out = fopen (tmpfil, "wb")) == NULL)
+#else
 	    if ((out = fopen (tmpfil, "w")) == NULL) {
 		(void) strcpy (tmpfil, m_tmpfil (invo_name));
 		if ((out = fopen (tmpfil, "w")) == NULL)
+#endif
 		    adios (tmpfil, "unable to create");
 	    }
 #ifdef	MHMTS
@@ -1351,7 +1382,11 @@
 		vec[i++] = tmpfil;
 		vec[i] = NULL;
 
+#ifdef __EMX__
+		execvp (mhlproc, (char * __const__ *)vec);
+#else  /* __EMX__ */
 		execvp (mhlproc, vec);
+#endif /* __EMX__ */
 		fprintf (stderr, "unable to exec ");
 		perror (mhlproc);
 		_exit (-1);
@@ -1382,7 +1417,11 @@
     char    buffer[BUFSIZ];
     FILE   *in;
 
+#ifdef __EMX__
+    if ((in = fopen (tmpfil, "rb")) == NULL)
+#else /* __EMX__ */
     if ((in = fopen (tmpfil, "r")) == NULL)
+#endif /* __EMX__ */
 	adios (tmpfil, "unable to re-open");
 
     len = strlen (prefix);
@@ -1395,7 +1434,11 @@
 	    for (cp = buffer + strlen (buffer) - 1; cp >= buffer; cp--)
 		if (!isspace (*cp))
 		    break;
+#ifdef __EMX__
+	    *++cp = (char)NULL;
+#else /* __EMX__ */
 	    *++cp = NULL;
+#endif /* __EMX__ */
 	    if (strcmp (buffer + 2, prefix) == 0) {
 		result = NOTOK;
 		break;
@@ -1565,10 +1608,14 @@
 	die (file, "unable to re-open");
     do_text (file, fd);
 #else	/* MHMTS */
-    if ((fd = open (file, 0)) == NULL)
+    if ((fd = open (file, 0)) == NOTOK)
 	adios (file, "unable to re-open");
 #ifdef	MF
+#ifdef  __EMX__
+    ud = fd;
+#else
     ud = UucpChan () && uuaddrs.m_next ? make_uucp_file (fd) : NOTOK;
+#endif
 #else	/* not MF */
     ud = NOTOK;
 #endif	/* not MF */
@@ -1790,6 +1837,9 @@
 #ifndef	BERK
     int	    state;
 #endif	/* not BERK */
+#if defined(__EMX__) && defined(MHMTS) && defined(MF)
+    int dest = 0;
+#endif
     register struct mailname *lp;
 
 #ifndef	BERK
@@ -1804,7 +1854,13 @@
 #ifndef	MHMTS
 	    do_an_address (lp, talk, 0);
 #else	/* MHMTS */
+#if defined(__EMX__) && defined(MF)
+	    if (talk)
+		printf ("  %s: \n", lp -> m_mbox);
+	    dest++;
+#else
 	    localmail (lp, talk, fd);
+#endif
 #endif	/* MHMTS */
 #ifndef	BERK
 	    state++;
@@ -1823,7 +1879,13 @@
 #ifndef	MHMTS
 	    do_an_address (lp, talk, 0);
 #else	/* MHMTS */
+#if defined(__EMX__) && defined(MF)
+	    if (talk)
+		printf ("  %s!%s: \n", lp -> m_host, lp -> m_mbox);
+	    dest++;
+#else
 	    uucpmail (lp, talk, ud != NOTOK ? ud : fd, ud == NOTOK);
+#endif
 #endif	/* MHMTS */
 #ifndef	BERK
 	    state++;
@@ -1842,12 +1904,21 @@
 #ifndef	MHMTS
 	    do_an_address (lp, talk, 0);
 #else	/* MHMTS */
+#if defined(__EMX__) && defined(MF)
+	    if (talk)
+		printf ("  %s at %s: \n", lp -> m_mbox, lp -> m_host);
+	    dest++;
+#else
 	    netmail (talk, fd, bccque);
+#endif
 #endif	/* MHMTS */
 #ifndef	BERK
 	    state++;
 #endif	/* not BERK */
 	}
+#if defined(__EMX__) && defined(MHMTS) && defined(MF)
+	uucpmail (NULL, talk, ud, 0);
+#endif
 
 /*  */
 
@@ -1878,6 +1949,9 @@
     struct rp_bufstruct reply;
 #endif	/* MMDFMTS */
 
+#if defined(__EMX__) && defined(SENDMTS) && !defined(SMTP)
+    do_sendmail (file, fd);
+#else
     (void) lseek (fd, (off_t)0, 0);
     while ((state = read (fd, buf, sizeof buf)) > 0)
 #ifdef	MMDFMTS
@@ -1935,6 +2009,7 @@
 	    die (NULLCP, "unexpected response; %s", rp_string (retval));
     }
 #endif	/* SENDMTS */
+#endif
 }
 #endif	/* not MHMTS */
 
@@ -2118,6 +2193,23 @@
 
 /*  */
 
+#if defined(__EMX__) && defined(MF)
+    switch (lp -> m_type) {
+	case LOCALHOST: 
+	    mbox = lp -> m_mbox;
+	    if (*mbox == '~')
+		mbox++;
+	    seek_home (mbox);
+	    lp -> m_mbox = mbox;
+	    if (talk)
+		printf ("address ok\n");
+	    break;
+
+	case UUCPHOST: 
+	    if (talk)
+		printf ("address ok\n");
+	    break;
+#else
     switch (lp -> m_type) {
 	case LOCALHOST: 
 	    mbox = lp -> m_mbox;
@@ -2150,6 +2242,7 @@
 		unkadr++;
 	    }
 	    break;
+#endif
 
 	case NETHOST: 
 	    if (talk)
@@ -2350,6 +2443,20 @@
 	printf ("  %sFcc %s: ", msgstate == RESENT ? "Resent-" : "", folder);
     (void) fflush (stdout);
 
+#ifdef __EMX__
+    (void) sprintf (fold, "%s%s",
+	    *folder == '+' || *folder == '@' ? "" : "+", folder);
+    if (status = spawnlp (P_WAIT, exepath (fileproc), _getname (fileproc),
+	    "-link", "-file", file, fold, NULLCP)) {
+	if (!verbose)
+	    fprintf (stderr, "  %sFcc %s: \n",
+		    msgstate == RESENT ? "Resent-" : "", folder);
+	(void) pidstatus (status, verbose ? stdout : stderr, NULLCP);
+    }
+    else
+	if (verbose)
+	    printf ("folder ok\n");
+#else  /* __EMX__ */
     for (i = 0; (child_id = fork ()) == NOTOK && i < 5; i++)
 	sleep (5);
     switch (child_id) {
@@ -2378,6 +2485,7 @@
 		if (verbose)
 		    printf ("folder ok\n");
     }
+#endif /* __EMX__ */
 
     (void) fflush (stdout);
 }
@@ -2540,7 +2648,11 @@
 
 /*  */
 
+#ifdef  __EMX__
+    switch (access (libpath (slocalproc), 01)) {
+#else
     switch (access (slocalproc, 01)) {
+#endif
 	default: 
 	    if (talk)
 		printf ("(invoking hook)\n\t");
@@ -2621,8 +2733,13 @@
 	case OK: 
 	    if (fd != 0)
 		(void) dup2 (fd, 0);
+#ifdef __EMX__
+	    (void) freopen ("nul", "w", stdout);
+	    (void) freopen ("nul", "w", stderr);
+#else
 	    (void) freopen ("/dev/null", "w", stdout);
 	    (void) freopen ("/dev/null", "w", stderr);
+#endif
 	    if (fd != 3)	/* backwards compatible... */
 		(void) dup2 (fd, 3);
 	    closefds (4);
@@ -2652,7 +2769,11 @@
 #endif	/* BSD42 */
 	    (void) setuid (hp -> h_uid);
 
+#ifdef  __EMX__
+	    execlp (libpath (slocalproc), slocalproc,
+#else
 	    execlp (slocalproc, r1bindex (slocalproc, '/'),
+#endif
 		    "-file", tmpfil, "-mailbox", mailbox,
 		    "-home", hp -> h_home, "-addr", lp -> m_aka,
 		    "-user", hp -> h_name, "-sender", from,
@@ -2729,12 +2850,21 @@
     char    addr[BUFSIZ],
             buffer[BUFSIZ];
     register FILE *fp;
+#ifdef __EMX__
+    FILE    *fsp = NULL, *ffp = NULL;
+    int     addnl, j;
+#endif
 
+#ifndef __EMX__
     (void) sprintf (addr, "%s!%s", lp -> m_host, lp -> m_mbox);
     if (talk)
 	printf ("  %s: ", addr);
     (void) fflush (stdout);
+#endif
 
+#ifdef  __EMX__
+    (void) strcpy (buffer, "rmail -t");
+#else
 #ifndef	UCI
     (void) sprintf (buffer, "uux -r -p %s!rmail \\(%s\\)",
 		lp -> m_host, lp -> m_mbox);
@@ -2742,11 +2872,16 @@
     (void) sprintf (buffer, "uux -p %s!rmail \\(%s\\)", lp -> m_host,
 	    lp -> m_mbox);
 #endif	/* UCI */
+#endif
     if ((fp = popen (buffer, "w")) == NULL) {
 	if (!talk)
 	    fprintf (stderr, "  %s: ", addr);
 	fprintf (talk ? stdout : stderr,
+#ifdef  __EMX__
+		"unable to start rmail; popen() failed\n");
+#else
 		"unable to start uux; popen() failed\n");
+#endif
 	unkadr++;
 	return;
     }
@@ -2761,17 +2896,66 @@
     }
 
     (void) lseek (fd, (off_t)0, 0);
+#ifdef  __EMX__
+    if (*UupcFileSentName && (ffp = fopen (UupcFileSentName, "a")))
+	fputs ("\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\n", ffp);
+
+    while ((i = read (fd, buffer, sizeof buffer)) > 0) {
+	addnl = buffer[i-1] == '\n' ? 0 : 1;
+#else
     while ((i = read (fd, buffer, sizeof buffer)) > 0)
+#endif
 	if (fwrite (buffer, sizeof *buffer, i, fp) != i) {
     oops:   ;
 	    if (!talk)
 		fprintf (stderr, "  %s: ", addr);
 	    fprintf (talk ? stdout : stderr,
+#ifdef  __EMX__
+		    "error in transmission; write to rmail failed\n");
+	    if (fsp)
+		fclose (fsp);
+	    if (ffp)
+		fclose (ffp);
+#else
 		    "error in transmission; write to uux failed\n");
+#endif
 	    unkadr++;
 	    (void) pclose (fp);
 	    return;
 	}
+#ifdef  __EMX__
+	if (ffp)
+	    fwrite (buffer, sizeof *buffer, i, ffp);
+    }
+    if (addnl) {
+  	fputc ('\n', fp);
+	if (ffp)
+	    fputc ('\n', ffp);
+    }
+
+    if (*UupcSignatureName)
+	fsp = fopen (UupcSignatureName, "r");
+    if (i == 0 && fsp) {
+	fputs ("--\n", fp);
+	if (ffp)
+	    fputs ("--\n", ffp);
+	while (fgets (buffer, BUFSIZ, fsp)) {
+	    j = strlen (buffer);
+	    fputs (buffer, fp);
+	    if (ffp)
+		fputs (buffer, ffp);
+	}
+        if (buffer[j-1] != '\n') {
+	    fputc ('\n', fp);
+	    if (ffp)
+		fputc ('\n', ffp);
+	}
+    }
+    if (fsp)
+	fclose (fsp);
+    if (ffp)
+	fclose (ffp);
+#endif
     if (pclose (fp))
 	goto oops;
     (void) signal (SIGPIPE, pstat);
@@ -2786,7 +2970,11 @@
     }
 
     if (talk)
+#ifdef  __EMX__
+	printf ("queued (via rmail)\n");
+#else
 	printf ("queued (via uux)\n");
+#endif
     (void) fflush (stdout);
 }
 
@@ -2880,3 +3068,98 @@
     }
 }
 #endif	/* MHMTS */
+
+#if defined(__EMX__) && defined(SENDMTS) && !defined(SMTP)
+static  do_sendmail (file, fd)
+register char   *file;
+int     fd;
+{
+    TYPESIG     (*pstat) ();
+    char    command[BUFSIZ], buffer[BUFSIZ], buffer_JIS[BUFSIZ];
+    FILE    *fp, *fdp, *fpp;
+    char    *cp, *ecp, **scp;
+    int     pd[2], org_handle, org_private;
+
+    if (!(cp = getenv ("USER")) || (*cp == '\0'))
+	die (NULLCP, "unable to start sendmail; no USER envariable");
+    if (!(ecp = getenv ("ETC")) || (*ecp == '\0'))
+	die (NULLCP, "unable to start sendmail; no ETC envariable");
+
+    /*
+        Generate a command string to be passed to popen(). V and H 
+	macros are set according to mtstailor and TCPOS2.INI.
+     */
+    sprintf (command, "%s -t -f %s -C%s\\SENDMAIL.UML", sendmail, cp, ecp);
+
+    if (servers != NULL && *servers != 0) {
+	scp = brkstring (getcpy (servers), " ", "\n");
+	sprintf (buffer, " -oMV%s", *scp);
+	strcat (command, buffer);
+    }
+    if ((cp = LocalName ()) && *cp) {
+	sprintf (buffer, " -oMH%s", cp);
+	strcat (command, buffer);
+    }
+
+    if (verbose)
+	printf ("command: %s\n", command);
+    /*
+        Redirect a standard output of OS/2 sendmail to a pipe.  OS/2
+        sendmail always puts some messages to a standard output even
+        when it ends successfully.  So I redirect its standard output
+        to a pipe and shows the messages only when sendmail returns
+        non-zero completion code.
+     */
+    if (pipe (pd) == NOTOK)
+	die (NULLCP, "unable to create pipe; pipe() failed");
+    fcntl (pd[0], F_SETFD, 1);
+    if ((org_private = fcntl (STDOUT_FILENO, F_GETFD, 0)) == NOTOK)
+	die (NULLCP, "unable to get flag; fcntl() failed");
+    if ((org_handle = dup (STDOUT_FILENO)) == NOTOK)
+	die (NULLCP, "unable to dup STDOUT; dup() failed");
+    if (close (STDOUT_FILENO) == NOTOK)
+	die (NULLCP, "unable to close STDOUT; close() failed");
+    if (dup (pd[1]) != STDOUT_FILENO)
+	die (NULLCP, "unable to dup pd[1]; dup() failed");
+    if (close (pd[1]) == NOTOK)
+	die (NULLCP, "unable to close pd[1]; close() failed");
+    if ((fpp = fdopen (pd[0], "r")) == NULL)
+	die (NULLCP, "unable to redirect STDOUT; fdopen() failed");
+
+    if ((fp = popen (command, "w")) == NULL)
+	die (NULLCP, "unable to start sendmail; popen() failed");
+
+    close (STDOUT_FILENO);
+    dup (org_handle);
+    close (org_handle);
+    fcntl (STDOUT_FILENO, F_SETFD, org_private);
+
+    pstat = signal (SIGPIPE, SIG_IGN);
+
+    (void) lseek (fd, (off_t)0, 0);
+    if ((fdp = fdopen (fd, "r")) == NULL) {
+	(void) pclose (fp);
+	die (NULLCP, "error in transmission; fdopen failed");
+    }
+
+    while (fgets (buffer, BUFSIZ, fdp)) {
+	strcpy (buffer_JIS, buffer);
+	if (fputs (buffer_JIS, fp) < 0) {
+	    (void) pclose (fp);
+	    die (NULLCP, "error in transmission; write to rmail failed");
+	}
+    }
+    if (pclose (fp))
+	while (fgets (buffer, BUFSIZ, fpp))
+	    fputs (buffer, stdout);
+
+    (void) signal (SIGPIPE, pstat);
+
+    if (ferror(fdp))
+	die (NULLCP, "error in transmission; read failed");
+
+    (void) fclose (fdp);
+    (void) fclose (fpp);
+    (void) fflush (stdout);
+}
+#endif
diff -urP ../mh-6.8.4/uip/prompter.c ./uip/prompter.c
--- ../mh-6.8.4/uip/prompter.c	Wed Dec  1 13:01:36 1993
+++ ./uip/prompter.c	Sat Mar  2 14:27:14 1996
@@ -6,15 +6,15 @@
 #include "../h/mh.h"
 #include <stdio.h>
 #include <errno.h>
-#ifndef	SYS5
+#if	!defined(SYS5) && !defined(__EMX__)
 #include <sgtty.h>
-#else	/* SYS5 */
+#else	/* SYS5 or __EMX__ */
 #include <sys/types.h>
 #include <termio.h>
 #ifndef	NOIOCTLH
 #include <sys/ioctl.h>
 #endif	/* NOIOCTLH */
-#endif	/* SYS5 */
+#endif	/* SYS5 or __EMX__ */
 #ifdef	BSD42
 #include <setjmp.h>
 #endif	/* BSD42 */
@@ -22,6 +22,9 @@
 #ifdef LOCALE
 #include	<locale.h>
 #endif
+#ifdef __EMX__
+#include <stdlib.h>
+#endif /* __EMX__ */
 
 
 #define	QUOTE	'\\'
@@ -71,19 +74,19 @@
 extern int  errno;
 
 
-#ifndef	SYS5
+#if	!defined(SYS5) && !defined(__EMX__)
 #define	ERASE	sg.sg_erase
 #define	KILL	sg.sg_kill
 static struct sgttyb    sg;
 
 #define	INTR	tc.t_intrc
 static struct tchars    tc;
-#else	/* SYS5 */
+#else	/* SYS5 or __EMX__ */
 #define	ERASE	sg.c_cc[VERASE]
 #define	KILL	sg.c_cc[VKILL]
 #define	INTR	sg.c_cc[VINTR]
 static struct termio    sg;
-#endif	/* SYS5 */
+#endif	/* SYS5 or __EMX__ */
 
 
 static TYPESIG	intrser ();
@@ -127,7 +130,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else  /* __EMX__ */
     invo_name = r1bindex (argv[0], '/');
+#endif /* __EMX__ */
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
@@ -206,29 +214,29 @@
     (void) chmod (tmpfil, 0600);
 
     if (killp || erasep) {
-#ifndef	SYS5
+#if	!defined(SYS5) && !defined(__EMX__)
 	int    serase,
 	       skill;
-#else	/* SYS5 */
+#else	/* SYS5 or __EMX__ */
 	char   serase,
 	       skill;
-#endif	/* SYS5 */
+#endif	/* SYS5 or __EMX__ */
 
-#ifndef	SYS5
+#if	!defined(SYS5) && !defined(__EMX__)
 	(void) ioctl (0, TIOCGETP, (char *) &sg);
 	(void) ioctl (0, TIOCGETC, (char *) &tc);
-#else	/* SYS5 */
+#else	/* SYS5 or __EMX__ */
 	(void) ioctl(0, TCGETA, &sg);
-#endif	/* SYS5 */
+#endif	/* SYS5 or __EMX__ */
 	skill = KILL;
 	serase = ERASE;
 	KILL = killp ? chrcnv (killp) : skill;
 	ERASE = erasep ? chrcnv (erasep) : serase;
-#ifndef	SYS5
+#if	!defined(SYS5) && !defined(__EMX__)
 	(void) ioctl (0, TIOCSETN, (char *) &sg);
-#else	/* SYS5 */
+#else	/* SYS5 or __EMX__ */
 	(void) ioctl(0, TCSETAW, &sg);
-#endif	/* SYS5 */
+#endif	/* SYS5 or __EMX__ */
 
 	chrdsp ("erase", ERASE);
 	chrdsp (", kill", KILL);
@@ -270,11 +278,11 @@
 		    if (i == -1) {
 abort: ;
 			if (killp || erasep)
-#ifndef	SYS5
+#if	!defined(SYS5) && !defined(__EMX__)
 			    (void) ioctl (0, TIOCSETN, (char *) &sg);
-#else	/* SYS5 */
+#else	/* SYS5 or __EMX__ */
 			    (void) ioctl (0, TCSETA, &sg);
-#endif	/* SYS5 */
+#endif	/* SYS5 or __EMX__ */
 			(void) unlink (tmpfil);
 			done (1);
 		    }
@@ -362,11 +370,11 @@
 /*  */
 
     if (killp || erasep)
-#ifndef	SYS5
+#if	!defined(SYS5) && !defined(__EMX__)
 	(void) ioctl (0, TIOCSETN, (char *) &sg);
-#else	/* SYS5 */
+#else	/* SYS5 or __EMX__ */
 	(void) ioctl (0, TCSETAW, &sg);
-#endif	/* SYS5 */
+#endif	/* SYS5 or __EMX__ */
 
     if ((fdi = open (tmpfil, 0)) == NOTOK)
 	adios (tmpfil, "unable to re-open");
diff -urP ../mh-6.8.4/uip/pshsbr.c ./uip/pshsbr.c
--- ../mh-6.8.4/uip/pshsbr.c	Sat Mar  2 01:50:12 1996
+++ ./uip/pshsbr.c	Sat Mar  2 14:27:16 1996
@@ -27,11 +27,13 @@
 #define	TRM	"."
 #define	TRMLEN	(sizeof TRM - 1)
 
+#ifndef __EMX__
 extern int  errno;
 #ifndef	BSD44
 extern int  sys_nerr;
 extern char *sys_errlist[];
 #endif
+#endif  /* __EMX__ */
 
 static int  poprint = 0;
 static int  pophack = 0;
@@ -93,7 +95,7 @@
 	return NULL;
     }
 
-    *++lp = NULL;
+    *++lp = '\0';
     (void) sprintf (buffer, "%s%s", cp, pass);
 
     MD5Init (&mdContext);
@@ -107,7 +109,7 @@
 	     dp < ep;
 	     cp += 2)
 	(void) sprintf (cp, "%02x", *dp++ & 0xff);
-    *cp = NULL;
+    *cp = '\0';
 
     return buffer;
 }
@@ -239,8 +241,13 @@
 	strcpy (xtnd_name, myname);	/* interface from bbc to msh */
 
 #endif	/* NNTP */
+#ifdef __EMX__
+    if ((input = fdopen (in, "rb")) == NULL
+	    || (output = fdopen (out, "wb")) == NULL) {
+#else /* __EMX__ */
     if ((input = fdopen (in, "r")) == NULL
 	    || (output = fdopen (out, "w")) == NULL) {
+#endif /* __EMX__ */
 	(void) strcpy (response, "fdopen failed on connection descriptor");
 	if (input)
 	    (void) fclose (input);
diff -urP ../mh-6.8.4/uip/rcvdist.c ./uip/rcvdist.c
--- ../mh-6.8.4/uip/rcvdist.c	Wed Dec  1 13:01:36 1993
+++ ./uip/rcvdist.c	Sat Mar  2 14:27:18 1996
@@ -11,6 +11,9 @@
 #ifdef LOCALE
 #include	<locale.h>
 #endif
+#ifdef __EMX__
+#include <process.h>
+#endif /* __EMX__ */
 
 /*  */
 
@@ -41,6 +44,9 @@
 {
     int     i,
             child_id,
+#ifdef __EMX__
+            status,
+#endif
             vecp = 1;
     char   *addrs = NULL,
            *cp,
@@ -55,7 +61,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     mts_init (invo_name);
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
@@ -100,7 +111,11 @@
 
     (void) umask (~m_gmprot ());
     (void) strcpy (tmpfil, m_tmpfil (invo_name));
+#ifdef __EMX__
+    if ((fp = fopen (tmpfil, "wb+")) == NULL)
+#else
     if ((fp = fopen (tmpfil, "w+")) == NULL)
+#endif
 	adios (tmpfil, "unable to create");
     (void) cpydata (fileno (stdin), fileno (fp), "message", tmpfil);
     (void) fseek (fp, 0L, 0);
@@ -111,11 +126,25 @@
     if (distout (drft, tmpfil, backup) == NOTOK)
 	done (1);
 
+#ifdef __EMX__
+    vec[0] = _getname (postproc);
+#else
     vec[0] = r1bindex (postproc, '/');
+#endif
     vec[vecp++] = "-dist";
     vec[vecp++] = drft;
     vec[vecp] = NULL;
 
+#ifdef __EMX__
+    if (-1 == (status = spawnvp (P_WAIT, libpath (postproc),
+				 (char * __const__ *)vec))) {
+        fprintf (stderr, "unable to exec ");
+        perror (fileproc);
+        _exit (-1);
+    }
+
+    done (status);
+#else
     for (i = 0; (child_id = fork ()) == NOTOK && i < 5; i++)
 	sleep (5);
     switch (child_id) {
@@ -130,6 +159,7 @@
 	default: 
 	    done (pidXwait (child_id, postproc));
     }
+#endif
 /* NOTREACHED */
 }
 
@@ -185,7 +215,11 @@
                           **savecomp;
     FILE   *out;
 
+#ifdef __EMX__
+    if ((out = fopen (drft, "wb")) == NULL)
+#else
     if ((out = fopen (drft, "w")) == NULL)
+#endif
 	adios (drft, "unable to create");
     
     cp = new_fs (form ? form : rcvdistcomps, NULLCP, NULLCP);
diff -urP ../mh-6.8.4/uip/rcvpack.c ./uip/rcvpack.c
--- ../mh-6.8.4/uip/rcvpack.c	Wed Dec  1 13:01:36 1993
+++ ./uip/rcvpack.c	Sat Mar  2 14:27:18 1996
@@ -41,7 +41,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     mts_init (invo_name);
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
diff -urP ../mh-6.8.4/uip/rcvstore.c ./uip/rcvstore.c
--- ../mh-6.8.4/uip/rcvstore.c	Wed Dec  1 13:01:36 1993
+++ ./uip/rcvstore.c	Sat Mar  2 14:27:20 1996
@@ -13,6 +13,9 @@
 #ifdef LOCALE
 #include	<locale.h>
 #endif
+#ifdef __EMX__
+#include <sys/fcntl.h>
+#endif
 
 /*  */
 
@@ -74,7 +77,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     mts_init (invo_name);
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
@@ -172,6 +180,9 @@
 	    == NOTOK)
 	adios (tmpfilenam, "unable to create");
     (void) chmod (tmpfilenam, m_gmprot ());
+#ifdef __EMX__
+    setmode (fd, O_BINARY);
+#endif
 
     cpydata (fileno (stdin), fd, "standard input", tmpfilenam);
 
diff -urP ../mh-6.8.4/uip/refile.c ./uip/refile.c
--- ../mh-6.8.4/uip/refile.c	Wed Dec  1 13:01:38 1993
+++ ./uip/refile.c	Sat Mar  2 14:27:22 1996
@@ -90,7 +90,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
diff -urP ../mh-6.8.4/uip/repl.c ./uip/repl.c
--- ../mh-6.8.4/uip/repl.c	Sat Mar  2 01:50:18 1996
+++ ./uip/repl.c	Sat Mar  2 14:27:24 1996
@@ -193,7 +193,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
diff -urP ../mh-6.8.4/uip/replsbr.c ./uip/replsbr.c
--- ../mh-6.8.4/uip/replsbr.c	Sat Mar  2 01:50:20 1996
+++ ./uip/replsbr.c	Sat Apr  6 02:32:18 1996
@@ -421,7 +421,11 @@
     mhl = r1bindex (mhlproc, '/');
 
     rewind (in);
+#ifdef __EMX__
+    (void) lseek (fileno(in), (off_t)0, SEEK_SET);
+#else
     (void) lseek (fileno(in), (off_t)0, L_SET);
+#endif
     (void) fflush (out);
 
     switch (pid = vfork ()) {
@@ -433,7 +437,11 @@
 	    (void) dup2 (fileno (out), fileno (stdout));
 	    closefds (3);
 
+#ifdef __EMX__
+	    execlp (libpath (mhlproc), mhl, "-form", filter, "-noclear", NULLCP);
+#else
 	    execlp (mhlproc, mhl, "-form", filter, "-noclear", NULLCP);
+#endif
 	    fprintf (stderr, "unable to exec ");
 	    perror (mhlproc);
 	    _exit (-1);
diff -urP ../mh-6.8.4/uip/rmail.c ./uip/rmail.c
--- ../mh-6.8.4/uip/rmail.c	Wed Dec  1 13:01:38 1993
+++ ./uip/rmail.c	Wed Mar 27 01:41:12 1996
@@ -21,6 +21,9 @@
 #include <stdio.h>
 #include "../zotnet/mts.h"
 #include <signal.h>
+#ifdef __EMX__
+#include <sys/types.h>
+#endif
 #ifdef LOCALE
 #include	<locale.h>
 #endif
@@ -68,7 +71,7 @@
 FILE * pipef;			/* output for "post" or "uux" */
 
 
-int	pipeser ();
+static TYPESIG	pipeser ();
 
 
 off_t    lseek ();
@@ -135,7 +138,7 @@
 	cp = index (linebuf, ' ');
 	fromptr = ++cp;
 	cp = index (cp, ' ');
-	*cp++ = NULL;
+	*cp++ = '\0';
 	(void) strcpy (fromwhom, fromptr);
 	(void) strncpy (date, cp, 24);
 
@@ -143,7 +146,7 @@
 	    if ((cp = index (cp + 1, 'r')) == NULL) {
 		if ((cp = rindex (fromwhom, '!')) != NULL) {
 		    char   *p;
-		    *cp = NULL;
+		    *cp = '\0';
 		    if ((p = rindex (fromwhom, '!')) != NULL)
 			(void) strcpy (origsys, p + 1);
 		    else
@@ -169,7 +172,7 @@
 	(void) strcat (from, "!");
 out: 	;
     }
-    if (fromwhom[0] == NULL)
+    if (fromwhom[0] == '\0')
 	adios (NULLCP, "no from line");
 
 /*  */
@@ -180,9 +183,9 @@
     if ((cp = rindex (usrfrm, '<')) != NULL) {
 	(void) strcpy (usrfrm, ++cp);	/* sigh */
 	if ((cp = rindex (usrfrm, '>')) != NULL)
-	    *cp = NULL;
+	    *cp = '\0';
     }
-    if (usrfrm[0] == NULL)
+    if (usrfrm[0] == '\0')
 	(void) sprintf (usrfrm, "%s!%s%%%s@%s%c",
 		SystemName (), from, UucpChan (), LocalName (), NULL);
 
@@ -193,7 +196,7 @@
     (void) freopen (Msgtmp, "r", msgf);
     (void) freopen (Fromtmp, "r", fromf);
     (void) unlink (Fromtmp);
-    mmdf[0] = NULL;
+    mmdf[0] = '\0';
 
     cpyback = 0;
     for (argv++; --argc > 0;) {
@@ -231,7 +234,7 @@
 
     switch (adrcheck (to)) {
 	case ADDROK: 
-	    if (mmdf[0] == NULL && filter () == NOTOK)
+	    if (mmdf[0] == '\0' && filter () == NOTOK)
 		(void) strcpy (mmdf, Msgtmp);
 	    replyval = xpost (to, mmdf);
 	    break;
@@ -364,7 +367,7 @@
 	cp = entry;
 	while (*cp != '\n' && *cp != ' ' && *cp != '\t')
 	    cp++;
-	*cp = NULL;
+	*cp = '\0';
 	if (uleq (what, entry)) {
 	    (void) fclose (lookf);
 	    return OK;
@@ -448,7 +451,7 @@
 
     (void) strcpy (buffer, to);
     if (cp = index (buffer, '!'))
-	*cp++ = NULL;
+	*cp++ = '\0';
     else {
 	fprintf (stderr, "internal error -- %s has no host\n", to);
 	return NOTOK;
@@ -470,7 +473,7 @@
 /* ARGSUSED */
 #endif	BSD42
 
-static int  pipeser (i)
+static TYPESIG pipeser (i)
 int     i;
 {
 #ifndef	BSD42
@@ -617,7 +620,7 @@
 	    break;
 
 	default: 
-	    mmdf[0] = NULL;
+	    mmdf[0] = '\0';
 	    break;
     }
     (void) close (td);
@@ -635,7 +638,7 @@
 {
     struct adrx *adrxp;
 
-    *to = NULL;
+    *to = '\0';
     if ((adrxp = seekadrx (addr)) == NULL)
 	return;
 
diff -urP ../mh-6.8.4/uip/rmf.c ./uip/rmf.c
--- ../mh-6.8.4/uip/rmf.c	Wed Dec  1 13:01:38 1993
+++ ./uip/rmf.c	Sat Mar  2 14:27:28 1996
@@ -47,7 +47,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
@@ -146,6 +151,9 @@
     register struct direct *dp;
 #endif	/* SYS5DIR */
     register    DIR * dd;
+#ifdef __EMX__
+    char    maildrive;
+#endif
 
 #ifdef	COMPAT
     (void) m_delete (concat (current, "-", m_mailpath (folder), NULLCP));
@@ -156,6 +164,10 @@
 		break;		/* fall otherwise */
 
 	case NOTOK: 
+#ifdef __EMX__
+            if (maildrive =  _fngetdrive (maildir))
+                _chdrive (maildrive);
+#endif
 	    (void) sprintf (cur, "atr-%s-%s", current, m_mailpath (folder));
 	    if (!m_delete (cur)) {
 		printf ("[+%s de-referenced]\n", folder);
diff -urP ../mh-6.8.4/uip/rmm.c ./uip/rmm.c
--- ../mh-6.8.4/uip/rmm.c	Wed Dec  1 13:01:38 1993
+++ ./uip/rmm.c	Sat Mar  2 14:27:30 1996
@@ -44,7 +44,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
diff -urP ../mh-6.8.4/uip/sbboards.c ./uip/sbboards.c
--- ../mh-6.8.4/uip/sbboards.c	Wed Dec  1 13:01:38 1993
+++ ./uip/sbboards.c	Sat Mar  2 14:27:30 1996
@@ -47,7 +47,7 @@
 #include <stdio.h>
 #include "../zotnet/mts.h"
 #include <pwd.h>
-#ifndef	SYS5
+#if !defined(SYS5) && !defined(__EMX__)
 #include <sysexits.h>
 #else	SYS5
 #define	EX_CANTCREAT	1
@@ -66,6 +66,9 @@
 #ifdef LOCALE
 #include	<locale.h>
 #endif
+#ifdef __EMX__
+#include <sys/types.h>
+#endif
 
 
 #define	NBB	100
@@ -363,8 +366,13 @@
 	    buffer[BUFSIZ];
 
     if (bb_fderr == NOTOK) {
+#ifdef __EMX__
+	if ((fd = open ("nul", 0)) == NOTOK)
+	    adios (EX_OSERR, "nul", "unable to open");
+#else
 	if ((fd = open ("/dev/null", 0)) == NOTOK)
 	    adios (EX_OSERR, "/dev/null", "unable to open");
+#endif
 	bb_fderr = copyfile (fd, bb_rept);
     }
 
@@ -478,7 +486,7 @@
     dp = (bp = outbuf) + sizeof outbuf;
     for (state = S1; (i = read (fd, buffer, sizeof buffer)) > 0;)
 	for (ep = (cp = buffer) + i; cp < ep; cp++) {
-	    if (*cp == NULL)
+	    if (*cp == '\0')
 		continue;
 	    switch (state) {
 		case S1: 
@@ -533,7 +541,12 @@
     register struct bboard *bp;
     register struct passwd *pw;
 
+#ifdef __EMX__
+    invo_name = _getname (*vec++);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (*vec++, '/');
+#endif
     m_foil (NULLCP);
     mts_init (invo_name);
 
diff -urP ../mh-6.8.4/uip/scan.c ./uip/scan.c
--- ../mh-6.8.4/uip/scan.c	Sat Mar  2 01:50:20 1996
+++ ./uip/scan.c	Sat Mar  2 14:27:30 1996
@@ -94,7 +94,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     mts_init (invo_name);
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
diff -urP ../mh-6.8.4/uip/scansbr.c ./uip/scansbr.c
--- ../mh-6.8.4/uip/scansbr.c	Sat Mar  2 01:50:22 1996
+++ ./uip/scansbr.c	Tue May 28 23:00:30 1996
@@ -18,6 +18,15 @@
 #define       _cnt    _w              /* Wretch */
 #endif
 
+#ifdef __EMX__
+#ifdef _FILE_MEMBERS_HAVE_UNDERSCORE
+#define       _cnt    _wcount         /* Wretch */
+#else
+#define       _ptr    ptr             /* Gag */
+#define       _cnt    wcount          /* Wretch */
+#endif
+#endif
+
 #define MAXSCANL 256		/* longest possible scan line */
 #define SBUFSIZ 512		/* buffer size for content part of header
 				 * fields.  We want this to be large
@@ -86,6 +95,9 @@
     char    *scnmsg;
     FILE    *scnout;
     char    name[NAMESZ];
+#ifdef __EMX__
+    char    bodytmpbuf[BUFSIZ];
+#endif
     static  int rlwidth,
 	        slwidth;
 
@@ -93,6 +105,9 @@
     if (scanl == NULLCP) {
 	int	bigwid;
 
+#ifdef __EMX__
+	setvbuf (stdout, NULL, _IOLBF, BUFSIZ);
+#endif
 	if (width == 0) {
 	    if ((width = sc_width ()) < WIDTH/2)
 		width = WIDTH/2;
@@ -167,9 +182,16 @@
 		return SCNNUM;
 	}
 	else
+#ifdef  __EMX__
+	    scnmsg = "nul";
+#else
 	    scnmsg = "/dev/null";
+#endif
 	if ((scnout = fopen (scnmsg, "w")) == NULL)
 	    adios (scnmsg, "unable to write");
+#ifdef __EMX__
+	_fsetmode (scnout, "b");
+#endif
 #ifdef	RPATHS
 	if ((cp = unixline ()) && *cp != '\n') {
 	    FPUTS ("Return-Path: ");
@@ -241,6 +263,14 @@
 		 */
 	body: 	;
 		while (state == BODY) {
+#ifdef __EMX__
+		    /* 
+		     * performace hack code crashes under emx/gcc.
+		     * I use the intermediate buffer as usual.
+		     */
+		    state = m_getfld (state, name, bodytmpbuf, rlwidth, inb);
+		    FPUTS (bodytmpbuf);
+#else
 		    if (scnout->_cnt <= 0) {
 			if (fflush(scnout) == EOF)
 			    adios (scnmsg, "write error on");
@@ -249,6 +279,7 @@
 				      -(scnout->_cnt), inb );
 		    scnout->_cnt -= msg_count;
 		    scnout->_ptr += msg_count;
+#endif
 		}
 		goto finished;
 
@@ -342,6 +373,9 @@
 
     if (outnum && fclose (scnout) == EOF)
 	adios (scnmsg, "write error on");
+#ifdef __EMX__
+    if (outnum) utime(".", NULL);
+#endif
 
     return (state != FILEEOF ? SCNERR : encrypted ? SCNENC : SCNMSG);
 }
diff -urP ../mh-6.8.4/uip/send.c ./uip/send.c
--- ../mh-6.8.4/uip/send.c	Sat Mar  2 01:50:22 1996
+++ ./uip/send.c	Sat Mar  2 14:27:32 1996
@@ -191,7 +191,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
@@ -482,7 +487,11 @@
 	push ();
 
     status = 0;
+#ifdef __EMX__
+    vec[0] = _getname (postproc);
+#else
     vec[0] = r1bindex (postproc, '/');
+#endif
     closefds (3);
 
     for (msgnum = 0; msgnum < msgp; msgnum++)
diff -urP ../mh-6.8.4/uip/sendsbr.c ./uip/sendsbr.c
--- ../mh-6.8.4/uip/sendsbr.c	Wed Dec  1 13:01:38 1993
+++ ./uip/sendsbr.c	Sat Mar  2 14:27:36 1996
@@ -9,6 +9,9 @@
 #include <signal.h>
 #include <sys/types.h>
 #include <sys/stat.h>
+#ifdef __EMX__
+#include <process.h>
+#endif /* __EMX__ */
 
 static		alert(), anno(), annoaux();
 static int	tmp_fd();
@@ -324,6 +327,42 @@
 	done (1);
     vec[vecp] = NULL;
 
+#ifdef __EMX__
+    (void) dup2 (fd, fileno (stdout));
+    (void) dup2 (fd, fileno (stderr));
+    (void) close (fd);
+
+    if (-1 == (status = spawnvp (P_WAIT, libpath (postproc),
+                                  (char * __const__ *)vec))) {
+      fprintf (stderr, "unable to exec ");
+      perror (fileproc);
+      _exit (-1);
+    }
+
+    if (status == 0) {
+	if (annotext && fd2 != NOTOK)
+	    anno (fd2, st);
+	if (splitsw < 0
+	        && rename (drft, strcpy (buf, m_backup (drft)))
+			== NOTOK)
+	    advise (buf, "unable to rename %s to", drft);
+    }
+    else {
+	if (fd != NOTOK) {
+	    alert (drft, fd);
+	    (void) close (fd);
+	}
+	else
+	    advise (NULLCP, "message not delivered to anyone");
+	if (annotext && fd2 != NOTOK)
+	    (void) close (fd2);
+	if (distfile) {
+	    (void) unlink (drft);
+	    if (rename (backup, drft) == NOTOK)
+		advise (drft, "unable to rename %s to", backup);
+	}
+    }
+#else  /* __EMX__ */
     for (i = 0; (child_id = vfork ()) == NOTOK && i < 5; i++)
 	sleep (5);
     switch (child_id) {
@@ -367,6 +406,7 @@
 	    }
 	    break;
     }
+#endif /* __EMX__ */
 
     return status;
 }
@@ -415,8 +455,13 @@
 	    (void) sprintf (buf, "send failed on %s",
 			forwsw ? "enclosed draft" : file);
 
+#ifdef __EMX__
+	    execlp (exepath (mailproc), getcpy (mailproc), getusr (),
+		    "-subject", buf, NULLCP);
+#else
 	    execlp (mailproc, r1bindex (mailproc, '/'), getusr (),
 		    "-subject", buf, NULLCP);
+#endif
 	    fprintf (stderr, "unable to exec ");
 	    perror (mailproc);
 	    _exit (-1);
@@ -439,6 +484,9 @@
 
     if ((fd = open (tmpfil, 2)) == NOTOK)
 	return NOTOK;
+#ifdef __EMX__
+    close (fd);
+#endif /* __EMX__ */
     if (debugsw)
 	advise (NULLCP, "temporary file %s selected", tmpfil);
     else
@@ -547,7 +595,11 @@
     }
     if (!debugsw			/* MOBY HACK... */
 	    && pushsw
+#ifdef __EMX__
+	    && (fd3 = open ("nul", 2)) != NOTOK
+#else
 	    && (fd3 = open ("/dev/null", 2)) != NOTOK
+#endif
 	    && (fd2 = dup (fileno (stderr))) != NOTOK) {
 	(void) dup2 (fd3, fileno (stderr));
 	(void) close (fd3);
diff -urP ../mh-6.8.4/uip/show.c ./uip/show.c
--- ../mh-6.8.4/uip/show.c	Sat Mar  2 01:50:22 1996
+++ ./uip/show.c	Thu Apr  4 01:34:50 1996
@@ -87,7 +87,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if (uleq (invo_name, "next"))
 	mode = NEXT;
     else
@@ -256,7 +261,11 @@
 #ifdef	MIME
     if (!nshow && !getenv ("NOMHNPROC")) {
 	if (!(cp = m_find ("mhnproc")))
+#ifdef __EMX__
+	    cp = getcpy (exepath ("mhn.exe"));
+#else
 	    cp = "mhn";
+#endif
 
 	if (draftsw || file) {
 	    if (nontext (vec[vecp - 1])) {
@@ -279,11 +288,21 @@
     }
 #endif	/* MIME */
     if (nshow)
+#ifdef __EMX__
+	proc = "cat.exe";
+#else
 	proc = "/bin/cat";
+#endif
     else {
 	if (folder && !draftsw && !file)
 	    (void) m_putenv ("mhfolder", folder);
+#ifdef __EMX__
+        cp = getcpy (_getname (showproc));
+        _remext (cp);
+	if (strcmp (cp, "mhl") == 0) {
+#else
 	if (strcmp (r1bindex (showproc, '/'), "mhl") == 0) {
+#endif
 	    vec[0] = "mhl";
 	    (void) mhl (vecp, vec);
 	    done (0);
@@ -304,7 +323,11 @@
     }
 
 finish:;
+#ifdef __EMX__
+    vec[0] = exepath (_getname (proc));
+#else   /* __EMX__ */
     vec[0] = r1bindex (proc, '/');
+#endif  /* __EMX__ */
     execvp (proc, vec);
     adios (proc, "unable to exec");
 }
@@ -403,8 +426,8 @@
 		    }
 		    for (dp = bp; istoken (*dp); dp++)
 			continue;
-		    c = *dp, *dp = NULL;
-		    if (*bp == NULL)
+		    c = *dp, *dp = (char)NULL;
+		    if (*bp == (char)NULL)
 			goto invalid;
 		    if (passno > 1) {
 			if (result = !uleq (bp, "plain"))
@@ -423,12 +446,12 @@
 			    dp++;
 			if (*dp == '"') {
 			    if (bp = index (++dp, '"'))
-				*bp = NULL;
+				*bp = (char)NULL;
 			}
 			else
 			    for (bp = dp; *bp; bp++)
 				if (isspace (*bp)) {
-				    *bp = NULL;
+				    *bp = (char)NULL;
 				    break;
 				}
 			if ((result = !uleq (dp, chset))
@@ -462,7 +485,7 @@
 			continue;
 		    for (dp = bp; istoken (*dp); dp++)
 			continue;
-		    *dp = NULL;
+		    *dp = (char)NULL;
 		    result = !uleq (bp, "7bit")
 				&& !uleq (bp, "8bit")
 				&& !uleq (bp, "binary");
diff -urP ../mh-6.8.4/uip/slocal.c ./uip/slocal.c
--- ../mh-6.8.4/uip/slocal.c	Sat Mar  2 01:50:24 1996
+++ ./uip/slocal.c	Sat Sep 21 23:51:58 1996
@@ -36,7 +36,11 @@
 #endif	/* NOIOCTLH */
 #endif	/* not V7 */
 #include <sys/stat.h>
+#ifdef __EMX__
+#include <sys/fcntl.h>
+#else
 #include <utmp.h>
+#endif
 #ifdef LOCALE
 #include	<locale.h>
 #endif
@@ -213,7 +217,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (*argv, '/');
+#endif
     m_foil (NULLCP);
     mts_init (invo_name);
 
@@ -434,7 +443,11 @@
 	return NOTOK;
     if (fstat (fileno (fp), &st) == NOTOK
 	    || (st.st_uid != 0 && (su || st.st_uid != pw -> pw_uid))
+#ifdef __EMX__
+	    ) {
+#else
 	    || st.st_mode & 0022) {
+#endif
 	if (verbose) {
 	    printf ("%s: ownership/modes bad (%d, %d,%d,0%o)\n",
 		    delivery, su, pw -> pw_uid, st.st_uid, st.st_mode);
@@ -535,12 +548,24 @@
 		if (!uleq (action, "pipe"))
 		    continue;	/* else fall */
 	    case '|': 
+#ifdef __EMX__
+		vec[2] = cp = _getname (getenv ("COMSPEC"));
+		if (!stricmp (cp, "CMD.EXE") || !stricmp (cp, "4OS2.EXE"))
+		  vec[3] = "/c";
+		else
+		  vec[3] = "-c";
+#else
 		vec[2] = "sh";
 		vec[3] = "-c";
+#endif
 		expand (tmpbuf, string, fd);
 		vec[4] = tmpbuf;
 		vec[5] = NULL;
+#ifdef __EMX__
+		status = usr_pipe (fd, tmpbuf, getenv ("COMSPEC"), vec + 2);
+#else
 		status = usr_pipe (fd, tmpbuf, "/bin/sh", vec + 2);
+#endif
 		break;
 
 	    case 'f': 
@@ -564,13 +589,25 @@
 		if (!uleq (action, "destroy"))
 		    continue;
 		status = OK;
+#ifdef REALLY_DESTROY
+		if (verbose)
+		    printf ("\tdestroying message\n");
+		if (accept)
+		    won++;
+		goto finish;
+#endif /* REALLY_DESTROY */
 		break;
 	}
 
-	if (accept && status == OK)
-	    won++;
+	if (status == OK) {		/* next is already 1. */
+	    if (accept)
+		won++;
+	} else {			/* overload the next variable */
+	    next = 0;			/* to indicate that action failed */
+	}
     }
 
+  finish:
     (void) fclose (fp);
     return (won ? OK : NOTOK);
 }
@@ -812,6 +849,7 @@
 /*  */
 
 static int  logged_in () {
+#ifndef __EMX__
     struct utmp ut;
     register FILE  *uf;
 
@@ -831,6 +869,7 @@
 	}
 
     (void) fclose (uf);
+#endif
     return (utmped = NOTOK);
 }
 
@@ -998,8 +1037,13 @@
 	case OK: 
 	    if (fd != 0)
 		(void) dup2 (fd, 0);
+#ifdef __EMX__
+	    (void) freopen ("nul", "w", stdout);
+	    (void) freopen ("nul", "w", stderr);
+#else
 	    (void) freopen ("/dev/null", "w", stdout);
 	    (void) freopen ("/dev/null", "w", stderr);
+#endif
 	    if (fd != 3)
 		(void) dup2 (fd, 3);
 	    closefds (4);
@@ -1136,6 +1180,9 @@
     (void) close (fd1);
     if ((fd1 = open (tmpfil, 2)) == NOTOK)
 	return NOTOK;
+#ifdef __EMX__
+    setmode (fd1, O_BINARY);
+#endif
 
     if (!fold) {
 	while ((i = read (qd, buffer, sizeof buffer)) > 0)
@@ -1299,7 +1346,11 @@
 		free (cp);
 		cp = key.dptr;
 
+#ifdef __EMX__
+		if ((db = dbm_open (file, O_RDWR | O_CREAT | O_BINARY, 0600)) == NULL) {
+#else
 		if ((db = dbm_open (file, O_RDWR | O_CREAT, 0600)) == NULL) {
+#endif
 		    advise (file, "unable to perform dbm_open on");
 out: ;
 		    free (cp);
diff -urP ../mh-6.8.4/uip/sortm.c ./uip/sortm.c
--- ../mh-6.8.4/uip/sortm.c	Sat Mar  2 01:50:26 1996
+++ ./uip/sortm.c	Sat Mar  2 14:27:44 1996
@@ -95,7 +95,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
diff -urP ../mh-6.8.4/uip/spost.c ./uip/spost.c
--- ../mh-6.8.4/uip/spost.c	Wed Dec  1 13:01:38 1993
+++ ./uip/spost.c	Sat Mar  2 14:27:46 1996
@@ -188,7 +188,11 @@
     normal, resent
 } msgstate = normal;
 
+#ifdef __EMX__
+static char tmpfil[BUFSIZ];
+#else
 static char tmpfil[] = "/tmp/pstXXXXXX";
+#endif
 
 static char from[BUFSIZ];	/* my network address */
 static char signature[BUFSIZ];	/* my signature */
@@ -227,7 +231,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     mts_init (invo_name);
     if ((cp = m_find (invo_name)) != NULL) {
 	argp = copyip (brkstring (cp, " ", "\n"), arguments);
@@ -357,7 +366,11 @@
 	out = stdout;
     }
     else {
+#ifdef __EMX__
+	    (void)strcpy (tmpfil, m_tmpfil ("pst"));
+#else
 	    (void)mktemp (tmpfil);
+#endif
 	    if ((out = fopen (tmpfil, "w")) == NULL)
 		adios (tmpfil, "unable to create");
 	    (void)chmod (tmpfil, 0600);
diff -urP ../mh-6.8.4/uip/trmsbr.c ./uip/trmsbr.c
--- ../mh-6.8.4/uip/trmsbr.c	Wed Dec  1 13:01:38 1993
+++ ./uip/trmsbr.c	Sat Mar  2 14:27:48 1996
@@ -5,7 +5,7 @@
 
 #include "../h/mh.h"
 #include <stdio.h>
-#ifndef	SYS5
+#if	!defined(SYS5) & !defined(__EMX__)
 #include <sgtty.h>
 #if	defined(ULTRIX) && !defined(BSD43)
 #undef	TIOCGWINSZ
@@ -18,6 +18,9 @@
 #endif	/* NOIOCTLH */
 #undef	TIOCGWINSZ
 #endif	/* SYS5 */
+#ifdef	__EMX__
+#include <termcap.h>
+#endif	/* __EMX__ */
 
 
 #if	BUFSIZ<2048
@@ -26,7 +29,7 @@
 #define	TXTSIZ	BUFSIZ
 #endif
 
-#ifndef	SYS5
+#if	!defined(SYS5) & !defined(__EMX__)
 extern char PC;
 extern short    ospeed;
 #else	/*   SYS5 */
@@ -58,7 +61,7 @@
                    *term;
     char   *cp,
 	    myterm[TXTSIZ];
-#ifndef	SYS5
+#if	!defined(SYS5) & !defined(__EMX__)
     struct sgttyb   sg;
 #else	/* SYS5 */
     struct termio   sg;
@@ -71,7 +74,7 @@
     if ((term = getenv ("TERM")) == NULL || tgetent (myterm, term) <= OK)
 	return;
 
-#ifndef	SYS5
+#if	!defined(SYS5) & !defined(__EMX__)
     ospeed = ioctl (fileno (stdout), TIOCGETP, (char *) &sg) != NOTOK
 		? sg.sg_ospeed : 0;
 #else	/* SYS5 */
diff -urP ../mh-6.8.4/uip/umhook.c ./uip/umhook.c
--- ../mh-6.8.4/uip/umhook.c	Wed Dec  1 13:01:38 1993
+++ ./uip/umhook.c	Thu Apr 18 03:33:50 1996
@@ -40,7 +40,7 @@
 #define	HELPSW	1
     "help", 4,
 
-    NULL, NULL
+    NULL, 0
 };
 
 /*  */
@@ -49,7 +49,9 @@
 
 static int  uucp = NOTOK;
 
+#ifndef __EMX__
 extern char *environ;
+#endif
 
 static char myhome[BUFSIZ] = "";
 static char mymail[BUFSIZ] = "";
@@ -57,7 +59,10 @@
 static char mystat[BUFSIZ] = "";
 static char myuser[BUFSIZ] = "";
 
-int	sigser ();
+static  TYPESIG sigser ();
+static  int hook ();
+static  umhook (), process (), seeksndr (), seekaddr ();
+static  st_init(), st_update();
 
 off_t    lseek ();
 #ifdef	SYS5
@@ -84,7 +89,15 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef JAPAN
+	ml_init();
+#endif /* JAPAN */
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     mts_init (invo_name);
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
@@ -152,7 +165,11 @@
     (void) strcpy (myhome, pw -> pw_dir);
     (void) sprintf (mystat, ".%s_%d", invo_name, pw -> pw_uid);
 
+#ifdef  __EMX__
+    if (access (libpath (slocalproc), 1) == NOTOK)
+#else
     if (access (slocalproc, 1) == NOTOK)
+#endif
 	adios (slocalproc, "unable to execute");
 
     closefds (fileno (stderr) + 1);
@@ -308,6 +325,9 @@
 
     if ((out = fdopen (fd1, "w")) == NULL)
 	adios (NULLCP, "no free file pointers");
+#ifdef  __EMX__
+    _fsetmode (out, "b");
+#endif
 
     for (done = TRUE;;) {
 	if (fgets (buffer, sizeof buffer, in) == NULL)
@@ -332,8 +352,13 @@
 	    (void) lseek (fd2, (off_t)0, 0);
 	    if (fd2 != 0)
 		(void) dup2 (fd2, 0);
+#ifdef  __EMX__
+	    (void) freopen ("nul", "w", stdout);
+	    (void) freopen ("nul", "w", stderr);
+#else
 	    (void) freopen ("/dev/null", "w", stdout);
 	    (void) freopen ("/dev/null", "w", stderr);
+#endif
 	    if (fd2 != 3)
 		(void) dup2 (fd2, 3);
 	    closefds (4);
@@ -347,7 +372,11 @@
 	    (void) setpgrp (0, getpid ());
 #endif	BSD42
 
+#ifdef  __EMX__
+	    execlp (libpath (slocalproc), slocalproc,
+#else
 	    execlp (slocalproc, r1bindex (slocalproc, '/'),
+#endif
 		    "-file", myfile, "-mailbox", mymail,
 		    "-home", myhome, "-addr", myaddr,
 		    "-user", myuser, "-sender", mysndr, NULLCP);
@@ -378,9 +407,9 @@
     if ((in = fdopen (fd2, "r")) == NULL)
 	adios (NULLCP, "no free file pointers");
 
-    for (from[0] = sender[0] = NULL; mfgets (in, &hp) != DONE;)
+    for (from[0] = sender[0] = '\0'; mfgets (in, &hp) != DONE;)
 	if ((bp = index (hp, ':')) != NULL) {
-	    *bp++ = NULL;
+	    *bp++ = '\0';
 	    if (lequal (hp, "From"))
 		seekaddr (from, bp);
 	    else
@@ -452,7 +481,7 @@
 /* ARGSUSED */
 #endif	BSD42
 
-static int  sigser (sig)
+static TYPESIG sigser (sig)
 int     sig;
 {
 #ifndef	BSD42
diff -urP ../mh-6.8.4/uip/vmh.c ./uip/vmh.c
--- ../mh-6.8.4/uip/vmh.c	Wed Dec  1 13:01:38 1993
+++ ./uip/vmh.c	Sat Mar  2 14:27:50 1996
@@ -143,7 +143,7 @@
 static int  tty_ready = NOTOK;
 
 static int  intrc;
-#ifndef	SYS5
+#if !defined(SYS5) && !defined(__EMX__)
 #define	ERASE	sg.sg_erase
 #define	KILL	sg.sg_kill
 static struct sgttyb    sg;
@@ -172,7 +172,7 @@
 #endif	/* TIOCGLTC */
 
 
-#if !defined(SYS5) && !defined(BSD44)
+#if !defined(SYS5) && !defined(BSD44) && !defined(__EMX__)
 int	_putchar ();
 #endif	/* not SYS5 */
 #ifdef	SIGTSTP
@@ -188,11 +188,13 @@
 
 
 					/* MISCELLANY */
+#ifndef __EMX__
 extern int  errno;
 #ifndef	BSD44
 extern int  sys_nerr;
 extern char *sys_errlist[];
 #endif
+#endif
 
 static void	adorn ();
 
@@ -220,7 +222,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
@@ -265,6 +272,9 @@
 
 /*  */
 
+#ifdef __EMX__
+    vmhproc = exepath (vmhproc);
+#endif
     if (TTYinit (nprog) == NOTOK || WINinit (nprog) == NOTOK) {
 	vec[vecp] = NULL;
 
@@ -1237,7 +1247,7 @@
 	    adios (NULLCP, "not a tty");
 
     foreground ();
-#ifndef	SYS5
+#if !defined(SYS5) && !defined(__EMX__)
     if (ioctl (fileno (stdin), TIOCGETP, (char *) &sg) == NOTOK)
 	adios ("failed", "ioctl TIOCGETP");
     if (ioctl (fileno (stdin), TIOCGETC, (char *) &tc) == NOTOK)
@@ -1272,7 +1282,7 @@
 	return;
 
     INTR = NOTOK;
-#ifndef	SYS5
+#if !defined(SYS5) && !defined(__EMX__)
     (void) ioctl (fileno (stdin), TIOCSETC, (char *) &tc);
 #else	/* SYS5 */
     (void) ioctl (fileno (stdin), TCSETA, &sg);
@@ -1302,7 +1312,7 @@
 	return;
 
     INTR = intrc;
-#ifndef	SYS5
+#if !defined(SYS5) && !defined(__EMX__)
     (void) ioctl (fileno (stdin), TIOCSETC, (char *) &tc);
 #else	/* SYS5 */
     (void) ioctl (fileno (stdin), TCSETA, &sg);
@@ -1516,7 +1526,11 @@
 	    iov++;
 	}
 	if (eindex > 0 && eindex < sys_nerr)
+#ifdef __EMX__
+	    iov -> iov_len = strlen (iov -> iov_base = (char *)(sys_errlist[eindex]));
+#else
 	    iov -> iov_len = strlen (iov -> iov_base = sys_errlist[eindex]);
+#endif
 	else {
 	    (void) sprintf (err, "Error %d", eindex);
 	    iov -> iov_len = strlen (iov -> iov_base = err);
@@ -1540,7 +1554,7 @@
 
 /*  */
 
-#ifndef	BSD42
+#if !defined(BSD42) && !defined(__EMX__)
 static int     writev (fd, iov, n)
 register int     fd;
 register struct iovec   *iov;
diff -urP ../mh-6.8.4/uip/vmhsbr.c ./uip/vmhsbr.c
--- ../mh-6.8.4/uip/vmhsbr.c	Wed Dec  1 13:01:38 1993
+++ ./uip/vmhsbr.c	Sat Mar  2 14:27:52 1996
@@ -10,6 +10,11 @@
 #include "../h/mh.h"
 #include "../h/vmhsbr.h"
 #include <stdio.h>
+#ifdef __EMX__
+#include <errno.h>
+#include <io.h>
+#include <fcntl.h>
+#endif
 
 /*  */
 
@@ -25,11 +30,13 @@
 static	int PEERwfd = NOTOK;
 
 
+#ifndef __EMX__
 extern int  errno;
 #ifndef	BSD44
 extern int  sys_nerr;
 extern char *sys_errlist[];
 #endif
+#endif
 
 static int	rclose();
 /*  */
@@ -41,6 +48,10 @@
     char   *cp,
             buffer[BUFSIZ];
 
+#ifdef __EMX__
+    (void) setmode (rfd, O_BINARY);
+    (void) setmode (wfd, O_BINARY);
+#endif
     PEERrfd = rfd;
     PEERwfd = wfd;
 
diff -urP ../mh-6.8.4/uip/whatnowproc.c ./uip/whatnowproc.c
--- ../mh-6.8.4/uip/whatnowproc.c	Wed Dec  1 13:01:38 1993
+++ ./uip/whatnowproc.c	Sat Mar  2 14:27:54 1996
@@ -5,6 +5,9 @@
 
 #include "../h/mh.h"
 #include <stdio.h>
+#ifdef __EMX__
+#include <stdlib.h>
+#endif /* __EMX__ */
 
 what_now (ed, nedit, use, file, altmsg, dist, mp, text, inplace, cwd)
 struct msgs *mp;
@@ -27,7 +30,11 @@
            *vec[MAXARGS];
 
     vecp = 0;
+#ifdef __EMX__
+    vec[vecp++] = _getname (whatnowproc);
+#else  /* __EMX__ */
     vec[vecp++] = r1bindex (whatnowproc, '/');
+#endif /* __EMX__ */
     vec[vecp] = NULL;
 
     (void) m_putenv ("mhdraft", file);
@@ -90,12 +97,20 @@
     if (cwd)
 	(void) chdir (cwd);
 
+#ifdef __EMX__
+    if (strcmp (vec[0], "whatnow.exe") == 0) {
+#else  /* __EMX__ */
     if (strcmp (vec[0], "whatnow") == 0) {
+#endif /* __EMX__ */
 	WhatNow (vecp, vec);
 	done (0);
     }
 
+#ifdef __EMX__
+    execvp (exepath (whatnowproc), vec);
+#else  /* __EMX__ */
     execvp (whatnowproc, vec);
+#endif /* __EMX__ */
     fprintf (stderr, "unable to exec ");
     perror (whatnowproc);
 
diff -urP ../mh-6.8.4/uip/whatnowsbr.c ./uip/whatnowsbr.c
--- ../mh-6.8.4/uip/whatnowsbr.c	Sat Mar  2 01:50:26 1996
+++ ./uip/whatnowsbr.c	Sat Mar  2 14:27:58 1996
@@ -8,6 +8,10 @@
 #include <signal.h>
 #include <sys/types.h>
 #include <sys/stat.h>
+#ifdef __EMX__
+#include <stdlib.h>
+#include <process.h>
+#endif
 
 #ifndef	MIME
 #define	MIMEminc(a)	(a)
@@ -94,7 +98,12 @@
            *arguments[MAXARGS];
     struct stat st;
 
+#ifdef __EMX__
+    invo_name = getcpy (_getname (argv[0]));
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
@@ -275,15 +284,23 @@
     else
 	if (!*ed) {		/* no explicit editor */
 	    *ed = edsave;
+#ifdef __EMX__
+	    cp = _getname (*ed);
+#else  /* __EMX__ */
 	    if ((cp = r1bindex (*ed, '/')) == NULL)
 		cp = *ed;
+#endif /* __EMX__ */
 	    cp = concat (cp, "-next", NULLCP);
 	    if ((cp = m_find (cp)) != NULL)
 		*ed = cp;
 	}
 
     if (altmsg) {
+#ifdef __EMX__
+	if (mp == NULL || _fnisabs (altmsg) || cwd == NULL)
+#else  /* __EMX__ */
 	if (mp == NULL || *altmsg == '/' || cwd == NULL)
+#endif /* __EMX__ */
 	    (void) strcpy (altpath, altmsg);
 	else
 	    (void) sprintf (altpath, "%s/%s", mp -> foldpath, altmsg);
@@ -316,6 +333,56 @@
     m_update ();
     (void) fflush (stdout);
 
+#ifdef __EMX__
+    if (cwd)
+	(void) chdir (cwd);
+    if (altmsg) {
+	if (mp)
+	    (void) m_putenv ("mhfolder", mp -> foldpath);
+	(void) m_putenv ("editalt", altpath);
+    }
+
+    vecp = 0;
+    vec[vecp++] = "cmd.exe";
+    vec[vecp++] = "/c";
+    vec[vecp++] = exepath (_getname (*ed));
+    if (arg)
+	while (*arg)
+	    vec[vecp++] = *arg++;
+    vec[vecp++] = file;
+    vec[vecp] = NULL;
+
+    if (-1 == (status = spawnvp (P_WAIT, "cmd.exe", (char * __const__ *) vec))) {
+        fprintf (stderr, "unable to exec ");
+        perror (*ed);
+        _exit (-1);
+    }
+
+    if (status) {
+	if (((status & 0xff00) != 0xff00)
+		&& (!reedit || (status & 0x00ff)))
+	    if (!use && (status & 0xff00) &&
+		    (rename (file, cp = m_backup (file)) != NOTOK)) {
+		advise (NULLCP, "problems with edit--draft left in %s",
+			cp);
+	    }
+	    else
+		advise (NULLCP, "problems with edit--%s preserved",
+			file);
+	status = -2;	/* maybe "reedit ? -2 : -1"? */
+    }
+    else {
+        reedit++;
+        if (altmsg
+    	    && mp
+    	    && (!mp -> msgflags & READONLY)
+    	    && stat (linkpath, &st) != NOTOK
+    	    && st.st_nlink == 1
+    	    && (unlink (altpath) == NOTOK
+    		|| link (linkpath, altpath) == NOTOK))
+    	advise (linkpath, "unable to update %s from", altmsg);
+    }
+#else
     switch (pid = vfork ()) {
 	case NOTOK: 
 	    advise ("fork", "unable to");
@@ -395,6 +462,7 @@
 		advise (linkpath, "unable to update %s from", altmsg);
 #endif	/* not BSD42 */
     }
+#endif  /* __EMX__ */
 
     edsave = getcpy (*ed);
     *ed = NULL;
@@ -454,6 +522,9 @@
     char *cp,
 	 *sp,
 	 *vec[MAXARGS];
+#ifdef __EMX__
+    int  status;
+#endif
 
 #ifdef	MIME
     if ((cp = m_find ("automhnproc"))
@@ -464,7 +535,13 @@
 	return 0;
 #endif
 
+#ifdef __EMX__
+    sp = getcpy (_getname (sendproc));
+    _remext (sp);
+    if (strcmp (sp, "send") == 0) {
+#else  /* __EMX__ */
     if (strcmp (sp = r1bindex (sendproc, '/'), "send") == 0) {
+#endif /* __EMX__ */
 	cp = invo_name;
 	sendit (invo_name = sp, arg, file, pushsw);
 	invo_name = cp;
@@ -474,6 +551,26 @@
     m_update ();
     (void) fflush (stdout);
 
+#ifdef __EMX__
+    vecp = 0;
+    vec[vecp++] = invo_name;
+    if (pushsw)
+        vec[vecp++] = "-push";
+    if (arg)
+        while (*arg)
+    vec[vecp++] = *arg++;
+    vec[vecp++] = file;
+    vec[vecp] = NULL;
+
+    if (-1 == (status = spawnvp (P_WAIT, sendproc, (char * __const__ *) vec))) {
+        fprintf (stderr, "unable to exec ");
+        perror (sendproc);
+        _exit (-1);
+    }
+    if (status == 0)
+	done (0);
+    return 1;
+#else
     for (i = 0; (child_id = vfork ()) == NOTOK && i < 5; i++)
 	sleep (5);
     switch (child_id) {
@@ -500,6 +597,7 @@
 		done (0);
 	    return 1;
     }
+#endif
 }
 
 /*  */
@@ -881,7 +979,11 @@
     if (pushsw = pushed)
 	push ();
 
+#ifdef __EMX__
+    vec[0] = postproc;
+#else  /* __EMX__ */
     vec[0] = r1bindex (postproc, '/');
+#endif /* __EMX__ */
     closefds (3);
 
     if (sendsbr (vec, vecp, file, &st) == OK)
@@ -897,10 +999,30 @@
     int     pid;
     register int    vecp;
     char   *vec[MAXARGS];
+#ifdef __EMX__
+    int    status;
+    char   *wp;
+#endif
 
     m_update ();
     (void) fflush (stdout);
 
+#ifdef __EMX__
+    vecp = 0;
+    vec[vecp++] = whomproc;
+    vec[vecp++] = file;
+    if (arg)
+	while (*arg)
+	    vec[vecp++] = *arg++;
+    vec[vecp] = NULL;
+
+    if (-1 == (status = spawnvp (P_WAIT, exepath (whomproc), (char * __const__ *) vec))) {
+        fprintf (stderr, "unable to exec ");
+        perror (whomproc);
+        _exit (-1);		/* NOTREACHED */
+    }
+    return (status & 0377 ? 1 : 0);
+#else
     switch (pid = vfork ()) {
 	case NOTOK: 
 	    advise ("fork", "unable to");
@@ -923,4 +1045,5 @@
 	default: 
 	    return (pidwait (pid, NOTOK) & 0377 ? 1 : 0);
     }
+#endif
 }
diff -urP ../mh-6.8.4/uip/whom.c ./uip/whom.c
--- ../mh-6.8.4/uip/whom.c	Wed Dec  1 13:01:38 1993
+++ ./uip/whom.c	Sat Mar  2 14:28:00 1996
@@ -72,7 +72,12 @@
 #ifdef LOCALE
 	setlocale(LC_ALL, "");
 #endif
+#ifdef __EMX__
+    invo_name = _getname (argv[0]);
+    _remext (invo_name);
+#else
     invo_name = r1bindex (argv[0], '/');
+#endif
     if ((cp = m_find (invo_name)) != NULL) {
 	ap = brkstring (cp = getcpy (cp), " ", "\n");
 	ap = copyip (ap, arguments);
@@ -184,7 +189,11 @@
 	case NOTOK:
     	    advise (NULLCP, "unable to fork, so checking directly...");
 	case OK:
+#ifdef __EMX__
+	    execvp (libpath (postproc), vec);
+#else
 	    execvp (postproc, vec);
+#endif
 	    fprintf (stderr, "unable to exec ");
 	    perror (postproc);
 	    _exit (-1);
diff -urP ../mh-6.8.4/zotnet/bboards/getbbent.c ./zotnet/bboards/getbbent.c
--- ../mh-6.8.4/zotnet/bboards/getbbent.c	Wed Dec  1 13:01:40 1993
+++ ./zotnet/bboards/getbbent.c	Sat Mar  2 14:28:00 1996
@@ -19,6 +19,9 @@
 #include <grp.h>
 #include <stdio.h>
 #include <sys/stat.h>
+#ifdef __EMX__
+#include <unistd.h>
+#endif
 
 
 #ifndef	MMDFONLY
@@ -538,7 +541,11 @@
 	return 1;
 
     if (strcmp (b -> bb_passwd,
+#ifdef __EMX__
+		getpass ("Password: ")) == 0)
+#else
 		crypt (getpass ("Password: "), b -> bb_passwd)) == 0)
+#endif
 	return 1;
 
     fprintf (stderr, "Sorry\n");
diff -urP ../mh-6.8.4/zotnet/mf/mmuu.c ./zotnet/mf/mmuu.c
--- ../mh-6.8.4/zotnet/mf/mmuu.c	Wed Dec  1 13:01:42 1993
+++ ./zotnet/mf/mmuu.c	Wed May  1 15:30:22 1996
@@ -1,5 +1,10 @@
 /* mmuu.c - routines to filter MMDF to UUCP mailboxes */
 
+#ifdef __EMX__
+#include <../h/mh.h>
+#include <io.h>
+#include <fcntl.h>
+#endif
 #include "mf.h"
 #include "../tws/tws.h"
 #include <stdio.h>
@@ -37,6 +42,12 @@
 
 long    time ();
 char   *ctime ();
+static  int mmuu (), mmdf_file (), mmdf_headers (), mmdf_text ();
+static  int do_header (), mmdf_die ();
+static  addr_convert (), date_convert ();
+#ifdef __EMX__
+static  char *crt_tmpfil ();
+#endif
 
 /*  */
 
@@ -64,6 +75,9 @@
     if ((in = fdopen (infd, "r")) == NULL
 	    || (out = fdopen (outfd, "w")) == NULL)
 	return MFSIO;
+#ifdef __EMX__
+    _fsetmode (out, "b");
+#endif
 
     result = mmuu (in, out, nodelim);
 
@@ -78,6 +92,10 @@
     dup2 (fd, outfd);
     close (fd);
 
+#ifdef __EMX__
+    setmode (outfd, O_BINARY);
+#endif
+
     return result;
 }
 
@@ -140,8 +158,12 @@
     if (!isdlm1 (tmpbuf))
 	return MFDLM;
 
+#ifdef __EMX__
+    strcpy (tmpfil, crt_tmpfil ("mmuu"));
+#else
     strcpy (tmpfil, "/tmp/mmuuXXXXXX");
     unlink (mktemp (tmpfil));
+#endif
     if ((fd = creat (tmpfil, TMPMODE)) == NOTOK)
 	return MFERR;
     close (fd);
@@ -152,6 +174,9 @@
 	close (fd);
 	return MFERR;
     }
+#ifdef __EMX__
+    _fsetmode (out, "b");
+#endif
     unlink (tmpfil);
 
     if ((*tmp_fd = dup (fd)) == NOTOK) {
@@ -196,10 +221,14 @@
             tmpfil[LINESIZ];
     FILE * tmp;
 
-    *from = *date = NULL;
+    *from = *date = '\0';
 
+#ifdef __EMX__
+    strcpy (tmpfil, crt_tmpfil ("mmuu"));
+#else
     strcpy (tmpfil, "/tmp/mmuuXXXXXX");
     unlink (mktemp (tmpfil));
+#endif
     if ((fd = creat (tmpfil, TMPMODE)) == NOTOK)
 	return MFERR;
     close (fd);
@@ -216,6 +245,9 @@
 	close (fd);
 	return MFERR;
     }
+#ifdef __EMX__
+    _fsetmode (tmp, "b");
+#endif
 
     for (;;) {
 	switch (do_header (from, date, in, tmp)) {
@@ -236,7 +268,7 @@
 
 /*  */
 
-    if (*date == NULL || *from == NULL) {
+    if (*date == '\0' || *from == '\0') {
 	if (*date)
 	    strcpy (buffer, "No (valid) From: field found in message\n");
 	else
@@ -246,23 +278,23 @@
 		strcpy (buffer,
 			"No (valid) From: or Date: fields found in message\n");
 	if (nodelim) {
-	    if (*date == NULL) {
+	    if (*date == '\0') {
 		long clock;
 
 		time (&clock);
 		sprintf (date, "%.24s", ctime (&clock));
 	    }
-	    if (*from == NULL)
+	    if (*from == '\0')
 		sprintf (from, "%s!%s", SystemName (), getusr ());
 	}
 	else
 	    return MFHDR;
     }
     else
-	buffer[0] = NULL;
+	buffer[0] = '\0';
 	
     if (nodelim && (cp = index (from, '!')) != NULL) {
-	*cp++ = NULL;
+	*cp++ = '\0';
 	fprintf (out, "From %s %s remote from %s\n", cp, date, from);
     }
     else
@@ -335,7 +367,7 @@
 	return OK;
     }
 
-    *cp = NULL;
+    *cp = '\0';
     for (hl = &headers[0]; hl -> h_name; hl++)
 	if (lequal (hl -> h_name, bp))
 	    break;
@@ -350,10 +382,10 @@
 
 	case HDATE: 
 	    pp = ++cp;
-	    if (*date != NULL || !lequal (hl -> h_name, "Date"))
+	    if (*date != '\0' || !lequal (hl -> h_name, "Date"))
 		return OK;
 	    date_convert (pp, date);
-	    if (*date == NULL)
+	    if (*date == '\0')
 		fprintf (out,
 			"Illegal-Object: %s: %s -- illegal date construct\n",
 			hl -> h_name, pp);
@@ -361,7 +393,7 @@
 
 	case HFROM: 
 	    pp = ++cp;
-	    if (*from != NULL)
+	    if (*from != '\0')
 		return OK;
 	    if ((adrxp = getadrx (pp)) == NULL) {
 		fprintf (out, "Illegal-Object: %s: %s -- %s\n",
@@ -369,7 +401,7 @@
 		return OK;	/* catch errors later (possibly) */
 	    }
 	    addr_convert (adrxp, from, TRUE);
-	    if (*from == NULL)
+	    if (*from == '\0')
 		fprintf (out, "Illegal-Object: %s: %s -- %s\n",
 			hl -> h_name, adrxp -> text, adrxp -> err);
 	    while (getadrx (NULL))
@@ -384,7 +416,7 @@
 	    margin = pos = strlen (hl -> h_name) + 2;
 	    while (adrxp = getadrx (pp)) {
 		addr_convert (adrxp, line, FALSE);
-		if (line[0] != NULL) {
+		if (line[0] != '\0') {
 		    if (!spat++)
 			fprintf (out, "%s: ", hl -> h_name);
 		    if (some++)
@@ -431,11 +463,11 @@
             uucp[LINESIZ];
     static char path[LINESIZ] = "";
 
-    if (path[0] == NULL)
+    if (path[0] == '\0')
 	strcpy (path, LocalName ());
 
     if (adrxp -> err || !adrxp -> mbox) {
-	*to = NULL;
+	*to = '\0';
 	return;
     }
     if (notice)
@@ -494,7 +526,7 @@
     if ((cp = dctime (dparsetime (from))) != NULL)
 	sprintf (to, "%.24s", cp);
     else
-	*to = NULL;
+	*to = '\0';
 }
 
 /*  */
@@ -544,3 +576,25 @@
 
     return error;
 }
+
+#ifdef  __EMX__
+static char  *crt_tmpfil (template)
+register char  *template;
+{
+    char *cp;
+    static char tmpfil[BUFSIZ];
+
+    cp = getenv("TMP");
+    if (cp && *cp) {
+	(void) sprintf (tmpfil, "%s/%sXXXXXX", cp, template);
+	if (_fullpath (tmpfil, tmpfil, BUFSIZ))
+	    (void) sprintf (tmpfil, "./%sXXXXXX", template);
+    }
+    else
+	(void) sprintf (tmpfil, "./%sXXXXXX", template);
+    _fullpath (tmpfil, tmpfil, BUFSIZ);
+    (void) unlink (mktemp (tmpfil));
+
+    return tmpfil;
+}
+#endif
diff -urP ../mh-6.8.4/zotnet/mf/muinc.c ./zotnet/mf/muinc.c
--- ../mh-6.8.4/zotnet/mf/muinc.c	Wed Dec  1 13:01:42 1993
+++ ./zotnet/mf/muinc.c	Sun Mar 17 20:35:20 1996
@@ -16,6 +16,10 @@
 static char mmdfbox[LINESIZ];
 static char uucpbox[LINESIZ];
 
+static int mbx_open ();
+static mbx_create (), mbx_copy (), die ();
+static int tmp_open ();
+
 /*  */
 
 main (argc, argv)
@@ -89,7 +93,11 @@
 		case ENOENT: 
 		    mbx_create (file);
 		    break;
+#ifdef __EMX__
+		case EWOULDBLOCK: 
+#else
 		case ETXTBSY: 
+#endif
 		    sleep (5);
 		    break;
 		default: 
@@ -98,7 +106,11 @@
 
     if (fd == NOTOK) {
 openerr: 
+#ifdef __EMX__
+	if (errno == EWOULDBLOCK)
+#else
 	if (errno == ETXTBSY)
+#endif
 	    die ("your UUCP mailbox '%s' is busy", file);
 	else
 	    die ("unable to open UUCP mailbox '%s'", file);
diff -urP ../mh-6.8.4/zotnet/mf/musift.c ./zotnet/mf/musift.c
--- ../mh-6.8.4/zotnet/mf/musift.c	Wed Dec  1 13:01:42 1993
+++ ./zotnet/mf/musift.c	Sun Mar 17 22:26:16 1996
@@ -3,6 +3,8 @@
 #include "mf.h"
 #include <stdio.h>
 
+static  sift (), die ();
+
 /*  */
 
 /* ARGSUSED */
@@ -21,7 +23,11 @@
 	sift (stdin);
     else
 	while (--argc) {
+#ifdef __EMX__
+	    if ((fp = fopen (*++argv, "r")) == NULL) {
+#else
 	    if ((fp = fopen (*++argv)) == NULL) {
+#endif
 		perror (*argv);
 		oops++;
 		continue;
diff -urP ../mh-6.8.4/zotnet/mf/uminc.c ./zotnet/mf/uminc.c
--- ../mh-6.8.4/zotnet/mf/uminc.c	Wed Dec  1 13:01:42 1993
+++ ./zotnet/mf/uminc.c	Sun Apr 28 23:42:24 1996
@@ -3,6 +3,11 @@
 static char Id[] = "@(#)$Id: uminc.c,v 1.2 1993/08/25 17:31:30 jromine Exp $";
 #endif
 
+#ifdef __EMX__
+#include <../h/mh.h>
+#include <io.h>
+#include <fcntl.h>
+#endif
 #include "mf.h"
 #include <stdio.h>
 #include "../mts/mts.h"
@@ -16,8 +21,13 @@
 static char mmdfbox[LINESIZ];
 static char uucpbox[LINESIZ];
 
-
+#ifdef __EMX__
+char *crt_tmpfil ();
+#endif
 off_t    lseek ();
+static   int  mbx_open (), tmp_open ();
+static   mbx_create (), mbx_chk (), mbx_copy ();
+static   die ();
 
 /*  */
 
@@ -90,14 +100,22 @@
     struct stat stbuf;
 
     for (clear = FALSE, count = 2; count > 0; count--)
+#ifdef __EMX__
+	if ((fd = lkopen (file, O_RDWR | O_NONBLOCK | O_BINARY)) == NOTOK)
+#else
 	if ((fd = lkopen (file, 6)) == NOTOK)
+#endif
 	    switch (errno) {
 		case ENOENT: 
 		    mbx_create (file);
 		    clear++;
 		    break;
 
+#ifdef __EMX__
+		case EWOULDBLOCK: 
+#else
 		case ETXTBSY: 
+#endif
 		    sleep (5);
 		    break;
 
@@ -113,7 +131,11 @@
 
     if (fd == NOTOK) {
 openerr: 
+#ifdef __EMX__
+	if (errno == EWOULDBLOCK)
+#else
 	if (errno == ETXTBSY)
+#endif
 	    die ("your MMDF mailbox '%s' is busy", file);
 	else
 	    die ("unable to open MMDF mailbox '%s'", file);
@@ -150,7 +172,7 @@
     if (lseek (fd, (off_t) - count, 2) == (off_t) NOTOK
 	    || read (fd, ldelim, count) != count)
 	die ("error reading MMDF mailbox '%s'", file);
-    ldelim[count] = NULL;
+    ldelim[count] = '\0';
 
     if (strcmp (ldelim, mmdlm2)) {
 	fprintf (stderr,
@@ -190,8 +212,12 @@
     int     fd;
     char    tmpfil[LINESIZ];
 
+#ifdef __EMX__
+    strcpy (tmpfil, crt_tmpfil ("uminc"));
+#else
     strcpy (tmpfil, "/tmp/umincXXXXXX");
     unlink (mktemp (tmpfil));
+#endif
     if ((fd = creat (tmpfil, TMPMODE)) == NOTOK)
 	die ("unable to create temporary file '%s'", tmpfil);
     close (fd);
@@ -202,6 +228,10 @@
 
     if ((*mbx_fd = dup (fd)) == NOTOK)
 	die ("unable to duplicate fd for temporary file '%s'", tmpfil);
+#ifdef __EMX__
+    setmode (fd, O_BINARY);
+    setmode (*mbx_fd, O_BINARY);
+#endif
 
     return fd;
 }
diff -urP ../mh-6.8.4/zotnet/mf/umsift.c ./zotnet/mf/umsift.c
--- ../mh-6.8.4/zotnet/mf/umsift.c	Wed Dec  1 13:01:42 1993
+++ ./zotnet/mf/umsift.c	Sun Mar 17 19:03:08 1996
@@ -3,6 +3,8 @@
 #include "mf.h"
 #include <stdio.h>
 
+static  sift ();
+
 /*  */
 
 /* ARGSUSED */
@@ -21,7 +23,11 @@
 	sift (stdin);
     else
 	while (--argc) {
+#ifdef __EMX__
+	    if ((fp = fopen (*++argv, "rb")) == NULL) {
+#else
 	    if ((fp = fopen (*++argv)) == NULL) {
+#endif
 		perror (*argv);
 		oops++;
 		continue;
diff -urP ../mh-6.8.4/zotnet/mf/uumm.c ./zotnet/mf/uumm.c
--- ../mh-6.8.4/zotnet/mf/uumm.c	Wed Dec  1 13:01:42 1993
+++ ./zotnet/mf/uumm.c	Mon Jun 17 03:33:16 1996
@@ -1,5 +1,10 @@
 /* uumm.c - routines to filter UUCP to MMDF mailboxes */
 
+#ifdef __EMX__
+#include <../h/mh.h>
+#include <io.h>
+#include <fcntl.h>
+#endif
 #include "mf.h"
 #include "../tws/tws.h"
 #include <stdio.h>
@@ -34,9 +39,15 @@
 static char buffer[BUFSIZ],
             tmpbuf[BUFSIZ];
 
-char   *shrink ();
+static  char *shrink ();
 
+#ifdef __EMX__
+char *crt_tmpfil ();
+static getrealname ();
+#endif
 long    time ();
+static  int uucp_file (), uucp_from (), uucp_headers (), uucp_text ();
+static  int do_header (), uucp_die ();
 
 /*  */
 
@@ -64,6 +75,9 @@
     if ((in = fdopen (infd, "r")) == NULL
 	    || (out = fdopen (outfd, "w")) == NULL)
 	return MFSIO;
+#ifdef __EMX__
+    _fsetmode (out, "b");
+#endif
 
     result = uumm (in, out, nodelim);
 
@@ -94,6 +108,9 @@
             date[LINESIZ];
     FILE   *tmp;
 
+#ifdef  __EMX__
+    fgets (tmpbuf, sizeof tmpbuf, in);
+#endif
     for (tmp_fd = NOTOK;;) {
 	if ((i = uucp_file (&tmp_fd, in, &tmp, nodelim)) == DONE)
 	    break;
@@ -145,8 +162,12 @@
 	if (feof (in))
 	    return DONE;
 
+#ifdef __EMX__
+    strcpy (tmpfil, crt_tmpfil ("uumm"));
+#else
     strcpy (tmpfil, "/tmp/uummXXXXXX");
     unlink (mktemp (tmpfil));
+#endif
     if ((fd = creat (tmpfil, TMPMODE)) == NOTOK)
 	return MFERR;
     close (fd);
@@ -157,6 +178,9 @@
 	close (fd);
 	return MFERR;
     }
+#ifdef __EMX__
+    _fsetmode (out, "b");
+#endif
     unlink (tmpfil);
 
     if ((*tmp_fd = dup (fd)) == NOTOK) {
@@ -176,8 +200,14 @@
 	    if (isfrom (tmpbuf))
 		break;
 	    else
+#ifdef  __EMX__
+		fputs (buffer, out);
+	if (done = tmpbuf[0] == '\001')
+	    strcpy (buffer, tmpbuf);
+#else
 		putc ('\n', out);
 	done = tmpbuf[0] == '\n';
+#endif
 	if (!done)
 	    fputs (tmpbuf, out);
 	if (fgets (tmpbuf, sizeof tmpbuf, in) == NULL)
@@ -206,13 +236,13 @@
     if (fgets (buffer, sizeof buffer, in) == NULL || !isfrom (buffer))
 	return MFROM;
     if (buffer[strlen (buffer) - 1] == '\n')
-	buffer[strlen (buffer) - 1] = NULL;
+	buffer[strlen (buffer) - 1] = '\0';
     if ((cp = index (buffer, ' ')) == NULL)
 	return MFROM;
     pp = ++cp;
     if ((cp = index (cp, ' ')) == NULL)
 	return MFROM;
-    *cp++ = NULL;
+    *cp++ = '\0';
     strcpy (fromwhom, pp);
     while (isspace (*cp))
 	cp++;
@@ -227,7 +257,7 @@
 	    break;
 	}
 	if (strncmp (cp, "remote from ", 12) == 0) {
-	    *cp = NULL;
+	    *cp = '\0';
 	    sprintf (from, "%s!%s", cp + 12, fromwhom);
 	    break;
 	}
@@ -238,10 +268,10 @@
     addr_convert (adrxp, from, TRUE);
     while (seekadrx (NULL))
 	continue;
-    if (from[0] == NULL)
+    if (from[0] == '\0')
 	return MFROM;
     date_convert (date, date);
-    return (date[0] != NULL ? OK : MFROM);
+    return (date[0] != '\0' ? OK : MFROM);
 }
 
 /*  */
@@ -320,10 +350,17 @@
             margin,
             some,
             spat,
+#ifdef  __EMX__
+            notop,
+            perslen,
+#endif
             pos;
     char   *bp,
            *cp,
            *pp,
+#ifdef  __EMX__
+            name[BUFSIZ],
+#endif
             line[BUFSIZ];
     struct adrx *adrxp;
     struct header  *hl;
@@ -336,7 +373,7 @@
 	return OK;
     }
 
-    *cp = NULL;
+    *cp = '\0';
     for (hl = &headers[0]; hl -> h_name; hl++)
 	if (lequal (hl -> h_name, bp))
 	    break;
@@ -350,7 +387,7 @@
 	    for (pp = cp + 1; isspace (*pp); pp++)
 		continue;
 	    date_convert (pp, line);
-	    if (line[0] == NULL)
+	    if (line[0] == '\0')
 		fprintf (out, "Illegal-Object: %s: %s -- %s\n",
 			hl -> h_name, pp, "illegal date construct");
 	    else
@@ -371,21 +408,40 @@
 	case HADDR: 
 	    spat = 0;
 	    some = FALSE;
+#ifdef  __EMX__
+	    notop = FALSE;
+#endif
 	    pp = ++cp;
 	    margin = pos = strlen (hl -> h_name) + 2;
 	    while (adrxp = seekadrx (pp)) {
 		addr_convert (adrxp, line, FALSE);
-		if (line[0] != NULL) {
+		if (line[0] != '\0') {
+#ifdef  __EMX__
+		    getrealname (adrxp, name, &perslen);
+#endif
 		    if (!spat++)
 			fprintf (out, "%s: ", hl -> h_name);
 		    if (some++)
 			fputs (", ", out), pos += 2;
+#ifdef  __EMX__
+		    if (notop++ && pos + strlen (line) + perslen >= OWIDTH) {
+#else
 		    if (pos + strlen (line) >= OWIDTH) {
+#endif
 			fprintf (out, "\n%*s", margin, " ");
 			pos = margin;
 		    }
+#ifdef  __EMX__
+		    if (perslen)
+			fprintf (out, "%s <%s>", name, line);
+		    else
+#endif
 		    fputs (line, out);
+#ifdef  __EMX__
+		    pos += (strlen (line) + perslen);
+#else
 		    pos += strlen (line);
+#endif
 		}
 		else {
 		    if (spat)
@@ -425,21 +481,21 @@
     static char path[LINESIZ] = "";
 
     if (adrxp -> err || !adrxp -> mbox) {
-	*to = NULL;
+	*to = '\0';
 	return;
     }
     if (notice)
 	if ((cp = rindex (adrxp -> mbox, '!')) != NULL)
 	    sprintf (path, "%.*s!", cp - adrxp -> mbox, adrxp -> mbox);
 	else
-	    path[0] = NULL;
+	    path[0] = '\0';
 
     sprintf (addr, "%s%s", path, adrxp -> mbox);
     sprintf (uucp, "%s!", SystemName ());
     uucplen = strlen (uucp);
     if ((addrlen = strlen (addr) - uucplen - 1) >= 0)
 	for (cp = addr + addrlen; cp >= addr; cp--)
-	    if (strncmp (cp, uucp, uucplen) == NULL) {
+	    if (strncmp (cp, uucp, uucplen) == 0) {
 		if (cp != addr && *(cp - 1) != '!')
 		    continue;
 		strcpy (addr, cp + uucplen);
@@ -454,15 +510,25 @@
 	sprintf (uucp, "%s%%%s@%s", cp, UucpChan (), LocalName ());
 #else	MMDFMTS
 	if (wp = index (adrxp -> mbox, '!'))
+#ifdef  __EMX__
+	    sprintf (uucp, "%s@%.*s",
+		wp + 1, wp - adrxp -> mbox, adrxp -> mbox);
+	else
+	    sprintf (uucp, "%s@%s",
+		adrxp -> mbox, SystemName ());
+#else
 	    sprintf (uucp, "%s@%.*s.%s",
 		wp + 1, wp - adrxp -> mbox, adrxp -> mbox, UucpChan ());
 	else
 	    sprintf (uucp, "%s@%s.%s",
 		adrxp -> mbox, SystemName (), UucpChan ());
+#endif
 #endif	MMDFMTS
+#ifndef __EMX__
 	if (strcmp (adrxp -> mbox, cp))
 	    sprintf (tmp, "\"%s\" <%s>", adrxp -> mbox, uucp);
 	else
+#endif
 	    strcpy (tmp, uucp);
     }
     else
@@ -473,15 +539,19 @@
 	    uucplen = strlen (uucp);
 	    cp = (lequal (LocalName (), adrxp -> host)
 		    && (addrlen = strlen (addr) - uucplen) > 0)
-		? addr + addrlen : NULL;
+		? addr + addrlen : "";
 	    if (lequal (uucp, cp))
 		sprintf (tmp, "%s@%s", shrink (addr), adrxp -> host);
 	    else {
+#ifdef  __EMX__
+		sprintf (tmp, "%s@%s", wp, adrxp -> host);
+#else
 		if (lequal (adrxp -> mbox, ++wp))
 		    sprintf (tmp, "%s@%s", wp, adrxp -> host);
 		else
 		    sprintf (tmp, "\"%s\" <%s@%s>", adrxp -> mbox,
 			    wp, adrxp -> host);
+#endif
 	    }
 	}
 
@@ -506,7 +576,7 @@
     i = strlen (r2);
     if ((j = strlen (addr) - i - 1) >= 0)
 	for (cp = &addr[j]; cp >= addr; cp--)
-	    if (strncmp (cp, r2, i) == NULL) {
+	    if (strncmp (cp, r2, i) == 0) {
 		if (cp != addr && *(cp - 1) != '!')
 		    continue;
 		strcpy (addr, cp + i);
@@ -517,7 +587,7 @@
 	sprintf (r1, "%s%s", r2, addr);
 	return r1;
     }
-    *cp++ = NULL;
+    *cp++ = '\0';
 
     if ((pp = rindex (addr, '!')) == NULL) {
 	*--cp = '!';
@@ -528,7 +598,7 @@
 
     while ((pp = rindex (addr, '!')) != NULL) {
 	for (pp++, xp = addr; (wp = index (xp, '!')) != NULL;) {
-	    *wp = NULL;
+	    *wp = '\0';
 	    if (strcmp (pp, xp)) {
 		*wp++ = '!';
 		xp = wp;
@@ -541,13 +611,13 @@
 	sprintf (r2, "%s!%s", pp, r1);
 	strcpy (r1, r2);
 	if (--pp > addr)
-	    *pp = NULL;
+	    *pp = '\0';
     }
 
 /*  */
 
     if ((wp = index (r1, '!')) != NULL) {
-	*wp = NULL;
+	*wp = '\0';
 	strcpy (r2, r1);
 	*wp = '!';
 	if (strcmp (addr, r2)) {
@@ -649,3 +719,51 @@
 
     return error;
 }
+
+#ifdef  __EMX__
+static getrealname (adrxp, name, len)
+struct adrx *adrxp;
+char   *name;
+int    *len;
+{
+    register char *cp, *wp;
+    char tmpbuf[BUFSIZ];
+
+    if (adrxp -> pers)
+	strcpy (tmpbuf, adrxp -> pers);
+    else
+	if ((cp = adrxp -> note) && *cp++ == '(') {
+	    for (wp = tmpbuf; *cp && *cp != ')'; cp++)
+		*wp++ = *cp;
+	    *wp = '\0';
+
+	    if (*cp != ')')
+		tmpbuf[0] = '\0';
+	}
+	else
+	    tmpbuf[0] = '\0';
+
+    if (*len = strlen (strcpy (name, legal_person (tmpbuf))))
+	*len += 3;
+}
+
+char  *crt_tmpfil (template)
+register char  *template;
+{
+    char *cp;
+    static char tmpfil[BUFSIZ];
+
+    cp = getenv("TMP");
+    if (cp && *cp) {
+	(void) sprintf (tmpfil, "%s/%sXXXXXX", cp, template);
+	if (_fullpath (tmpfil, tmpfil, BUFSIZ))
+	    (void) sprintf (tmpfil, "./%sXXXXXX", template);
+    }
+    else
+	(void) sprintf (tmpfil, "./%sXXXXXX", template);
+    _fullpath (tmpfil, tmpfil, BUFSIZ);
+    (void) unlink (mktemp (tmpfil));
+
+    return tmpfil;
+}
+#endif
diff -urP ../mh-6.8.4/zotnet/mts/client.c ./zotnet/mts/client.c
--- ../mh-6.8.4/zotnet/mts/client.c	Sat Mar  2 01:50:28 1996
+++ ./zotnet/mts/client.c	Sat Mar  2 14:28:04 1996
@@ -52,11 +52,13 @@
 
 /*  */
 
+#ifndef	__EMX__
 extern int errno;
 #ifndef	BSD44
 extern int  sys_nerr;
 extern char *sys_errlist[];
 #endif
+#endif /* __EMX__ */
 
 
 struct addrent {
diff -urP ../mh-6.8.4/zotnet/mts/lock.c ./zotnet/mts/lock.c
--- ../mh-6.8.4/zotnet/mts/lock.c	Sat Mar  2 01:47:04 1996
+++ ./zotnet/mts/lock.c	Sat Mar  2 14:28:06 1996
@@ -46,6 +46,10 @@
 #if defined(_AIX) || defined(AUX)
 #include <sys/file.h>
 #endif
+#ifdef  __EMX__
+#include <io.h>
+#include <sys/fcntl.h>
+#endif
 
 #ifdef	SYS5
 #define	u_short	ushort
@@ -112,7 +116,11 @@
     for (i = 0;;)
 	switch (lockit (tmplock, curlock)) {
 	    case OK: 
+#ifdef __EMX__
+		if ((i = open (file, access | O_BINARY)) == NOTOK) {
+#else
 		if ((i = open (file, access)) == NOTOK) {
+#endif
 		    j = errno;
 		    (void) unlink (curlock);
 		    errno = j;
@@ -171,7 +179,11 @@
                    *cp;
 
     bp = curlock;
+#ifdef __EMX__
+    if ((cp = _getname (file)) == file || *cp == 0)
+#else
     if ((cp = rindex (file, '/')) == NULL || *++cp == 0)
+#endif
 	cp = file;
     if (lockldir == NULL || *lockldir == 0) {
 	if (cp != file) {
@@ -196,7 +208,11 @@
     }
 
     if (tmplock) {
+#ifdef __EMX__
+        if ((cp = _getname (curlock)) == curlock || *cp == 0)
+#else
 	if ((cp = rindex (curlock, '/')) == NULL || *++cp == 0)
+#endif
 	    (void) strcpy (tmplock, ",LCK.XXXXXX");
 	else
 	    (void) sprintf (tmplock, "%.*s,LCK.XXXXXX",
diff -urP ../mh-6.8.4/zotnet/mts/mts.h ./zotnet/mts/mts.h
--- ../mh-6.8.4/zotnet/mts/mts.h	Wed Dec  1 13:01:42 1993
+++ ./zotnet/mts/mts.h	Sat Jul  6 13:53:46 1996
@@ -109,3 +109,24 @@
 
 extern int Everyone;
 extern char *NoShell;
+
+#if  defined(__EMX__) && defined(MF)
+/* OS/2 UUPC/Extended stuff */
+
+void uupc_init ();
+extern char	*UupcName,
+		*UupcOrganization,
+		*UupcReplyto,
+		*UupcFromDomain,
+		*UupcFileSentName,
+		*UupcSignatureName;
+extern int	UupcAutoSign;
+#endif
+
+#if  defined(__EMX__) && defined(SENDMTS) && !defined(SMTP) && !defined(SOUPER)
+/* OS/2 sendmail stuff */
+
+void tcpip_init ();
+extern char	*SendmailReplyDomain,
+		*SendmailMailServer;
+#endif
diff -urP ../mh-6.8.4/zotnet/mts.h ./zotnet/mts.h
--- ../mh-6.8.4/zotnet/mts.h	Wed Dec  1 13:01:42 1993
+++ ./zotnet/mts.h	Sat Jul  6 13:53:28 1996
@@ -110,3 +110,24 @@
 
 extern int Everyone;
 extern char *NoShell;
+
+#if  defined(__EMX__) && defined(MF)
+/* OS/2 UUPC/Extended stuff */
+
+void uupc_init ();
+extern char	*UupcName,
+		*UupcOrganization,
+		*UupcReplyto,
+		*UupcFromDomain,
+		*UupcFileSentName,
+		*UupcSignatureName;
+extern int	UupcAutoSign;
+#endif
+
+#if  defined(__EMX__) && defined(SENDMTS) && !defined(SMTP) && !defined(SOUPER)
+/* OS/2 sedmail stuff */
+
+void tcpip_init ();
+extern char	*SendmailReplyDomain,
+		*SendmailMailServer;
+#endif
diff -urP ../mh-6.8.4/zotnet/tws/dtime.c ./zotnet/tws/dtime.c
--- ../mh-6.8.4/zotnet/tws/dtime.c	Wed Dec  1 13:01:42 1993
+++ ./zotnet/tws/dtime.c	Sat Mar  2 14:28:08 1996
@@ -107,7 +107,9 @@
 
 #define CENTURY 1900
 
+#ifndef __EMX__
 long    time ();
+#endif
 struct tm *localtime ();
 
 /*  */
@@ -168,16 +170,20 @@
     tw.tw_year = tm -> tm_year + CENTURY;
     tw.tw_wday = tm -> tm_wday;
     tw.tw_yday = tm -> tm_yday;
+#if !defined(__EMX__)
     if (tm -> tm_isdst)
 	tw.tw_flags |= TW_DST;
+#endif
 #if	defined(SYS5)
     tzset ();
     tw.tw_zone = -(timezone / 60);
 #else	/* defined(SYS5) */
 #if	defined(ZONEINFO)
     tw.tw_zone = tm->tm_gmtoff / 60;
+#if !defined(__EMX__)
     if (tm -> tm_isdst)			/* if DST is in effect */
 	tw.tw_zone -= 60;		/* reset to normal offset */
+#endif
 #else	/* defined(ZONEINFO) */
     ftime (&tb);
     tw.tw_zone = -tb.timezone;
@@ -210,8 +216,10 @@
     tw.tw_year = tm -> tm_year + CENTURY;
     tw.tw_wday = tm -> tm_wday;
     tw.tw_yday = tm -> tm_yday;
+#if !defined(__EMX__)
     if (tm -> tm_isdst)
 	tw.tw_flags |= TW_DST;
+#endif
     tw.tw_zone = 0;
     tw.tw_flags &= ~TW_SDAY, tw.tw_flags |= TW_SEXP;
     tw.tw_flags &= ~TW_SZONE, tw.tw_flags |= TW_SZEXP;
diff -urP ../mh-6.8.4/zotnet/tws/dtimep.c-lexed ./zotnet/tws/dtimep.c-lexed
--- ../mh-6.8.4/zotnet/tws/dtimep.c-lexed	Wed Dec  1 13:01:42 1993
+++ ./zotnet/tws/dtimep.c-lexed	Sat Mar  2 14:28:10 1996
@@ -161,8 +161,10 @@
 	time (&clock);
 	tm = localtime(&clock);
 	tw.tw_zone = tm->tm_gmtoff / 60;
+#ifndef __EMX__
 	if (tm -> tm_isdst)			/* if DST is in effect */
 		tw.tw_zone -= 60;		/* reset to normal offset */
+#endif
 #else
 	ftime( &tb );
 	tw.tw_zone = -tb.timezone;
@@ -368,10 +370,10 @@
 			ZONE(0 * 60);
 break;
 case 21:
-			ZONE(2 * 60);
+			ZONE(9 * 60);
 break;
 case 22:
-			ZONED(2 * 60);
+			ZONED(9 * 60);
 break;
 case 23:
 			ZONE(-5 * 60);
