;*****************************************************************************
;*
;*                            Open Watcom Project
;*
;*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
;*
;*  ========================================================================
;*
;*    This file contains Original Code and/or Modifications of Original
;*    Code as defined in and that are subject to the Sybase Open Watcom
;*    Public License version 1.0 (the 'License'). You may not use this file
;*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
;*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
;*    provided with the Original Code and Modifications, and is also
;*    available at www.sybase.com/developer/opensource.
;*
;*    The Original Code and all software distributed under the License are
;*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
;*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
;*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
;*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
;*    NON-INFRINGEMENT. Please see the License for the specific language
;*    governing rights and limitations under the License.
;*
;*  ========================================================================
;*
;* Description: Module to implement stack check and growing functions for
;*              SNAP applications and drivers. For now we only implement
;*              __GRO, as we cannot support stack checks at the moment. To
;*              support that, we need to add code to the C runtime library
;*              InitLibC code such that we can find out from the OS where
;*              the stack lives so we can update the _STACKLOW variable as
;*              necessary.
;*
;*****************************************************************************

include mdef.inc
include struct.inc
include xinit.inc
include exitwmsg.inc

        modstart        stk

        assume  ds:DGROUP

; Watcom C++ stack growing function. Due to the way that OS/2 and Windows
; handle stack growing we need to touch all 4K pages in order that might be
; used by a C function at entry. This code will be generated by the Watcom
; compiler when the C function uses more than 4K of stack space and will
; not cause any harm on other OS'es (or actually it will pre-page in the
; new stack pages as necessary).
;
; Note: For Linux the stack growing is a little different, such that the ESP
;       register must always point to a value that is at the bottom of the
;       stack. If you access a value on the stack below the ESP value that
;       requires a new stack page to be brought in, the kernel will fault.
;       To solve this we modified this function to make sure ESP points
;       to memory below where we will grow the stack to, so that the kernel
;       will correctly bring in the necessary stack pages. In reality this
;       funciton is not needed at all on Linux, but this way we have a
;       function that works on Linux and will still work on Windows and OS/2.

xdefp   __GRO
defpe   __GRO                           ; dummy function to resolve symbol
        push    eax                     ; save regs
        push    ebx                     ; ...
        push    ebp                     ; ...
        mov     ebp,esp                 ; initialize base pointer
        mov     eax,[esp+16]            ; get size to grow by
        mov     ebx,-4                  ; initialize index
        sub     esp,eax                 ; Make sure esp covers the grown stack region
lup:                                    ; do {
        mov     [ebp+ebx],ebx           ; - touch that stack page
        sub     ebx,1000H               ; - decrement by 4k
        sub     eax,1000H               ; - decrement by 4k
        jg      lup                     ; } while stack left to go
        mov     esp,ebp                 ; restore stack pointer
        pop     ebp                     ; restore regs
        pop     ebx                     ; ...
        pop     eax                     ; ...
        ret     4                       ; return to caller
endproc __GRO

        endmod
        end

