/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  Mask differences between architectures where va_list
*               is an array type and those where it isn't.
*
****************************************************************************/


#ifndef _MYVALIST_H_INCLUDED

#include "variety.h"
#include <stdarg.h>

typedef struct my_va_list {
    va_list v;
} my_va_list;

#if defined(__AXP__) || (defined(__PPC__) && !defined(__GNUC__)) || defined(__MIPS__)
  #define MY_VA_LIST( a ) (*(my_va_list *)&(a))
#elif defined(__WATCOMC__) || (defined(__PPC__) && defined(__GNUC__)) || (defined(__X86_64__) && defined(__GNUC__))
  #define MY_VA_LIST( a ) (*(my_va_list *)(a))
#else
  #error MY_VA_LIST not set up!
#endif

#define _MYVALIST_H_INCLUDED
#endif
