/* REXX install program for SOMObjects Workgroup Enabler       */
/*                                                             */
/* 1. Call installer program.  If MTPN component selected      */
/*    installer will write file <bootdrive>:SOMWGBSE.DRS       */
/*    that will contain values for:                            */
/*        CONFIG.SYS UPDATED: (yes/no)                         */
/*        SOMBASE: drive and path                              */
/*        MPTNDRIVE: drive                                     */
/* 2. Get bootdrive                                            */
/* 3. if <bootdrive>:SOMWGBSE.DRS exists then                  */
/*        get UPDCNF, SOMBASE and MPTNDRIVE from it            */
/*        if UPDCNF=yes then                                   */
/*             call <SOMBASE>\tmp\mptn\mptinst with args:      */
/*             /S:<SOMBASE>\tmp\ /T:<MPTNDRIVE> /U:<bootdrive> */
/*             clean <SOMBASE>\tmp\mptn\                       */
/*             delete <bootdrive>:SOMWGBSE.DRS                 */
/*        else                                                 */
/*             tell user to perform the above tasks            */
/*        endif                                                */
/*    endif                                                    */

'@echo off'

/* register all Rexx util functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* trace all */

/* get current drive (i.e. the drive this pgm is being run from) */
parse source . . cmdline
curdrive = filespec("drive",cmdline)
/* say 'curdrive: 'curdrive */

/* get boot drive info from C program: bootdriv.exe */
curdrive'bootdriv.exe | RXQUEUE'
pull bootdrive
bootdrive = strip(bootdrive);
/* say 'bootdrive:'bootdrive */

/* Invoke Software Installer */
curdrive'wginstal.exe'

/* The file SOMWGBSE.DRS will be written to the */
/* top level of the bootdrive if MPTN selected. */

mptninfo = bootdrive':\SOMWGBSE.DRS'
/* say 'mptninfo:'mptninfo */

if stream(mptninfo,'C','QUERY EXISTS') \== "" then
   /* MPTN component installed, so read the info */
   do
      info = linein(mptninfo);
      rc = stream(mptninfo,'C','CLOSE');
      parse upper var info updatecnf mptndrive sombase;
      updatecnf = strip(updatecnf);
      mptndrive = substr(mptndrive,1,1);
      sombase = strip(sombase);
      mptntmp = sombase||'\TMP\MPTN'
/*      say 'sombase:'sombase; */
/*      say 'mptndrive:'mptndrive; */
/*      say 'updatecnf:'updatecnf; */
      if updatecnf=="YES" then
         do
/*            say FILESPEC("drive",mptntmp) */
            FILESPEC("drive",mptntmp)
/*            say 'cd 'mptntmp'\BIN' */
            'cd 'mptntmp'\BIN'
/*            say 'mptinst /S:'sombase||'\tmp\ /T:'mptndrive' /U:'bootdrive */
            'mptinst /S:'sombase||'\tmp\ /T:'mptndrive' /U:'bootdrive
/*            say 'cd \' */
            'cd \'
            call cleanup
         end
      else
         do
            msg = SysGetMessage(1,curdrive'mptnmsg.msg',mptntmp,sombase,mptndrive,bootdrive)
            say msg
         end; /* if */
      /* Delete "MPTN-info" file (written by MPTN component exit) */
      rc = SysFileDelete(mptninfo)
/*      say 'Deleted 'mptninfo' file with rc = 'rc */
   end; /* if */

/* Done with install */
exit

/************************************/
/* Clean up MPTN tmp files and dirs */
/************************************/
cleanup: procedure expose mptntmp mptninfo
/*   say 'Cleaning up...' */
   /* Delete files */
   call SysFileTree mptntmp'\*.*', 'file', 'SFO'
   do i=1 to file.0
      rc = SysFileDelete(file.i)
/*      say 'Deleted 'file.i' with rc = 'rc */
   end
   /* Remove directories */
   call SysFileTree mptntmp'\*.*', 'dir', 'SDO'
   do i=1 to dir.0
      rc = SysRmDir(dir.i)
/*      say 'Removed dir 'dir.i' with rc = 'rc */
   end
   rc = SysRmDir(mptntmp)
/*   say 'Removed dir 'mptntmp' with rc = 'rc */
/*   say '...finished cleaning.' */
   return
