/*******************************************************************/
/*                                                                 */
/* Program: SERVICE.CMD                                            */
/*                                                                 */
/* Purpose:                                                        */
/*    Install the OS2 version of the SOMobjects 2.1 CSD 2.11.      */
/* This was written to install from the Developers Connection for  */
/* LAN Systems CDROM, using the DevCon CATALOG.                    */
/*                                                                 */
/*******************************************************************/
'@ECHO OFF'

ENV = 'OS2ENVIRONMENT'
curdir = DIRECTORY()

PARSE SOURCE progname
progname = WORD( progname, 3)
srcdrv = FILESPEC( 'drive', progname)

SAY 'Installing the Corrective Service -- SOMobjects CSD 2.11'

/* Check for Existance of SOMBASE directory */
somdir = VALUE( 'SOMBASE',,ENV)
IF somdir = "" THEN SIGNAL errnosom

/* Change to that directory */
newdir = DIRECTORY( somdir)
IF newdir = "" THEN SIGNAL errbaddir

/* copy CSD files to SOMBASE to execute fixes */
'copy' srcdrv'\SERVICE\SOMCS211\OS2\CSD211.EX@' somdir
'copy' srcdrv'\SERVICE\SOMCS211\OS2\CSD211.OS@' somdir

/* Unpack each of the files */
'unpack CSD211.EX@'
'del' somdir'\CSD211.EX@'
'unpack CSD211.OS@'
'del' somdir'\CSD211.OS@'

/* Run the Corrective Service Install program */
'CSD211 -f'

/* Cleanup the sevice files */
'del' somdir'\CSD211.EXE'
'del' somdir'\CSD211.OS2'

success:
   SAY 'The SOMobjects 2.11 Corrective Service has been successfully '
   SAY 'applied to your system.'
   newdir = DIRECTORY( curdir)
   pause
   EXIT 0

errnosom:
   SAY 'The SOMobjects environment varible SOMBASE was not detected'
   SAY 'Either SOMobjects has not been installed or this varible is not'
   SAY 'set.  Please install SOMobjects 2.1 or set the SOMBASE varible'
   SAY 'before re-attempting this command.'
   pause
   EXIT 1

errbaddir:
   SAY 'The SOMobjects base directory' somdir 'does not exist or is'
   SAY 'inaccessable to this CSD install program.  Please verify that'
   SAY 'the SOMobjects environment varible SOMBASE is set to the correct'
   SAY 'directory, that that directory exists, and that that directory'
   SAY 'is accessable.'
   pause
   EXIT 2

