/****************************** Module Header ******************************\
*
* Module Name: _pm.c
*
* PM helper functions sample
*
* Copyright (c) WPS Toolkit Project - Christian Langanke 2004
*
* $Id: _pm.c,v 1.24 2008/08/20 00:13:23 cla Exp $
*
* ===========================================================================
*
* This file is part of the WPS Toolkit package and is free software.  You can
* redistribute it and/or modify it under the terms of the GNU Library General
* Public License as published by the Free Software Foundation, in version 2
* as it comes in the "COPYING.LIB" file of the WPS Toolkit main distribution.
* This library is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
* License for more details.
*
\***************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <process.h>

#define INCL_ERRORS
#define INCL_DOS
#define INCL_WIN
#define INCL_GPI
#include <os2.h>

#define INCL_WTKUTLPM
#define INCL_WTKUTLCONTROL
#define INCL_WTKUTLMODULE
#define INCL_WTKBBH
#define INCL_WTKFILEBMP
#include <wtk.h>

#include "_pm.rch"

#define __TITLE__  "PM related helper functions sample"

#define WM_USER_INITSUBCLASS   (WM_USER + 0x1000)

#define TYPE_DEFNOTEBOOK         0
#define TYPE_OKNOTEBOOK          1

typedef struct _PAGEDATA {
         BOOL           fOkButtonEnabled;
} PAGEDATA, *PPAGEDATA;


static   PSZ            pszBitmapfileNumbers = "numbers.bmp";

// ---------------------------------------------------------------------

static MRESULT EXPENTRY _DirDlgSubclassProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
         PDIRDLG        pdd = WinQueryWindowPtr( hwnd, QWL_USER);

switch (msg)
   {
   case WM_COMMAND:
      switch (LONGFROMMP( mp1))
         {
         case DID_CANCEL:
            WinAlarm( HWND_DESKTOP, WA_ERROR);
            break;
         }
      break;
   }

return WtkDefDirDlgProc( hwnd, msg, mp1, mp2);
}


// -----------------------------------------------------------------------------

static VOID _initGuiControls( HWND hwnd, PVOID pvData)
{
         ULONG          ulWindowId =  WinQueryWindowUShort( hwnd, QWS_ID);
         PPAGEDATA      ppd = pvData;

// setup controls
switch (ulWindowId)
   {
   case IDDLG_DEFNOTEBOOK_PAGE1:
      break;

   case IDDLG_DEFNOTEBOOK_PAGE2:
      break;

   case IDDLG_DEFNOTEBOOK_PAGE3:
      break;

   case IDDLG_OKNOTEBOOK_PAGE1:
      WtkEnableNotebookButton( hwnd, IDPBS_OK, ppd->fOkButtonEnabled);
      break;

   case IDDLG_OKNOTEBOOK_PAGE2:
      WtkEnableNotebookButton( hwnd, IDPBS_OK, ppd->fOkButtonEnabled);
      break;

   case IDDLG_OKNOTEBOOK_PAGE3:
      WtkEnableNotebookButton( hwnd, IDPBS_OK, ppd->fOkButtonEnabled);
      break;

   case IDDLG_DEFNOTEBOOK_PAGE4:
   case IDDLG_OKNOTEBOOK_PAGE4:
      {

               ULONG          aulBitmapId[]   = {IDSTC_BITMAP16, IDSTC_BITMAP32, IDSTC_BITMAP64};
               ULONG          aulBitmapSize[] = {16, 32, 64};
#define BITMAP_COUNT (sizeof( aulBitmapId) / sizeof( ULONG))

               APIRET         rc;
               ULONG          i;
               HPS            hps;
               ULONG          ulStyle;
               HWND           hwndStatic;
               HBITMAP        ahbmp[ BITMAP_COUNT];

      // modify static text windows to display the bitmaps of numbers.bmp
      // this file must reside in the current directory
      for (i = 0; i < BITMAP_COUNT; i++)
         {
         // get handle to static window
         hwndStatic = WinWindowFromID( hwnd, aulBitmapId[ i]);

         // load bitmap
         hps = WinGetPS( hwndStatic);
         if (hps)
            {
            rc = WtkLoadBitmapFromFile( hps, pszBitmapfileNumbers, &ahbmp[ i],
                                        aulBitmapSize[ i], aulBitmapSize[ i], TRUE);
            if (rc == NO_ERROR)
               {
               // switch static window style to bitmap
               ulStyle = WinQueryWindowULong( hwndStatic, QWL_STYLE);
               WinSetWindowULong( hwndStatic, QWL_STYLE, (ulStyle & ~SS_TEXT) | SS_BITMAP);

               // set bitmap handle
               WinSendMsg( hwndStatic, SM_SETHANDLE, MPFROMLONG( ahbmp[ i]), 0);

               }

            // cleanup
            WinReleasePS( hps);
            }


         }

      }
      break;

   }

return;
}

// --------------------------------------------------------------------------

static VOID _enableCheckbox( HWND hwnd, ULONG ulCurrentWindowId, ULONG ulPageWindowId,
                             ULONG ulButtonId, BOOL fEnable)
{
if (ulCurrentWindowId != ulPageWindowId)
   WinSendDlgItemMsg( WinWindowFromID( WinQueryWindow( hwnd, QW_PARENT), ulPageWindowId),
                      ulButtonId, BM_SETCHECK,
                      (MPARAM) fEnable, 0L);
}

// -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

static VOID _controlGuiValues( HWND hwnd, PVOID pvData, MPARAM mp1, MPARAM mp2)
{
         ULONG          ulWindowId =  WinQueryWindowUShort( hwnd, QWS_ID);
         PPAGEDATA      ppd = pvData;

// control dialog items

switch( SHORT1FROMMP( mp1))
   {

   // same checkbox on all pages of 2nd sample notebook
   case IDCHB_ENABLEOK:
      {
               HWND           hwndOkButton = NULLHANDLE;

      // enable ok button on all pages
      // - for that use a WtkQueryNotebookButton loop and WinEnableWindow
      // - can alse be done using a single call to WtkEnableNotebookButton
      ppd->fOkButtonEnabled = (BOOL) WinSendDlgItemMsg( hwnd, IDCHB_ENABLEOK, BM_QUERYCHECK, 0L, 0L);
      do
         {
         hwndOkButton = WtkQueryNotebookButton( hwnd, IDPBS_OK, hwndOkButton);
         WinEnableWindow( hwndOkButton, ppd->fOkButtonEnabled);
         } while (hwndOkButton);

      // as this checkbox is on every page, set all checkboxes to the same state
      _enableCheckbox( hwnd, ulWindowId, IDDLG_OKNOTEBOOK_PAGE1,  IDCHB_ENABLEOK, ppd->fOkButtonEnabled);
      _enableCheckbox( hwnd, ulWindowId, IDDLG_OKNOTEBOOK_PAGE2,  IDCHB_ENABLEOK, ppd->fOkButtonEnabled);
      _enableCheckbox( hwnd, ulWindowId, IDDLG_OKNOTEBOOK_PAGE21, IDCHB_ENABLEOK, ppd->fOkButtonEnabled);
      _enableCheckbox( hwnd, ulWindowId, IDDLG_OKNOTEBOOK_PAGE22, IDCHB_ENABLEOK, ppd->fOkButtonEnabled);
      _enableCheckbox( hwnd, ulWindowId, IDDLG_OKNOTEBOOK_PAGE3,  IDCHB_ENABLEOK, ppd->fOkButtonEnabled);
      _enableCheckbox( hwnd, ulWindowId, IDDLG_OKNOTEBOOK_PAGE4,  IDCHB_ENABLEOK, ppd->fOkButtonEnabled);
      }
      break;
   }

return;
}

// --------------------------------------------------------------------------

static VOID _saveGuiValues( HWND hwnd, PVOID pvData)
{
         ULONG          ulWindowId =  WinQueryWindowUShort( hwnd, QWS_ID);


// save all values of GUI controls
switch (ulWindowId)
   {
   case IDDLG_DEFNOTEBOOK_PAGE1:
      break;

   case IDDLG_DEFNOTEBOOK_PAGE2:
      break;

   case IDDLG_DEFNOTEBOOK_PAGE21:
      break;

   case IDDLG_DEFNOTEBOOK_PAGE22:
      break;

   case IDDLG_DEFNOTEBOOK_PAGE3:
      break;

   case IDDLG_OKNOTEBOOK_PAGE1:
      break;

   case IDDLG_OKNOTEBOOK_PAGE2:
      break;

   case IDDLG_OKNOTEBOOK_PAGE21:
      break;

   case IDDLG_OKNOTEBOOK_PAGE22:
      break;

   case IDDLG_OKNOTEBOOK_PAGE3:
      break;
   }

return;
}

// --------------------------------------------------------------------------

static VOID _restoreGuiValues( HWND hwnd, PVOID pvData)
{
         ULONG          ulWindowId =  WinQueryWindowUShort( hwnd, QWS_ID);

// restore all values to GUI controls
switch (ulWindowId)
   {
   case IDDLG_DEFNOTEBOOK_PAGE1:
      break;

   case IDDLG_DEFNOTEBOOK_PAGE2:
      break;

   case IDDLG_DEFNOTEBOOK_PAGE21:
      break;

   case IDDLG_DEFNOTEBOOK_PAGE22:
      break;

   case IDDLG_DEFNOTEBOOK_PAGE3:
      break;

   case IDDLG_OKNOTEBOOK_PAGE1:
      break;

   case IDDLG_OKNOTEBOOK_PAGE2:
      break;

   case IDDLG_OKNOTEBOOK_PAGE21:
      break;

   case IDDLG_OKNOTEBOOK_PAGE22:
      break;

   case IDDLG_OKNOTEBOOK_PAGE3:
      break;
   }

return;
}

// -----------------------------------------------------------------------------

static VOID _defaultGuiValues( HWND hwnd, PVOID pvData)
{
         ULONG          ulWindowId =  WinQueryWindowUShort( hwnd, QWS_ID);

// reset controls
switch (ulWindowId)
   {
   case IDDLG_DEFNOTEBOOK_PAGE1:
      break;

   case IDDLG_DEFNOTEBOOK_PAGE2:
      break;

   case IDDLG_DEFNOTEBOOK_PAGE21:
      break;

   case IDDLG_DEFNOTEBOOK_PAGE22:
      break;

   case IDDLG_DEFNOTEBOOK_PAGE3:
      break;

   case IDDLG_OKNOTEBOOK_PAGE1:
      break;

   case IDDLG_OKNOTEBOOK_PAGE2:
      break;

   case IDDLG_OKNOTEBOOK_PAGE21:
      break;

   case IDDLG_OKNOTEBOOK_PAGE22:
      break;

   case IDDLG_OKNOTEBOOK_PAGE3:
      break;
      break;
   }

return;
}

// -----------------------------------------------------------------------------

static ULONG _launchNotebook( HWND hwnd, HWND hwndBubbleHelp, PSZ pszHelpFile, ULONG ulNotebookType)
{
         ULONG          ulResult = MBID_ERROR;
         ULONG          i;

         ULONG          ulFrameId;
         ULONG          ulPageCount;
         PULONG         paulPageId;

         CHAR           szStatusMask[ 64];

static   ULONG          aulDefNotebookPageId[] = { IDDLG_DEFNOTEBOOK_PAGE1,
                                                   IDDLG_DEFNOTEBOOK_PAGE2,
                                                   IDDLG_DEFNOTEBOOK_PAGE21,
                                                   IDDLG_DEFNOTEBOOK_PAGE22,
                                                   IDDLG_DEFNOTEBOOK_PAGE3,
                                                   IDDLG_DEFNOTEBOOK_PAGE4};
static   ULONG          aulOkNotebookPageId[] =  { IDDLG_OKNOTEBOOK_PAGE1,
                                                   IDDLG_OKNOTEBOOK_PAGE2,
                                                   IDDLG_OKNOTEBOOK_PAGE21,
                                                   IDDLG_OKNOTEBOOK_PAGE22,
                                                   IDDLG_OKNOTEBOOK_PAGE3,
                                                   IDDLG_OKNOTEBOOK_PAGE4};
static   ULONG          aulHelpPanelId[]      =  { IDPNL_NOTEBOOKPAGE1,
                                                   IDPNL_NOTEBOOKPAGE2,
                                                   IDPNL_NOTEBOOKPAGE21,
                                                   IDPNL_NOTEBOOKPAGE22,
                                                   IDPNL_NOTEBOOKPAGE3,
                                                   IDPNL_NOTEBOOKPAGE4};

#define DEFNOTEBOOK_PAGECOUNT (sizeof( aulDefNotebookPageId) / sizeof( ULONG))
#define OKNOTEBOOK_PAGECOUNT (sizeof( aulOkNotebookPageId) / sizeof( ULONG))

         NOTEBOOKPAGEINFO anpi[ DEFNOTEBOOK_PAGECOUNT]; // make sure that this number is large enough !
         NOTEBOOKINFO   ni;

         PAGEDATA       pd;

// stop bubble help
WtkDeactivateBubbleHelp( hwndBubbleHelp);

do
   {
   // load subtitle mask
    WinLoadString( WinQueryAnchorBlock( HWND_DESKTOP), NULLHANDLE,
                       IDSTR_PAGESTATUS, sizeof( szStatusMask), szStatusMask);

   // distinct between different notebooks
   switch (ulNotebookType)
      {
      case TYPE_DEFNOTEBOOK:
         ulFrameId   = IDDLG_DEFNOTEBOOK;
         paulPageId  = aulDefNotebookPageId;
         ulPageCount = DEFNOTEBOOK_PAGECOUNT;
         break;

      case TYPE_OKNOTEBOOK:
         ulFrameId   = IDDLG_OKNOTEBOOK;
         paulPageId  = aulOkNotebookPageId;
         ulPageCount = OKNOTEBOOK_PAGECOUNT;
         break;
      }

   // prepare notebook page info
   memset( anpi, 0, sizeof( anpi));
   for (i = 0; i < ulPageCount; i++, paulPageId++)
      {
      // determine notebook style
      switch (*paulPageId)
         {
         case IDDLG_DEFNOTEBOOK_PAGE21:
         case IDDLG_DEFNOTEBOOK_PAGE22:
         case IDDLG_OKNOTEBOOK_PAGE21:
         case IDDLG_OKNOTEBOOK_PAGE22:
            anpi[ i].usPageStyle   = BKA_MINOR;
            break;

         default:
            anpi[ i].usPageStyle = BKA_MAJOR;
            break;
         }

      anpi[ i].ulDlgResId        = *paulPageId;
      anpi[ i].usPageStyle      |= BKA_AUTOPAGESIZE;
      anpi[ i].usPageOrder       = BKA_LAST;
      anpi[ i].pszTabText        = NULL;
      anpi[ i].pszMinorTabText   = NULL;
      anpi[ i].pszStatusText     = NULL;

      if (ulNotebookType == TYPE_OKNOTEBOOK)
         {
         anpi[ i].ulOkButtonId     = IDPBS_OK;
         anpi[ i].ulCancelButtonId = IDPBS_CANCEL;
         anpi[ i].ulFocusId        = IDPBS_CANCEL;
         }
      else
         anpi[ i].ulFocusId        = IDPBS_UNDO;

      anpi[ i].ulHelpPanel       = aulHelpPanelId[ i];
      anpi[ i].ulUndoButtonId    = IDPBS_UNDO;
      anpi[ i].ulDefaultButtonId = IDPBS_DEFAULT;
      anpi[ i].ulHelpButtonId    = IDPBS_HELP;
      }

   // prepare notebook
   memset( &ni, 0, sizeof( ni));
   ni.cbFix             = sizeof( NOTEBOOKINFO);
   ni.hwndParent        = HWND_DESKTOP;
   ni.hwndOwner         = hwnd;
   ni.ulDlgResId        = ulFrameId;
   ni.ulNotebookResId   = IDNBK_NOTEBOOK;
   ni.ulSysIconId       = 0;
   ni.hmodResource      = NULLHANDLE;
   ni.pszHelpTitle      = "Help";
   ni.pszStatusMask     = szStatusMask;
   ni.pvData            = &pd;
   ni.ulNbPageCount     = ulPageCount;
   ni.panpi             = anpi;
   ni.pfnwcmdInitialize = _initGuiControls;
   ni.pfnwcntControl    = _controlGuiValues;
   ni.pfnwcmdSave       = _saveGuiValues;
   ni.pfnwcmdRestore    = _restoreGuiValues;
   ni.pfnwcmdDefault    = _defaultGuiValues;
   ni.pszHelpLibrary    = pszHelpFile;
   ni.fUndoAllPages     = FALSE;
   ni.fDefaultAllPages  = FALSE;

   memset( &pd, 0, sizeof( pd));
   ulResult = WtkNotebookDlg( &ni);

   } while (FALSE);

// restart bubble help
WtkActivateBubbleHelp( hwndBubbleHelp);
return ulResult;
}

// -----------------------------------------------------------------------------

static ULONG _launchDirDlg( HWND hwnd, HWND hwndBubbleHelp,
                            BOOL fPreload, BOOL fLoadCustomDialog)

{
         BOOL           ulResult = MBID_ERROR;
         BOOL           fResult;
         DIRDLG         dd;

         CHAR           szMessage[ _MAX_PATH];
         PSZ            pszButtonCode;

// stop bubble help
WtkDeactivateBubbleHelp( hwndBubbleHelp);

do
   {
   // setup data
   memset( &dd, 0, sizeof( dd));
   dd.cbSize     = sizeof( dd);
   dd.fl         = WTK_DDS_CENTER | WTK_DDS_HELPBUTTON | WTK_DDS_FORCEDIALOGID;
   dd.pszTitle   = "Directory test dialog";
   dd.pfnDlgProc = _DirDlgSubclassProc;
   strcpy( dd.szFullDir, "?:\\OS2");

   // select help panel and store it in user reserved field
   if (fPreload)
      {
      dd.ulUser  = (fLoadCustomDialog) ?
                      IDPNL_CUSTDIRDLGPRELOAD :
                      IDPNL_DEFDIRDLGPRELOAD;
      }
   else
      dd.ulUser  = IDPNL_DEFDIRDLG;

   // preload volume info
   if (fPreload)
      dd.fl |= WTK_DDS_PRELOAD_VOLINFO;

   // use custom dialog
   if (fLoadCustomDialog)
      {
      dd.fl      |= WTK_DDS_CUSTOM;
      dd.usDlgId  = IDDLG_CUSTDIRDLGPRELOAD;
      }
   else if (fPreload)
      dd.usDlgId  = IDDLG_DEFDIRDLGPRELOAD;
   else
      dd.usDlgId  = IDDLG_DEFDIRDLG;

   // launch dialog
   fResult = WtkDirDlg( HWND_DESKTOP, hwnd, &dd);

   if (!fResult)
      sprintf( szMessage, "error launching WtkDirDlg\n");
   else if (dd.lReturn == DID_OK)
      sprintf( szMessage, "directory is: %s\n", dd.szFullDir);
   else
      sprintf( szMessage, "error occurred!\n");

   switch (dd.lReturn)
      {
      case DID_OK:     pszButtonCode = "(DID_OK)";     break;
      case DID_CANCEL: pszButtonCode = "(DID_CANCEL)"; break;
      case DID_ERROR:  pszButtonCode = "(DID_ERROR)";  break;
      default:         pszButtonCode = "";             break;
      }

   sprintf( &szMessage[ strlen( szMessage)],
            "\015\015"
            "return code is: %u %s\015"
            "OS/2 reason code is: %u\015",
            dd.lReturn, pszButtonCode, dd.rc);

   WinMessageBox( HWND_DESKTOP, hwnd, szMessage, "Directory Dialog Result", 
                  IDDLG_MSGBOX_RESULTDIRDLG, MB_MOVEABLE | MB_OK | MB_HELP);

   // on error return error code
   if (!fResult)
      break;

   // hand over result
   ulResult = dd.lReturn;

   } while (FALSE);


// restart bubble help
WtkActivateBubbleHelp( hwndBubbleHelp);
return ulResult;
}

// -----------------------------------------------------------------------------

static ULONG _launchFileDlg( HWND hwnd, HWND hwndBubbleHelp)

{
         BOOL           ulResult = MBID_ERROR;
         BOOL           fResult;
         FILEDLG        fd;

         CHAR           szMessage[ _MAX_PATH];
         PSZ            pszButtonCode;

// stop bubble help
WtkDeactivateBubbleHelp( hwndBubbleHelp);

do
   {
   // setup data
   memset( &fd, 0, sizeof( fd));
   fd.cbSize     = sizeof( fd);
   fd.fl         = FDS_CENTER | FDS_HELPBUTTON | FDS_OPEN_DIALOG;
   fd.pszTitle   = "System File test dialog";
   strcpy( fd.szFullFile, "C:\\*");

   // launch dialog
   fResult = WinFileDlg( HWND_DESKTOP, hwnd, &fd);

   if (!fResult)
      sprintf( szMessage, "error launching WinFileDlg\n");
   else if (fd.lReturn == DID_OK)
      sprintf( szMessage, "file is: %s\n", fd.szFullFile);
   else
      sprintf( szMessage, "error occurred!\n");

   switch (fd.lReturn)
      {
      case DID_OK:     pszButtonCode = "(DID_OK)";     break;
      case DID_CANCEL: pszButtonCode = "(DID_CANCEL)"; break;
      case DID_ERROR:  pszButtonCode = "(DID_ERROR)";  break;
      default:         pszButtonCode = "";             break;
      }

   sprintf( &szMessage[ strlen( szMessage)],
            "\015\015"
            "return code is: %u %s\015"
            "WinFileDlg error source code is: %u\015",
            fd.lReturn, pszButtonCode, fd.lSRC);

   WinMessageBox( HWND_DESKTOP, hwnd, szMessage, "File Dialog Result", 
                  IDDLG_MSGBOX_RESULTFILEDLG, MB_MOVEABLE | MB_OK | MB_HELP);

   // on error return error code
   if (!fResult)
      break;

   // hand over result
   ulResult = fd.lReturn;

   } while (FALSE);


// restart bubble help
WtkActivateBubbleHelp( hwndBubbleHelp);
return ulResult;
}

// ---------------------------------------------------------------------

static MRESULT EXPENTRY _MleSubclassProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
         APIRET         rc = NO_ERROR;
         HAB            hab = WinQueryAnchorBlock( HWND_DESKTOP);
static   PFNWP          pfnwpOrgWindowProc = NULL;
static   HWND           hwndMenu = NULLHANDLE;
static   CHAR           szHelpFile[ _MAX_PATH];
static   HWND           hwndBubbleHelp = NULLHANDLE;

if (!pfnwpOrgWindowProc)
   pfnwpOrgWindowProc = WtkGetDefaultWindowProcPtr( hwnd);

switch (msg)
   {
   case WM_USER_INITSUBCLASS:
      {
               ULONG          ulStyle;
               ULONG          ulMleWindowId =  WinQueryWindowUShort( hwnd, QWS_ID);

      // determine helpfile and create help instance
      rc = WtkGetModulePath( (PFN)_MleSubclassProc, szHelpFile, sizeof( szHelpFile));
      if (rc == NO_ERROR)
         strcat( szHelpFile, "\\_pm.hlp");

      // create the help instance
      WtkCreateHelpInstanceWithTable( hwnd, "Help", szHelpFile, NULLHANDLE, MAKEP( 0xFFFF, IDDLG_MAIN));

      // initialize bubble help
      WtkInitializeBubbleHelp( hwnd, NULL, &hwndBubbleHelp);

      // activate and update bubble help
      WtkActivateBubbleHelp( hwndBubbleHelp);
      WtkUpdateBubbleHelp( hwndBubbleHelp, "Press mouse button 2 to\rbring up the context menu.");

      // load basic menu
      hwndMenu = WinLoadMenu( HWND_OBJECT, NULLHANDLE, IDMEN_POPUP);

      // demo usage of WtkInsertMenu
      // insert one menu into existing one
      // (this is helpful when extending the menu of XCenter widgets)
      WtkInsertMenu( hwnd, hwndMenu, IDMEN_DEFFILEDLG, NULLHANDLE, IDMEN_INSERT,
                     WTK_INSERTMENU_TOPSEPARATOR | WTK_INSERTMENU_BOTTOMSEPARATOR);

      // set style of MLE and change font
      WinSendMsg( hwnd, MLM_SETREADONLY, MPFROMLONG( TRUE), 0);
      WinSendMsg( hwnd, MLM_SETSEL, MPFROMLONG( 5), MPFROMLONG( 5));
      WinSendMsg( hwnd, MLM_SETWRAP, MPFROMLONG( TRUE), 0);
      WtkSetWindowFont( hwnd, "9.WarpSans Bold", 0);

      // set MLE content
      WtkAddTextResourceToMLE( WinQueryWindow( hwnd, QW_PARENT),
                               ulMleWindowId, NULLHANDLE, RT_USER_DATAFILE, IDRES_MLETEXT);

      }
      break;

   // -------------------------------------------------------

   case HM_ERROR:
      printf( "HM_ERROR with 0x%08x\n", LONGFROMMP( mp1));
      break;

   // -------------------------------------------------------

   case WM_BUTTON2UP:
      {
               POINTL         ptl;
               ULONG          ulPopupMenuStyle = PU_HCONSTRAIN     | PU_VCONSTRAIN   |
                                                 PU_MOUSEBUTTON1   | PU_MOUSEBUTTON2 |
                                                 PU_MOUSEBUTTON3   | PU_KEYBOARD;

      // popup system menu
      WinQueryPointerPos( HWND_DESKTOP, &ptl);
      WinPopupMenu( HWND_DESKTOP,
                    hwnd,
                    hwndMenu,
                    ptl.x,
                    ptl.y,
                    0,
                    ulPopupMenuStyle);
      }
      break;

   // -------------------------------------------------------

   case WM_INITMENU:
      // don't show bubble help while menu is active
      WtkDeactivateBubbleHelp( hwndBubbleHelp);
      break;

   // -------------------------------------------------------

   case WM_MENUEND:
      // show bubble help again
      WtkActivateBubbleHelp( hwndBubbleHelp);
      break;

   // -------------------------------------------------------

   case WM_COMMAND:
      switch (LONGFROMMP( mp1))
         {
         case IDMEN_DEFNOTEBOOK:
            _launchNotebook( hwnd, hwndBubbleHelp, szHelpFile, TYPE_DEFNOTEBOOK);
            break;

         case IDMEN_OKNOTEBOOK:
            _launchNotebook( hwnd, hwndBubbleHelp, szHelpFile, TYPE_OKNOTEBOOK);
            break;

         case IDMEN_DEFDIRDLG:
            _launchDirDlg( hwnd, hwndBubbleHelp, FALSE, FALSE);
            break;

         case IDMEN_DEFDIRDLGPRELOAD:
            _launchDirDlg( hwnd, hwndBubbleHelp, TRUE, FALSE);
            break;

         case IDMEN_CUSTDIRDLGPRELOAD:
            _launchDirDlg( hwnd, hwndBubbleHelp, TRUE, TRUE);
            break;

         case IDMEN_DEFFILEDLG:
            _launchFileDlg( hwnd, hwndBubbleHelp);
            break;

         case IDMEN_EXIT:
            WinPostMsg( hwnd, WM_QUIT, 0, 0);
            break;

         case IDMEN_ITEM1:
         case IDMEN_ITEM2:
         case IDMEN_ITEM3:
            {
                     CHAR           szMessage[ 127];
            sprintf( szMessage, "Inserted text menu item %u was selected!",
                     LONGFROMMP( mp1) - IDMEN_ITEM1 + 1);
            WinMessageBox( HWND_DESKTOP, hwnd, szMessage,
                           __TITLE__, LONGFROMMP( mp1), MB_MOVEABLE | MB_OK | MB_INFORMATION | MB_HELP);
            }
            break;

         case IDMEN_ITEMBITMAP:
            WinMessageBox( HWND_DESKTOP, hwnd, "Inserted bitmap menu item was selected!",
                           __TITLE__, LONGFROMMP( mp1), MB_MOVEABLE | MB_OK | MB_INFORMATION | MB_HELP);
            break;

         }
      return (MRESULT) TRUE;
      break;

   // -------------------------------------------------------

   case WM_DESTROY:
      if (hwndMenu)
         WinDestroyWindow( hwndMenu);

      WtkDestroyHelpInstance( hwnd);

      if (hwndBubbleHelp)
         {
         WtkDeactivateBubbleHelp( hwndBubbleHelp);
         WtkTerminateBubbleHelp( hwndBubbleHelp);
         }
      break;

   } // switch (msg)

return pfnwpOrgWindowProc( hwnd, msg, mp1, mp2);

}

// -----------------------------------------------------------------------------

int main ( int argc, char *argv[])
{

         APIRET         rc = NO_ERROR;
         BOOL           fResult = FALSE;

         HAB            hab = NULLHANDLE;
         HMQ            hmq = NULLHANDLE;
         QMSG           qmsg;

         HWND           hwndFrame;

         HWND           hwndMle;
         ULONG          ulFrameStyles = FCF_SIZEBORDER | FCF_TITLEBAR | FCF_SYSMENU |
                                        FCF_MINMAX | FCF_TASKLIST | FCF_ACCELTABLE;
         ULONG          ulMLEStyle = 0;
do
   {
   // get PM resources
   if ((hab = WinInitialize( 0)) == NULLHANDLE)
      break;
   if ((hmq = WinCreateMsgQueue( hab, 0)) == NULLHANDLE)
      break;

   // create a standard window with MLE as client
   // so we don't have to deal with drawing issues for this sample
   hwndFrame = WinCreateStdWindow( HWND_DESKTOP, 0, &ulFrameStyles,
                                   WC_MLE, __TITLE__, ulMLEStyle,
                                   0, IDDLG_MAIN,
                                   &hwndMle);
   if (!hwndFrame)
      {
      rc = ERRORIDERROR( WinGetLastError( hab));
      break;
      }

   // set window postition, show later
   WinSetWindowPos( hwndFrame, HWND_TOP, 200, 200, 600, 600,
                    SWP_MOVE | SWP_SIZE | SWP_ZORDER | SWP_ACTIVATE);

   // center window on the desktop, then show
   WtkCenterWindow( hwndFrame, HWND_DESKTOP, 0);
   WinShowWindow( hwndFrame, TRUE);

   // subclass MLE window to get further control
   WinSubclassWindow( hwndMle, _MleSubclassProc);

   // run initialization code of our subclass procedure
   WinPostMsg( hwndMle, WM_USER_INITSUBCLASS, 0, 0);

   // now dispatch messages
   while (WinGetMsg( hab, &qmsg, NULLHANDLE, 0, 0))
      {
      WinDispatchMsg(hab, &qmsg);
      }

   } while (FALSE);

// cleanup
if (hmq) WinDestroyMsgQueue( hmq);
if (hab) WinTerminate( hab);

return rc;
}

