#define INCL_WIN
#define INCL_GPI
#define VERTICES 4

#include <os2.h>
#include <stdlib.h>
#include "savers.h"
#include "demo.h"

HAB habProgram;
int cxMax, cyMax;

#include <gl.h>
#include <glu.h>
#include <math.h>
#include <stdio.h>
#include "aux.h"

GLint fogMode;
PVISUALCONFIG PVisConfig;
int AttrList[] = {PGL_RGBA, PGL_DOUBLEBUFFER, None};
HGC HglContext;
BOOL Init = TRUE;
float t=0.0;

void Setup()
{
  glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_FALSE);
  glDepthMask(GL_FALSE);
  glEnable(GL_CULL_FACE);
}

float verts[][3] = {
  { 0.0, 0.0, (1.0/1.4142)},
  { 0.5, 0.5, 0.0},
  {-0.5, 0.5, 0.0},
  {-0.5,-0.5, 0.0},
  { 0.5,-0.5, 0.0},
  { 0.0, 0.0, -(1.0/1.4142)}
};

float colors[][3] = {
  {1.0, 1.0, 1.0},
  {1.0, 0.0, 0.0},
  {0.0, 1.0, 0.0},
  {0.0, 0.0, 1.0},
  {1.0, 0.0, 1.0},
  {0.0, 1.0, 1.0},
};

MRESULT EXPENTRY __export SaverProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	HPS hps;
    static PFNWP OldSaverProc;

	switch(msg)
	{
		case UM_INIT_SAVER:
			OldSaverProc = (PFNWP)mp2;
			habProgram =WinQueryAnchorBlock(hwnd);
			cxMax = SHORT1FROMMP(mp1);
			cyMax = SHORT2FROMMP(mp1);

			if(PVisConfig = pglChooseConfig(habProgram, AttrList))
			{   
				HglContext = pglCreateContext(habProgram, PVisConfig, NULL, TRUE);
				pglMakeCurrent(habProgram, HglContext, hwnd);
				Setup();
			}
		return((MRESULT)SHAREWARE);                                                                               

		case WM_PAINT:
			if(Init)
			{
      			    glViewport(0, 0, cxMax, cyMax);
					--Init;
			}
			/* This is what is done for every frame of the animation        */
			t += 1.0;
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			glPushMatrix();
			glRotatef(t, 1.0, 1.0, 1.0);
			glBegin(GL_TRIANGLE_FAN);
				glColor3fv(colors[0]);
				glVertex3fv(verts[0]);
				glColor3fv(colors[1]);
				glVertex3fv(verts[1]);
				glColor3fv(colors[2]);
				glVertex3fv(verts[2]);
				glColor3fv(colors[3]);
				glVertex3fv(verts[3]);
				glColor3fv(colors[4]);
				glVertex3fv(verts[4]);
				glColor3fv(colors[1]);
				glVertex3fv(verts[1]);
			glEnd();
			glBegin(GL_TRIANGLE_FAN);
				glColor3fv(colors[5]);
				glVertex3fv(verts[5]);
				glColor3fv(colors[1]);
				glVertex3fv(verts[1]);
				glColor3fv(colors[4]);
				glVertex3fv(verts[4]);
				glColor3fv(colors[3]);
				glVertex3fv(verts[3]);
				glColor3fv(colors[2]);
				glVertex3fv(verts[2]);
      			glVertex3fv(verts[1]);
			glEnd();
			glPopMatrix();
			pglSwapBuffers(habProgram, hwnd);
		return(0);

		
		case UM_KILL_SAVER:
			pglMakeCurrent(habProgram, NULL, None);
			pglDestroyContext(habProgram, HglContext);
			free(PVisConfig);
		return(0);
	}
	return OldSaverProc(hwnd, msg, mp1, mp2);
}


MRESULT EXPENTRY __export SetupProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	WinMessageBox(HWND_DESKTOP, hwnd, "There is nothing to set for this module", "WPSaver", 0, MB_OK|MB_ICONEXCLAMATION);
		if(!WinQueryWindowPtr(hwnd, 0))
			exit(0);
	return WinDefDlgProc(hwnd, msg, mp1, mp2);
}
