#ifndef _GT64_LIB_H_
#define _GT64_LIB_H_

#include "../../../samples/shared/pci_regs.h"
#include "../../../samples/shared/bits.h"

#ifdef __cplusplus
extern "C" {
#endif


// Supported Galileo Chip Sets
typedef enum
{
    GT64_VERSION_64111,
    GT64_VERSION_64120,
    GT64_VERSION_64130
} GT64_VERSION;


// GalileoT 64XXX register definitions 
enum {
    // CPU/Local Master Interface
    GT64_CPU_TO_LOCAL_MASTER_INTERFACE_CONFIGURATION = 0x000,
    GT64_MULTI_GT_REGISTER                           = 0x120,   // apply only for 64120, 64130
    // Processor Address Space
    GT64_RAS_1_0_LOW_DECODE_ADDRESS             = 0x008,
    GT64_RAS_1_0_HIGH_DECODE_ADDRESS            = 0x010,
    GT64_RAS_3_2_LOW_DECODE_ADDRESS             = 0x018,
    GT64_RAS_3_2_HIGH_DECODE_ADDRESS            = 0x020,
    GT64_CS_2_0_LOW_DECODE_ADDRESS              = 0x028,
    GT64_CS_2_0_HIGH_DECODE_ADDRESS             = 0x030,
    GT64_CS_3_BOOT_CS_LOW_DECODE_ADDRESS        = 0x038,
    GT64_CS_3_BOOT_CS_HIGH_DECODE_ADDRESS       = 0x040,
    GT64_PCI_IO_LOW_DECODE_ADDRESS              = 0x048,
    GT64_PCI_IO_HIGH_DECODE_ADDRESS             = 0x050,
    GT64_PCI_MEMORY_0_LOW_DECODE_ADDRESS        = 0x058,
    GT64_PCI_MEMORY_0_HIGH_DECODE_ADDRESS       = 0x060,
    GT64_INTERNAL_SPACE_DECODE                  = 0x068,
    GT64_BUS_ERROR_ADDRESS_LOW_PROCESSOR        = 0x070,
    GT64_READ_ONLY_0                            = 0x078,
    GT64_PCI_MEMORY_1_LOW_DECODE_ADDRESS        = 0x080,
    GT64_PCI_MEMORY_1_HIGH_DECODE_ADDRESS       = 0x088,
    // The following applies for 64120, 64130
    GT64_PCI_1_IO_LOW_DECODE_ADDRESS            = 0x090,
    GT64_PCI_1_IO_HIGH_DECODE_ADDRESS           = 0x098,
    GT64_PCI_1_MEMORY_0_LOW_DECODE_ADDRESS      = 0x0a0,
    GT64_PCI_1_MEMORY_0_HIGH_DECODE_ADDRESS     = 0x0a8,
    GT64_PCI_1_MEMORY_1_LOW_DECODE_ADDRESS      = 0x0b0,
    GT64_PCI_1_MEMORY_1_HIGH_DECODE_ADDRESS     = 0x0b8,
    GT64_SCS_1_0_ADDRESS_REMAP                  = 0x0d0,
    GT64_SCS_3_2_ADDRESS_REMAP                  = 0x0d8,
    GT64_CS_2_0_REMAP                           = 0x0e0,
    GT64_CS_3_BOOT_CS_REMAP                     = 0x0e8,
    GT64_PCI_0_IO_REMAP                         = 0x0f0,
    GT64_PCI_0_MEMORY_0_REMAP                   = 0x0f8,
    GT64_PCI_0_MEMORY_1_REMAP                   = 0x100,
    GT64_PCI_1_IO_REMAP                         = 0x108,
    GT64_PCI_1_MEMORY_0_REMAP                   = 0x110,
    GT64_PCI_1_MEMORY_1_REMAP                   = 0x118,
    // CPU Sync Barrier - applies for 64120, 64130
    GT64_PCI_0_SYNC_BARRIER_VIRTUAL_REGISTER    = 0x0c0,
    GT64_PCI_1_SYNC_BARRIER_VIRTUAL_REGISTER    = 0x0c8,
    // DRAM and Device Address Space
    GT64_RAS_0_LOW_DECODE_ADDRESS               = 0x400,
    GT64_RAS_0_HIGH_DECODE_ADDRESS              = 0x404,
    GT64_RAS_1_LOW_DECODE_ADDRESS               = 0x408,
    GT64_RAS_1_HIGH_DECODE_ADDRESS              = 0x40c,
    GT64_RAS_2_LOW_DECODE_ADDRESS               = 0x410,
    GT64_RAS_2_HIGH_DECODE_ADDRESS              = 0x414,
    GT64_RAS_3_LOW_DECODE_ADDRESS               = 0x418,
    GT64_RAS_3_HIGH_DECODE_ADDRESS              = 0x41c,
    GT64_CS_0_LOW_DECODE_ADDRESS                = 0x420,
    GT64_CS_0_HIGH_DECODE_ADDRESS               = 0x424,
    GT64_CS_1_LOW_DECODE_ADDRESS                = 0x428,
    GT64_CS_1_HIGH_DECODE_ADDRESS               = 0x42c,
    GT64_CS_2_LOW_DECODE_ADDRESS                = 0x430,
    GT64_CS_2_HIGH_DECODE_ADDRESS               = 0x434,
    GT64_CS_3_LOW_DECODE_ADDRESS                = 0x438,
    GT64_CS_3_HIGH_DECODE_ADDRESS               = 0x43c,
    GT64_BOOT_CS_LOW_DECODE_ADDRESS             = 0x440,
    GT64_BOOT_CS_HIGH_DECODE_ADDRESS            = 0x444,
    GT64_Address_Decode_Error                   = 0x470,
    // DRAM Configuration
    GT64_DRAM_CONFIGURATION                     = 0x448,
    // The following applies for 64120,64130
    GT64_SDRAM_OPERATION_MODE                   = 0x474,
    GT64_SDRAM_BURST_MODE                       = 0x478,
    GT64_SDRAM_ADDRESS_DECODE                   = 0x47c,
    // DRAM Parameters
    GT64_DRAM_BANK0_PARAMETERS                  = 0x44c,
    GT64_DRAM_BANK1_PARAMETERS                  = 0x450,
    GT64_DRAM_BANK2_PARAMETERS                  = 0x454,
    GT64_DRAM_BANK3_PARAMETERS                  = 0x458,
    // Device Parameters
    GT64_DEVICE_BANK0_PARAMETERS                = 0x45c,
    GT64_DEVICE_BANK1_PARAMETERS                = 0x460,
    GT64_DEVICE_BANK2_PARAMETERS                = 0x464,
    GT64_DEVICE_BANK3_PARAMETERS                = 0x468,
    GT64_DEVICE_BOOT_BANK_PARAMETERS            = 0x46c,
    // ECC - applies for 64130
    GT64_ECC_UPPER_DATA                         = 0x480,
    GT64_ECC_LOWER_DATA                         = 0x484,
    GT64_ECC_FROM_MEMORY                        = 0x488,
    GT64_ECC_CALCULATED                         = 0x48c,
    GT64_ECC_ERROR_REPORT                       = 0x490,
    // DMA Record
    GT64_CHANNEL_0_DMA_BYTE_COUNT               = 0x800,
    GT64_CHANNEL_1_DMA_BYTE_COUNT               = 0x804,
    GT64_CHANNEL_2_DMA_BYTE_COUNT               = 0x808,
    GT64_CHANNEL_3_DMA_BYTE_COUNT               = 0x80c,
    GT64_CHANNEL_0_DMA_SOURCE_ADDRESS           = 0x810,
    GT64_CHANNEL_1_DMA_SOURCE_ADDRESS           = 0x814,
    GT64_CHANNEL_2_DMA_SOURCE_ADDRESS           = 0x818,
    GT64_CHANNEL_3_DMA_SOURCE_ADDRESS           = 0x81c,
    GT64_CHANNEL_0_DMA_DESTINATION_ADDRESS      = 0x820,
    GT64_CHANNEL_1_DMA_DESTINATION_ADDRESS      = 0x824,
    GT64_CHANNEL_2_DMA_DESTINATION_ADDRESS      = 0x828,
    GT64_CHANNEL_3_DMA_DESTINATION_ADDRESS      = 0x82c,
    GT64_CHANNEL_0_NEXT_RECORD_POINTER          = 0x830,
    GT64_CHANNEL_1_NEXT_RECORD_POINTER          = 0x834,
    GT64_CHANNEL_2_NEXT_RECORD_POINTER          = 0x838,
    GT64_CHANNEL_3_NEXT_RECORD_POINTER          = 0x83c,
    // The following applies for 64120, 64130
    GT64_CHANNEL_0_CURRENT_DESCRIPTOR_POINTER   = 0x870,
    GT64_CHANNEL_1_CURRENT_DESCRIPTOR_POINTER   = 0x874,
    GT64_CHANNEL_2_CURRENT_DESCRIPTOR_POINTER   = 0x878,
    GT64_CHANNEL_3_CURRENT_DESCRIPTOR_POINTER   = 0x87c,
    // DMA Channel Control
    GT64_CHANNEL_0_CONTROL                      = 0x840,
    GT64_CHANNEL_1_CONTROL                      = 0x844,
    GT64_CHANNEL_2_CONTROL                      = 0x848,
    GT64_CHANNEL_3_CONTROL                      = 0x84c,
    // DMA Arbiter
    GT64_ARBITER_CONTROL                        = 0x860,
    // Timer Counter
    GT64_TIMER_COUNTER_0                        = 0x850,
    GT64_TIMER_COUNTER_1                        = 0x854,
    GT64_TIMER_COUNTER_2                        = 0x858,
    GT64_TIMER_COUNTER_3                        = 0x85c,
    GT64_TIMER_COUNTER_CONTROL                  = 0x864,
    // PCI Internal
    GT64_PCI_0_COMMAND                          = 0xc00,
    GT64_PCI_0_TIME_OUT_RETRY                   = 0xc04,
    GT64_PCI_0_RAS_1_0_BANK_SIZE                = 0xc08,
    GT64_PCI_0_RAS_3_2_BANK_SIZE                = 0xc0c,
    GT64_PCI_0_CS_2_0_BANK_SIZE                 = 0xc10,
    GT64_PCI_0_CS_3_BOOT_CS_BANK_SIZE           = 0xc14,
    GT64_PCI_0_BASE_ADDRESS_REGISTERS_ENABLE    = 0xc3c,
    GT64_PCI_0_CONFIGURATION_ADDRESS            = 0xcf8,
    GT64_PCI_0_CONFIGURATION_DATA               = 0xcfc,
    // The following applies for 64120, 64130
    GT64_PCI_1_COMMAND                          = 0xc80,
    GT64_PCI_1_TIME_OUT_RETRY                   = 0xc84,
    GT64_PCI_1_RAS_1_0_BANK_SIZE                = 0xc88,
    GT64_PCI_1_RAS_3_2_BANK_SIZE                = 0xc8c,
    GT64_PCI_1_CS_2_0_BANK_SIZE                 = 0xc90,
    GT64_PCI_1_CS_3_BOOT_CS_BANK_SIZE           = 0xc94,
    GT64_PCI_1_BASE_ADDRESS_REGISTERS_ENABLE    = 0xcbc,
    GT64_PCI_0_PREFETCH_MAX_BURST_SIZE          = 0xc40,
    GT64_PCI_1_PREFETCH_MAX_BURST_SIZE          = 0xcc0,
    GT64_PCI_0_SCS_1_0_BASE_ADDRESS_REMAP       = 0xc48,
    GT64_PCI_1_SCS_1_0_BASE_ADDRESS_REMAP       = 0xcc8,
    GT64_PCI_0_SCS_3_2_BASE_ADDRESS_REMAP       = 0xc4c,
    GT64_PCI_1_SCS_3_2_BASE_ADDRESS_REMAP       = 0xccc,
    GT64_PCI_0_CS_2_0_BASE_ADDRESS_REMAP        = 0xc50,
    GT64_PCI_1_CS_2_0_BASE_ADDRESS_REMAP        = 0xcd0,
    GT64_PCI_0_CS_3_BOOT_CS_ADDRESS_REMAP       = 0xc54,
    GT64_PCI_1_CS_3_BOOT_CS_ADDRESS_REMAP       = 0xcd4,
    GT64_PCI_0_SWAPPED_SCS_1_0_BASE_ADDRESS_REMAP       = 0xc58,
    GT64_PCI_1_SWAPPED_SCS_1_0_BASE_ADDRESS_REMAP       = 0xcd8,
    GT64_PCI_0_SWAPPED_SCS_3_2_BASE_ADDRESS_REMAP       = 0xc5c,
    GT64_PCI_1_SWAPPED_SCS_3_2_BASE_ADDRESS_REMAP       = 0xcdc,
    GT64_PCI_0_SWAPPED_CS_3_BOOTCS_BASE_ADDRESS_REMAP   = 0xc64,
    GT64_PCI_1_SWAPPED_CS_3_BOOTCS_BASE_ADDRESS_REMAP   = 0xce4,
    GT64_PCI_1_CONFIGURATION_ADDRESS                    = 0xcf0,
    GT64_PCI_1_CONFIGURATION_DATA                       = 0xcf4,
    GT64_PCI_1_INTERRUPT_ACKNOWLEDGE_VIRTUAL_REGISTER   = 0xc30,
    // Interrupts
    GT64_INTERRUPT_CAUSE                        = 0xc18,
    GT64_CPU_TO_LOCAL_MASTER_MASK               = 0xc1c,
    GT64_PCI_0_MASK                             = 0xc24,
    GT64_PCI_0_SERR_MASK                        = 0xc28,  
    GT64_INTERRUPT_ACKNOWLEDGE                  = 0xc34,  
    // The following applies for 64120, 64130
    GT64_HIGH_INTERRUPT_CAUSE_REGISTER          = 0xc98,
    GT64_CPU_HIGH_INTERRUPT_MASK_REGISTER       = 0xc9c,
    GT64_PCI_0_HIGH_INTERRUPT_CAUSE_MASK_REGISTER = 0xca4,
    GT64_PCI_1_SERR1_MASK                       = 0xca8,
    GT64_CPU_SELECT_CAUSE_REGISTER              = 0xc70,
    GT64_PCI_0_INTERRUPT_SELECT_REGISTER        = 0xc74
};

typedef struct {
    DWORD AddControl:2;   // BITS 1:0
    DWORD SrcDir:2;       // BITS 3:2
    DWORD DstDir:2;       // BITS 5:4
    DWORD DataTransLim:3; // BITS 8:6
    DWORD ChainMod:1;     // BIT 9
    DWORD IntMode:1;      // BIT 10
    DWORD TransMod:1;     // BIT 11
    DWORD ChanEn:1;       // BIT 12
    DWORD FetNexRec:1;    // BIT 13
    DWORD DMAActSt:1;     // BIT 14
    DWORD Reserved:17;    // BITS 31:15
} GT64_BITS_DMA_CHANNEL_CONTROL;


// DMA
enum { GT64_DMA_CHANNEL_SHIFT = 0x4 }; // shift in address between channels of DMA

typedef enum
{
    GT64_DMA_CHANNEL_0 = 0,
    GT64_DMA_CHANNEL_1 = 1,
    GT64_DMA_CHANNEL_2 = 2,
    GT64_DMA_CHANNEL_3 = 3
} GT64_DMA_CHANNEL;

typedef struct {
    WD_DMA dma;
    WD_DMA dmaList;
    GT64_DMA_CHANNEL dmaChannel;
    DWORD dwDmaControl;
} GT64_DMA_STRUCT, *GT64_DMA_HANDLE;

typedef enum
{
    GT64_DAT_TRANS_LIM_1_BYTE = BIT8 | BIT6,
    GT64_DAT_TRANS_LIM_2_BYTES = BIT8 | BIT7,
    GT64_DAT_TRANS_LIM_4_BYTES = 0,
    GT64_DAT_TRANS_LIM_8_BYTES = BIT6,
    GT64_DAT_TRANS_LIM_16_BYTES = BIT7 | BIT6,
    GT64_DAT_TRANS_LIM_32_BYTES = BIT8 | BIT7 | BIT6,
} GT64_DAT_TRANS_LIM;


// Address spaces
typedef enum
{
    GT64_ADDR_BAR0  = AD_PCI_BAR0,
    GT64_ADDR_BAR1  = AD_PCI_BAR1,
    GT64_ADDR_BAR2  = AD_PCI_BAR2,
    GT64_ADDR_BAR3  = AD_PCI_BAR3,
    GT64_ADDR_BAR4  = AD_PCI_BAR4,
    GT64_ADDR_BAR5  = AD_PCI_BAR5
} GT64_ADDR;

#define GT64_ADDR_REG GT64_ADDR_BAR4
#define GT64_ADDR_REG_IO GT64_ADDR_BAR5

enum { GT64_RANGE_REG = 0x00000080 };

typedef struct GT64_STRUCT *GT64_HANDLE;


// Interrupts
typedef struct
{
    DWORD dwCounter;   // number of interrupts received
    DWORD dwLost;      // number of interrupts not yet dealt with
    BOOL fStopped;     // was interrupt disabled during wait?
    DWORD dwStatusReg; // value of status register when interrupt occured
} GT64_INT_RESULT;
typedef void (WINAPI *GT64_INT_HANDLER)( GT64_HANDLE hGT, GT64_INT_RESULT *intResult);

typedef struct
{
    WD_INTERRUPT Int;
    HANDLE hThread;
    WD_TRANSFER Trans[2];
    GT64_INT_HANDLER funcIntHandler;
} GT64_INTERRUPT;


// Address Description
typedef struct 
{
    DWORD dwMask;
    DWORD dwBytes;
    DWORD dwAddr;
    DWORD dwAddrDirect;
    BOOL  fIsMemory;
} GT64_ADDR_DESC;


// 64XXX Card structure
typedef struct GT64_STRUCT
{
    HANDLE hWD;
    WD_PCI_SLOT pciSlot;
    WD_CARD_REGISTER cardReg;
    GT64_ADDR_DESC addrDesc[AD_PCI_BARS];
    BOOL   fUseInt;
    GT64_INTERRUPT Int;
    GT64_VERSION gt64Ver;
} GT64_STRUCT;

enum { GT64_OPEN_USE_INT =   0x1 }; // options for GT64_Open 



/////////////////////
// 64XXX Functions //
/////////////////////

// General
DWORD GT64_CountCards (DWORD dwVendorID, DWORD dwDeviceID);

BOOL GT64_Open (GT64_HANDLE *phGT, GT64_VERSION gt64Ver, DWORD dwVendorID, 
                DWORD dwDeviceID, DWORD nCardNum, DWORD dwOptions);
void GT64_Close (GT64_HANDLE hGT);

BOOL GT64_IsAddrSpaceActive(GT64_HANDLE hGT, GT64_ADDR addrSpace);


// Read / Write functions
void GT64_ReadBlock (GT64_HANDLE hGT, DWORD dwOffset, PVOID buf, 
                    DWORD dwBytes, GT64_ADDR addrSpace);
void GT64_WriteBlock (GT64_HANDLE hGT, DWORD dwOffset, PVOID buf, 
                     DWORD dwBytes, GT64_ADDR addrSpace);
DWORD GT64_ReadDWord (GT64_HANDLE hGT, GT64_ADDR addrSpace, DWORD dwOffset);
void GT64_WriteDWord (GT64_HANDLE hGT, GT64_ADDR addrSpace, DWORD dwOffset, DWORD data);


// interrupt functions
BOOL GT64_IntIsEnabled (GT64_HANDLE hGT);
BOOL GT64_IntEnable (GT64_HANDLE hGT, GT64_INT_HANDLER funcIntHandler);
void GT64_IntDisable (GT64_HANDLE hGT);


// Register Access
DWORD GT64_ReadReg (GT64_HANDLE hGT, DWORD dwReg);
void GT64_WriteReg (GT64_HANDLE hGT, DWORD dwReg, DWORD dwData);


// PCI configuration registers Access
DWORD GT64_ReadPCIReg(GT64_HANDLE hGT, DWORD dwReg);
void GT64_WritePCIReg(GT64_HANDLE hGT, DWORD dwReg, DWORD dwData);


//      DMA
//
// Start DMA to/from card.
// dwLocalAddr - local address on card to write to / read from
// buf - the buffer to transfer
// dwBytes - number of bytes to transfer (must be a multiple of 4)
// fIsRead - TRUE: read from card to buffer.  FALSE: write from buffer to card
// lim_mode - local bus width.
// fmaChannel - uses channel 0-3 of the GT-64XXX
GT64_DMA_HANDLE GT64_DMAOpen (GT64_HANDLE hGT, DWORD dwLocalAddr, PVOID buf, DWORD dwBytes,
    BOOL fIsRead, GT64_DAT_TRANS_LIM lim_mode, GT64_DMA_CHANNEL dmaChannel);
void GT64_DMAStart (GT64_HANDLE hGT, GT64_DMA_HANDLE hDma, BOOL fBlocking);
void GT64_DMAClose (GT64_HANDLE hGT, GT64_DMA_HANDLE hDma);
BOOL GT64_DMAIsDone (GT64_HANDLE hGT, GT64_DMA_HANDLE hDma);
BOOL GT64_DMAReadWriteBlock (GT64_HANDLE hGT, GT64_ADDR addrSpace, DWORD dwLocalAddrOffset, PVOID buf, 
    DWORD dwBytes, BOOL fIsRead, GT64_DAT_TRANS_LIM lim_mode, GT64_DMA_CHANNEL dmaChannel);


// Errors
extern CHAR GT64_ErrorString[]; // This string is set to an error message, if one occurs


#ifdef __cplusplus
}
#endif

#endif
