////////////////////////////////////////////////////////////////
// File - PCI_DUMP.C
//
// A utility for getting a dump of all the PCI configuration
// registers of the PCI cards installed.
// 
////////////////////////////////////////////////////////////////

#include "../../include/windrvr.h"
#include "../shared/pci_diag_lib.h"
#include <stdio.h>

int main (int argc, char *argv[]) 
{
    HANDLE hWD;
    char buf[256];
    WORD *pVendorID = (WORD *) buf;
    WORD *pDeviceID = (WORD *) (buf+2);
    WD_PCI_CONFIG_DUMP pciCnf;
    int g;

    if (!PCI_Get_WD_handle(&hWD)) return 0;

    BZERO(pciCnf);
    pciCnf.pBuffer = buf;
    pciCnf.dwOffset = 0;
    pciCnf.dwBytes = 256;
    pciCnf.fIsRead = TRUE;
    printf ("pci bus scan (using WD_PciConfigDump)\n");

    for (pciCnf.pciSlot.dwBus=0; pciCnf.pciSlot.dwBus<256; pciCnf.pciSlot.dwBus++)
    {
        for (pciCnf.pciSlot.dwSlot=0; pciCnf.pciSlot.dwSlot<32; pciCnf.pciSlot.dwSlot++)
        {
            for (pciCnf.pciSlot.dwFunction=0; pciCnf.pciSlot.dwFunction<8; pciCnf.pciSlot.dwFunction++)
            {
                CHAR tmp[100];
                *pDeviceID = 0xffff;
                *pVendorID = 0xffff;
                WD_PciConfigDump(hWD,&pciCnf);
                if (*pDeviceID==0xffff)
                    break; // skip slot
                    
                printf("Bus %d Slot %d Function %d, VendorID %04x DeviceID %04x\n",
                    pciCnf.pciSlot.dwBus, pciCnf.pciSlot.dwSlot, pciCnf.pciSlot.dwFunction, *pVendorID, *pDeviceID);
                for (g=0; g<256; g+=4)
                {
                    if ((g/4) %    8 == 0) printf("%2x ",g);
                    printf ("%08x ",*((DWORD *) (buf+g)));
                    if ((g/4) %    8 == 7) printf("\n");
                }

                PCI_Print_card_info(pciCnf.pciSlot);
                printf("Press Enter to continue to next slot\n");
                gets (tmp);
            }
        }
    }

    WD_Close(hWD);

    return 0;
}

