/****************************************************
 *      Copyright (c) IBM Corporation, 1994         *
 *              All Rights Reserved                 *
 ****************************************************
 *                                                  *
 *               32 bit Games Installation          *
 *   HISTORY:                                       *
 *   Version 1.0  20 Dec 94 - Doug Azzarito         *
 ****************************************************/

   '@echo off'
   trace off
   PARSE VALUE 1 0 WITH True False .

   /* Load in function library */

   Call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
   Call SysLoadFuncs

   /* Tell the user what we're doing */

   Say 'Ĵ OS/2 32-bit Game Installation Ŀ'
   Say ' This program will replace the Klondike and Chess games '
   Say ' with updated, 32-bit versions of these games.  The old '
   Say ' versions will be erased.                               '
   Say ''
   Say 'Do you wish to continue? (Y or N)'
   PARSE PULL Answer

   if (TRANSLATE(LEFT(Answer,1)) \='Y') then
     do
       Say 'Install cancelled at your request.'
       exit
     end

   /* Parse Call Path Info (ignore OS/2 and call type, just get path */

   Parse Source . . callPath

   /* Strip program name, leaving source path */

   rcp = REVERSE(callPath)
   SrcPath = REVERSE(substr(rcp,POS("\",rcp)+1))

   /* Define list of files to be copied and deleted */

   PgmFiles. = ""
   PgmFiles.0 = 5
   PgmFiles.1 = "OS2CHESS.EXE"
   PgmFiles.2 = "KLONDIKE.EXE"
   PgmFiles.3 = "OS2CHESS.BIN"
   PgmFiles.4 = "CARDSYM.FON"
   PgmFiles.5 = "GAMEREAD.ME"

   DllFiles. = ""
   DllFiles.0 = 1
   DllFiles.1 = "CHESSAI.DLL"

   HlpFiles. = ""
   HlpFiles.0 = 2
   HlpFiles.1 = "OS2CHESS.HLP"
   HlpFiles.2 = "KLONDIKE.HLP"

   DelFiles. = ""
   DelFiles.0 = 3
   DelFiles.1 = "DLL\KLONBGA.DLL"
   DelFiles.2 = "KLONDIKE.INI"
   DelFiles.3 = "OS2CHESS.INI"

   /* find "OS2\APPS" in path, to see what drive the apps are on */

   PathStr = TRANSLATE(VALUE("PATH",,"OS2ENVIRONMENT"))
   InsPathPos = POS(":\OS2\APPS;",PathStr)
   if (InsPathPos \= 0) then
     do
       InsPath = Substr(PathStr,InsPathPos-1,11)

       /* Make sure this guy exists - create if not.*/

       rc = SysFileTree(InsPath,"dirfind","DO")
       if (dirfind.0 = 0) then
         do
           rc = SysMkDir(InsPath)
           if rc \= 0 then
             do
               Say 'ERROR: The target directory, 'InsPath' could not be created.'
               Say '       Installation is aborted.'
               Call Done
             end
         end          /* end if dirfind.0 = 0 */
     end              /* end if InsPathPos \=0 */
   else do
   /* \OS2\APPS is a required path directory! */

     Say 'ERROR: The PATH statement does not include "\OS2\APPS."'
     Say '       OS/2 Installation creates this directory and places it in the'
     Say '       PATH environment (in CONFIG.SYS) when you install the original'
     Say '       OS/2 game applets.  To correct this error, use "Selective Install"'
     Say '       to install the original OS/2 game applets.  Then retry this'
     Say '       installation.'
     call Done
   end

   /* Look for a \DLL subdirectory inside the APPS subdirectory */

   rc = SysFileTree(InsPath||"\DLL","dirfind","DO")
   if (dirfind.0 = 1) then
     do
       InsDllPath = dirfind.1
     end
   else do
     Say 'ERROR: The directory "\OS2\APPS\DLL" was not found.'
     Say '       OS/2 Installation creates this directory and places it in the'
     Say '       LIBPATH environment (in CONFIG.SYS) when you install the original'
     Say '       OS/2 game applets.  To correct this error, use "Selective Install"'
     Say '       to install the original OS/2 game applets.  Then retry this'
     Say '       installation.'
     call Done
   end

   /* Look for \OS2\HELP in the HELP environment variable */

  HelpWarn = False
   PathStr = TRANSLATE(VALUE("HELP",,"OS2ENVIRONMENT"))
   HlpPathPos = POS(":\OS2\HELP;",PathStr)
   if (HlpPathPos \= 0) then
     do
       InsHlpPath = Substr(PathStr,HlpPathPos-1,11)
       /* Make sure this guy exists - create if not.*/

       rc = SysFileTree(InsHlpPath,"dirfind","DO")
       if (dirfind.0 = 0) then
         do
           rc = SysMkDir(InsHlpPath)
           if rc \= 0 then
             do
               Say 'ERROR: The target directory, 'InsHlpPath' could not be created.'
               Say '       Installation is aborted.'
               Call Done
             end
         end          /* end if dirfind.0 = 0 */
     end              /* end if HlpPathPos \=0 */
   else do
     InsHlpPath = InsPath            /* Put HELP in pgm directory */

     Say 'WARNING: The HELP statement does not include "\OS2\HELP."'
     Say '         OS/2 installation creates the \OS2\HELP subdirectory, and adds'
     Say '         a SET HELP statement to CONFIG.SYS.  All standard help files'
     Say '         (including the original game help files) should be here.'
     Say '         The new HELP files will be placed in 'InsHlpPath'.  You should'
     Say '         either move them to a directory in your HELP path, or add'
     Say '         'InsHlpPath' to your HELP path.  Your current HELP path is:'
     Say PathStr
     Say ''
     HelpWarn = True
   end

   /* Verify Source Files */

   do i = 1 to PgmFiles.0
     rc = VerifySourcePath( SrcPath||'\'||PgmFiles.i )
     if ( rc == 1 ) then
       call Done
   end

   do i = 1 to DllFiles.0
     rc = VerifySourcePath( SrcPath||'\'||DllFiles.i )
     if ( rc == 1 ) then
       call Done
   end

   do i = 1 to HlpFiles.0
     rc = VerifySourcePath( SrcPath||'\'||HlpFiles.i )
     if ( rc == 1 ) then
       call Done
   end

   /* Copy files
   */
   do i = 1 to PgmFiles.0
     success = CopyFiles(PgmFiles.i, SrcPath, InsPath)
     if ( success \= 0 ) then
       call Done
   end

   do i = 1 to DllFiles.0
     success = CopyFiles(DllFiles.i, SrcPath, InsDllPath)
     if ( success \= 0 ) then
       call Done
   end

   do i = 1 to HlpFiles.0
     success = CopyFiles(HlpFiles.i, SrcPath, InsHlpPath, HelpWarn)
     if ( success \= 0 ) then
       call Done
   end

   do i = 1 to DelFiles.0
     success = DeleteFiles(DelFiles.i, InsPath)
   end

   if (success == 0) then
     call UpdateWPShell InsPath

   Say '32-bit game installation complete.'
Done:
   exit

/* Procedures and Functions
*/

VerifySourcePath: Procedure

   Parse Arg file;

   fExists = Stream(file,'c','query exists')
   if (fExists == "")
     then do
       Say 'ERROR: The file 'file' does not exist.'
       Say '       This file is required to install the 32-bit games.'
       Say '       To correct this error, place ALL 32-bit game files in the same'
       Say '       directory and restart this installation.'
       return 1
     end

return 0

CopyFiles: Procedure expose True False

   Parse Arg FileName, SrcPath, TargetPath, Warning;

   copystr = SrcPath||"\"||FileName||" "||TargetPath||" > nul 2>&1"
   If (Warning = True) then
     MsgStr = ' copied.  (should be in the HELP path)'
   else
     MsgStr = ' copied.'

   'copy 'copystr

   if (rc \= 0) then
     do
       Say 'ERROR: Could not copy 'FileName' from'
       Say '       'SrcPath' to 'TargetPath'.'
       Say '       Installation is aborted.'
       return 1
     end
     else Say TargetPath||"\"||FileName||msgstr

return 0

DeleteFiles: Procedure

   Parse Arg FileName, SrcPath;

   delstr = SrcPath||"\"||FileName||" > nul 2>&1"

   'del 'delstr

   if (rc = 0) then
       Say SrcPath||"\"||FileName' deleted.'

return 0

UpdateWPShell: Procedure

   Parse Arg InsPath;

  /* delete the ORIGINAL games if they exist */

   Say 'Deleting old program objects'
   rc = SysDestroyObject("<WP_KLDK>")
   rc = SysDestroyObject("<WP_CHESS>")

   /* Create Program Object in the "Games" Folder */
   pgmpath   = InsPath||'\OS2CHESS.EXE'
   classname = 'WPProgram'
   title     = '32-Bit Chess'
   location  = '<WP_GAMES>'
   setup     = 'OBJECTID=<WP_CHESS_32>;'||,
               'EXENAME='||pgmpath||';'||,
               'PROGTYPE=PM;'

   Say 'Creating 32-bit Chess object'
   rc = SysCreateObject(classname, title, location, setup, 'replace')

   pgmpath   = InsPath||'\KLONDIKE.EXE'
   classname = 'WPProgram'
   title     = '32-Bit Solitaire'
   location  = '<WP_GAMES>'
   setup     = 'OBJECTID=<WP_KLDK_32>;'||,
               'EXENAME='||pgmpath||';'||,
               'PROGTYPE=PM;'

   Say 'Creating 32-bit Solitaire object'
   rc = SysCreateObject(classname, title, location, setup, 'replace')

   pgmpath   = InsPath||'\GAMEREAD.ME'
   classname = 'WPShadow'
   title     = 'GAMEREAD.ME'
   location  = '<WP_GAMES>'
   setup     = 'OBJECTID=<WP_GAMEREAD>;'||,
               'SHADOWID='||pgmpath||';'

   Say 'Creating Read-Me object'
   rc = SysCreateObject(classname, title, location, setup, 'replace')

   /* Open "Games" Folder
   */
   object    = '<WP_GAMES>'
   setup     = 'OPEN=DEFAULT'

   rc = SysSetObjectData(object, setup)

return

