#ifndef BUILDQUEUE_H
#define BUILDQUEUE_H

#include <algorithm>
#include <vector>
#include "actioneventqueue.h"
#include "common.h"

class UnitOrStructure;
class UnitOrStructureType;
class Player;

namespace BuildQueue {
typedef std::pair<UnitOrStructureType*, Uint8> buildorder;

class BQEvent : public ActionEvent {
public:
    BQEvent(Player* p);
    ~BQEvent();

    bool add(UnitOrStructureType* type);
    ConStatus pausecancel(UnitOrStructureType* type);
    void run();

    ConStatus getStatus(UnitOrStructureType* type, Uint8* quantity, Uint8* progress) const;

    void placed();

    const UnitOrStructureType* getCurrentType() const {return queue.front().first;}
private:
    void next();
    enum RQstate {RQ_DONE, RQ_NEW, RQ_MAXED};
    RQstate requeue(UnitOrStructureType* type);

    Player *player;
    Uint32 last, left;
    ConStatus status;

    // I don't know whether a vector is the right type here -- nap
    // Given that we're mostly inserting / deleting from the front and end, a
    // dequeue might be better. -- zx64
    /// @TODO Try using a dequeue.
    typedef std::vector<buildorder> Queue;
    Queue queue;
};

} /* namespace BuildQueue */

#endif /* BUILDQUEUE_H */
