#ifndef MONEYCOUNTER_H
#define MONEYCOUNTER_H
#include "actioneventqueue.h"

class MoneyCounter : public ActionEvent {
public:
    MoneyCounter(Sint32* money, bool sound) : ActionEvent(1), money(*money),
           sound(sound), queued(false), creditleft(0), debitleft(0),
           creditsound(-1), debitsound(-1) {}
    void run();
    void addCredit(Uint32 amount);
    void addDebit(Uint32 amount);
private:
    static const Uint8 delta = 5;

    Sint32& money;
    bool sound;
    bool queued;
    // Seperate because we want both credit and debit sounds being played
    Uint32 creditleft, debitleft;
    Sint32 creditsound, debitsound;

    Uint8 step(Uint32& value);

    void reshedule();
};
#endif /* MONEYCOUNTER_H */
