! MOVECLASS, a library file to provide movement for NPCs, whether random or
! directed.
!
! Version 7.5, written by Neil Brown-> neil@highmount.demon.co.uk
!
! Last altered 24 January 1998.
!
! Developed on an Acorn. Some weaker PC text editors (eg Notepad) don't like
! the fact that lines aren't terminated in exactly the same way as on PCs.
!
! The functions of this library are too complex to go into here, so please
! refer to the brief manual which should be near to where you found this
! file, and is named 'moveman.txt'.
!
! If you are including the library file FOLLOWER.H in your game code, please
! include this file AFTERWARDS and not before, otherwise errors will occur.

System_file;

Attribute explored;
Attribute blocked;
Property  npc_open;
Property  after_action;
Property  before_action;
Global    path_size_limit = 10;
Array best_path -> 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0;

Message "!! Compiling library extension MoveClass !!";

Class Room
  with number 0;

Class moveclass
  with walkoff "walks off",
       walkon "walks into the room",
       time_left 0,
       daemon
        [ p i n k j st sr tr tmp;
          if (self provides before_action) self.before_action();
          switch(self.move_type)
          { 0: ! Random movement
#ifdef DEBUG;
              if (parser_trace>1) print "Started first daemon section.^";
#endif;
              if (random(3)~=1) rfalse;
              p=parent(self);
              objectloop (i in compass)
              { j=p.(i.door_dir);
                if (ZRegion(j)==1 || ZRegion(j)==2) n++;
              }
              if (n==0) rfalse;
              k=random(n); n=0;
              objectloop (i in compass)
              { j=p.(i.door_dir);
                if (ZRegion(j)==1 || ZRegion(j)==2) n++;
                if (n==k)
                { if (ZRegion(j)==2) ! deal with it if it points to a routine
                  { tmp=j();
                    if (ZRegion(tmp)~=1) rfalse; ! can't get an object
                    j=tmp;
                  }
                  if (j has door) ! return location beyond the door
                  { if (~~(j provides npc_open)) rfalse; ! No npc_open
                    st=parent(j);
                    move j to parent(self);
                    sr=j.door_to();
                    move j to st;
                    tr=j.npc_open(self);  ! Attempts to open door
                    if (tr==false) rfalse; ! Can't open the door
                    j=sr;
                  }
                  MoveNPC(self, j, ##Go, i);
                  if (p==location)
                  { if (ZRegion(self.walkoff)==3)
                    { print "^", (The) self, " ", (string) self.walkoff, " ";
                      GiveDir(i); print ".^";
                    }
                    else
                    { self.walkoff(i);
                    }
                    if (self provides after_action) self.after_action();
                    rtrue;
                  }
                  if (j==location)
                  { if (ZRegion(self.walkon)==3)
                    { print "^", (The) self, " ", (string) self.walkon, ".^";
                    }
                    else
                    { self.walkon(i);
                    }
                  }
                  if (self provides after_action) self.after_action();
                  rtrue;
                }
              }
            1, 3: ! Following the set path (1=calculated, 3=pre-determined)
#ifdef DEBUG;
              if (parser_trace>1) print "In second daemon bit.^";
#endif;
              if (self.move_type==1)
              { i=self.&npc_dirs->self.npc_stage;
              }
              else
              { i=(self.prepath_name)->self.npc_stage;
              }
              if (i==0)
              { self.npc_stage++;
                if (self.npc_stage==self.prepath_size) self.npc_arrived();
                rtrue;
              }
#ifdef DEBUG;
              if (parser_trace>1) print "i is ", (the) i, ", self is ",
               (the) self, "npc_stage is ", self.npc_stage, ".^";
#endif;
              p=parent(self);
              j=p.(i.door_dir);
              if (ZRegion(j)==2)
              { tmp=j();
#ifdef DEBUG;
                if (parser_trace>1) print "Trying first npc_blocked
                 condition^";
#endif;
                if (ZRegion(tmp)~=1) {self.npc_blocked(); rfalse; }
                j=tmp;
              }
              if (j has door)
              { if ((~~(j provides npc_open)) &&
                  (j hasnt open || j has locked))
                 {
#ifdef DEBUG;
                   if (parser_trace>1) print "Second npc_blocked^";
#endif;
                   self.npc_blocked(); rfalse; }
                st=parent(j);
                move j to parent(self);
                sr=j.door_to();
                move j to st;
                if (j hasnt open || j has locked)
                { tr=j.npc_open(self);
                  if (tr==false) {
#ifdef DEBUG;
                                   if (parser_trace>1) print "Third
                                    npc_blocked bit^";
#endif;
                                   self.npc_blocked(); rfalse; }
                }
                j=sr;
              }
              MoveNPC(self, j, ##Go, i);
              self.npc_stage++;
              if (p==location)
              { if (ZRegion(self.walkoff)==3)
                { print "^", (The) self, " ", (string) self.walkoff, " ";
                  GiveDir(i); print ".^";
                }
                else
                { self.walkoff(i);
                }
              }
              if (j==location)
              { if (ZRegion(self.walkon)==3)
                { print "^", (The) self, " ", (string) self.walkon, ".^";
                }
                else
                { self.walkon(i);
                }
              }
              if (self provides after_action) self.after_action();
              if (self.move_type==3)
              { if (self.npc_stage==self.prepath_size) self.npc_arrived();
                rtrue;
              }
              if (self.npc_stage==path_size_limit ||
                  parent(self)==self.npc_target)
               self.npc_arrived();
              rtrue;
            2: ! Do nothing.
            default: "** ERROR: move_type set to an unacceptable value for \
             NPC ", (the) self, ". **";
          }
        ],
       npc_dirs 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                0 0, ! Stores the directions NPC has to take
       npc_target, ! The target destination
       npc_ifblocked 0, ! Which action to take if the route is blocked
       npc_backtrack 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
                     0 0 0 0, ! Used by the search algorithm
       npc_blocked ! - Not user definable - acts on ifblocked number
        [ i;
#ifdef DEBUG;
          if (parser_trace>1) print "___ NPC has found route blocked ___^";
#endif;
          switch(self.npc_ifblocked)
          { 0: self.move_type=0;
            1: ! Not yet coded, but will wait for route to be unblocked.
            2: i=NPC_path(self,self.npc_target,0);
               if (i==false) self.move_type=0;
          }
        ],
       npc_arrived  ! Redefine this within the actual NPC object
        [;          ! for more sophisticated results. Deals with what
                    ! happens when an NPC arrives at its destination. In
                    ! this case, it returns to random movement.
          self.move_type=0;
        ],
       npc_stage 0, ! position along movement array - do not alter this
       move_type 0, ! 0 is random, 1 is following path, 2 is stand still
       follow_action, ! } In case Follower has been included but the NPC
       follow_object, ! } isn't of FollowClass.
       prepath_name 0,
       prepath_size 0;

!----------------------------------------------------------------------------
! Note: To calculate a pathway for an NPC and send it on its way, use the
! call 'NPC_path(npc_in_question,target_room,what_to_do_if_blocked,best)'.
! The second-to-last parameter can either be set to 0 or 2 at the moment - 0
! means that if the path is found to be blocked (by, for example, a suddenly
! locked door), the NPC should stop following the path and move randomly.
! Passing 2 will attempt to calculate a different path. The routine will
! return true if a path has been found, or false if it hasn't. The last
! parameter, best, should be set to 1 if you want the routine to find the
! best (ie shortest) pathway, or 0 if you are happy with the first one it
! finds.
!----------------------------------------------------------------------------

Object used_by_moveclass
  with spare_variable 0,
       whattodo 0;

[ NPC_path npc targetroom ifblocked best thisroom count i numunbl numunex j
           tmp magicdir nextdir atmp nextunbl;
! targetroom, ifblocked and best are passed from the originator.
! thisroom = current room. count = no. of paths (pos of array)
! i = compass locations, j = places leading off, tmp = temporary variable
! numunbl = number of rooms unblocked from here with higher count score
! numunex = number of rooms unexplored from here with higher count score
! magicdir = only set if a dir from current location leads to targetroom
! nextdir = next likely direction to try, atmp = another temp variable
! nextunbl = next unblocked direction, if none are unexplored
! used_by_moveclass.whattodo = deciding action
! used_by_moveclass.spare_variable = no of unblocked, regardless of score
  thisroom=parent(npc);
  count=0;
  npc.npc_target=targetroom;
  npc.npc_stage=0;
  npc.npc_ifblocked=ifblocked;
  objectloop(i ofclass Room) i.number=path_size_limit+5;
  for (i=0: i<=(path_size_limit-1): i++)
  { npc.&npc_dirs->i=0;
    best_path->i=0;
  }
  do
   { numunbl=0; numunex=0; magicdir=0; nextdir=0; nextunbl=0;
     used_by_moveclass.whattodo=0;
#ifdef DEBUG;
     if (parser_trace>1) print "*** Iteration *** - room is ", (the)
      thisroom, "^";
#endif;
     give thisroom explored;
     used_by_moveclass.spare_variable=0;
     objectloop (i in compass)
     { j=thisroom.(i.door_dir);
       if (ZRegion(j)>0)
       { if (ZRegion(j)==2)
         { tmp=j();
           j=tmp;
         }
         if (ZRegion(j)==1)
         { if (j has door)
           { tmp=parent(j);
#ifdef DEBUG;
             if (parser_trace>1) print "Inside initial door check routine.^";
#endif;
             move j to thisroom;
             atmp=j.door_to();
             move j to tmp;
             if (j has locked || (j hasnt open && (~~(j provides npc_open))))
              {give j blocked explored;
#ifdef DEBUG;
               if (parser_trace>1) print "Door not openable.^";
#endif;
              }
             else
              {j=atmp;}
#ifdef DEBUG;
             if (parser_trace>1) print "target room now ", (the) j, ".^";
#endif;
           }
           if (j hasnt blocked)
           { if (j.number>count+1) 
             { numunbl++;
               nextunbl=i;
               used_by_moveclass.spare_variable++;}
             else { used_by_moveclass.spare_variable++;}
           }
           if (j hasnt explored && j.number>count+1) {numunex++; nextdir=i;}
           if (j==targetroom) magicdir = i;
         }
       }
     }
     if (used_by_moveclass.spare_variable==1) ! if numunbl==1
     { give thisroom blocked;
#ifdef DEBUG;
       if (parser_trace>1)
        print ">-Giving ", (name) thisroom, " blocked <-^";
#endif;
     }
   ! Decide whattodo: 1 = found room, 2 = no path possible, 3 = backtrack,
   !                  4 = move forward
     if (ZRegion(magicdir)==1 && (LeadsTo(magicdir,thisroom)).number>count+1)
      used_by_moveclass.whattodo=1;
     if (numunbl==0)
     { if (used_by_moveclass.spare_variable==0) used_by_moveclass.whattodo=2;
       else used_by_moveclass.whattodo=3;
     }
     if (count>0)
     { if (numunbl==1 && Leadsto(nextunbl,thisroom)==
           npc.&npc_backtrack->(count-1))
        used_by_moveclass.whattodo=3;
       if (used_by_moveclass.whattodo==0)
       { if (numunex>0) used_by_moveclass.whattodo=4;
         if (used_by_moveclass.whattodo==0 && numunbl==1 &&
             Leadsto(nextunbl,thisroom)~=npc.&npc_backtrack->(count-1))
         { used_by_moveclass.whattodo=4; nextdir=nextunbl; }
         if (numunex==0 && numunbl>1)
         { used_by_moveclass.whattodo=4; !! -- was whattodo=3 -- !!
           nextdir=nextunbl; !! -- added -- !!
         }
       }
     }
     if (count==(path_size_limit-1) && used_by_moveclass.whattodo~=1)
      used_by_moveclass.whattodo=3;
    ! backtrack if target not acquired by max. count no.
     if (count==0 && used_by_moveclass.whattodo==0)
     { if (numunbl>0) ! was numunex
       { used_by_moveclass.whattodo=4;
         nextdir=nextunbl;
       }
       else used_by_moveclass.whattodo=2;
     }
     if (count==0 && used_by_moveclass.whattodo==3)
      used_by_moveclass.whattodo=2;
     switch(used_by_moveclass.whattodo)
     { 1: npc.&npc_dirs->count=magicdir;
          if (best==0)
          { CleanRooms();
            npc.move_type=1;
            rtrue;
          }
          for (atmp=0: atmp<=count: atmp++)
          { best_path->atmp=npc.&npc_dirs->atmp;
#ifdef DEBUG;
            if (parser_trace>1) print ">><><< ", (name) best_path->atmp, "^";
#endif;
          }
          (LeadsTo(magicdir,thisroom)).number=count+1;
!          npc.move_type=1;
!          CleanRooms();
!          rtrue;
       2: CleanRooms(); 
          if (best_path->0==0) rfalse;
          for (i=0: i<=targetroom.number: i++)
          { npc.&npc_dirs->i=best_path->i;
          }
          npc.move_type=1;
          rtrue;
       3:
#ifdef DEBUG;
          if (parser_trace>1) print "** BACKTRACK ** count is ", count,
           "(-1)^";
#endif;
          count--;
          thisroom=npc.&npc_backtrack->count;
          npc.&npc_dirs->count=0;
       4: npc.&npc_dirs->count=nextdir;
#ifdef DEBUG;
          if (parser_trace>1)
          { print "*** Move forward - nextdir is ", (the) nextdir, "***^";
            print "The relevant array reads ",
             (the) npc.&npc_dirs->count, ", count is ", count, "(+1)^";
          }
#endif;
          count++;
          j=thisroom.(nextdir.door_dir);
          if (ZRegion(j)==2)
          { tmp=j();
            j=tmp;
          }
          if (ZRegion(j)~=1) "Error in npc_move - can't move";
          if (j has door)
          { tmp=parent(j);
            move j to thisroom;
            atmp=j.door_to();
            move j to tmp;
            j=atmp;
          }
#ifdef DEBUG;
          if (parser_trace>1) print "Attempting to set ", (the) j, " as
           current room.^";
#endif;
          npc.&npc_backtrack->(count-1)=thisroom;
          thisroom=j;
          thisroom.number=count;
       default:
#ifdef DEBUG;
                if (parser_trace>1) print "** Error - whattodo is unset ***^
                 nextdir = ", (the) nextdir, ", nextunbl = ", (the) nextunbl,
                 ", number unexplored = ", numunex, ", number \
                 unblocked = ", numunbl, ", count = ", count,
                 ", thisroom = ", (the) thisroom, ", spare_variable = ",
                 used_by_moveclass.spare_variable, ".^";
#endif;
                CleanRooms();
                rfalse;
     }
   }
  until (false);
];


! To use NPCPrePath: NPCPrePath(name_of_npc,name_of_array,number_of_entries);

[ NPCPrePath npcname arname arentries fakevar;
  fakevar=fakevar; !Included in case game code tries passing a room name.
#ifdef DEBUG;
  if (parser_trace>1) print "arname given as ", arname, ".^";
#endif;
  if (npcname ofclass moveclass)
  { npcname.npc_stage=0;
    npcname.move_type=3;
    npcname.prepath_name=arname;
    npcname.prepath_size=arentries;
  }
  else
  { "*** MoveClass Error: NPCPrePath called for non-moveclass object '",
     (the) npcname, "' ***";
  }
];

[ CleanRooms i;
  objectloop (i has explored)
   {
#ifdef DEBUG;
     if (parser_trace>=2) print "Explored: ", (the) i, ".^";
#endif;
     give i ~explored;
   }
  objectloop (i has blocked)
   {
#ifdef DEBUG;
     if (parser_trace>=2) print "Blocked: ", (the) i, ".^";
#endif;
     give i ~blocked;
   }
#ifdef DEBUG;
  if (parser_trace>1) print "ClearRooms finished.^";
#endif;
];

[ GiveDir i;
  switch(i)
  { n_obj: print "to the north";
    s_obj: print "to the south";
    e_obj: print "to the east";
    w_obj: print "to the west";
    ne_obj: print "to the northeast";
    nw_obj: print "to the northwest";
    se_obj: print "to the southeast";
    sw_obj: print "to the southwest";
    u_obj: print "upwards";
    d_obj: print "downwards";
    in_obj: print "inside";
    out_obj: print "outside";
  }
];

[ Leadsto i thisroom  j tmp atmp;
          j=thisroom.(i.door_dir);
          if (ZRegion(j)==2)
          { tmp=j();
            j=tmp;
          }
          if (ZRegion(j)~=1) "Error in npc_move - can't move";
          if (j has door)
          { tmp=parent(j);
            move j to thisroom;
            atmp=j.door_to();
            move j to tmp;
            j=atmp;
          }
  return j;
];

#ifndef MoveNPC; ! Provides MoveNPC if program isn't including 'Follower'

[ MoveNPC tomove dest actn objn;
  move tomove to dest;
  actn=actn;
  objn=objn;
];

#endif;