#ifndef __MainWin_hpp__
#define __MainWin_hpp__

#include <iframe.hpp>
#include <imcelcv.hpp>
#include <istattxt.hpp>
#include <igroupbx.hpp>
#include <ilistbox.hpp>
#include <icmdhdr.hpp>
#include <itimer.hpp>

#include <iksssts.h>


#include <string.h>
#include <time.h>
#include <istring.hpp>

#include "Saver.hh"


class SaverEntry{

public:
   class Exceptions{};
   class BogusSaverName:public Exceptions{};

   SaverEntry();
   SaverEntry(const IString &savername,const IString &dllname,SaverModule *mod=NULL);
   SaverEntry(const SaverEntry &arg);
   ~SaverEntry();

   SaverEntry&       operator=(const SaverEntry &arg);

   const IString&    GetSaverName() const{return SaverName;}
   const IString&    GetDLLName() const{return DLLName;}

   SaverModule *     operator->(){return Module;}
                     operator SaverModule*(){return Module;}
                     operator SaverModule*() const {return Module;}

protected:
   IString     SaverName,
               DLLName;
   SaverModule *Module;
};


inline IString const&   key(SaverEntry const &el){return el.GetSaverName();}
inline long             compare(IString const &k1,IString const &k2){
                                    return strcmp(k1,k2);}

//=====================================
class SaverMainWin;

class SaverHandler:public IHandler{

public:
   SaverHandler(SaverMainWin &mw);
   ~SaverHandler();

protected:
   Boolean dispatchHandlerEvent(IEvent &event);

   SaverMainWin &mainwin;
};

//=====================================
class SaverMainWin:public IFrameWindow{
   typedef IKeySortedSetOnSortedTabularSequence<SaverEntry,IString> tContainerType;

   class CommandHandler:public ICommandHandler{
      public:
         CommandHandler(SaverMainWin &mw);
         ~CommandHandler();

      protected:
         Boolean  systemCommand(ICommandEvent &evt);
         Boolean  command(ICommandEvent &evt);

         SaverMainWin   &main;
   };

public:
   SaverMainWin();
   ~SaverMainWin();

   SaverModule *  GetActiveSaver();

   void           GotInput();

   void           StartCurSaverModule();
   void           StopSaverModule();

   void           SaveSetup();
   void           LoadSetup();

private:
   void              TimerFunc();

   IFrameWindow      myclient;
   IListBox          List;
   ITimer            myTimer;
   ITimerMemberFn0<SaverMainWin>
                     myTimerFunc;

   CommandHandler    handler;
   SaverHandler      aSaverHandler;

   tContainerType    ModuleList;

   time_t            CurTime,
                     LastInTime;

   void              *SaverData;
   int               IsSaving;

   SaverModule*      Running;

friend CommandHandler;
};


#endif
