#define INCL_DOS
#define INCL_PM
#include <os2.h>
#include <iostream.h>
#include <ThreadTemp.h>

#include "TstSave.hh"

static MRESULT EXPENTRY MyProc(HWND hwnd, ULONG msgid, MPARAM mp1, MPARAM mp2);

TestSaver::TestSaver():SaverModule(){
   SaverActive=0;
   TestThread=new ClassThreadwoArg<TestSaver> (this,&ThreadFnc);
   TestThread->ChangeStackSize(32*1024);
}

TestSaver::~TestSaver(){
   DeactivateSaver();
   delete TestThread;
}


void TestSaver::ThreadFnc(void){
   HAB  hab   =WinInitialize(0);
   HMQ  hmq   =WinCreateMsgQueue(hab,10);
   static const char *MyClass="TstSaveWindow";

   int  rc;

   rc=WinRegisterClass(hab,MyClass,&MyProc,0,4);
   if(rc){
      myhwnd=WinCreateWindow(HWND_DESKTOP,MyClass,MyClass,WS_VISIBLE,0,0,
           WinQuerySysValue(HWND_DESKTOP,SV_CXSCREEN),
           WinQuerySysValue(HWND_DESKTOP,SV_CYSCREEN),
           HWND_DESKTOP,
           HWND_TOP,
           0,
           NULL,
           NULL);

      if(myhwnd){
         QMSG qmsg;

         WinSetWindowULong(myhwnd,0, (ULONG)this);
         WinSetFocus(HWND_DESKTOP,myhwnd);

         while(WinGetMsg(hab,&qmsg,0,0,0))
            WinDispatchMsg(hab,&qmsg);

         WinDestroyWindow(myhwnd);
      }
      else{
         WinMessageBox(
            HWND_DESKTOP,
            HWND_DESKTOP,
            "Couldn't create window",
            "Error",
            10,
            MB_OK|MB_WARNING|MB_MOVEABLE);
      }
   }
   else{
      WinMessageBox(
         HWND_DESKTOP,
         HWND_DESKTOP,
         "Couldn't register the class",
         "Error",
         10,
         MB_OK|MB_WARNING|MB_MOVEABLE);
   }

   WinDestroyMsgQueue(hmq);
   WinTerminate(hab);
}

string TestSaver::GetSaverName(){
   return "Test Saver";
}

SaverModule::HWND TestSaver::GetPageHandle(){
return 0;
}

void TestSaver::ActivateSaver(){
   SaverActive=1;
   TestThread->Start();
}

void TestSaver::DeactivateSaver(){
   if(TestThread->IsRunning()){
      WinPostMsg(myhwnd,WM_QUIT,0,0);
//      TID tid=TestThread->GetThreadID();
      SaverActive=0;
//      DosWaitThread(&tid,0);
   }
}

MRESULT EXPENTRY MyProc(HWND hwnd, ULONG msgid, MPARAM mp1, MPARAM mp2){

  switch(msgid){
     case WM_PAINT:{
        HPS hps;
        RECTL rectl;

        hps=WinBeginPaint(hwnd,0,&rectl);
        WinFillRect(hps,&rectl,CLR_BLACK);
        WinEndPaint(hps);
        break;
     }
     case WM_CHAR:
//        WinPostMsg(hwnd,WM_QUIT,0,0);
        SaverModule::SignalStop();
        break;
     default:
        return WinDefWindowProc(hwnd,msgid,mp1,mp2);
  }
return 0;
}
