////////////////////////////////////////////////////////////////////////////
//
// AFILE.CPP - description of AFile, base file class
//
////////////////////////////////////////////////////////////////////////////

#include "afile.hpp"

//**************************************************************************
// AFile :: AFile - Constructor of AFile                                   *
//**************************************************************************
AFile :: AFile (PVOID pBuffer, ULONG ulBufferSize)
                : m_ulBufferSize (ulBufferSize),  // initialize m_ulBufferSize and m_pBuffer
                  m_pBuffer (pBuffer)

{
  m_bIsOpen = false;        // reset the variables

  m_pFilestatus3 = 0L;

  m_pisFileName = 0L;

  m_hFile = 0;

  m_ulActionTaken =
  m_ulFileAttribute,
  m_ulOpenFlag,
  m_ulOpenMode,
  m_ulBytesRead,
  m_ulBytesWritten = 0UL;

  m_lastDosError = 0;
}

//**************************************************************************
// AFile :: ~AFile - Destructor of AFile                                   *
//**************************************************************************
AFile :: ~AFile(void)

{
  if(m_bIsOpen)  // is the file still open
     {                    
      close ();  // yes, close it
     }

  if(m_pisFileName)          // is the IString allocated?
     {
      delete(m_pisFileName); // yes, delete it
      m_pisFileName = 0L;
     }

  if(m_pFilestatus3)         // is the FILESTATUS3 allocated
     {
      delete m_pFilestatus3; // yes, delete it
      m_pFilestatus3 = 0L;
     }
}

//**************************************************************************
// AFile :: open - open the file                                           *
//**************************************************************************
APIRET AFile :: open (const PSZ pszFileName, const ULONG ulFileSize, const ULONG ulFileAttribute,
                      const ULONG ulOpenFlag, const ULONG ulOpenMode, const PEAOP2 pEABuf)

{
  IString fileName (pszFileName);  // create an IString and call open

  return (open(fileName, ulFileSize, ulFileAttribute, ulOpenFlag, ulOpenMode, pEABuf));
}

//**************************************************************************
// AFile :: open - open the file                                           *
//**************************************************************************
APIRET AFile :: open (const IString & fileName, const ULONG ulFileSize, const ULONG ulFileAttribute,
                      const ULONG ulOpenFlag, const ULONG ulOpenMode, const PEAOP2 pEABuf)

{
  APIRET ret;

  if(m_bIsOpen)           // is the file already open?
     return ((APIRET) 0); // yes, return 0

  if(!m_pisFileName)                          // is the IString allocated
     m_pisFileName = new IString (fileName);  // no, allocate it
  else
     *m_pisFileName = fileName;               // yes, reset the stored filename

  m_ulFileAttribute = ulFileAttribute;        // store the attributes
  m_ulOpenFlag      = ulOpenFlag;             // store the flags
  m_ulOpenMode      = ulOpenMode;             // store the mode

  ret = DosOpen(*m_pisFileName, &m_hFile, &m_ulActionTaken, ulFileSize,   // try to open the file
                m_ulFileAttribute, m_ulOpenFlag, m_ulOpenMode, pEABuf);

  if (!ret)             // open was successful?
      m_bIsOpen = true; // yes, set the flag to true

  return (ret);         // return the return-value of DosOpen
}

//**************************************************************************
// AFile :: reOpen - re-open a file                                        *
//**************************************************************************
APIRET AFile :: reOpen (const ULONG ulFileSize, const ULONG ulFileAttribute,
                        const ULONG ulOpenFlag, const ULONG ulOpenMode, const PEAOP2 pEABuf)

{
  if(!m_pisFileName)                    // do we have a filename
     return (AFILE_FILENAME_MISSING);   // no, return

  return (open(*m_pisFileName, ulFileSize, ulFileAttribute, ulOpenFlag, ulOpenMode, pEABuf)); // open the file
}

//**************************************************************************
// AFile :: close - close the file                                         *
//**************************************************************************
APIRET AFile :: close(void)

{
  APIRET ret;

  if(!m_bIsOpen)                  // is the file open?
     return(AFILE_FILE_NOT_OPEN); // no, return

  ret = DosClose(m_hFile);        // close the file

  if(!ret)                        // close successful?
      m_bIsOpen = false;          // yes, reset the flag

  return(ret);                    // return the return-value of DosClose
}

//**************************************************************************
// AFile :: read - read the data                                           *
//**************************************************************************
APIRET AFile :: read(PVOID pBuffer, ULONG ulBufferSize)

{
  APIRET ret = checkReadWrite (pBuffer, ulBufferSize); // check if all parameters are set properly

  if(ret)                                                             // all parameters ok?
     m_ulBytesRead = 0UL;                                             // no, don't read
  else
     ret = DosRead (m_hFile, (pBuffer ? pBuffer : m_pBuffer),         // yes, read the data
                    (ulBufferSize ? ulBufferSize : m_ulBufferSize),
                    &m_ulBytesRead);

  return (ret);  // return the value of checkReadWrite / DosRead
}

//**************************************************************************
// AFile :: write - writes the data                                        *
//**************************************************************************
APIRET AFile :: write(PVOID pBuffer, ULONG ulBufferSize)

{
  APIRET ret = checkReadWrite (pBuffer, ulBufferSize); // check if all parameters are set properly

  if(ret)                                                             // all parameters ok?
     m_ulBytesWritten = 0UL;                                          // no, don't write
  else
     ret = DosWrite (m_hFile, (pBuffer ? pBuffer : m_pBuffer),        // yes, write the data
                     (ulBufferSize ? ulBufferSize : m_ulBufferSize),
                     &m_ulBytesWritten);

  return (ret);  // return the value of checkReadWrite / DosWrite
}

//**********************************************************************************************
// AFile :: checkReadWrite- checks if the buffer and it's size are set and if the file is open *
//**********************************************************************************************
APIRET AFile :: checkReadWrite(const PVOID pBuffer, const ULONG ulBufferSize)

{
  if(!m_bIsOpen)                    	  // is the file open
     return (AFILE_FILE_NOT_OPEN);      // no, return

  if(!pBuffer                           // is a pointer to a buffer set?
     && !m_pBuffer)
     return (AFILE_NO_BUFFER_POINTER);  // no, return

  if(!ulBufferSize                      // is the size of the buffer set?
     && !m_ulBufferSize)
     return (AFILE_NO_BUFFER_SIZE);     // no, return

  return ((APIRET) 0);                  // everything is ok
}

//**************************************************************************
// AFile :: queryFileInfo - query the file info level 1                    *
//**************************************************************************
APIRET AFile :: queryFileInfo (Boolean bRefresh)

{
  if(!m_bIsOpen)                        // is the file open?
     {
      if(bRefresh)                       // no; is refresh demanded?
         {
          return (AFILE_FILE_NOT_OPEN);   // yes, but can't refresh because the file is not open, return
         }
      else                               // no refresh demanded
         {
          if(!m_pFilestatus3)            // did i query the file info before?
             {
              return (AFILE_FILE_NOT_OPEN); // no, but can't do it now because the file is not open, return
             }
          else                           // got the file info before
             {
              return (NO_ERROR);         // return
             }
         }
     }

  // the file is open

  if(!m_pFilestatus3)                         // did i query the file info before?
     {                                        // no
      if(!(m_pFilestatus3 = new FILESTATUS3)) // allocte the buffer
         return (ERROR_BUFFER_OVERFLOW);
      return (DosQueryFileInfo (m_hFile, FIL_STANDARD, m_pFilestatus3, sizeof(FILESTATUS3))); // query the file info and return
     }

  if(!bRefresh)                               // shall i re-query?
     return (NO_ERROR);                       // no, return

  return (DosQueryFileInfo (m_hFile, FIL_STANDARD, m_pFilestatus3, sizeof(FILESTATUS3)));  // query the file info and return
}

//**************************************************************************
// AFile :: getFileSize - return the size of the file                      *
//**************************************************************************
ULONG AFile :: getFileSize (Boolean bRefresh)

{
  m_lastDosError = queryFileInfo (bRefresh); // query the file info

  if(m_lastDosError)                         // error?
     return (0UL);                           // yes, return 0UL
  else
     return (m_pFilestatus3 -> cbFile);        // no, return the size of the file
}
