#ifndef _AFILE_HPP_
#define _AFILE_HPP_

#define INCL_DOSFILEMGR
#define INCL_ERRORS

#include <os2.h>
#include <ibase.hpp>
#include <istring.hpp>

#ifndef AFILE_FILE_NOT_OPEN
#define AFILE_FILE_NOT_OPEN 100UL
#endif

#ifndef AFILE_FILENAME_MISSING
#define AFILE_FILENAME_MISSING 101UL
#endif

#ifndef AFILE_NO_BUFFER_POINTER
#define AFILE_NO_BUFFER_POINTER 102UL
#endif

#ifndef AFILE_NO_BUFFER_SIZE
#define AFILE_NO_BUFFER_SIZE 103UL
#endif


class AFile

{
  public:
    AFile(PVOID pBuffer = 0L, ULONG ulBufferSize = 0L);                       // constructor
    ~AFile();                                                                 // destrcutor
    virtual APIRET open (const PSZ pszFileName, const ULONG ulFileSize = 0L,  // opens a file
                         const ULONG ulFileAttribute = FILE_NORMAL,
                         const ULONG ulOpenFlag = FILE_OPEN | FILE_CREATE,
                         const ULONG ulOpenMode = OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYREADWRITE,
                         const PEAOP2 pEABuf = 0L);
    virtual APIRET open (const IString & fileName, const ULONG ulFileSize = 0L, // opens a file
                         const ULONG ulFileAttribute = FILE_NORMAL,
                         const ULONG ulOpenFlag = FILE_OPEN | FILE_CREATE,
                         const ULONG ulOpenMode = OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYREADWRITE,
                         const PEAOP2 pEABuf = 0L);
    virtual APIRET reOpen (const ULONG ulFileSize = 0L,                        // re-opens a file
                           const ULONG ulFileAttribute = FILE_NORMAL,
                           const ULONG ulOpenFlag = FILE_OPEN,
                           const ULONG ulOpenMode = OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYREADWRITE,
                           const PEAOP2 pEABuf = 0L);
    virtual APIRET close (void);                                               // closes the file
    APIRET read (PVOID pBuffer = 0L, ULONG ulBufferSize = 0UL);                // read data
    APIRET write (PVOID pBuffer = 0L, ULONG ulBufferSize = 0UL);               // write data

    ULONG getFileSize (Boolean bRefresh = false);                              // returns the file size

    APIRET getLastDosError (void) const { return (m_lastDosError); };          // returns the last DOS error

    ULONG getActionTaken (void) const { return (m_ulActionTaken); };           // returns the action taken by DosOpen
    ULONG getBytesRead (void) const   { return (m_ulBytesRead); };             // number of bytes read last time
    ULONG getBytesWritten (void) const   { return (m_ulBytesWritten); };       // number of bytes written last time
    Boolean isOpen (void) const { return (m_bIsOpen); };                       // is the file open

  private:
    APIRET checkReadWrite(const PVOID pBuffer, const ULONG ulBufferSize);  // checking before reading/writing
    virtual APIRET queryFileInfo (Boolean bRefresh = false);               // query the file info

    IString * m_pisFileName;      // the filename
    Boolean m_bIsOpen;            // is the file open (true == open)
    HFILE   m_hFile;              // file handle needed by the API-calls
    ULONG   m_ulActionTaken,      // action taken by DosOpen
            m_ulFileAttribute,    // file attributes
            m_ulOpenFlag,         // open flags
            m_ulOpenMode,         // open mode
            m_ulBytesRead,        // bytes read last time
            m_ulBytesWritten;     // bytes written last time
    const ULONG m_ulBufferSize;   // initial buffer size passed to the constructor
    PVOID const m_pBuffer;        // initial buffer passed to the constructor
    FILESTATUS3 * m_pFilestatus3; // level 1 file status
    APIRET m_lastDosError;        // last DOS error
};

#endif //_AFILE_HPP_
