////////////////////////////////////////////////////////////////////////////
//
// EDITFILE.CPP - description of AEdiFile
//
////////////////////////////////////////////////////////////////////////////

#include "editfile.hpp"

#include <iexcbase.hpp>
#include <ibexctxt.h>

#include "mymsg.h"

//**************************************************************************
// AEditFile :: AEditFile - Constructor for AEditFile                      *
//**************************************************************************
AEditFile :: AEditFile (void)
             : AFile ()

{
  m_pFileContents = 0L;   // reset the variables

  m_ulFileSize = 0UL;

  m_bStopProcess = false;
}

//**************************************************************************
// AEditFile :: ~AEditFile - Destructor for AEditFile                      *
//**************************************************************************
AEditFile :: ~AEditFile (void)

{
  delete [] m_pFileContents;  // delete the data buffer
}

//**************************************************************************
// AEditFile :: allocateDataBuffer - allocate the data buffer              *
//**************************************************************************
Boolean AEditFile :: allocateDataBuffer (void)

{
  if(m_pFileContents)                                 // is the buffer already allocated
     return (true);                                   // yes, return

  if(!isOpen ())                                      // is the file open?
     return (false);                                  // no, return

  m_ulFileSize = getFileSize ();                      // get the file's size to know the buffer size

  if(!m_ulFileSize)                                   // no size?
     throw m_ulFileSize;                              // throw an exception

  if(!(m_pFileContents = new char[m_ulFileSize]))     // allocate the buffer; if not successful
     throw m_pFileContents;                           // throw an exception

  return (true);                                      // buffer allocated, return
}

//**************************************************************************
// AEditFile :: read - read the data into the buffer                       *
//**************************************************************************
APIRET AEditFile :: read (HWND hwndStatusLine)

{
  ULONG ulBytesLeftToRead = m_ulFileSize;  // set the variables
  ULONG ulReadAtBufferPos = 0;
  APIRET ret;

  if(!m_pFileContents)                    // no buffer allocated?
     throw m_pFileContents;               // throw an exception

  m_bStopProcess = false;                 // do not stop the process

  while(ulBytesLeftToRead)                // as long as there are still some bytes left to read
        {
         ret = AFile :: read (m_pFileContents + ulReadAtBufferPos,    // read a block of data
                              (ulBytesLeftToRead > (ULONG) eBytesToRead ? eBytesToRead : ulBytesLeftToRead));
         if(ret && ret != ERROR_MORE_DATA)                            // a serious error occured?
            break;                                                    // yes, break the loop
         if(m_bStopProcess)                                           // stop the process?
            {                                                         // yes
             m_bStopProcess = false;                                  // reset the flag
             return (ERROR_MORE_DATA);                                // return
            }
         if(hwndStatusLine)                                           // is a handle of a status line passed?
            WinPostMsg (hwndStatusLine, MYM_STATUS_PROCEED, 0, 0);    // yes, post the message
         ulBytesLeftToRead -= getBytesRead ();                        // decrease the number of bytes left to read
         ulReadAtBufferPos += getBytesRead ();                        // increase the position where to place the data
        }

  return (ret);
}

//**************************************************************************
// AEditFile :: write - write the data from the buffer                     *
//**************************************************************************
APIRET AEditFile :: write (HWND hwndStatusLine)

{
  ULONG ulBytesLeftToWrite = m_ulFileSize;    // set the variables
  ULONG ulWriteFromBufferPos = 0;
  APIRET ret;

  if(!m_pFileContents)                    // no buffer allocated?
     throw m_pFileContents;               // throw an exception

  m_bStopProcess = false;                 // do not stop the process

  while(ulBytesLeftToWrite)               // as long as there are still some bytes left to write
        {
         if((ret = AFile :: write (m_pFileContents + ulWriteFromBufferPos, // write a block of data
                                   (ulBytesLeftToWrite > (ULONG) eBytesToRead ? eBytesToRead : ulBytesLeftToWrite))))
            break;                                                    // if not 0 == NO_ERROR returned, break the loop
         if(m_bStopProcess)                                           // stop the process?
            {                                                         // yes
             m_bStopProcess = false;                                  // reset the flag
             return (ERROR_MORE_DATA);                                // return
            }
         ulBytesLeftToWrite -= getBytesWritten ();                    // decrease the number of bytes left to write
         ulWriteFromBufferPos += getBytesWritten ();                  // increase the (buffer-)position from where to write the data
         if(hwndStatusLine && ulBytesLeftToWrite)                     // is a handle of a status line passed?
            WinPostMsg (hwndStatusLine, MYM_STATUS_PROCEED, 0, 0);    // yes, post the message
       }

  return (ret);
}
