//---------------------------------------------------------------------------------------------
// File STATUS.CPP
//---------------------------------------------------------------------------------------------
#define INCL_WIN

#include <os2.h>
#include "status.h"

MRESULT EXPENTRY ClientWndProc (HWND,ULONG,MPARAM,MPARAM);    // Window procedure
MRESULT EXPENTRY NewFrameProc  (HWND, ULONG ,MPARAM, MPARAM); // subclass framewindow

HAB   hab;
HWND  hwndFrame,
      hwndClient,
      hwndStatus;

PFNWP pfnwOldFrameProc; // Pointer to normal Frame routine in kernel for subclassing

main()
     {
     HMQ   hmq;
     QMSG  qmsg;
     ULONG flFrameFlags = FCF_TITLEBAR |FCF_SYSMENU |FCF_SIZEBORDER |FCF_MENU |FCF_MINMAX |FCF_TASKLIST;
     CHAR  szClient[] = "CLIENT";

     hab = WinInitialize (0);
     hmq = WinCreateMsgQueue (hab, 0);

     WinRegisterClass (hab, szClient, ClientWndProc, CS_SIZEREDRAW, 0);

     // Create Frame window
     hwndFrame = WinCreateStdWindow (HWND_DESKTOP,
                                     WS_VISIBLE,
                                     &flFrameFlags,
                                     szClient,
                                     "Standard WIndow with statusbar",
                                     0,
                                     NULLHANDLE,
                                     MAINMENU,
                                     &hwndClient);

      // Create statusbar window
      hwndStatus= WinCreateWindow(hwndFrame,
                                  WC_STATIC,
                                 " StatusBar",
                                  SS_TEXT| DT_VCENTER | WS_VISIBLE
                                  ,0, 0, 0, 0,       // client window has no size or position at this point
                                  hwndFrame,         // Owner handle
                                  HWND_TOP,          // Z-order ontop
                                  STATUSBAR,         // Window ID
                                  0,                 // Control
                                  0);                // Presentation Parameters


     //---------------------------------------------------------------------------------------------
     // Subclassing normal window proc
     //---------------------------------------------------------------------------------------------
     pfnwOldFrameProc = WinSubclassWindow(hwndFrame,NewFrameProc);  // subclass Framewin
     WinSetWindowULong(hwndFrame,QWL_USER,(ULONG)pfnwOldFrameProc); // Pointer to oldwinproc in winword

     WinSetWindowPos(hwndFrame,
                     NULLHANDLE,
                     10,10,550,300,
                     SWP_ACTIVATE| SWP_MOVE| SWP_SIZE |SWP_SHOW);


     while (WinGetMsg (hab, &qmsg, 0, 0, 0))
           WinDispatchMsg (hab, &qmsg);

     WinDestroyWindow (hwndFrame);
     WinDestroyMsgQueue (hmq);
     WinTerminate (hab);
     return(0);
     }


MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     switch (msg)
          {
          case WM_PAINT:
               {
               RECTL rectl ;
               HPS   hps;

               hps = WinBeginPaint( hwnd, (HPS) NULL, &rectl );
               WinFillRect( hps, (PRECTL)&rectl, CLR_DARKPINK);
               WinEndPaint( hps );
               }
          break;
          }
     return (WinDefWindowProc (hwnd,msg,mp1,mp2));
     }


//-------------------------------------------------------------------------------------------------
// NewFrameProc
//
// this proc is coupled through subclassing to the original window proc of the framewindow.
// If the framewindow proc is called, for example if the framewindow is put on the screen,
// this proc is called first. At the end of this subclass the handle  is passed to the
// original proced.
//-------------------------------------------------------------------------------------------------
MRESULT EXPENTRY NewFrameProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     PFNWP   oldFrameProc ;
     oldFrameProc = (PFNWP) WinQueryWindowULong( hwnd, QWL_USER );      // Pointer from windowword

     switch (msg)
          {
          case WM_QUERYFRAMECTLCOUNT:
               {
               USHORT   itemCount;
               itemCount = SHORT1FROMMR(oldFrameProc(hwnd,msg,mp1,mp2)); //count frame controls
               return ( (MRESULT) ++itemCount );                         //add 1 for new statusbar
               }

           case WM_FORMATFRAME :
               {
               USHORT usClient = 0,
                      usMenu   = 0;
               USHORT itemCount = SHORT1FROMMR( oldFrameProc( hwnd, msg, mp1, mp2 ));
               PSWP pSWP = (PSWP)PVOIDFROMMP(mp1);

               while (pSWP[usClient].hwnd != WinWindowFromID(hwndFrame, FID_CLIENT))
                    ++usClient;
               while (pSWP[usMenu].hwnd != WinWindowFromID(hwndFrame, FID_MENU))
                    ++usMenu;

	          pSWP[itemCount].hwnd = hwndStatus;             // Window handle
               pSWP[itemCount].fl = SWP_SIZE | SWP_MOVE;      // SWP_SIZE style flag
               pSWP[itemCount].cy = pSWP[usMenu].cy;          // Heigth menu hoogte
               pSWP[itemCount].cx = pSWP[usMenu].cx ;         // width is menu width
               pSWP[itemCount].x = pSWP[usClient].x ;         // XPOS in FRAME
               pSWP[itemCount].y = pSWP[usClient].y ;         // YPOS in FRAME
               pSWP[itemCount].hwndInsertBehind = HWND_TOP ;  // On which window (ONTOP)
               // adjust client window size for 2nd menu
               // If not, the client window will be placed over the statusbar
               pSWP[usClient].cy= pSWP[usClient].cy - pSWP[itemCount].cy ;
               pSWP[usClient].y = pSWP[itemCount].y + pSWP[itemCount].cy ;
               // return total count of frame controls
               return( MRFROMSHORT(++itemCount ));
               }

          default:
               return oldFrameProc(hwnd,msg,mp1,mp2);
          }
     }

