/* --------------------------------------------------------------------
      This is the main OS/2 shell from which the game will be hung.
   Almost all other modules should be OS inspecific, with the exception
   of the input modules.

     Sample code for the article "Gearing Up For Games" in EDM/2.

                 Article and code by Michael T. Duffy

-------------------------------------------------------------------- */

// ***********************************************************************
//  Header Files
// ***********************************************************************

#define __IBMC__
#define INCL_WIN
#define INCL_GPI
#define INCL_DOS
#define INCL_ERRORS

// OS/2 API functions
#include <os2.h>

// DIVE required header files
#define  _MEERROR_H_
#include <mmioos2.h>
#include <dive.h>
#include <fourcc.h>

// ANSI C functions
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "newtypes.hpp"
#include "canvas.hpp"
#include "game2.hpp"
#include "errdisp.hpp"


#include "os2pal.hpp"
#include "bitmap.hpp"
#include "pcx.hpp"

// Note: You can see what happens when the palette is not suspended or
//       restored upon the WM_ACTIVATE message by commenting out the
//       following #define
#define ADJUST_PALETTE_ON_FOCUS


// ***********************************************************************
//  Variables
// ***********************************************************************

// OS/2 environment variables.
HAB                hab;
HWND               hwndFrame,
                   hwndClient;
CHAR               szTitle [64];
BOOL               bAppIsActive = FALSE;
HDC                hdcClientHDC = NULLHANDLE;
HPS                hpsMainHPS   = NULLHANDLE;

const CHAR         szClientClass []  = "CLIENT";

SHORT              sBorderHeight;
SHORT              sBorderWidth;

LONG               lTotalWidth   = 320;
LONG               lTotalHeight  = 200;

// Dive variables
DIVE_CAPS          DiveCaps           = {0};
FOURCC             fccFormats[100]    = {0};
HDIVE              hDive              = NULLHANDLE;
BOOL               bDiveHaveBuffer    = FALSE;
ULONG              ulDiveBufferNumber = 0;


// Canvas variables
PCANVAS            pcnvMainCanvas = NULL;

// Palette objects
OS2Palette         pal2Real;
OS2Palette         pal2Image;

// Constants
const ULONG        ulIMAGE_WIDTH  = 320;
const ULONG        ulIMAGE_HEIGHT = 200;



// ***********************************************************************
//  Code
// ***********************************************************************


//........................................................................
int main()
//........................................................................
  {
  HMQ              hmq;
  QMSG             qmsg;
  ULONG            flFrameFlags;



  hab = WinInitialize (0);
  hmq = WinCreateMsgQueue (hab, 0);

  WinRegisterClass (hab, szClientClass, ClientWndProc, CS_SIZEREDRAW, 0);

  if (InitializeDive () == NO_ERROR)
    {
    // Ready variables for main window creation.
    WinLoadString (hab, 0, ID_APPMAIN, sizeof(szTitle), szTitle);
    flFrameFlags = FCF_TITLEBAR      | FCF_DLGBORDER  |  FCF_MINBUTTON |
                   FCF_SHELLPOSITION | FCF_TASKLIST   |  FCF_ICON      |
                   FCF_SYSMENU       | FCF_MENU;

    // Create the main window
    hwndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
                                    &flFrameFlags, szClientClass, szTitle,
                                    0, 0, ID_APPMAIN, &hwndClient);


    if (InitializeAppWindow () == ES_ERROR)
      {
      WinPostMsg(hwndClient, WM_QUIT, 0L, 0L);
      };
    DrawTestPcx ();

    // Size the window here.
    Snap1_1 ();
    CenterWindow ();

    WinShowWindow (hwndFrame, TRUE);
    WinSetActiveWindow (HWND_DESKTOP, hwndFrame);

    // Process messages while there are some.
    while (WinGetMsg (hab, &qmsg, 0, 0, 0))
        WinDispatchMsg (hab, &qmsg);


    WinSetVisibleRegionNotify (hwndClient, FALSE);
    };

  if (bDiveHaveBuffer)
    {
    DiveFreeImageBuffer (hDive, ulDiveBufferNumber);
    ulDiveBufferNumber = 0;
    bDiveHaveBuffer = FALSE;
    };

  if (pcnvMainCanvas != NULL)
    {
    delete (pcnvMainCanvas);
    pcnvMainCanvas = NULL;
    };

  if (hDive != NULLHANDLE) DiveClose (hDive);

  WinDestroyWindow (hwndFrame);

  WinDestroyMsgQueue (hmq);
  WinTerminate (hab);
  return (0);
  };

//........................................................................
ERRORSTATUS InitializeAppWindow
//........................................................................
  (
  VOID
  )
{
PBYTE              pbySurface;
ULONG              ulWidth;
USHORT             usLastError;



ulDiveBufferNumber = 0;
bDiveHaveBuffer = FALSE;

// Create your display canvas.  Make it a bottom up canvas for use with DIVE
if (pcnvMainCanvas != NULL) delete (pcnvMainCanvas);
pcnvMainCanvas = new Canvas ((USHORT)ulIMAGE_WIDTH,
                             (USHORT)ulIMAGE_HEIGHT,
                             FALSE);
if ((usLastError = pcnvMainCanvas->QueryLastErrorCode ()) != 0)
  {
  PostError (hab, hwndFrame, usLastError);
  return (ES_ERROR);
  };

pbySurface = pcnvMainCanvas->QuerySurface ();
ulWidth    = (ULONG) pcnvMainCanvas->QueryWidth ();

// Associate the canvas with a DIVE handle
if (DiveAllocImageBuffer (hDive, &ulDiveBufferNumber, FOURCC_LUT8,
                          ulIMAGE_WIDTH, ulIMAGE_HEIGHT,
                          ulWidth,  pbySurface) == ES_ERROR)
  {
  // post error message here.
  PostError (hab, hwndFrame, IDS_ERR_CREATE_DIVEBUFFER);
  return (ES_ERROR);
  };
bDiveHaveBuffer = TRUE;

// Turn on visible region notification.
WinSetVisibleRegionNotify (hwndClient, TRUE);

// Send an invalidation message to the client.
WinPostMsg (hwndFrame, WM_VRNENABLED, 0L, 0L );

return (ES_NO_ERROR);
};

//........................................................................
ERRORSTATUS DrawTestPcx
//........................................................................
  (
  VOID
  )
{
PcxPainter         pcxPainter;
ULONG              ulFileSize;
PBYTE              pbyBlock;
PBYTE              pbyPalette;
FILE *             fp;


// Load the sample PCX file

// Open the file.
if ((fp = fopen ("test1.pcx", "rb")) == NULL)
  {
  return (ES_ERROR);
  };

// Get it's total size
fseek (fp, 0, SEEK_END);
ulFileSize = ftell (fp);
fseek (fp, 0, SEEK_SET);

// Allocate memory for the file
if ((pbyBlock = (PBYTE) malloc (ulFileSize)) == NULL)
  {
  return (ES_ERROR);
  };

// Read the entire file.
if (fread (pbyBlock, 1, ulFileSize, fp) != ulFileSize)
  {
  // Unable to read the entire file.
  return (ES_ERROR);
  };

fclose (fp);


// Tell the painter object which buffer to use as input.
if (pcxPainter.AssociateBuffer (pbyBlock, ulFileSize) == ES_ERROR)
  {
  PostError (hab, hwndFrame, pcxPainter.QueryLastErrorCode ());
  return (ES_ERROR);
  };

// Tell the painter object which canvas to use as output.
if (pcxPainter.AssociateCanvas (pcnvMainCanvas) == ES_ERROR)
  {
  PostError (hab, hwndFrame, pcxPainter.QueryLastErrorCode ());
  return (ES_ERROR);
  };

// Draw the PCX file to the main canvas
if (pcxPainter.PaintCanvas () == ES_ERROR)
  {
  PostError (hab, hwndFrame, pcxPainter.QueryLastErrorCode ());
  return (ES_ERROR);
  };

pcxPainter.DissociateBuffer ();
pcxPainter.DissociateCanvas ();

// Set the source palette to the PCX palette

// Get a pointer to the palette.
pbyPalette = pcxPainter.QueryPaletteBuffer ();

// Initialize the palette object from the PCX's palette.
pal2Image.SetValuesFromRaw8 (pbyPalette, 0, 256);

// Set the system palette
pal2Image.InitSystemPalette (hab, hwndClient, hdcClientHDC, hpsMainHPS);

// Tell DIVE what the source image's palette is.
pal2Image.SetAsDiveSource (hDive);

// Set the DIVE destination palette to the new system palette

pal2Real.LoadActualPalette (hpsMainHPS);
pal2Real.SetAsDiveDestination (hDive);

// or you can use:

//DiveSetDestinationPalette (hDive, 0, 256, 0 );

return (ES_NO_ERROR);
};

//........................................................................
VOID Snap1_1
//........................................................................
  (
  VOID
  )
{
LONG               lBorderWidth;
LONG               lBorderHeight;
LONG               lTitlebarHeight;
LONG               lMenuHeight;



lBorderWidth    = (LONG) WinQuerySysValue (HWND_DESKTOP, SV_CXDLGFRAME);
lBorderHeight   = (LONG) WinQuerySysValue (HWND_DESKTOP, SV_CYDLGFRAME);
lTitlebarHeight = (LONG) WinQuerySysValue (HWND_DESKTOP, SV_CYTITLEBAR);
lMenuHeight     = (LONG) WinQuerySysValue (HWND_DESKTOP, SV_CYMENU);

lTotalWidth  = ulIMAGE_WIDTH + lBorderWidth * 2;
lTotalHeight = ulIMAGE_HEIGHT + (lBorderHeight * 2) + lTitlebarHeight +
               lMenuHeight;

// Set the window size.
WinSetWindowPos (hwndFrame,
                 HWND_TOP,
                 0, 0, lTotalWidth, lTotalHeight,
                 SWP_SIZE | SWP_SHOW | SWP_ACTIVATE);
};

//........................................................................
VOID CenterWindow
//........................................................................
  (
  VOID
  )
{
LONG               lcxWindowPos;
LONG               lcyWindowPos;


lcxWindowPos   = ( (LONG)WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN)
                     - lTotalWidth ) / 2;
lcyWindowPos   = ( (LONG)WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN)
                     - lTotalHeight ) / 2;

// Set the window position.
WinSetWindowPos (hwndFrame,
                 HWND_TOP,
                 lcxWindowPos, lcyWindowPos, 0, 0,
                 SWP_MOVE | SWP_SHOW | SWP_ACTIVATE);
};

//........................................................................
MRESULT EXPENTRY ClientWndProc
//........................................................................
  (
  HWND             hwnd,
  ULONG            msg,
  MPARAM           mp1,
  MPARAM           mp2
  )
{
POINTL             pointl;         // Point to offset from Desktop
SWP                swp;            // Window position
HRGN               hrgn;           // Region handle
RECTL              rcls[50];       // Rectangle coordinates
RGNRECT            rgnCtl;         // Processing control structure
SETUP_BLITTER      SetupBlitter;   // structure for DiveSetupBlitter
SIZEL              sizl;
ULONG              ulcPaletteColors = 256;


switch (msg)
  {
  case WM_CREATE:
       sizl.cx = sizl.cy = 0;
       hdcClientHDC = WinOpenWindowDC (hwnd);
       hpsMainHPS = GpiCreatePS (hab, hdcClientHDC, &sizl,
                           PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC);

       // Code differs from game1.cpp starting here.

       // Set the palette to the default 16 palette

       pal2Image.Default16         ();
       pal2Image.SetFlag           (PC_RESERVED);
       pal2Image.Convert           (PAL_FMT_OS2);
       pal2Image.InitSystemPalette (hab, hwnd, hdcClientHDC, hpsMainHPS);
       pal2Image.SetAsDiveSource   (hDive);

       pal2Real.LoadActualPalette    (hpsMainHPS);
       pal2Real.SetAsDiveDestination (hDive);

       // Alternatively, if you don't need to look at the specific colors
       //   of the real palette, the above pal2Real code can be replaced
       //   with the single line:
       // DiveSetDestinationPalette (hDive, 0, 256, 0 );

       return (0);

  case WM_DESTROY:
       pal2Image.UninitSystemPalette ();
       if (hpsMainHPS != NULLHANDLE)  GpiDestroyPS (hpsMainHPS);
       return (0);


#ifdef ADJUST_PALETTE_ON_FOCUS

  case WM_ACTIVATE:
       bAppIsActive = (BOOL) SHORT1FROMMP(mp1);

       if (bAppIsActive)
         {
         // Set the palette like you want it.
         pal2Image.RestoreSystemPalette ();

         // Repaint the image
         WinInvalidateRect (hwndClient, NULL, TRUE);
         }
       else
         {
         // Release the palette
         pal2Image.SuspendSystemPalette ();
         };
       return(0);

#endif // ADJUST_PALETTE_ON_FOCUS


  case WM_PAINT:
       // Notice here that the HPS created during the WM_CREATE message
       //   is used for both WinBeginPaint() and WinEndPaint().  This saves
       //   resources since WinBeginPaint() doesn't have to create a new HPS.

       WinBeginPaint (hwnd, hpsMainHPS, NULL);

       // blit Dive buffer to screen.
       DiveBlitImage (hDive,
                      ulDiveBufferNumber,
                      DIVE_BUFFER_SCREEN );

       WinEndPaint (hpsMainHPS);
       return (0);

  case WM_COMMAND:
       switch (SHORT1FROMMP(mp1))
         {
         case IDM_QUIT:
           {
           WinPostMsg(hwndClient, WM_CLOSE, MPVOID, MPVOID);
           return(0);
           };
         };
       break;

  case WM_REALIZEPALETTE:
       // This tells DIVE that the physical palette may have changed.
       DiveSetDestinationPalette (hDive, 0, 256, 0 );
       break;

  case WM_VRNDISABLED:
       DiveSetupBlitter (hDive, 0);
       break;

  case WM_VRNENABLED:
       if ( !hpsMainHPS )
          break;
       hrgn = GpiCreateRegion ( hpsMainHPS, 0L, NULL );
       if ( hrgn )
          {
          // NOTE: If mp1 is zero, then this was just a move message.
          // Illustrate the visible region on a WM_VRNENABLE.
          //
          WinQueryVisibleRegion ( hwnd, hrgn );
          rgnCtl.ircStart     = 0;
          rgnCtl.crc          = 50;
          rgnCtl.ulDirection  = 1;

          // Get the all ORed rectangles
          if ( GpiQueryRegionRects ( hpsMainHPS, hrgn, NULL, &rgnCtl, rcls) )
             {
             // Now find the window position and size, relative to parent.
             WinQueryWindowPos (hwndClient, &swp );

             // Convert the point to offset from desktop lower left.
             pointl.x = swp.x;
             pointl.y = swp.y;
             WinMapWindowPoints ( hwndFrame, HWND_DESKTOP, &pointl, 1 );

             // Tell DIVE about the new settings.
             SetupBlitter.ulStructLen = sizeof ( SETUP_BLITTER );
             SetupBlitter.fccSrcColorFormat = FOURCC_LUT8;
             SetupBlitter.ulSrcWidth   = ulIMAGE_WIDTH;
             SetupBlitter.ulSrcHeight  = ulIMAGE_HEIGHT;
             SetupBlitter.ulSrcPosX    = 0;
             SetupBlitter.ulSrcPosY    = 0;
             SetupBlitter.fInvert      = TRUE;
             SetupBlitter.ulDitherType = 1;

             SetupBlitter.fccDstColorFormat = FOURCC_SCRN;
             SetupBlitter.ulDstWidth        = swp.cx;
             SetupBlitter.ulDstHeight       = swp.cy;
             SetupBlitter.lDstPosX          = 0;
             SetupBlitter.lDstPosY          = 0;
             SetupBlitter.lScreenPosX       = pointl.x;
             SetupBlitter.lScreenPosY       = pointl.y;
             SetupBlitter.ulNumDstRects     = rgnCtl.crcReturned;
             SetupBlitter.pVisDstRects      = rcls;
             DiveSetupBlitter (hDive, &SetupBlitter);
             }
          else
             DiveSetupBlitter (hDive, 0);

          GpiDestroyRegion (hpsMainHPS, hrgn);
          }
       break;

  }; // switch (msg)

return (WinDefWindowProc(hwnd, msg, mp1, mp2));
};

//........................................................................
ERRORSTATUS InitializeDive
//........................................................................
  (
  VOID
  )
{


// Get the screen capabilities, and if the system supports only 16 colors
//  the program should be terminated.

DiveCaps.pFormatData    = fccFormats;
DiveCaps.ulFormatLength = 100;
DiveCaps.ulStructLen    = sizeof(DIVE_CAPS);

if ( DiveQueryCaps ( &DiveCaps, DIVE_BUFFER_SCREEN ))
   {
   WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
       (PSZ)"Error: DIVE routines cannot function in this system environment.",
       (PSZ)"   This program is unable to run.", 0, MB_OK | MB_INFORMATION );
   return (ES_ERROR);
   };

if ( DiveCaps.ulDepth < 8 )
   {
   WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
       (PSZ)"Error: Not enough screen colors to run DIVE.  Must be at least 256 colors.",
       (PSZ)"   This program is unable to run.", 0, MB_OK | MB_INFORMATION );
   return (ES_ERROR);
   };

// Get an instance of DIVE APIs.
if ( DiveOpen ( &hDive, FALSE, 0 ) )
   {
   WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
       (PSZ)"Error: Unable to open an instance of DIVE.",
       (PSZ)"   This program is unable to run.", 0, MB_OK | MB_INFORMATION );
   return (ES_ERROR);
   };

return (ES_NO_ERROR);
};


