Unit BMMsgDB;

Interface

Uses Use32, Dos, Objects, Strings, String3, Os2Base, Os2Def, VPUtils;

Type
    PMsg = ^Msg;
    Msg = Object(TObject)
        Locked : Boolean;                       { Message is being read, written, etc. }
        BBSID,                                  { BBS Message is from }
        Conference,                             { Conference message is in }
        MsgNum,                                 { Message number }
        Folder : Word;                          { Folder, if any, message is in }
        Tu,                                     { Addressee }
        From,                                   { Author }
        Subject,                                { Subject }
        Tagline,
        MsgID : String[64];                     { Message ID }
        Attributes,                             { Attributes }
        ArchiveAction : SmallWord;              { Archive action
                                                        1 = Delete
                                                        2 = Keep
                                                        3 = Age - Days
                                                        4 = Expire on Date }
        MsgDate,                                { Date message written }
        RcvDate,                                {   "     "    received }
        ReplyDate,                              {   "     "    replied to }
        ExpireDate : LongInt;                   {   "     "    will expire.  All dates are
                                                    in the DOS Unit's PackTime format }
        KeepDays,                               { Days to keep message around }
        Lines : Word;                           { Length of message in lines }
        Length,                                 {   "    "     "    "  bytes }
        Offset : LongInt;                       { Offset into text file }
        RevRef : LongInt;                       { Reverse reference for message }
        FwdRef : Array[1..25] of LongInt;
        ReplyConference,
        ReplyBBS : Word;
        Reserved : Array[1..18] of Byte;        { Reserved for future usage }
        Function IsPrivate : Boolean;
        Procedure SetPrivate(p : Boolean);
        Function IsFiled : Boolean;
        Procedure SetFiled(f : Boolean);
        Function IsChron : Boolean;
        Procedure SetChron(c : Boolean);
        Function IsDeleted : Boolean;
        Procedure SetDeleted(c : Boolean);
        Function IsRead : Boolean;
        Procedure SetRead(r : Boolean);
        Function IsArchived : Boolean;
        Procedure SetArchived(a : Boolean);
        Function IsOutgoing : Boolean;
        Procedure SetOutgoing(o : Boolean);
        Function IsNull : Boolean;
        Procedure SetNull(o : Boolean);    { A null message, for non-reply message entry }
        Function IsTrash : Boolean;
      Private
        Function Att(b : Byte) : Boolean;
        Procedure SetAtt(b : Byte);
        Procedure ClearAtt(b : Byte);
    End;

    MsgCollection = Object(TCollection)
        Procedure NewM(M : PMsg);
    End;

    PMsgCollection = ^MsgCollection;

    PWord = ^Word;

    MsgIndex = Object(TSortedCollection)
        MsgBase : PMsgCollection;
        SortType : Byte;
        Procedure FreeItem(Item : Pointer); virtual;
        Procedure NewI(w : Word);
        Function MsgAt(w : Word) : PMsg;
        Function Compare(Key1, Key2 : Pointer) : Integer; virtual;
        Constructor Init(x,y : Word);
    End;

    PMsgIndex = ^MsgIndex;

    PCharCollection = Object(TCollection)
        Procedure FreeItem(Item : Pointer); virtual;
    End;

    PPCharCollection = ^PCharCollection;

    MsgBuffer = Object
        MIndex : PPCharCollection;
        Function NumLines : LongInt;
        Procedure NewStr(s : String);
        Function StrOf(l : LongInt) : String;
        Constructor Init;
        Destructor Done; virtual;
        Function SizeOf : LongInt;
        Function IsTrash : Boolean;
    Private
        Size : LongInt;
    End;

    PMsgBuffer = ^MsgBuffer;

    BBSConference = Object(TObject)
        ConfNum : Word;
        ConfName : String[64];
        IsMail : Boolean;                                 { Not valid for QWK or QWKE packets }
        IsInternet : Boolean;    { Is it an Internet conference (i.e.: offer E-Mail replies?) }
        DefaultArchiveAction : Byte;                                 { Default archive action }
        SigFile : String[64];                   { Signature file, if any, for this conference }
        AltTag : String[64];            { Alternate tagline file, if any, for this conference }
        Unused : Array[1..50] Of Byte;
        { More to come, I suppose }
    End;

    PBBSConference = ^BBSConference;

    BBSConfCollection = Object(TSortedCollection)
        Procedure NewC(w : Word; s : String; Mail, Internet : Boolean; Archive : Word);
        Function ConfName(w : Word) : String;
        Function IsMail(w : Word) : Boolean;
        Function ConfOf(s : String) : Word;
        Function ConfSpecOf(w : Word) : pBBSConference;
        Function Compare(Key1, Key2 : Pointer) : Integer; virtual;
        Procedure ChangeName(w : Word; s : String);
    End;

    PBBSConfCollection = ^BBSConfCollection;

    BBS = Object(TObject)                                                   { BBS definition }
        Number : Word;                                    { Unique ID, for matching purposes }
        PacketType,                             { Type of packet, ex.: "QWK", "QWKE", "SOUP" }
        ID : String[8];                                                             { BBS ID }
        UserName,
        SysOpName,
        ControlName : String[64];
        AddCmd,
        DropCmd,
        ResetCmd : String[25];
        DefArchiveAction : Word;
        Confs : PBBSConfCollection;
        ArchiverType : String[3];
        Incrementer : Word;
        BinaryReplies : Boolean;                                     { Only for SOUP replies }
        Autoquote : Boolean;
        Unused : Array[1..195] Of Byte;                                      { For expansion }
    End;

    PBBS = ^BBS;

    BBSCollection = Object(TSortedCollection)
        Procedure NewB(p : PBBS);
        Function Compare(Key1, Key2 : Pointer) : Integer; virtual;
        Function BBSOf(w : Word) : PBBS;
        Function BBSOfName(s : String) : PBBS;
        Function HighIDNumber : Word;
    End;

    PBBSCollection = ^BBSCollection;

    Folder = Record
        Name : String[64];
        Num : Word;
    End;

    PFolder = ^Folder;

    BMConfig = Record                               { System configuration, stored in CONFIG.BM }
       InPath,                                                       { In/out paths for packets }
       OutPath,
       SoupPath,                                               { Path for incoming SOUP packets }
       TagCmd,                                                       { External tagline program }
       ExtEditCmd : String[64];                                       { External editor program }
       FKCmd : Array[1..10] Of String[64];                           { Function key definitions }
       HeaderPath : String[32];
       TaglinePath : String[31];
       ReplyFilename,
       OrigFilename : String[16];            { Filenames for tagline management/external editor }
       InetBBS,
       InetConference : Word;                             { Internet E-Mail BBS/Conference spec }
       EmailSoup : Boolean;
       EmailAddress : String[30];
       EmailConference,
       EmailBBS : Word;                                                 { E-Mail specifications }
       Browser : String[64];                                        { Path/fname of Web Browser }
       SpellChecker : String[64];                                 { Path/fname of Spell Checker }
       Unused : Array[1..28] of Byte;
    End;

    PBoolean = ^Boolean;

    AccessQueue = Object(TCollection)
       AccessingQueue : Boolean;
       Function StartRequest : pBoolean;
       Procedure FreeItem(Item : Pointer); Virtual;
    End;

    PAccessQueue = ^AccessQueue;

    FontType = Record
       Name : String[32];
       Pitch : Word;
       Attrs : FAttrs;
    End;

    FontSpec = Record
       Reading,
       Replying,
       Listing,
       Printing : FontType;
    End;

Const
   ReaderID = ' * BM 1.0 * ';

Var
   MsgTxtFile : File;
   MsgIdxFile : File;
   MsgTxtFileLocked : Boolean;                  { A message is currently being written }
   MsgTxtFileOpened : Boolean;                  { The text file is currently open }
   OpenTxtQueue : PAccessQueue;
   Cfg : BMConfig;                                                      { Configuration record }
   trashtext, trashto, trashfrom, trashsubj : PStCollection;
   numt_to, numt_from, numt_subj, numt_text : Word;
   SuspendBGMaintenance : Boolean;      { Prevent Background Maintenance from accessing index }

Function Exist(FileName: string) : Boolean;
Function CurrentTime : LongInt;
Function BuildConferenceIndex(b, c : Word; M : PMsgCollection) : PMsgIndex;
Function BuildArchiveConferenceIndex(b, c : Word; M : PMsgCollection) : PMsgIndex;
Function BuildOutgoingConferenceIndex(b, c : Word; M : PMsgCollection) : PMsgIndex;
Function BuildPersonalConferenceIndex(b, c : Word; M : PMsgCollection; BBSs : PBBSCollection) : PMsgIndex;
Function BuildChronConferenceIndex(b, c : Word; M : PMsgCollection) : PMsgIndex;
Procedure DisposeIndex(M : PMsgIndex);
Function BuildFolderIndex(f : Word; M : PMsgCollection) : PMsgIndex;
Procedure CreateMsgTxtFile;
Procedure ResortIndex(var p : PMsgIndex; SortType : Word);
Procedure InitRequestQueue;
Function OpenMsgTxtFile : pBoolean;
Procedure CloseMsgTxtFile(b : pBoolean);
Function CreateNewMsgTxt(Conf, MNum : Word) : LongInt;
Procedure DumpTxtLine(s : String);
Procedure CloseMsg(Offset, size : LongInt);     { Close out the current message }
Function ReadTxtLine : String;
Function OpenMsgTxt(offset, l : LongInt; c, m : Word) : Boolean;
Function LoadMsgText(PM : PMsg; PB : PMsgBuffer) : Boolean;
Procedure LoadMsgFromTxtFile(var PB : PMsgBuffer;txt : String);
Procedure DumpMsgText(PB : PMsgBuffer);
Procedure DumpMsgToTxtFile(PM : PMsg; PB : PMsgBuffer; Hdr, Txt : String);
Function CreateNewMsg(BBS, Conf, MNum : Word; MsgBase : PMsgCollection) : PMsg;
Function WriteNewMsg(M : PMsg; buf : PMsgBuffer) : Boolean;
Function MakeDirName : String;
Function LoadMsgBase : PMsgCollection;
Procedure SaveMsgBase(MBase : PMsgCollection);
Procedure LoadBBSDefs(BBSs : PBBSCollection);
Procedure SaveBBSDefs(BBSs : PBBSCollection);
Procedure Wipe(Workdir : String);
Function DateStr(l : LongInt) : String;
Procedure LoadFilters;
Procedure WriteFilters;

Implementation

Function DateStr(l : LongInt) : String;
Var
   dt : Dos.DateTime;
   s : String[30];
Begin;
   s := '';
   UnPackTime(l,dt);
   Case dt.Month Of
      1 : s := 'Jan';
      2 : s := 'Feb';
      3 : s := 'Mar';
      4 : s := 'Apr';
      5 : s := 'May';
      6 : s := 'June';
      7 : s := 'July';
      8 : s := 'Aug';
      9 : s := 'Sep';
      10: s := 'Oct';
      11: s := 'Nov';
      12: s := 'Dec';
   End;
   s := s + ' ' + StrX(dt.Day) + ' ' + StrX(dt.Year) + '  ' + Digit2(dt.Hour) + ':' + Digit2(dt.Min) +
   ':' + Digit2(dt.Sec);
   DateStr := s;
End;

Procedure Wipe(Workdir : String);
Var
   sr : SearchRec;
   F2 : File;
   x : Word;
Begin;
   FindFirst(WorkDir + '\*.*', AnyFile, Sr);
   While (Dos.DosError = 0) do
   Begin
     Assign(F2,Workdir + '\' + sr.Name);
   {$I-}
     Erase(F2);
   {$I+}
     x := IOResult;
     FindNext(sr);
   End;
   FindClose(sr);
{$I-}
   Rmdir(WorkDir);
{$I+}
   x := IOResult;
End;

Function Exist(FileName: string) : Boolean;
Var
  f: file;
  S: Dos.SearchRec;
Begin;
  FindFirst(FileName,Archive,S);
  If Dos.DosError = 0 Then Exist := True Else Exist := False;
  FindClose(S);
End;

Function CurrentTime : LongInt;
Var
   d : Dos.DateTime;
   i : Word;
   l : LongInt;
Begin;
   GetTime(d.Hour,d.Min,d.Sec,i);
   GetDate(d.Year,d.Month,d.Day,i);
   PackTime(d,l);
   CurrentTime := l;
End;

Function MakeDirName : String;
Var
   y, mx, d, dw, l, h, m, s, hu, dy : Word;
   tname : String;
Begin;
   GetDate(y, mx, d, dw);
   GetTime(h, m, s, hu);
   l := s + (m * 60);
   dy := h;
   l := l + (dy * 3600);
   dy := d mod 10;
   l := l + (dy * 86400);
   l := (l * 100) + hu;
   tname := HexStr(l);
   If Length(tname) > 7 Then tname := Right(tname,Length(tname) - 7 + 1);
   While Length(tname) < 7 Do tname := '0' + tname;
   MakeDirName := tname;
End;

Function MakeSubj(s : String) : String;
Begin;
   If Length(s) > 3 Then Begin;
      If Left(s,4) = 'Re:' Then s := Right(s,4);
   End;
   MakeSubj := Upper(s);
End;

Procedure LoadFilters;
Var
   f3 : Text;
   s, s2 : String;
Begin;
   TrashTo := New(PStCollection,Init(1024,128));
   TrashFrom := New(PStCollection,Init(1024,128));
   TrashSubj := New(PStCollection,Init(1024,128));
   TrashText := New(PStCollection,Init(1024,128));
   Assign(f3,'FILTERS.BM');
   Reset(f3);
   NumT_From := 0;
   NumT_To := 0;
   NumT_Subj := 0;
   NumT_Text := 0;
   While Not EOF(f3) Do Begin;
         ReadLn(f3,s);
         s2 := Left(s,Pos(' ',s));
         s := Right(s,Pos(' ',s));
         Trim(s);
         Trim(s2);
         If (Upper(s2) = 'FROM') Then Begin;
            Inc(NumT_From);
            TrashFrom^.Add(s);
         End;
         If (Upper(s2) = 'TO') Then Begin;
            Inc(NumT_To);
            TrashTo^.Add(s);
         End;
         If (Upper(s2) = 'SUBJECT') Then Begin;
            Inc(NumT_Subj);
            TrashSubj^.Add(s);
         End;
         If (Upper(s2) = 'TEXT') Then Begin;
            Inc(NumT_Text);
            TrashText^.Add(s);
         End;
   End;
   Close(f3);
End;

Procedure WriteFilters;
Var
   t : Text;
   s : String;
   w : Word;
Begin;
   Assign(t,'FILTERS.BM');
   Rewrite(t);
   If TrashFrom <> nil Then For w := 1 To TrashFrom^.Count Do WriteLn(t,'from ' + TrashFrom^.Get(w));
   If TrashSubj <> nil Then For w := 1 To TrashSubj^.Count Do WriteLn(t,'subject ' + TrashSubj^.Get(w));
   If TrashText <> nil Then For w := 1 To TrashText^.Count Do WriteLn(t,'text ' + TrashText^.Get(w));
   Close(t);
End;

Function AccessQueue.StartRequest : pBoolean;
Var
   pb : pBoolean;
Begin;
   New(pb);
   pb^ := False;
   Insert(pb);
   StartRequest := pb;
End;

Procedure AccessQueue.FreeItem(Item : Pointer);
Begin;
   Dispose(Item);
End;

Function Msg.Att(b : Byte) : Boolean;
Var
   w : SmallWord;
Begin;
   If b > 7 {} Then w := 0 Else w := (Attributes SHR b) And 1;
   If w = 1 Then Att := True Else Att := False;
End;

Procedure Msg.SetAtt(b : Byte);
Var
   w : SmallWord;
Begin;
   w := 1 SHL b;
   Attributes := Attributes OR w;
End;

Procedure Msg.ClearAtt(b : Byte);
Var
   w : SmallWord;
Begin;
   w := (1 SHL b) XOR $FFFF;
   Attributes := Attributes AND w;
End;

Function Msg.IsPrivate : Boolean;
Begin;
   IsPrivate := Att(0);
End;

Procedure Msg.SetPrivate(p : Boolean);
Begin;
   If p Then SetAtt(0) Else ClearAtt(0);
End;

Function Msg.IsFiled : Boolean;
Begin;
   IsFiled := Att(1);
End;

Procedure Msg.SetFiled(f : Boolean);
Begin;
   If f Then SetAtt(1) Else ClearAtt(1);
End;

Function Msg.IsChron : Boolean;
Begin;
   IsChron := Att(2);
End;

Procedure Msg.SetChron(c : Boolean);
Begin;
   If c Then SetAtt(2) Else ClearAtt(2);
End;

Function Msg.IsDeleted : Boolean;
Begin;
   IsDeleted := Att(3);
End;

Procedure Msg.SetDeleted(c : Boolean);
Begin;
   If c Then SetAtt(3) Else ClearAtt(3);
End;

Function Msg.IsRead : Boolean;
Begin;
   IsRead := Att(4);
End;

Procedure Msg.SetRead(r : Boolean);
Begin;
   If r Then SetAtt(4) Else ClearAtt(4);
End;

Function Msg.IsArchived : Boolean;
Begin;
  IsArchived := Att(5);
End;

Procedure Msg.SetArchived(a : Boolean);
Begin;
   If a Then SetAtt(5) Else ClearAtt(5);
End;

Function Msg.IsOutgoing : Boolean;
Begin;
   IsOutgoing := Att(6);
End;

Procedure Msg.SetOutgoing(o : Boolean);
Begin;
   If o Then SetAtt(6) Else ClearAtt(6);
End;

Function Msg.IsNull : Boolean;
Begin;
   IsNull := Att(7);
End;

Procedure Msg.SetNull(o : Boolean);
Begin;
   If o Then SetAtt(7) Else ClearAtt(7);
End;

Procedure MsgCollection.NewM(M : PMsg);
Begin;
   Insert(M);
End;

Constructor MsgIndex.Init(x, y : Word);
Begin;
   TSortedCollection.Init(x, y);
   Duplicates := True;
End;

Procedure MsgIndex.NewI(w : Word);
Var
   p : PWord;
Begin;
   p := New(PWord);
   If p <> nil Then Begin;
      p^ := w;
      Insert(p);
   End;
End;

Function MsgIndex.MsgAt(w : Word) : PMsg;
Var
   M : PMsg;
   p : PWord;
Begin;
   p := At(w);
   M := MsgBase^.At(p^);
   MsgAt := M;
End;

Procedure MsgIndex.FreeItem(Item : Pointer);
Begin;
   If Item <> nil Then Dispose(Item);
End;

Function MsgIndex.Compare(Key1, Key2 : Pointer) : Integer;
Var
   i : Integer;
   p : PMsg;
   w1, w2 : Word;
   M1, M2 : PMsg;
   ST : Word;
Begin;
   i := 0;
   w1 := Word(Key1^);
   w2 := Word(Key2^);
   M1 := MsgBase^.At(w1);
   M2 := MsgBase^.At(w2);
   If SortType <> 0 Then ST := SortType Else ST := 1;
   Case ST Of
        1 : Begin;
               If MakeSubj(M1^.Subject) > MakeSubj(M2^.Subject) Then i := 1;
               If MakeSubj(M1^.Subject) < MakeSubj(M2^.Subject) Then i := -1;
               If MakeSubj(M1^.Subject) = MakeSubj(M2^.Subject) Then Begin;
                  If M1^.MsgNum > M2^.MsgNum Then i := 1;
                  If M1^.MsgNum < M2^.MsgNum Then i := -1;
               End
            End;
        2 : Begin;
               If M1^.MsgNum > M2^.MsgNum Then i := 1;
               If M1^.MsgNum < M2^.MsgNum Then i := -1;
            End;
        3 : Begin;
               If M1^.Tu > M2^.Tu Then i := 1;
               If M1^.Tu < M2^.Tu Then i := -1;
               If M1^.Tu = M2^.Tu Then Begin;
                  If M1^.MsgNum > M2^.MsgNum Then i := 1;
                  If M1^.MsgNum < M2^.MsgNum Then i := -1;
               End
            End;
        4 : Begin;
               If M1^.From > M2^.From Then i := 1;
               If M1^.From < M2^.From Then i := -1;
               If M1^.From = M2^.From Then Begin;
                  If M1^.MsgNum > M2^.MsgNum Then i := 1;
                  If M1^.MsgNum < M2^.MsgNum Then i := -1;
               End
            End;
        5 : Begin;
               If M1^.MsgDate > M2^.MsgDate Then i := 1;
               If M1^.MsgDate < M2^.MsgDate Then i := -1;
               If M1^.MsgDate = M2^.MsgDate Then Begin;
                  If M1^.MsgNum > M2^.MsgNum Then i := 1;
                  If M1^.MsgNum < M2^.MsgNum Then i := -1;
               End
            End;
        End;
   Compare := i;
End;

Procedure PCharCollection.FreeItem(Item : Pointer);
Begin;
   StrDispose(Item);
End;

Function MsgBuffer.NumLines : LongInt;
Begin;
   NumLines := MIndex^.Count;
End;

Procedure MsgBuffer.NewStr(s : String);
Var
   p : PChar;
Begin;
   GetMem(p,Length(s) + 1);
   p := StrPCopy(p,s);
   MIndex.Insert(p);
   Size := Size + Length(s) + 1;
End;

Function MsgBuffer.SizeOf : LongInt;
Begin;
   SizeOf := Size;
End;

Function MsgBuffer.StrOf(l : LongInt) : String;
Begin;
   StrOf := StrPas(MIndex^.At(l - 1));
End;

Constructor MsgBuffer.Init;
Var
   l : LongInt;
Begin;
   MIndex := New(PPCharCollection,Init(64,32));
End;

Destructor MsgBuffer.Done;
Var
   l : LongInt;
Begin;
   Dispose(MIndex,Done);
End;

Procedure BBSConfCollection.NewC(w : Word; s : String; Mail, Internet : Boolean; Archive : Word);
Var
   p : PBBSConference;
Begin;
   p := New(PBBSConference);
   If p <> nil Then Begin;
      p^.ConfNum := w;
      p^.ConfName := s;
      p^.IsMail := Mail;
      p^.IsInternet := Internet;
      p^.DefaultArchiveAction := Archive;
      Insert(p);
   End;
End;

Function BBSConfCollection.Compare(Key1, Key2 : Pointer) : Integer;
Var
   i : Integer;
   w1, w2 : PBBSConference;
Begin;
   i := 0;
   w1 := PBBSConference(Key1);
   w2 := PBBSConference(Key2);
   If w1^.ConfNum > w2^.Confnum Then i := 1
   Else If w1^.ConfNum < w2^.ConfNum Then i := -1;
   Compare := i;
End;

Function BBSConfCollection.ConfOf(s : String) : Word;
Var
   w : Word;
   p : PBBSConference;
   found : Boolean;
Begin;
   w := 0;
   found := False;
   While (w < Count) And Not Found Do Begin;
      p := At(w);
      If Upper(p^.ConfName) = Upper(s) Then found := True;
      If Not Found Then Inc(w);
   End;
   If Found Then ConfOf := p^.ConfNum Else ConfOf := $FFFFFFFF;
End;

Procedure BBSConfCollection.ChangeName(w : Word; s : String);
Var
   y : Word;
   p : PBBSConference;
   found : Boolean;
Begin;
   y := 0;
   found := False;
   While (y < Count) And Not Found Do Begin;
      p := At(y);
      found := (p^.ConfNum = w);
      If Not Found Then Inc(y);
   End;
   If Found Then p^.ConfName := s Else NewC(w,s,False,False,4);
End;

Procedure BBSCollection.NewB(p : PBBS);
Begin;
   Insert(p);
End;

Function BBSCollection.Compare(Key1, Key2 : Pointer) : Integer;
Var
   i : Integer;
   w1, w2 : PBBS;
Begin;
   i := 0;
   w1 := PBBS(Key1);
   w2 := PBBS(Key2);
   If w1^.Number > w2^.Number Then i := 1
   Else If w1^.Number < w2^.Number Then i := -1;
   Compare := i;
End;

Function BBSCollection.BBSOf(w : Word) : PBBS;
Var
   p : PBBS;
   b : Boolean;
   i : LongInt;
Begin;
   p := New(PBBS);
   p^.Number := w;
   b := Search(p,i);
   Dispose(p);
   If b Then Begin;
      BBSOf := At(i);
   End Else BBSOf := nil;
End;

Function BBSCollection.BBSOfName(s : String) : PBBS;
Var
   p, b : PBBS;
   i : LongInt;
Begin;
   p := nil;
   For i := 0 To Count - 1 Do Begin;
      b := At(i);
      If b^.ID = s Then p := b;
   End;
   BBSOfName := p;
End;

Function BBSCollection.HighIDNumber : Word;
Var
   y, w : Word;
   p : PBBS;
Begin;
   w := 0;
   For y := 0 To Count - 1 Do Begin;
      p := At(y);
      If p^.Number > w Then w := p^.Number;
   End;
   HighIDNumber := w + 1;
End;

Function BBSConfCollection.ConfSpecOf(w : Word) : pBBSConference;
Var
   p : PBBSConference;
   b : Boolean;
   i : LongInt;
Begin;
   p := New(PBBSConference);
   p^.ConfNum := w;
   b := Search(p,i);
   Dispose(p);
   If b Then Begin;
      p := At(i);
      ConfSpecOf := p;
   End Else ConfSpecOf := nil;
End;

Function BBSConfCollection.ConfName(w : Word) : String;
Var
   p : PBBSConference;
   b : Boolean;
   i : LongInt;
Begin;
   p := New(PBBSConference);
   p^.ConfNum := w;
   b := Search(p,i);
   Dispose(p);
   If b Then Begin;
      p := At(i);
      ConfName := p^.ConfName;
   End Else ConfName := '';
End;

Function BBSConfCollection.IsMail(w : Word) : Boolean;
Var
   p : PBBSConference;
   b : Boolean;
   i : LongInt;
Begin;
   p := New(PBBSConference);
   p^.ConfNum := w;
   b := Search(p,i);
   Dispose(p);
   If b Then Begin;
      p := At(i);
      IsMail := p^.IsMail;
   End Else IsMail := False;
End;

Function OpenMsgTxtFile : pBoolean;
Var
   b : Byte;
   p : pBoolean;
Begin;
   p := OpenTxtQueue^.StartRequest;
   While p^ = False Do DosSleep(100);
   Assign(MsgTxtFile,'MSGTXT.DAT');
   Reset(MsgTxtFile,1);
   b := 1;
   Seek(MsgTxtFile,0);
   BlockWrite(MsgTxtFile,b,1);            { Open it and mark it dirty. }
   Seek(MsgTxtFile,3);
   OpenMsgTxtFile := p;
End;

Procedure CloseMsgTxtFile(b : pBoolean);
Var
   b2 : Byte;
Begin;
   b2 := 0;                                   { Set clean flag }
   Seek(MsgTxtFile,0);
   BlockWrite(MsgTxtFile,b2,1);
   Close(MsgTxtFile);
   b^ := False;
End;

Function ReadTxtLine : String;
Var
   s : String;
   c : Char;
Begin;
   s := '';
   Repeat
       BlockRead(MsgTxtFile,c,1);
       If c <> #0 Then s := s + c;
   Until (c = #0);
   ReadTxtLine := s;
End;

Function OpenMsgTxt(offset, l : LongInt; c, m : Word) : Boolean;
Var
   ie : Word;
   ln : LongInt;
   co, mn : Word;
   b : Byte;
Begin;
   {$I-}
   Seek(MsgTxtFile,offset);
   BlockRead(MsgTxtFile,ln,SizeOf(ln));
   BlockRead(MsgTxtFile,co,SizeOf(co));
   BlockRead(MsgTxtFile,mn,SizeOf(mn));
   BlockRead(MsgTxtFile,b,SizeOf(b));
   {$I+}
   ie := IOResult;
   If (co <> c) Or (mn <> m) Or (ie <> 0) Then OpenMsgTxt := False Else OpenMsgTxt := True;
End;

Function LoadMsgText(PM : PMsg; PB : PMsgBuffer) : Boolean;
{ Load the specified message into the buffer object provided. }
Var
   b : pBoolean;
   b2 : Boolean;
   l : LongInt;
Begin;
   b := OpenMsgTxtFile;
   b2 := OpenMsgTxt(PM^.Offset,PM^.Lines,PM^.Conference,PM^.MsgNum);
   If b2 Then For l := 1 To PM^.Lines Do PB^.NewStr(ReadTxtLine);
   CloseMsgTxtFile(b);
   LoadMsgText := b2;
End;

Function BuildConferenceIndex(b, c : Word; M : PMsgCollection) : PMsgIndex;
Var
   xw : Word;
   p : PMsgIndex;
   xM : PMsg;
Begin;
   p := New(PMsgIndex,Init(256,128));
   With p^ Do Begin;
        MsgBase := M;
        For xw := 0 To MsgBase^.Count - 1 Do Begin;
            xM := MsgBase^.At(xw);
            If xM <> nil Then
            If (xM^.IsArchived) Then Begin;
               If (xM^.ArchiveAction = 4) And (xM^.ExpireDate <= CurrentTime) Then
                  xM^.SetDeleted(True);
            End Else
            If (xM^.Conference = c) And (xM^.BBSID = b) And Not (xM^.IsDeleted)
               And Not (xM^.IsArchived) And Not (xM^.IsOutgoing)
               And Not (xM^.IsFiled) And Not (xM^.IsChron) Then
               NewI(xw);
        End;
   End;
   BuildConferenceIndex := p;
End;

Function AccessQueueThread(P : Pointer) : LongInt;
{ Monitor the access queue, and when there are any present, handle them one by one. }
Var
   pb : pBoolean;
   x : LongInt;
   rc : ApiRet;
Begin;
   Repeat;
      x := OpenTxtQueue^.Count;
      While x = 0 Do Begin;
         DosSleep(100);
         x := OpenTxtQueue^.Count;
      End;
      pb := OpenTxtQueue^.At(0);
      pb^ := True;
      While pb^ = True Do DosSleep(100);
      OpenTxtQueue^.AtDelete(0);
      Dispose(pb);
   Until False;
End;

Function BuildArchiveConferenceIndex(b, c : Word; M : PMsgCollection) : PMsgIndex;
Var
   xw : Word;
   p : PMsgIndex;
   xM : PMsg;
Begin;
   p := New(PMsgIndex,Init(256,128));
   With p^ Do Begin;
        MsgBase := M;
        For xw := 0 To MsgBase^.Count - 1 Do Begin;
            xM := MsgBase^.At(xw);
            If xM <> nil Then
            If (xM^.ArchiveAction = 4) And (xM^.ExpireDate <= CurrentTime) Then
               xM^.SetDeleted(True)
            Else
            If (xM^.Conference = c) And (xM^.BBSID = b) And Not (xM^.IsDeleted)
               And (xM^.IsArchived) And Not (xM^.IsFiled) And Not (xM^.IsChron) Then
               NewI(xw);
        End;
   End;
   BuildArchiveConferenceIndex := p;
End;

Function BuildOutgoingConferenceIndex(b, c : Word; M : PMsgCollection) : PMsgIndex;
Var
   xw : Word;
   p : PMsgIndex;
   xM : PMsg;
Begin;
   p := New(PMsgIndex,Init(256,128));
   With p^ Do Begin;
        MsgBase := M;
        For xw := 0 To MsgBase^.Count - 1 Do Begin;
            xM := MsgBase^.At(xw);
            If xM <> nil Then Begin;
               If (xM^.Conference = c) And (xM^.BBSID = b) And Not (xM^.IsDeleted)
                  And (xM^.IsOutgoing) Then
                  NewI(xw);
            End;
        End;
   End;
   BuildOutgoingConferenceIndex := p;
End;

Function BuildPersonalConferenceIndex(b, c : Word; M : PMsgCollection; BBSs : PBBSCollection) : PMsgIndex;
Var
   xw : Word;
   p : PMsgIndex;
   xM : PMsg;
   s : String;
Begin;
   p := New(PMsgIndex,Init(256,128));
   With p^ Do Begin;
        MsgBase := M;
        For xw := 0 To MsgBase^.Count - 1 Do Begin;
            xM := MsgBase^.At(xw);
            If xM <> nil Then If Not (xM^.IsArchived or xM^.IsChron or xM^.IsFiled) Then Begin;
               s := xM^.Tu;
               Trim(s);
               If (xM^.BBSID = b) And Not (xM^.IsDeleted) And (s <> '') And
               ((xM^.Tu = BBSs^.BBSOf(xM^.BBSID)^.UserName) Or ((s <> '') And (Pos(Cfg.EmailAddress,s) <> 0)))
               And (xM^.Conference = c) Then
                  NewI(xw);
            End;
        End;
   End;
   BuildPersonalConferenceIndex := p;
End;

Function BuildChronConferenceIndex(b, c : Word; M : PMsgCollection) : PMsgIndex;
Var
   xw : Word;
   p : PMsgIndex;
   xM : PMsg;
Begin;
   p := New(PMsgIndex,Init(256,128));
   With p^ Do Begin;
        MsgBase := M;
        For xw := 0 To MsgBase^.Count - 1 Do Begin;
            xM := MsgBase^.At(xw);
            If xM <> nil Then
            If (xM^.Conference = c) And (xM^.BBSID = b) And Not (xM^.IsDeleted)
               And (xM^.IsChron) Then
               NewI(xw);
        End;
   End;
   BuildChronConferenceIndex := p;
End;

Procedure DisposeIndex(M : PMsgIndex);
Begin;
   Dispose(M,Done);
End;

Function BuildFolderIndex(f : Word; M : PMsgCollection) : PMsgIndex;
Var
   xw : Word;
   p : PMsgIndex;
   xM : PMsg;
Begin;
   p := New(PMsgIndex,Init(256,128));
   p^.MsgBase := M;
   With p^ Do Begin;
        For xw := 0 To MsgBase^.Count - 1 Do Begin;
            xM := MsgBase^.At(xw);
            If xM <> nil Then
            If (xM^.IsFiled) And (xM^.Folder = f) And Not (xM^.IsDeleted) Then
               NewI(xw);
        End;
   End;
   BuildFolderIndex := p;
End;

Procedure ResortIndex(var p : PMsgIndex; SortType : Word);
Var
   p2 : PMsgIndex;
   p3 : PWord;
   w, M : Word;
   ms : PMsg;
Begin;
   p2 := New(PMsgIndex,Init(256,128));
   p2^.MsgBase := p^.MsgBase;
   p2^.SortType := SortType;
   For w := 0 To p^.Count -1 Do Begin;
       p3 := p^.At(w);
       M := p3^;
       ms := p^.MsgBase^.At(M);
       If Not Ms^.IsDeleted Then p2^.NewI(M);
   End;
   DisposeIndex(p);
   p := p2;
End;

Procedure CreateMsgTxtFile;
Var
   b : Byte;
   w : Smallword;
Begin;
   Assign(MsgTxtFile,'MSGTXT.DAT');
   Rewrite(MsgTxtFile,1);
   b := 0;                                      { Message text file is 'clean' }
   BlockWrite(MsgTxtFile,b,1);
   w := $100;                               { Message text file version number }
   BlockWrite(MsgTxtFile,w,2);
   Close(MsgTxtFile);
End;

Procedure InitRequestQueue;
Begin;
   OpenTxtQueue := New(PAccessQueue,Init(8,8));
   VPBeginThread(AccessQueueThread,16384,nil);
End;

Function CreateNewMsgTxt(Conf, MNum : Word) : LongInt;
Var                                             { Create space for a new message }
   l : LongInt;
   b : Byte;
   msgaddr : LongInt;                           { Where message starts in file }
Begin;
   msgaddr := FileSize(MsgTxtFile);
   Seek(MsgTxtFile,msgaddr);                    { Place message at the very end. }
   l := 0;
   BlockWrite(MsgTxtFile,l,SizeOf(l));          { The length usually goes here }
   BlockWrite(MsgTxtFile,Conf,SizeOf(Conf));
   BlockWrite(MsgTxtFile,MNum,SizeOf(MNum));
   b := 0;
   BlockWrite(MsgTxtFile,b,SizeOf(b));          { Compression type  0 = uncompressed }
   CreateNewMsgTxt := msgaddr;                  { And return beginning of message, with
                                                  file position already set to go. }
End;

Procedure DumpTxtLine(s : String);
Var
   c : Char;
Begin;
   BlockWrite(MsgTxtFile,s[1],Length(s));
   c := #0;
   BlockWrite(MsgTxtFile,c,1);
End;

Procedure CloseMsg(Offset, size : LongInt);     { Close out the current message }
Begin;
   Seek(MsgTxtFile,Offset);
   BlockWrite(MsgTxtFile,size,SizeOf(size));
   MsgTxtFileLocked := False;
End;

Procedure DumpMsgText(PB : PMsgBuffer);
{ Dump the message text object to the data file at its current location. }
Var
   l : LongInt;
Begin;
   For l := 1 To PB^.NumLines Do DumpTxtLine(PB^.StrOf(l));
End;

Procedure DumpMsgToTxtFile(PM : PMsg; PB : PMsgBuffer; Hdr, Txt : String);
Var
   f : Text;
   y : Word;
Begin;
   If Hdr <> '' Then Begin;
      Assign(f,Hdr);
      Rewrite(f);
      WriteLn(f,PM^.Tu);
      WriteLn(f,PM^.From);
      WriteLn(f,PM^.Subject);
      Close(f);
   End;
   Assign(f,Txt);
   Rewrite(f);
   For y := 1 To PB^.NumLines Do WriteLn(f,PB^.StrOf(y));
   Close(f);
End;

Procedure LoadMsgFromTxtFile(var PB : PMsgBuffer;txt : String);
Var
   f : Text;
   s : String;
Begin;
   If PB <> nil Then Dispose(PB, Done);
   PB := New(PMsgBuffer,Init);
   Assign(f,Txt);
   Reset(f);
   While Not EOF(f) Do Begin;
      ReadLn(f,s);
      PB^.NewStr(s);
   End;
   Close(f);
End;

Function CreateNewMsg(BBS, Conf, MNum : Word; MsgBase : PMsgCollection) : PMsg;
Var
   p : PMsg;
   l : LongInt;
Begin;
   p := New(PMsg,Init);
   p^.BBSID := BBS;
   p^.Conference := Conf;
   p^.MsgNum := MNum;
   p^.SetFiled(False);
   p^.SetChron(False);
   p^.SetRead(False);
   p^.SetArchived(False);
   p^.SetOutgoing(False);
   p^.Folder := 0;
   MsgBase^.NewM(p);
   CreateNewMsg := p;
End;

Function WriteNewMsg(M : PMsg; buf : PMsgBuffer) : Boolean;
Var
   b : Byte;
   p : pBoolean;
   l : LongInt;
Begin;
   p := OpenMsgTxtFile;
   l := CreateNewMsgTxt(M^.Conference,M^.MsgNum);
   M^.Offset := l;
   M^.Lines := buf^.NumLines;
   M^.Length := buf^.SizeOf;
   DumpMsgText(buf);
   CloseMsg(M^.Offset,M^.Length);
   Assign(MsgIdxFile,'MSGIDX.DAT');
   Reset(MsgIdxFile,1);
   Seek(MsgIdxFile,FileSize(MsgIdxFile));
   BlockWrite(MsgIdxFile,M^,SizeOf(M^));
   Close(MsgIdxFile);
   CloseMsgTxtFile(p);
End;

Function LoadMsgBase : PMsgCollection;
{ Load the message base's index }
Var
   M : PMsg;
   f : File;
   MsgBase : PMsgCollection;
Begin;
   MsgBase := New(PMsgCollection,Init(1024,1024));
   Assign(f,'MSGIDX.DAT');
   Reset(f,1);
   While Not EOF(f) Do Begin;
      M := New(PMsg,Init);
      BlockRead(f,M^,SizeOf(M^));
      MsgBase^.NewM(M);
   End;
   Close(f);
   LoadMsgBase := MsgBase;
End;

Procedure SaveMsgBase(MBase : PMsgCollection);
{ Save the message base's index, in its current state }
Var
   M : PMsg;
   f : File;
   MsgBase : PMsgCollection;
   y : LongInt;
Begin;
   Assign(f,'MSGIDX.~AT');
   Rewrite(f,1);
   For y := 0 To MBase^.Count - 1 Do Begin;
      M := MBase^.At(y);
      If M <> Nil Then
      If Not M^.IsDeleted Then BlockWrite(f,M^,SizeOf(Msg));
   End;
   Close(f);
   Assign(f,'MSGIDX.DAT');
   Erase(f);
   Assign(f,'MSGIDX.~AT');
   Rename(f,'MSGIDX.DAT');
End;

Procedure SaveBBSDefs(BBSs : PBBSCollection);
Var
   b : PBBS;
   c : PBBSConference;
   f, f2 : File;
   y, z : LongInt;
Begin;
   Assign(f,'BBSCFG.DAT');
   Rewrite(f,1);
   For y := 0 To BBSs^.Count - 1 Do Begin;
      b := BBSs^.At(y);
      BlockWrite(f,b^,SizeOf(BBS));
      Assign(f2,b^.ID + '.BBS');
      Rewrite(f2,1);
      For z := 0 To b^.Confs^.Count - 1 Do Begin;
         c := b^.Confs^.At(z);
         BlockWrite(f2,c^,SizeOf(BBSConference));
      End;
      Close(f2);
   End;
   Close(f);
End;

Procedure LoadBBSDefs(BBSs : PBBSCollection);
Var
   b : PBBS;
   c : BBSConference;
   f, f2 : File;
   y, z : LongInt;
Begin;
   Assign(f,'BBSCFG.DAT');
   Reset(f,1);
   While Not EOF(f) Do Begin;
      b := New(PBBS);
      BlockRead(f,b^,SizeOf(BBS));
      Trim(b^.UserName);
      If (b^.PacketType = 'SOUP') And (b^.UserName <> Cfg.EMailaddress) Then b^.UserName := Cfg.EMailAddress;
      If (b^.PacketType = 'SOUP') And (b^.Incrementer < 0) Then b^.Incrementer := 0;
      BBSs^.NewB(b);
      b^.Confs := New(PBBSConfCollection,Init(128,64));
      Assign(f2,b^.ID + '.BBS');
      Reset(f2,1);
      While Not EOF(f2) Do Begin;
         BlockRead(f2,c,SizeOf(BBSConference));
         If c.DefaultArchiveAction = 0 Then c.DefaultArchiveAction := 4;
         b^.Confs^.NewC(c.ConfNum,c.ConfName,c.IsMail,c.IsInternet,c.DefaultArchiveAction);
      End;
      Close(f2);
   End;
   Close(f);
End;

Function InStr(s, s2 : String) : Boolean;
Begin;
   If Pos(Upper(s2),Upper(s)) > 0 Then InStr := True Else InStr := False;
End;

Function Msg.IsTrash : Boolean;
Var
   st, s2 : String;
   r : Boolean;
   Index, c, tot, ctr : Word;
Begin;
   r := False;
   Index := 1;
   While (Index <= 3) And Not r Do Begin;
      Case Index Of
           1 : tot := TrashFrom^.Count;
           2 : tot := TrashTo^.Count;
           3 : tot := TrashSubj^.Count;
      End;
      c := 1;
      While (c <= tot) And Not r Do Begin;
          Case Index Of
               1 : If Instr(From,TrashFrom^.Get(c)) Then r := True;
               2 : If Instr(Tu,TrashTo^.Get(c)) Then r := True;
               3 : If Instr(Subject,TrashSubj^.Get(c)) Then r := True;
          End;
          Inc(c);
      End;
      Inc(Index);
   End;
   IsTrash := r;
End;

Function MsgBuffer.IsTrash : Boolean;
Var
   st, s2 : String;
   r : Boolean;
   c, tot, ctr : Word;
Begin;
   r := False;
   If (NumT_Text > 0) Then Begin;
       ctr := 1;
       While (ctr <= NumLines) And Not r Do Begin;
          st := Upper(StrOf(ctr));
          For c := 1 To tot Do Begin;
              s2 := Upper(TrashText^.Get(c));
              If Instr(st,s2) Then r := True;
          End;
          Inc(ctr);
       End;
   End;
   IsTrash := r;
End;

End.

