/* RESIDS.H Resource-IDs */

#define IDIC_CCENTRY        8
#define IDIC_MESSAGE        9
#define ID_WINDOW           1  /* ID des App-Frames */
#define IDBMP_ABOUT        11
#define IDBMP_CHECK        12
#define ID_REGTIMER        25  /* Timer-ID fuer Nagging Features */
#define ID_ACCEL1          30  /* Accelerator-Tabelle Lesen */
#define ID_ACCEL2          31  /* Accelerator-Tabelle Schreiben */
#define ID_ACCEL3          32  /* Accelerator-Tabelle Dialoge */

/* Fensterelemente */
#define IDML_MAINEDIT     110
#define IDS_FROM          133
#define IDS_TO            134
#define IDS_SUBJ          135
#define IDS_DATEWRITTEN   137
#define IDS_DATERECEIVED  138
#define IDE_FROMNAME      139
#define IDE_TONAME        140
#define IDE_SUBJTEXT      141
#define IDE_FROMADDRESS   142
#define IDE_TOADDRESS     143
#define IDS_ATTRTEXT      144

/* Buttons */
#define IDB_PREVMSG       200
#define IDB_NEXTMSG       201
#define IDB_PREVREPLY     202
#define IDB_NEXTREPLY     203
#define IDB_FIRSTMSG      204
#define IDB_LASTMSG       205
#define IDB_FIND          206
#define IDB_MSGTREE       207
#define IDB_NEWMSG        208
#define IDB_REPLY         209
#define IDB_IMPORT        210
#define IDB_EXPORT        211
#define IDB_DELMSG        212
#define IDB_EDITMSG       213
#define IDB_AREA          214
#define IDB_MSGLIST       215
#define IDB_PRINTMSG      216
#define IDB_SHOWKLUDGES   217
#define IDB_OK            218
#define IDB_CANCEL        219
#define IDB_CHANGEATTR    220
#define IDB_HOMEMSG       221
#define IDB_NEXTAREA      222
#define IDB_BOOKMARKS     223
#define IDB_HELP          224
#define IDB_COPYMSG       225
#define IDB_COPY          226
#define IDB_CUT           227
#define IDB_PASTE         228
#define IDB_SHELL         229
#define IDB_SCRIPTS       230
#define IDB_MOVEMSG       231
#define IDB_BROWSER       232
#define IDB_FORWARD       233
#define IDB_CATCHUP       234
#define IDB_REQUEST       235

/* Bitmaps f. Buttons */
#define IDBMP_PREVMSG     250
#define IDBMP_NEXTMSG     251
#define IDBMP_PREVREPLY   252
#define IDBMP_NEXTREPLY   253
#define IDBMP_FIRSTMSG    254
#define IDBMP_LASTMSG     255
#define IDBMP_FIND        256
#define IDBMP_MSGTREE     257
#define IDBMP_NEWMSG      258
#define IDBMP_REPLY       259
#define IDBMP_IMPORT      260
#define IDBMP_EXPORT      261
#define IDBMP_DELMSG      262
#define IDBMP_EDITMSG     263
#define IDBMP_AREA        264
#define IDBMP_MSGLIST     265
#define IDBMP_PRINTMSG    266
#define IDBMP_SHOWKLUDGES 267
#define IDBMP_OK          268
#define IDBMP_CANCEL      269
#define IDBMP_CHANGEATTR  270
#define IDBMP_HOMEMSG     271
#define IDBMP_NEXTAREA    272

#define IDBMP_PREVMSG_S      273
#define IDBMP_NEXTMSG_S      274
#define IDBMP_PREVREPLY_S    275
#define IDBMP_NEXTREPLY_S    276
#define IDBMP_FIRSTMSG_S     277
#define IDBMP_LASTMSG_S      278
#define IDBMP_FIND_S         279
#define IDBMP_MSGTREE_S      280
#define IDBMP_NEWMSG_S       281
#define IDBMP_REPLY_S        282
#define IDBMP_IMPORT_S       283
#define IDBMP_EXPORT_S       284
#define IDBMP_DELMSG_S       285
#define IDBMP_EDITMSG_S      286
#define IDBMP_AREA_S         287
#define IDBMP_MSGLIST_S      288
#define IDBMP_PRINTMSG_S     289
#define IDBMP_SHOWKLUDGES_S  290
#define IDBMP_OK_S           291
#define IDBMP_CANCEL_S       292
#define IDBMP_CHANGEATTR_S   293
#define IDBMP_HOMEMSG_S      294
#define IDBMP_NEXTAREA_S     295

#define IDBMP_SEPARATOR      296

#define IDBMP_BOOKMARKS      297
#define IDBMP_BOOKMARKS_S    298
#define IDBMP_HELP           299
#define IDBMP_HELP_S         300
#define IDBMP_COPYMSG        301
#define IDBMP_COPYMSG_S      302
#define IDBMP_COPY           303
#define IDBMP_COPY_S         304
#define IDBMP_CUT            305
#define IDBMP_CUT_S          306
#define IDBMP_PASTE          307
#define IDBMP_PASTE_S        308
#define IDBMP_SHELL          309
#define IDBMP_SHELL_S        310
#define IDBMP_SCRIPTS        311
#define IDBMP_SCRIPTS_S      312
#define IDBMP_MOVEMSG        313
#define IDBMP_MOVEMSG_S      314
#define IDBMP_BROWSER        315
#define IDBMP_BROWSER_S      316
#define IDBMP_FORWARD        317
#define IDBMP_FORWARD_S      318
#define IDBMP_CATCHUP        319
#define IDBMP_CATCHUP_S      320
#define IDBMP_REQUEST        321
#define IDBMP_REQUEST_S      322

/* Strings */
#define IDST_TABLE          300

#define IDST_HLP_PREVMSG         301
#define IDST_HLP_NEXTMSG         302
#define IDST_HLP_PREVREPLY       303
#define IDST_HLP_NEXTREPLY       304
#define IDST_HLP_FIRSTMSG        305
#define IDST_HLP_LASTMSG         306
#define IDST_HLP_FIND            307
#define IDST_HLP_MSGTREE         308
#define IDST_HLP_NEWMSG          309
#define IDST_HLP_REPLY           310
#define IDST_HLP_IMPORT          311
#define IDST_HLP_EXPORT          312
#define IDST_HLP_DELMSG          313
#define IDST_HLP_EDITMSG         314
#define IDST_HLP_AREA            315
#define IDST_HLP_MSGLIST         316
#define IDST_HLP_PRINTMSG        317
#define IDST_HLP_SHOWKLUDGES     318
#define IDST_HLP_OK              319
#define IDST_HLP_CANCEL          320
#define IDST_HLP_CHANGEATTR      321
#define IDST_HLP_FI_FILE         322
#define IDST_HLP_FI_IMPORT       323
#define IDST_HLP_FI_EXPORT       324
#define IDST_HLP_FI_ECHOTOSS     325
#define IDST_HLP_FI_EXIT         326
#define IDST_HLP_ED_EDIT         327
#define IDST_HLP_ED_UNDO         328
#define IDST_HLP_ED_CUT          329
#define IDST_HLP_ED_COPY         330
#define IDST_HLP_ED_PASTE        331
#define IDST_HLP_ED_CLEAR        332
#define IDST_HLP_ED_CLRLINE      333
#define IDST_HLP_MS_MESSAGE      334
#define IDST_HLP_MS_MOVE         335
#define IDST_HLP_MS_XPOST        336
#define IDST_HLP_MS_REQ          337
#define IDST_HLP_MS_CCOPY        338
#define IDST_HLP_MS_MARK         339
#define IDST_HLP_SU_SETUP        340
#define IDST_HLP_SU_OPTIONS      341
#define IDST_HLP_SU_TEMPL        342
#define IDST_HLP_SU_CCLIST       343
#define IDST_HLP_SU_NAMEAD       344
#define IDST_HLP_SU_SAVE         345
#define IDST_HLP_WI_WINDOWS      346
#define IDST_HLP_WI_KLUDGE       347
#define IDST_HLP_WI_THREAD       348
#define IDST_HLP_WI_RESULTS      349
#define IDST_HLP_WI_PROGRESS     350
#define IDST_HLP_HE_HELP         351
#define IDST_HLP_HE_INDEX        352
#define IDST_HLP_HE_USING        353
#define IDST_HLP_HE_KEYS         354
#define IDST_HLP_HE_ABOUT        355
#define IDST_HLP_HE_GENERAL      356
#define IDST_HLP_FI_PRINT        357
#define IDST_HLP_MS_FIND         358
#define IDST_HLP_MS_DELETE       359
#define IDST_HLP_MS_REPLY        360
#define IDST_HLP_MS_CHANGE       361
#define IDST_HLP_MS_NEW          362
#define IDST_HLP_FI_SHELL        363
#define IDST_HLP_HOMEMSG         364
#define IDST_HLP_NEXTAREA        365
#define IDST_HLP_MS_COPY         366
#define IDST_HLP_MS_FORWARD      367
#define IDST_HLP_WI_AREAS        368
#define IDST_HLP_WI_MLIST        369
#define IDST_HLP_HE_CONTENTS     370
#define IDST_HLP_MS_BCAST        371
#define IDST_HLP_MS_BCDELETE     372
#define IDST_HLP_MS_BCMODIFY     373
#define IDST_HLP_SP_SPECIAL      374
#define IDST_HLP_MS_QUICKCC      375
#define IDST_HLP_FI_PRINTSETUP   376
#define IDST_HLP_ED_SEARCH       377
#define IDST_HLP_TB_ADD          378

#define IDST_MSG_DELETE           500
#define IDST_MSG_CANCEL           501
#define IDST_MSG_NORMALEXIT       502
#define IDST_MSG_EXITNOSAVE       503
#define IDST_MSG_BEENSENT         504
#define IDST_MSG_ERRORLOAD        505
#define IDST_MSG_ERRORSAVE        506
#define IDST_MSG_ERRORAREA        507
#define IDST_MSG_NOTFOUND         508
#define IDST_MSG_FALSEADDRESS     509
#define IDST_MSG_QUOTEWARN        510
#define IDST_MSG_FALSEREGISTER    511
#define IDST_MSG_NODELISTNF       513
#define IDST_MSG_ERRREADINGCFG    514
#define IDST_MSG_NOINIFILE        515
#define IDST_MSG_OLDINIFILE       516
#define IDST_MSG_ALREADYHAVEAREA  517
#define IDST_MSG_NOHELP           518
#define IDST_MSG_DELAREA          519
#define IDST_MSG_DELADDRESS       520
#define IDST_MSG_DELUNAME         521
#define IDST_MSG_DELNICKNAME      522
#define IDST_MSG_DUPAREAS         523
#define IDST_MSG_ERRORINIFILE     524
#define IDST_MSG_INFOMISSING      525
#define IDST_MSG_TEXTTOOLONG      526
#define IDST_MSG_ERRORMSGSAVE     527
#define IDST_MSG_INVALIDFILE      528
#define IDST_MSG_MARKALL          529
#define IDST_MSG_EMPTYFILE        530
#define IDST_AL_AREADESC          531
#define IDST_AL_UNREAD            532
#define IDST_AL_TOTAL             533
#define IDST_AL_DELETE            534
#define IDST_FD_AREA              535
#define IDST_FD_NUMBER            536
#define IDST_FD_FROM              537
#define IDST_FD_SUBJECT           538
#define IDST_TITLE_DISCARD        539
#define IDST_FORMAT_SCANNING      540
#define IDST_TITLE_MARKALL        541
#define IDST_TITLE_DELETE         542
#define IDST_TITLE_BEENSENT       543
#define IDST_TITLE_CANCEL         544
#define IDST_MW_NOAREA            545
#define IDST_MW_FROM              546
#define IDST_MW_TO                547
#define IDST_MW_SUBJ              548
#define IDST_MW_ATTRIB            549
#define IDST_MW_AREA              550
#define IDST_ML_WORKING           551
#define IDST_ML_UNREAD            552
#define IDST_ML_ALLTHREADS        553
#define IDST_ML_NUMBER            554
#define IDST_ML_FROM              555
#define IDST_ML_TO                556
#define IDST_ML_SUBJECT           557
#define IDST_ML_UNREADBT          558
#define IDST_ML_ALLMSGBT          559
#define IDST_TITLE_DELUNAME       560
#define IDST_TITLE_DELADDRESS     561
#define IDST_TITLE_DELNICKNAME    562
#define IDST_FORMAT_RANGE         563
#define IDST_TITLE_DELCCLIST      564
#define IDST_MSG_DELCCLIST        565
#define IDST_CC_NAME              567
#define IDST_CC_ADDRESS           568
#define IDST_CC_SHOW              569
#define IDST_CC_YES               570
#define IDST_CC_NO                571
#define IDST_MSG_DELCCENTRY       572
#define IDST_TITLE_DELCCENTRY     573
#define IDST_TAB_QUOTE            574
#define IDST_TAB_HEADER           575
#define IDST_TAB_FOOTER           576
#define IDST_TAB_REPLY            577
#define IDST_TAB_DAREA            578
#define IDST_TAB_FORWARD          579
#define IDST_TAB_XPOST            580
#define IDST_TAB_CCOPY            581
#define IDST_TPL_HEADER           582
#define IDST_TPL_FOOTER           583
#define IDST_TPL_REPLY            584
#define IDST_TPL_DAREA            585
#define IDST_TPL_FORWARD          586
#define IDST_TPL_XPOST            587
#define IDST_TPL_CCOPY            588
#define IDST_ML_UNREADONLY        589
#define IDST_NOT_XPDESELECT       590
#define IDST_NOT_CCDESELECT       591
#define IDST_NOT_MOVED            592
#define IDST_NOT_COPIED           593
#define IDST_MSG_HAVEDOMAIN       594
#define IDST_NOT_REQUESTED        596
#define IDST_NOT_EXPORTED         597
#define IDST_NOT_MARKALL          598
#define IDST_MSG_INVALIDFILENAME  599
#define IDST_MSG_RESEND           600
#define IDST_TITLE_RESEND         601
#define IDST_MSG_HAVENICKNAME     602
#define IDST_NICK_NICKNAME        603
#define IDST_NICK_REALNAME        604
#define IDST_NICK_ADDRESS         605
#define IDST_NOT_PRINTED          608
#define IDST_MSG_IDXOPENERR       609
#define IDST_MSG_DATOPENERR       610
#define IDST_MSG_IDXREADERR       611
#define IDST_MSG_DATREADERR       612
#define IDST_MSG_LOOKUPMEM        613
#define IDST_MSG_ERRREADSQPARAM   614
#define IDST_MSG_ERRWRITESQPARAM  615
#define IDST_MSG_SQPARAMVALUES    616
#define IDST_TPL_FORWARDFOOTER    617
#define IDST_TAB_FORWARDFOOTER    618
#define IDST_MSG_LOOKUPHANDLE     619
#define IDST_MSG_DELDOMAIN        620
#define IDST_TITLE_DELDOMAIN      621
#define IDST_RENUM_STAGE1         622
#define IDST_RENUM_STAGE2         623
#define IDST_AP_TITLE             624
#define IDST_AP_EMPTYTITLE        625
#define IDST_LU_ADDRESS           626
#define IDST_LU_SYSTEM            627
#define IDST_LU_LOCATION          628
#define IDST_LU_PHONE             629
#define IDST_LU_MODEM             630
#define IDST_LU_BAUD              631
#define IDST_LU_CALLCOST          632
#define IDST_LU_USERCOST          633
#define IDST_LU_FLAGS             634
#define IDST_ATT_TITLEFILE        635
#define IDST_ATT_TITLESIZE        636
#define IDST_ATT_TITLESTATUS      637
#define IDST_ATT_OK               638
#define IDST_ATT_NOTF             639
#define IDST_ML_NOSUBJ            640
#define IDST_LU_SYSOP             641
#define IDST_TAB_FORWARDORDER     642
#define IDST_MSG_NEXTAREA         643
#define IDST_MSG_NONEXTAREA       644
#define IDST_TITLE_NEXTAREA       645
#define IDST_TAB_AL_VIEW          646
#define IDST_TAB_AL_SORT          647
#define IDST_TAB_AL_COLORS        648
#define IDST_MSG_WORKERROR        649
#define IDST_ML_DATEWRITTEN       650
#define IDST_MSG_LOCKERROR        651
#define IDST_MSG_BCDELERROR       652
#define IDST_TITLE_BCDELERROR     653
#define IDST_TITLE_AL_COPY        654
#define IDST_TITLE_AL_MOVE        655
#define IDST_TITLE_AL_FORWARD     656
#define IDST_TITLE_AL_XPOST       657
#define IDST_TITLE_AL_REPLY       658
#define IDST_TPL_DEFNAME          659
#define IDST_TPL_NEWNAME          660
#define IDST_MSG_DELTEMPLATE      661
#define IDST_TITLE_DELTEMPLATE    662
#define IDST_CC_NEWNAME           663
#define IDST_MSG_NOCCLIST         664
#define IDST_RX_NEWSCRIPT         665
#define IDST_HLP_REXX             666
#define IDST_HLP_RXSCRIPTS        667
#define IDST_MSG_REXXERROR        668
#define IDST_TITLE_REXXERROR      669
#define IDST_TAB_RXGENERAL        670
#define IDST_TAB_RXMONITOR        671
#define IDST_MSG_DELSCRIPT        672
#define IDST_TITLE_DELSCRIPT      673
#define IDST_MSG_NOCCENTRIES      674
#define IDST_MSG_MODQUICKCC       675
#define IDST_TITLE_MODQUICKCC     676
#define IDST_CC_QUICKCC           677
#define IDST_TAB_THREADS          678
#define IDST_TAB_THREADCOLORS     679
#define IDST_MSG_DOINGWORK        680
#define IDST_MSG_REPLACENICK      681
#define IDST_TITLE_REPLACENICK    682
#define IDST_HLP_ADDTONICK        683
#define IDST_HLP_ADDTOCC          684
#define IDST_MSG_CATCHUP          685
#define IDST_TITLE_CATCHUP        686
#define IDST_TAB_RXHOOKS          687
#define IDST_RX_NOHOOK            688
#define IDST_MSG_FINDNOPARTS      689
#define IDST_MSG_FINDNOAREAS      690
#define IDST_MSG_FINDNOTEXT       691
#define IDST_HLP_MARKMSG          692
#define IDST_HLP_UNMARKMSG        693
#define IDST_MSG_NOTTHERE         694
#define IDST_HLP_SPCBROWSER       695
#define IDST_BRS_NODESTPL         696
#define IDST_BRS_NAMESTPL         697
#define IDST_BRS_ZONETPL          698
#define IDST_BRS_NETTPL           699
#define IDST_BRS_OTHERNAME        700
#define IDST_BRS_WORKING          701
#define IDST_RX_ACCEL             702
#define IDST_MSG_ETOSSERROR       703
#define IDST_FORMAT_REG           704
#define IDST_MSG_NOAREATAG        705
#define IDST_MSG_NOPATHFILE       706
#define IDST_LU_TITLE             707
#define IDST_TAB_ORIGIN           708
#define IDST_AP_CANCEL            709
#define IDST_HLP_OPNICKNAMES      710
#define IDST_EM_ECHO              711
#define IDST_EM_STATUS            712
#define IDST_EM_ACTION            713
#define IDST_EM_LINKED            714
#define IDST_EM_UNLINKED          715
#define IDST_EM_LINK              716
#define IDST_EM_UNLINK            717
#define IDST_EM_RESCAN            718
#define IDST_TAB_DLLEXT           719
#define IDST_TAB_UPLINKS          720
#define IDST_HLP_OPECHOMAN        721
#define IDST_HLP_OPADDAREAS       722
#define IDST_MSG_NOUPLINKAREAS    723
#define IDST_EM_REFRESH           724
#define IDST_EM_PAUSE             725
#define IDST_EM_RESUME            726
#define IDST_MSG_NOACTIONS        727
#define IDST_MSG_DOEXTRACT        728
#define IDST_TITLE_DOEXTRACT      729
#define IDST_MSG_EM_DLLLOAD       730
#define IDST_MSG_EM_DLLVER        731
#define IDST_MSG_EM_DLLFUNC       732
#define IDST_MSG_EM_DLLINT        733
#define IDST_MSG_EM_CFGNOTF       734
#define IDST_MSG_EM_INIT          735
#define IDST_MSG_EM_CFGREAD       736
#define IDST_MSG_EM_CFGWRITE      737
#define IDST_MSG_EM_CFGFORMAT     738
#define IDST_MSG_EM_CFGLINKED     739
#define IDST_MSG_EM_CFGUNLINKED   740
#define IDST_MSG_DELUPLINK        741
#define IDST_TITLE_DELUPLINK      742
#define IDST_MSG_EM_NOPASS        743
#define IDST_NOT_EXTRACTED        744
#define IDST_TITLE_ATTACHFILES    745
#define IDST_MSG_INITBASE2        746 /* unbenutzt */
#define IDST_MSG_INITBASE         747 /* + 10 reserviert */
#define IDST_TPL_ALLSYN           757
#define IDST_MSG_APPENDAREAS      758
#define IDST_NOT_STRINGNOTFOUND   759
#define IDST_TAB_PS_LIST          760
#define IDST_TAB_PS_BORDERS       761
#define IDST_TAB_PS_FONTS         762
#define IDST_TAB_PS_OUTPUT        763
#define IDST_MT_BIT               764
#define IDST_MT_BYTE              765
#define IDST_MT_DESC              766
#define IDST_TBC_DISP             767
#define IDST_TBC_AVAIL            768
#define IDST_TBC_SEPARATOR        769
#define IDST_MSG_REGONLY          770
#define IDST_TITLE_REGONLY        771
#define IDST_MSG_REQ_NOTF         772
#define IDST_MSG_REQ_READERR      773
#define IDST_MSG_REQ_DELLIST      774
#define IDST_TITLE_REQ_DELLIST    775
#define IDST_MSG_CFGDLLBASE       776  /* +10 reserviert */
                               /* 786 */
#define IDST_TAB_SU_OPENWIN       787
#define IDST_AL_DEFAULT           788
#define IDST_AL_NEWFOLDER         789

/* Icons */
#define IDIC_PLUS                 700
#define IDIC_MINUS                701
#define IDIC_TEMPLATE             712
#define IDIC_DEFTEMPLATE          713
#define IDIC_CCLIST               714
#define IDIC_RXSCRIPT             715
#define IDIC_SCRIPTFOLDER         716
#define IDIC_CCFOLDER             717
#define IDIC_TEMPLATEFOLDER       718
#define IDIC_NETFOLDER            719
#define IDIC_ONENODE              720
#define IDIC_AREAFOLDER           721
#define IDIC_AREAFOLDER_OPEN      722
#define IDIC_AREAFOLDER_UNREAD    723

/* Menue */
#define IDM_MENU          1000
#define IDM_FILE          1100
#define IDM_EXIT          1101
#define IDM_FILEIMPORT    1102
#define IDM_FILEEXPORT    1103
#define IDM_FILEECHOTOSS  1104
#define IDM_FILESHELL     1105
#define IDM_FILEPRINT     1106
#define IDM_FILEPRINTSETUP 1107

#define IDM_EDIT          1200
#define IDM_EDITCUT       1201
#define IDM_EDITCOPY      1202
#define IDM_EDITPASTE     1203
#define IDM_EDITCLEAR     1204
#define IDM_EDITUNDO      1205
#define IDM_EDITDELLINE   1206
#define IDM_EDITSEARCH    1207

#define IDM_OPTIONS       1300
#define IDM_OPCONFIG      1301
#define IDM_OPSAVE        1302
#define IDM_OPNAMEADDR    1303
#define IDM_OPCCLISTS     1304
#define IDM_OPTEMPLATE    1305
#define IDM_OPNICKNAMES   1306
#define IDM_OPECHOMAN     1307
#define IDM_OPADDAREAS    1308

#define IDM_HELP          1400
#define IDM_HELPKEYS      1401
#define IDM_HELPABOUT     1402
#define IDM_HELPGENERAL   1403
#define IDM_HELPINDEX     1404
#define IDM_HELPUSING     1405
#define IDM_HELPCONTENTS  1406

#define IDM_MESSAGE       1500
#define IDM_MSGMOVE       1501
#define IDM_MSGXPOST      1502
#define IDM_MSGREQUEST    1503
#define IDM_MSGCCOPY      1504
#define IDM_MSGMARK       1505
#define IDM_MSGNEW        1506
#define IDM_MSGCHANGE     1507
#define IDM_MSGREPLY      1508
#define IDM_MSGDELETE     1509
#define IDM_MSGFIND       1510
#define IDM_MSGCOPY       1511
#define IDM_MSGFORWARD    1512
#define IDM_MSGBCAST      1513
#define IDM_MSGBCDELETE   1514
#define IDM_MSGBCMODIFY   1515
#define IDM_MSGMARKMSG    1516
#define IDM_MSGUNMARKMSG  1517

#define IDM_WINDOWS       1600
#define IDM_WINTHREADS    1601
#define IDM_WINKLUDGES    1602
#define IDM_WINAREAS      1603
#define IDM_WINRESULTS    1604
#define IDM_WINPROGRESS   1605
#define IDM_WINMSGLIST    1606

#define IDM_SPECIAL       1700
#define IDM_MSGQUICKCC    1701
#define IDM_SPCADDTONICK  1702
#define IDM_SPCADDTOCC    1703
#define IDM_SPCBROWSER    1704

#define IDM_REXX          1800
#define IDM_RXSCRIPTS     1801
#define IDM_RXQUICK1      1810
#define IDM_RXQUICK2      1811
#define IDM_RXQUICK3      1812
#define IDM_RXQUICK4      1813
#define IDM_RXQUICK5      1814
#define IDM_RXQUICK6      1815
#define IDM_RXQUICK7      1816
#define IDM_RXQUICK8      1817
#define IDM_RXQUICK9      1818
#define IDM_RXQUICK10     1819

/* Popup-Menue im Area-Dialog */
#define IDM_AREAPOPUP     2000
#define IDM_AP_SETTINGS   2001
#define IDM_AP_CREATE     2002
#define IDM_AP_DELETE     2003
#define IDM_AP_RENUMBER   2006
#define IDM_AP_SQPARAMS   2007
#define IDM_AP_CATCHUP    2008
#define IDM_AP_SCAN       2009

#define IDM_AS_CANCEL     2020

/* kleines Popup-Menue Area-Liste */
#define IDM_SAREAPOPUP    2050
#define IDM_SAP_SETTINGS  2051
#define IDM_SAP_CREATE    2056
#define IDM_SAP_SCANALL   2057
#define IDM_SAP_FGROUND   2058

/* Folder-Popup */
#define IDM_FOLDERPOPUP   2060
#define IDM_FP_OPEN       2061
#define IDM_FP_SORT       2062
#define IDM_FP_SORT_NONE  2063
#define IDM_FP_SORT_NAME  2064
#define IDM_FP_SORT_UNR   2065
#define IDM_FP_CREATE     2066
#define IDM_FP_DELETE     2067
#define IDM_FP_SCAN       2068

/* kleines Folder-Popup */
#define IDM_SFOLDERPOPUP     2070
#define IDM_SFP_ICONS        2071
#define IDM_SFP_ICONS_LARGE  2072
#define IDM_SFP_ICONS_SMALL  2073
#define IDM_SFP_ICONS_NONE   2074
#define IDM_SFP_CREATE       2075


/* Popup-Menue der Messageliste */
#define IDM_MSGLISTPOPUP  2100
#define IDM_MP_DELETE     2101
#define IDM_MP_EXPORT     2102
#define IDM_MP_MOVE       2103
#define IDM_MP_COPY       2104
#define IDM_MP_PRINT      2105
#define IDM_MP_SELECT     2106
#define IDM_MP_SELECTALL  2107
#define IDM_MP_SELECTNONE 2108

/* kleines Popup-Menue der Messageliste */
#define IDM_SMLISTPOPUP   2120
#define IDM_SMP_SETTINGS  2121
#define IDM_SMP_FGROUND   2122

#define IDM_EDITPOPUP     2200
#define IDM_EP_CUT        2201
#define IDM_EP_COPY       2202
#define IDM_EP_PASTE      2203
#define IDM_EP_CLEAR      2204
#define IDM_EP_UNDO       2205
#define IDM_EP_DELLINE    2206
#define IDM_EP_HIGHLIGHT  2207
#define IDM_EP_MONO       2208

/* Template-Folder-Popup */
#define IDM_TPLF_POPUP    2300
#define IDM_TPLF_OPEN     2301
#define IDM_TPLF_DELETE   2302
#define IDM_TPLF_CREATE   2303
#define IDM_TPLF_COPY     2304

#define IDM_TPLF_POPUP2   2350
#define IDM_TPLF_FGROUND  2351

/* Threadlisten-Popup */
#define IDM_TL_POPUP      2400
#define IDM_TLP_SETTINGS  2401
#define IDM_TLP_VIEW      2402
#define IDM_TLP_VIEWALL   2403
#define IDM_TLP_VIEWTHR   2404
#define IDM_TLP_VIEWUNR   2405
#define IDM_TLP_SENDER    2406
#define IDM_TLP_FGROUND   2407
#define IDM_TLP_REFRESH   2408
#define IDM_TLP_CATCHUP   2409

/* Thread-Popup */
#define IDM_TH_POPUP      2450
#define IDM_THP_DELETE    2451
#define IDM_THP_MOVE      2452
#define IDM_THP_COPY      2453
#define IDM_THP_EXPORT    2454
#define IDM_THP_PRINT     2455
#define IDM_THP_MARK      2456
#define IDM_THP_EXPAND    2457

/* CC-Folder */
#define IDM_CCF_POPUP     2500
#define IDM_CCF_OPEN      2501
#define IDM_CCF_DELETE    2502
#define IDM_CCF_CREATE    2503

#define IDM_CCF_POPUP2    2520
#define IDM_CCF_FGROUND   2521

/* Rexx-Folder */
#define IDM_RXF_POPUP     2600
#define IDM_RXF_OPEN      2601
#define IDM_RXF_OPEN_SET  2602
#define IDM_RXF_OPEN_SCR  2603
#define IDM_RXF_DELETE    2604
#define IDM_RXF_CREATE    2605
#define IDM_RXF_OPEN_EDIT 2606

#define IDM_RXF_POPUP2    2650
#define IDM_RXF_FGROUND   2651
#define IDM_RXF_SETTINGS  2652

/* Find results/Bookmarks */
#define IDM_BM_POPUP      2700
#define IDM_BMP_DELETE    2701
#define IDM_BMP_EXPORT    2702
#define IDM_BMP_PRINT     2703
#define IDM_BMP_COPY      2704
#define IDM_BMP_MOVE      2705
#define IDM_BMP_REMOVE    2706
#define IDM_BMP_SELECT    2707
#define IDM_BMP_SELECTALL  2708
#define IDM_BMP_SELECTNONE 2709

#define IDM_BMF_POPUP      2750
#define IDM_BMFP_VIEW      2751
#define IDM_BMFP_VIEW_FIND 2752
#define IDM_BMFP_VIEW_PERS 2753
#define IDM_BMFP_VIEW_MARK 2754
#define IDM_BMFP_FGROUND   2755
#define IDM_BMFP_SAVE      2756
#define IDM_BMFP_VIEW_UNSENT 2757

/* Toolbar-Menue */
#define IDM_TB_POPUP       2800
#define IDM_TB_POSITION    2801
#define IDM_TB_TOP         2802
#define IDM_TB_BOTTOM      2803
#define IDM_TB_LEFT        2804
#define IDM_TB_RIGHT       2805
#define IDM_TB_SMALL       2806
#define IDM_TB_ADD         2807

/* Echo-Manager Folder */
#define IDM_EMF_POPUP      2900
#define IDM_EMF_SETTINGS   2901
#define IDM_EMF_REFRESH    2902
#define IDM_EMF_PAUSE      2903
#define IDM_EMF_RESUME     2904
#define IDM_EMF_RESET      2905

#define IDM_EMF_UPLINK     2910  /* danach: IDs f. Uplinks (max. bis IDM_EM_POPUP) */

/* Echo-Manager Popup */
#define IDM_EM_POPUP       2950
#define IDM_EM_LINK        2951
#define IDM_EM_UNLINK      2952
#define IDM_EM_RESCAN      2953
#define IDM_EM_RESET       2954
#define IDM_EM_REMOVE      2955

/* Accelerator-Keys */
#define IDA_END              4000
#define IDA_DELLINE          4001
#define IDA_F2               4002
#define IDA_F3               4003
#define IDA_F4               4004
#define IDA_F5               4005
#define IDA_F6               4006
#define IDA_F7               4007
#define IDA_F8               4008
#define IDA_F9               4009
#define IDA_F10              4010
#define IDA_F11              4011
#define IDA_F12              4012
#define IDA_KEYSHELP         4013
#define IDA_UNDO             4014
#define IDA_CANCEL           4015
#define IDA_SAVE             4016
#define IDA_REPLY            4017
#define IDA_REPLYNET         4018
#define IDA_AREA             4019
#define IDA_MSGLIST          4020
#define IDA_PRINT            4021
#define IDA_IMPORT           4022
#define IDA_THREADLIST       4023
#define IDA_MOVE             4024
#define IDA_CROSSPOST        4025
#define IDA_CCOPY            4026
#define IDA_REQUEST          4027
#define IDA_ENTER            4028
#define IDA_EXPORT           4029
#define IDA_PREVMSG          4030
#define IDA_NEXTMSG          4031
#define IDA_PREVREPLY        4032
#define IDA_NEXTREPLY        4033
#define IDA_FIRSTMSG         4034
#define IDA_LASTMSG          4035
#define IDA_DELMSG           4036
#define IDA_NEXTUNREAD       4037
#define IDA_CHANGEMSG        4038
#define IDA_TOGGLE_KILL      4039
#define IDA_TOGGLE_CRASH     4040
#define IDA_TOGGLE_FILE      4041
#define IDA_TOGGLE_REQ       4042
#define IDA_TOGGLE_PRIV      4043
#define IDA_DEFAULTADDR      4044
#define IDA_ATTRIB           4045
#define IDA_FIND             4046
#define IDA_HOMEMSG          4047
#define IDA_NEXTAREA         4048
#define IDA_REPLYNOJOIN      4049
#define IDA_REPLYNETNOJOIN   4050
#define IDA_KLUDGES          4051
#define IDA_COPY             4052
#define IDA_FORWARD          4053
#define IDA_ADDTONICK        4054
#define IDA_ADDTOCC          4055
#define IDA_MARKTOGGLE       4056
#define IDA_BOOKMARKS        4057
#define IDA_RXQUICK1         4058
#define IDA_RXQUICK2         4059
#define IDA_RXQUICK3         4060
#define IDA_RXQUICK4         4061
#define IDA_RXQUICK5         4062
#define IDA_RXQUICK6         4063
#define IDA_RXQUICK7         4064
#define IDA_RXQUICK8         4065
#define IDA_RXQUICK9         4066
#define IDA_RXQUICK10        4067
#define IDA_NLBROWSER        4068
#define IDA_TOGGLE_HOLD      4069
#define IDA_TOGGLE_DIRECT    4070
#define IDA_CATCHUP          4071
#define IDA_BACKWIN          4072
#define IDA_MONO             4073
#define IDA_HIGHLIGHT        4074

/* Ende RESIDS.H */
