/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         DisplayValue
*/
/*  Display the value of the selected property for the
    selected object.
*/ 
DisplayValue: procedure
    property = VRGet( "LB_Props", "SelectedString" )
    if( property = "" ) then do
        signal DisplayDone
    end
    object = VRGet( "LB_Objects", "Selected" )
    if( object = 0 ) then do
        signal DisplayDone
    end
    object = VRMethod( "LB_Objects", "GetItemData", object )
    value = VRGet( object, property )
    call VRSet "EF_Value", "Value", value
    call VRSet "EF_Value", "SelectedStart", 1
    call VRSet "EF_Value", "SelectedEnd", Length( value ) + 1 
    call VRMethod "EF_Value", "SetFocus"
DisplayDone:
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
/*  Assume invoked as a VRXEDIT macro so
        InitArgs.0 = 2
        InitArgs.1 = <object>
        InitArgs.2 = <editWindow>
*/
Init: procedure expose InitArgs. CurProp
    window = VRWindow()
    call VRMethod window, "CenterWindow"

    /*  Operate on the object under the pop-up, or on 
        all selected items if the pop-up was on a selected  
        item.
    */
    call VRMethod InitArgs.2, "GetSelectedRoots", "objects."
    i = 1
    do while( i <= objects.0 )
        if( objects.i = InitArgs.1 ) then do
            leave
        end
        i = i + 1
    end
    if( i > objects.0 ) then do
        objects.1 = InitArgs.1
        objects.0 = 1
    end
    do i = 1 to objects.0
        call VRMethod "LB_Objects", "AddString",,
                      VRGet( objects.i, "Name" ),, objects.i
    end

    /*  Enable PB_SetAll only if all objects are of the same class.
    */
    class = VRGet( objects.1, "ClassName" )
    i = 2
    do while( i <= objects.0 )
        if( VRGet( objects.i, "ClassName" ) <> class ) then do
            leave
        end
        i = i + 1
    end
    if( i > objects.0 ) then do
        call VRSet "PB_SetAll", "Enabled", 1
    end

    CurProp = ""
    call VRSet "LB_Objects", "Selected", 1
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return

/*:VRX         LB_Objects_Click
*/
LB_Objects_Click:
    call ListProps VRMethod( "LB_Objects", "GetItemData", VRGet( "LB_Objects", "Selected" ) )
    call DisplayValue
return

/*:VRX         LB_Props_Click
*/
LB_Props_Click:
    CurProp = VRGet( "LB_Props", "SelectedString" )
    call DisplayValue
return

/*:VRX         ListProps
*/
ListProps: procedure expose CurProp
    parse arg object

    /*  List properties which are not read only.
    */
    call VRSet "LB_Props", "Painting", 0
    call VRMethod "LB_Props", "Clear"
    call VRMethod object, "ListProperties", "list.", "Saveable" 
    call VRMethod "LB_Props", "AddStringList", "list."
    call VRMethod object, "ListProperties", "list.", "Events" 
    do i = 1 to list.0
        call VRMethod "LB_Props", "DeleteString", list.i
    end
    call VRMethod object, "ListProperties", "list.", "ReadOnly" 
    do i = 1 to list.0
        call VRMethod "LB_Props", "DeleteString", list.i
    end
    call VRSet "LB_Props", "Painting", 1

    /*  Set the selected property for the new object to
        the current property.
    */
    pos = VRMethod( "LB_Props", "FindString", CurProp, , "Exact" )
    if( pos > 0 ) then do
        call VRSet "LB_Props", "Selected", pos    
    end    
return

/*:VRX         PB_Cancel_Click
*/
PB_Cancel_Click:
    call VRDestroy "SW_1"
return

/*:VRX         PB_Edit_Click
*/
PB_Edit_Click:
    call VRLoadSecondary "SW_1"
    call VRSet "MLE_Edit", "Value", VRGet( "EF_Value", "Value" )
return

/*:VRX         PB_OK_Click
*/
PB_OK_Click:
    call VRSet "EF_Value", "Value", VRGet( "MLE_Edit", "Value" )        
    call VRDestroy "SW_1"
return

/*:VRX         PB_Set_Click
*/
PB_Set_Click:
    property = VRGet( "LB_Props", "SelectedString" )
    if( property = "" ) then do
        signal SetDone
    end
    index = VRGet( "LB_Objects", "Selected" )
    if( index = 0 ) then do
        signal SetDone
    end

    object = VRMethod( "LB_Objects", "GetItemData", index )
    call VRSet object, property, VRGet( "EF_Value", "Value" )
    if( index < VRGet( "LB_Objects", "Count" ) ) then do
        index = index + 1
    end
    else do
        index = 1
    end
    call VRSet "LB_Objects", "Selected", index

SetDone:
    drop property index object
return

/*:VRX         PB_SetAll_Click
*/
PB_SetAll_Click:
    property = VRGet( "LB_Props", "SelectedString" )
    if( property = "" ) then do
        signal SetAllDone
    end

    value = VRGet( "EF_Value", "Value" )
    call VRMethod "LB_Objects", "GetItemDataList", "objects."
    do i = 1 to objects.0
        call VRSet objects.i, property, value
    end

SetAllDone:
    drop property value objects. i
return


/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         SW_1_Close
*/
SW_1_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

