/* iPost (c) 1995 Wouter Cloetens */
/* Post message through Squish msgapi32.dll */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#define INCL_DOSDATETIME
#include <os2.h>
#include "msgapi.h"
#include "prog.h"
#include "ipost.h"

/* msgapi structures */
struct _minf mi;
HAREA ha;
HMSG hmsg;
XMSG msg;

/* function declarations */
void setupAPI(word zone);
void setupArea(char *szAreaName, bool fEcho);
void setupMsg(dword lMsgAttr, NETADDR naFrom, NETADDR naTo, struct _stamp *date,
	char *szFrom, char *szTo, char *szSubject, char *szCtrl, dword buflen);
void writeMsg(char *buf, dword buflen);
void death(char *s);

/* Rip-offs from MsgPost. Thanks Colin Wheat! */
static unsigned long HsecTime();
static char *AddrToStr(NETADDR *addr);
static void GetAddr(char *str, NETADDR *addr);

/********************
  main test function
********************
main()
{
  char *buf;
  char szAreaName[] = "$f:\\msgbase\\test";
  char szSubject[] = "Test message";
  char szFromAddr[] = "2:292/608.18";
  char szToAddr[] = "1:234/567.89";
  char szFrom[] = "My Own Test Program";
  char szTo[] = "Y'All";
  bool fEcho = true;
  dword lMsgAttr = MSGLOCAL;

  buf = (char *)malloc(14);
  strcpy(buf, "Hello world!\r");

  writemsg(szAreaName, fEcho, lMsgAttr,
		szFromAddr, szToAddr, szFrom, szTo, szSubject, buf);
  free(buf);
}
*/

/******************************
  Init API, open and lock area
******************************/
void beginmsg(char *szFromAddr, char *szAreaName, bool fEcho)
{
  NETADDR naFrom = {0, 0, 0, 0};

  GetAddr(szFromAddr, &naFrom);

  setupAPI(naFrom.zone);
  setupArea(szAreaName, fEcho);
  if(MsgLock(ha))
	death("MsgLock");
}

/**********************************
  Unlock and close area, close API
**********************************/
void endmsg()
{
  if(MsgUnlock(ha))
	death("MsgUnlock");
  if(MsgCloseArea(ha))
	death("MsgCloseArea");
  if(MsgCloseApi())
	death("MsgCloseApi");
}

/***************************
  Function that does it all
***************************/
void writemsg(bool fEcho, dword lMsgAttr, struct _stamp *date,
	char *szFromAddr, char *szToAddr, char *szFrom, char *szTo,
	char *szSubject, char *szCtrl, char *buf)
{
  NETADDR naFrom = {0, 0, 0, 0};
  NETADDR naTo   = {0, 0, 0, 0};
  dword buflen = strlen(buf) + 1;

  GetAddr(szFromAddr, &naFrom);
  if(!fEcho)
	GetAddr(szToAddr, &naTo);

  setupMsg(lMsgAttr, naFrom, naTo, date, szFrom, szTo, szSubject, szCtrl, buflen);

  writeMsg(buf, buflen);

  if(MsgCloseMsg(hmsg))
	death("MsgCloseMsg");
}

/*****************
  Open MsgAPI
*****************/
void setupAPI(word zone)
{
  memset(&mi, 0, sizeof(mi));
  mi.req_version = MSGAPI_VERSION;
  mi.def_zone = zone;
  if(MsgOpenApi(&mi))
	death("MsgOpenApi");
}

/*****************
  Open Area
*****************/
void setupArea(char *szAreaName, bool fEcho)
{
  word wType;
  char *szAreaFileName = szAreaName;

  if(szAreaName[0] == '$')
  {
	wType = MSGTYPE_SQUISH;
	szAreaFileName++;
  }
  else
  {
	wType = MSGTYPE_SDM;
	if(fEcho)
		wType |= MSGTYPE_ECHO;
  }

  if(!(ha = MsgOpenArea(szAreaFileName, MSGAREA_CRIFNEC, wType)))
	death("MsgOpenArea");
}

/**********************************
  Create message and setup headers
**********************************/
void setupMsg(dword lMsgAttr, NETADDR naFrom, NETADDR naTo, struct _stamp *date,
	char *szFrom, char *szTo, char *szSubject, char *szCtrl, dword buflen)
{
  union stamp_combo combo;
  struct tm *tmdate;
  time_t time_now, time_new;
  unsigned long seed;
  char *ctrl = (char *)malloc(128);

  if(!(hmsg = MsgOpenMsg(ha, MOPEN_CREATE, 0)))
	death("MsgOpenMsg");

  memset(&msg, 0, sizeof(msg));

  msg.attr = lMsgAttr;
  strncpy(msg.from, szFrom, XMSG_FROM_SIZE);
  strncpy(msg.to, szTo, XMSG_TO_SIZE);
  strncpy(msg.subj, szSubject, XMSG_SUBJ_SIZE);
  msg.orig = naFrom;
  msg.dest = naTo;

  time(&time_now);
  tmdate = localtime(&time_now);
  msg.date_written = *date;
  msg.date_arrived = (TmDate_to_DosDate(tmdate, &combo))->msg_st;

  seed=HsecTime();
  srand((unsigned)seed);
  time_new=HsecTime();
  if(seed<time_new)
	seed=time_new;
  sprintf(ctrl, "\01MSGID: %s %08lx",AddrToStr(&naFrom), seed);
  strcat(ctrl, "\01PID: iPost/2 " VER);
  strcat(ctrl, "\01CHARSET: LATIN-1 2");
  ctrl = (char *)realloc(ctrl, strlen(ctrl) + strlen(szCtrl) + 1);
  strcat(ctrl, szCtrl);

  if(MsgWriteMsg(hmsg, false, &msg, NULL, 0, buflen, strlen(ctrl) + 1, ctrl))
	death("MsgWriteMsg (header)");
}

/***************
 Write message
***************/
void writeMsg(char *buf, dword buflen)
{
  if(MsgWriteMsg(hmsg, false, 0, buf, buflen, buflen, 0, NULL))
	death("MsgWriteMsg");
}

/*****************
  Terminal Error
*****************/
void death(char *s)
{
  fputs(s, stderr);
  fputc(':', stderr);
  switch(msgapierr)
  {
	case MERR_NONE:
		fputs(" Error\n", stderr);
		break;
	case MERR_BADH:
		fputs(" Invalid handle passed to function\n", stderr);
		break;
	case MERR_BADF:
		fputs(" Invalid or corrupted file\n", stderr);
		break;
	case MERR_NOMEM:
		fputs(" Not enough memory for specified operation\n", stderr);
		break;
	case MERR_NODS:
		fputs(" Maybe not enough disk space for operation\n", stderr);
		break;
	case MERR_NOENT:
		fputs(" File/message does not exist\n", stderr);
		break;
	case MERR_BADA:
		fputs(" Bad argument passed to msgapi function\n", stderr);
		break;
	case MERR_EOPEN:
		fputs(" Couldn't close - messages still open\n", stderr);
		break;
	case MERR_NOLOCK:
		fputs(" Base needs to be locked to perform operation\n", stderr);
		break;
	case MERR_SHARE:
		fputs(" Resource in use by other process\n", stderr);
		break;
	case MERR_EACCES:
		fputs(" Access denied (can't write to read-only, etc)\n", stderr);
		break;
	case MERR_BADMSG:
		fputs(" Bad message frame (Squish)\n", stderr);
		break;
	case MERR_TOOBIG:
		fputs(" Too much text/ctrlinfo to fit in frame (Squish)\n", stderr);
		break;
	default:
		fputs(" Unknown error\n", stderr);
		break;
  }
  exit(-1);
}

/*
** HsecTime ()
** Get system date/time in hsec's
*/

static unsigned long HsecTime()
{
    unsigned long i;
    DATETIME dt;
    APIRET rc;

    rc = DosGetDateTime(&dt);
    i=((dt.day+(((unsigned)dt.month*3057-3007)/100))*144000L) +
    (dt.hours*360000L) +                             /* hours today: hsec    */
    (dt.minutes*6000L) +                             /* minutes: hsec        */
    (dt.seconds*100L) +                              /* seconds: hsec        */
    dt.hundredths;                                   /* hundreds of seconds  */

    return i;
}

/*
** AddrToStr ()
** Build address string
*/

static char *AddrToStr(NETADDR *addr)
{
    static char str[256];
    char point[20];

    if(addr->point) sprintf(point,".%u",addr->point);
    else *point='\0';

    sprintf(str,"%u:%u/%u%s",addr->zone,addr->net,addr->node,point);
    return str;
}

/*
** GetAddr ()
** Get command line system address
*/
static void GetAddr(char *str, NETADDR *addr)
{
    char *p;

    /* Zone */
    if((p=strchr(str,':'))!=NULL) {
        addr->zone=(unsigned int)atol(str); str=p+1;
    }
    else addr->zone=0;

    /* Net */
    if((p=strchr(str,'/'))!=NULL) {
        addr->net=(unsigned int)atol(str); str=p+1;
    }
    else addr->net=0;

    /* Node */
    addr->node=(unsigned int)atol(str);

    /* Point */
    if((p=strchr(str,'.'))!=NULL) {
        str=p+1; addr->point=(unsigned int)atol(str);
    }
    else addr->point=0;
}
