/* Installation Script for PM Zipper */
SAY " "

/* REXXUTIL laden */
CALL rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
CALL sysloadfuncs

call SysCls

say "Please choose your language.       Bitte whlen Sie Ihre Sprache."
say "----------------------------       ------------------------------"
say "        E = English                          D = Deutsch"
language=""
do while \ ((language="D") | (language="E"))
  pull language
end

call SysCls
dest="C:\PMZIPPER"
if language="E" then
do
  say "Welcome to PM Zipper installation."
  say " "
  say "Please enter the destination directory (default: " dest ") "
end
else
do
  say "Willkommen bei der Installation von PM Zipper."
  say " "
  say "Bitte geben Sie das Zielverzeichnis ein (Standard: " dest ") "
end
pull dest
if dest="" then dest="C:\PMZIPPER"
say " "
if language="E" then
do
  say "PM Zipper will be installed in " dest
end
else
do
  say "PM Zipper wird in " dest " installiert"
end

say " "
call SysMkDir dest
call SysMkDir dest"\ICON"
call SysMkDir dest"\ICON\ASC"
call SysMkDir dest"\ICON\BIN"
call SysMkDir dest"\TMP"
call SysMkDir dest"\ZIPS"
call SysMkDir dest"\ZIP"
call SysMkDir dest"\UNZIP"

copy "ICON\ASC\*.ico" dest"\ICON\ASC"
copy "ICON\BIN\*.ico" dest"\ICON\BIN"
copy "UNZIP\*.*" dest"\UNZIP"
copy "UNZIP\unzip.exe" dest
copy "ZIP\*.*" dest"\ZIP"
copy "ZIP\zip.exe" dest
copy BPMCC.DLL dest
copy FILES.LST dest
copy FILE_ID.DIZ dest
copy PMZIPPER.EXE dest
copy READ.ME dest
if language="E" then
do
  copy ENGLISH.DLL dest"\LANGUAGE.DLL"
  copy ENGLISH.HLP dest"\PMZIPPER.HLP"
  copy ENGLISH.INF dest"\PMZIPPER.INF"
end
else
do
  copy DEUTSCH.DLL dest"\LANGUAGE.DLL"
  copy DEUTSCH.HLP dest"\PMZIPPER.HLP"
  copy DEUTSCH.INF dest"\PMZIPPER.INF"
end

/* Einen Ordner anlegen */
klasse='WPFolder'
titel='PM Zipper'
ort='<WP_DESKTOP>'
param='OBJECTID=<PMZIPPER>'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Das Programmobjekt anlegen */
klasse='WPProgram'
titel='PM Zipper'
ort='<PMZIPPER>'
param='PROGTYPE=PM;EXENAME='dest'\PMZIPPER.EXE;STARTUPDIR='dest';ASSOCTYPE=ZIP Archive;ASSOCFILTER=*.ZIP'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Dokumentation */
klasse='WPProgram'
titel='PM Zipper Help'
ort='<PMZIPPER>'
param='PROGTYPE=PM;EXENAME=VIEW.EXE;STARTUPDIR='dest';PARAMETERS=PMZIPPER.INF'
mode='fail'
rc=SysCreateObject(klasse,titel,ort,param,mode)

/* ZIPS-Verzeichnis */
klasse='WPShadow'
titel='ZIPS'
ort='<PMZIPPER>'
param='SHADOWID='dest'\ZIPS'
mode='fail'
rc=SysCreateObject(klasse,titel,ort,param,mode)

if language="E" then
do
  say " "
  say "PM Zipper successfully installed!"
end
else
do
  say " "
  say "PM Zipper wurde erfolgreich installiert!"
end
