/* Generic REXX Installation Utility                                 */
/* John Wagner, Power Programming, Inc. - 1994 -                     */
/* Checks for the existance of the file to be installed              */
/* If file found, creates a WPS object for it                        */
/* Will add the ability to input an install drive/dir in the future  */

/* Load the RexxUtil DLL                                             */
call RxFuncAdd 'SysLoadFuncs' , RexxUtil, 'SysLoadFuncs'
call SysLoadFuncs

/* Initialize the varibles needed for this installation              */
/* These variables should cover most basic installations             */
ProgramTitle = 'The UnZip Shell'
EXE = 'UNZSH.EXE'
InstallDir = Directory()
/* Put any file type associations in this string, seperated by a ,   */
Assoc = '*.ZIP'
Setup = 'EXENAME='InstallDir'\'EXE';ASSOCFILTER='Assoc''
/* Action to take if pre-existing object is found */
Action = Update

call SysCls

say '    Ŀ'
say '                      Rexx Installation Utility                    '
say '    '
say
say 'This program will create an object on your desktop to access:'
say ProgramTitle
say 'After the installation, you can move the object to any WPS folder.'

/* See if EXE is in this directory. If not, quit!                    */
say 'Locating file:' EXE || '...'
if Stream(EXE,'C','Query Exists') = '' then do
  say 'The file' EXE 'was not located in' InstallDir
  say EXE 'must be in this directory for the installation to work.'
  say 'Exiting...'
  exit
end

/* Create the WPS object                                             */
say 'Located' EXE ||'. Creating WPS object...'
rc = SysCreateObject('WPProgram', ProgramTitle, '<WP_DESKTOP>',,
                     Setup,,
                     Action)

/* Check if the WPS object was created                               */
if rc = 0 then do
   say 'Failed to create WPS object for' ProgramTitle || '!!!'
end
else do
   say 'WPS Object created for' ProgramTitle || '.'
   if Assoc \= '' then do
      say
      say ProgramTitle 'has been associated with file types ending in:'
      say Assoc
      say 'Double clicking on a WPS file object with that extension(s)'
      say 'will invoke' ProgramTitle 'with that file loaded.'
      say
   end
end

say 'Exiting REXX installation utility.'
