/* WarpIN UnPacker v0.1.0 */

/*
   Change this to suit your needs. I put the 'wic.cmd' script in my path, so that
   I can invoke wic.exe from anywhere w/o the need to move it around, modify my
   system paths, etc.
*/
wic_invoke = 'call wic'

parse arg wpifile
wpifile = strip(wpifile)

if wpifile = '' then do
  Say 'Usage: <program> <wpi_file>'
  exit 1
 end
wpifile = stream(wpifile,'C','QUERY EXISTS')
say wpifile
if wpifile = '' then do
  Say 'Error: WPI file does not exist, or something'
  exit 1
 end

td = directory()
wpiname = substr(wpifile,lastpos('\',wpifile)+1)
wpiname = substr(wpiname,1,lastpos('.',wpiname)-1)
wpiscript = wpiname||'.wis'

wic_invoke||' -X '||wpifile||' '||wpiscript

wpiscript_data = charin(wpiscript,1,chars(wpiscript))
call stream wpiscript,'C','CLOSE'

call htmltaghunt wpiscript_data,'pck','pck.index'
package.0 = 0
do i=1 to pck.0
  parse var pck.i offset length .
  call htmlattrlist substr(wpiscript_data,offset,length),'pckattr'
  do j=1 to pckattr.0
    parse var pckattr.j att_name att_value
    if att_name = 'index' then do
      nr = package.0 +1
      package.0 = nr
      package.nr.index = att_value
      leave
     end
   end
 end

wic_create = wic_invoke||' '||wpiname||' -a'
do i=1 to package.0
  n = right(package.i.index,length(package.0),'0')
  'md Pck'||n
  call directory('Pck'||n)
  'call wic -x '||wpifile||' '||n
  call directory td
  wic_create = wic_create||' '||package.i.index||' -r -cPck'||n||' *'
 end
wic_create = wic_create||' -s '||wpiscript
call lineout wpiname||'.cmd',wic_create

exit 0

/* Subroutines from other proggies of mine ... */

/*
   htmltaghunt v1.1 2006/12/22

   Function that goes through an HTML string with tags and text and builds an
   array with data from the tags that match ANY of the specified conditions
   Parameters:
   1) HTML String
   2) Name of the array to put the data into
   3) List of tags to search for, in the special format:
    'tagspec_1 tagspec_2 ... tagspec_n' where any tagspec can be:
    - a simple "tag", i.e. 'table', or even '/table'
    - a tag that must have a certain attribute to be matched, in the format
     'tag.attribute'
    - a tag with an attribute that needs to match a certain value, in the
     format 'tag.attribute=value'
    - a tag with an attribute that needs to be different from a certain value,
     in the format 'tag.attribute!value'
    - a tag with an attribute that needs to contain a certain substring, in the
     format 'tag.attribute>substring'
    - a tag with an attribute that needs not to contain a certain substring, in
     the format 'tag.attribute<substring'

   Remarks:
   1) Tag and attribute names to search for are matched insensitively to ensure
      a maximum number of matches
   2) When a substring is searched for within an attribute, search is performed
      case-insensitively, to ensure a maximum number of matches
   3) When a substring is NOT wanted within an attribute, search is performed
      case-sensitively, to ensure a minimum number of matches
   There's a call to translate(...) 'everywhere where appropriate' in the code
   below...
   4) Attribute substrings specified in the 'matches' list cannot contain
      spaces.
   5) Anything between an innermost '<' and '>' pair is considered a tag i.e.
    '<tag blah blah >' inside '<!-- <tag blah blah > -->' IS a tag
    I know that this is inside a comment, but you'll have to live with it.
    This allows for CC stuff and closing tags like '/table' to be processed as
    well without any more code.

   A poor man's DOM? You bet it!

*/

htmltaghunt:
  parse arg htmldata,listname,targtags
  TagTerm = '0D0A'x||' <>'
  dlen    = length(htmldata)
  mycnt = 0
  do while length(targtags)>0
    parse var targtags newtag targtags
    mycnt = mycnt+1
    parse var newtag tag.mycnt '.' rest
    if rest = '' then
      attr.mycnt = ''
    else
      select
        when pos('=',rest)>0 then do
          parse var rest attr.mycnt '=' compval.mycnt
          comptype.mycnt = '='
         end
        when pos('!',rest)>0 then do
          parse var rest attr.mycnt '!' compval.mycnt
          comptype.mycnt = '!'
         end
        when pos('>',rest)>0 then do
          parse var rest attr.mycnt '>' compval.mycnt
          comptype.mycnt = '>'
         end
        when pos('<',rest)>0 then do
          parse var rest attr.mycnt '<' compval.mycnt
          comptype.mycnt = '<'
         end
        otherwise
          attr.mycnt = rest
          compval.mycnt = ''
          comptype.mycnt = '-'
       end
    tag.mycnt  = translate(tag.mycnt,xrange('a','z'),xrange('A','Z'))
    attr.mycnt = translate(attr.mycnt,xrange('a','z'),xrange('A','Z'))
   end
  tag.0 = mycnt
  curpos  = 1
  nextpos = 1
  tagcnt = 0
  do until (nextpos = 0 | curpos >= dlen )
    nextpos = pos('<',htmldata,curpos)
    tag = ''
    if nextpos > 0 then do
      curpos   = nextpos
      nextchar = ''
      do while ((pos(nextchar,TagTerm)=0) & (curpos < dlen))
        nextchar = substr(htmldata,curpos+1,1)
        curpos = curpos +1
        if pos(nextchar,TagTerm)=0 then
          tag = tag||nextchar
       end
      tag = translate(tag,xrange('a','z'),xrange('A','Z'))
      if nextchar <> '<' then do   /* "<whatever<..." things are out now */
        closepos = pos('>',htmldata,curpos)
        if closepos > 0 then do
          do mycnt=1 to tag.0
            if (tag.mycnt = tag) | (tag.mycnt = '*') then do
              if attr.mycnt = '' then do /* only tag to match is specified */
                tagcnt = tagcnt +1
                call value value(listname).tagcnt,nextpos||' '||closepos-nextpos+1||' '||tag
               end
              else do
                call htmlattrlist substr(htmldata,nextpos,closepos-nextpos+1),testattr
                match = 0
                do my2=1 to testattr.0
                  parse var testattr.my2 testattr.my2 attrval
                  if attr.mycnt = testattr.my2 then do
                    select
                      when comptype.mycnt = '-' then
                        match = 1
                      when comptype.mycnt = '=' then
                        match = (compval.mycnt = attrval)
                      when comptype.mycnt = '!' then
                        match = (compval.mycnt <> attrval)
                      when comptype.mycnt = '>' then
                        match = (pos(translate(compval.mycnt),translate(attrval))>0)
                      when comptype.mycnt = '<' then
                        match = (pos(compval.mycnt,attrval)=0)
                      otherwise nop
                     end
                   end
                  if match = 1 then do
                    tagcnt = tagcnt +1
                    call value value(listname).tagcnt,nextpos||' '||closepos-nextpos+1||' '||tag
                    leave /* leave my2 */
                   end
                 end
               end
             end
           end
         end /* if closepos > 0*/
       end /* if nextchar <> '<' */
     end /* if nextpos > 0 */
   end /* until nextpos = 0 | curpos >= dlen */
  call value value(listname).0,tagcnt
return

/*
   htmlattrlist v1.0 2006/12/22

   Function that goes through an HTML tag string and builds an array with
   attibute + space + value strings, thus saving the need to further search
   for equal signs, quotes and the like - purportedly at least!

   Parameters:
   1) tag string (the text delimited by '<' and '>', included)
   2) Name of the array to put the data into

   Remarks:
   1) In the output array, attribute names are converted to lowercase but of
     course NOT attribute values
   2) Output array components have the form 'attrname[ attrvalue]' i.e. if
     an attribute has ANY value (even ''), it is appended to the corresponding
     array element along with a blank space.
     This allows to distinguish 'contracted' attribute from modern-style ones.
*/

htmlattrlist:
  parse arg htmlstring,list
  attrcnt = 0
  if (left(htmlstring,1) <> '<' | right(htmlstring,1) <> '>' ) then do
    call value value(list).0,attrcnt
    return 1
   end
  htmlstring = substr(htmlstring,2,length(htmlstring)-2)
  htmlstring = translate(htmlstring,'  ','0D0A'x)
  parse var htmlstring . htmlstring   /* the tag is always leading */
  htmlstring = strip(htmlstring)
  do while length(htmlstring)>0
    /* Any '=' inside an attr value should be between quotes, so... */
    parse var htmlstring curattr '=' htmlstring
    do while pos(' ',curattr)>0
      parse var curattr preattr curattr
      curattr = strip(curattr)
      attrcnt = attrcnt +1
      preattr = translate(preattr,xrange('a','z'),xrange('A','Z'))
      call value value(list).attrcnt,preattr
     end
    attrcnt = attrcnt +1
    curattr = translate(curattr,xrange('a','z'),xrange('A','Z'))
    newattr = curattr
    htmlstring = strip(htmlstring)
    if htmlstring <> '' then do
      select
        when left(htmlstring,1)='"' then
          valterm = '"'
        when left(htmlstring,1)="'" then
          valterm = "'"
        otherwise
          valterm = " "
       end
      endval = pos(valterm,htmlstring,2)
      if endval > 0 then do
        curval = substr(htmlstring,1,endval)
        htmlstring = substr(htmlstring,endval+1)
        htmlstring = strip(htmlstring)
       end
      else do
        curval = htmlstring
        htmlstring = ''
       end
      curval = strip(curval,,'"')
      curval = strip(curval,,"'")
      newattr = curattr||' '||curval
     end
    call value value(list).attrcnt,newattr
   end
  call value value(list).0,attrcnt
return 0
